/*
 * Copyright @ 2001-2003, The Institute for Genomic Research (TIGR).
 * All rights reserved.
 *
 *
 * BlockFiller.java
 *
 * Created on June 3, 2002, 2:42 PM
 * @author  wliang
 * @version 
 */

package org.tigr.midas.util;

import java.io.*;
import java.util.*;
import java.lang.*;

public class BlockFiller {

    private static int blockNumber;
    private float[][] blockCy3;
    private float[][] blockCy5;
    private int[][] origIndex;
    private int[] blockRowCount;
    private IDAssigner idAssigner;
    
    public BlockFiller(ColumnWorker fileCW) {
        
        String[] metaCombo = fileCW.getMetaCombo();
        int totalRowCount = fileCW.getRowCounts();
        float[] cy3Column = fileCW.getColumnOneArray();
        float[] cy5Column = fileCW.getColumnTwoArray();
        
        //Assign genes to different blocks based on their metaCombo
        idAssigner = new IDAssigner();
        Vector metaComboVec = new Vector();
        int[] geneBlockNdx = new int[totalRowCount];

        for (int row = 0; row < totalRowCount; row++){
            idAssigner.findUniqueID(metaCombo[row], metaComboVec);
            geneBlockNdx[row] = idAssigner.getID();
        }
        logger.log("    Block meta:        " + idAssigner.getKeyBank().toString());
        logger.log("    Block id:          " + idAssigner.getIDVec());
        logger.log("    Block gene counts: " + idAssigner.getIDRepeatCount().toString());
        
        blockNumber = idAssigner.getIDVec().size();
        blockCy3 = new float[blockNumber][];
        blockCy5 = new float[blockNumber][];
        origIndex = new int[blockNumber][];
        blockRowCount = new int[blockNumber];
        
        for (int i = 0; i < blockNumber; i++){   
            blockCy3[i] = new float[Integer.parseInt(idAssigner.getIDRepeatCount().get(i).toString())];
            blockCy5[i] = new float[Integer.parseInt(idAssigner.getIDRepeatCount().get(i).toString())];
            origIndex[i] = new int[Integer.parseInt(idAssigner.getIDRepeatCount().get(i).toString())];
        }
        
        for (int row = 0; row < totalRowCount; row++){
            blockCy3[geneBlockNdx[row]][blockRowCount[geneBlockNdx[row]]] = cy3Column[row];
            blockCy5[geneBlockNdx[row]][blockRowCount[geneBlockNdx[row]]] = cy5Column[row];
            origIndex[geneBlockNdx[row]][blockRowCount[geneBlockNdx[row]]] = row;
            
            blockRowCount[geneBlockNdx[row]]++;
        }        
    }

    public final float[] getBlockCy3(int blockIndx){
        int blockSize = Integer.parseInt(idAssigner.getIDRepeatCount().get(blockIndx).toString());
        float[] blkCy3 = new float[blockSize];
        System.arraycopy(blockCy3[blockIndx], 0, blkCy3, 0, blockSize);
        return blkCy3;
    }
    
    public final float[] getBlockCy5(int blockIndx){
        int blockSize = Integer.parseInt(idAssigner.getIDRepeatCount().get(blockIndx).toString());
        float[] blkCy5 = new float[blockSize];
        System.arraycopy(blockCy5[blockIndx], 0, blkCy5, 0, blockSize);
        return blkCy5;
    }
    
    public final int[] getOrigIndex(int blockIndx){
        int blockSize = Integer.parseInt(idAssigner.getIDRepeatCount().get(blockIndx).toString());
        int[] origNdx = new int[blockSize];
        System.arraycopy(origIndex[blockIndx], 0, origNdx, 0, blockSize);
        return origNdx;
    }
    
    public final int getBlockSize(int blockIndx){
        return Integer.parseInt(idAssigner.getIDRepeatCount().get(blockIndx).toString());
    }
    
    public final int getBlockNumber(){
        return blockNumber;
    }
        
}
