/*
 * Copyright @ 2001-2003, The Institute for Genomic Research (TIGR).
 * All rights reserved.
 *
 * QSort.java
 *
 * Created on March 6, 2002, 2:15 PM
 * @author  wliang
 * @version
 */


package org.tigr.midas.math;

import java.io.*;
import org.tigr.midas.util.*;


public class QSort extends SortAlgorithm {
    
    private int[] origIndx;
    private float[] sorted;
    
    public QSort(float[] a){
        sort(a);
    }
    
    public void sort(float a[]) {
        
        origIndx = new int[a.length];
        for (int i = 0; i <= origIndx.length - 1; i++){
            origIndx[i] = i;
        }
        QuickSort(a, 0, a.length - 1);
    }
    
    void QuickSort(float a[], int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        float mid;
        
        if ( hi0 > lo0) {
            
         /* Arbitrarily establishing partition element as the midpoint of
          * the array.
          */
            mid = a[ ( lo0 + hi0 ) / 2 ];
            
            // loop through the array until indices cross
            while( lo <= hi ) {
            /* find the first element that is greater than or equal to
             * the partition element starting from the left Index.
             */
                while( ( lo < hi0 ) && ( a[lo] < mid ))
                    ++lo;
                
            /* find an element that is smaller than or equal to
             * the partition element starting from the right Index.
             */
                while( ( hi > lo0 ) && ( a[hi] > mid ))
                    --hi;
                
                // if the indexes have not crossed, swap
                if( lo <= hi ) {
                    swap(a, lo, hi);
                    ++lo;
                    --hi;
                }
            }
            
         /* If the right index has not reached the left side of array
          * must now sort the left partition.
          */
            if( lo0 < hi )
                QuickSort( a, lo0, hi );
            
         /* If the left index has not reached the right side of array
          * must now sort the right partition.
          */
            if( lo < hi0 )
                QuickSort( a, lo, hi0 );
            
        }
        sorted = a;
    }
    
    private void swap(float a[], int i, int j) {
        
        float T;
        T = a[i];
        a[i] = a[j];
        a[j] = T;
        
        int TT = origIndx[i];
        origIndx[i] = origIndx[j];
        origIndx[j] = TT;
    }
    
    public float[] getSorted(){
        return sorted;
    }
    
    public int[] getOrigIndx(){
        return origIndx;
    }
}
