/*
 * Copyright @ 2001-2003, The Institute for Genomic Research (TIGR).
 * All rights reserved.
 *
 *
 * TotInt.java
 *
 * Created on May 24, 2002, 11:29 AM
 * @author  wliang
 * @version
 */

package org.tigr.midas.engine;

import java.io.*;
import java.util.*;
import java.math.*;
import java.lang.*;
import org.tigr.midas.*;
// Mod for MeV import org.tigr.midas.display.*;
import org.tigr.midas.util.*;

public class TotInt extends Module {
    
    private ColumnWorker fCW;
    
    public TotInt(ColumnWorker fileCW, String ref, boolean noNorm){
        super();
        boolean[] tempFlag = fileCW.getRowFlagArray();
        boolean[] inputFlag = new boolean[tempFlag.length];
        System.arraycopy(tempFlag, 0, inputFlag, 0, tempFlag.length);

        DataPrep dataPrep;
        // Mod for MeV DataReporter dr;

        if (noNorm){
            
             /* Mod for MeV    
              FileBrowser projFolderFB = new FileBrowser(proj.getProjPath(), Constant.READ_FILE);
              String totintFB = projFolderFB.createSubDir("low_intensity_filter");
             */
            
            //Output pre-filtering results
            //Mod for MeV
            //String preName = super.proj.getProjPath() + "low_intensity_filter" + FileBrowser.fsep + fileCW.getFileName() + "_pre.prc";
            dataPrep = new DataPrep(fileCW);
            // Mod for MeV
            //dr = new DataReporter(preName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            int inCount = dataPrep.getNonZeroCount();
            
            fileCW.KeepTwoColumnsAddFlags(Parameter.pCy3CutoffVal, Parameter.pCy5CutoffVal);
            
            // Mod for MeV (//comments below) 
            //Output post-filtering results
            //String postName = super.proj.getProjPath() + "low_intensity_filter" + FileBrowser.fsep + fileCW.getFileName() + "_post.prc";
            dataPrep = new DataPrep(fileCW);
            //dr = new DataReporter(postName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            int outCount = fileCW.getNonZeroCounts();
            
            /* Mod for MeV
            Hashtable hash = new Hashtable();
            hash.put(new String("pre_prc_name"), preName);
            hash.put(new String("post_prc_name"), postName);
            hash.put(new String("in_row_count"), new Integer(inCount));
            hash.put(new String("out_row_count"), new Integer(outCount));
            proj.insertReportItem("low_intensity_filter_for_" + fileCW.getFileName(), hash);
            */
            
        }else{
            
            /* Mod for MeV
            FileBrowser projFolderFB = new FileBrowser(super.proj.getProjPath(), Constant.READ_FILE);
            String totintFB = projFolderFB.createSubDir("total_intensity");
            */
            
            //Output pre-normalization results
            // Mod for MeV String preName = super.proj.getProjPath() + "total_intensity" + FileBrowser.fsep + fileCW.getFileName() + "_pre.prc";
            dataPrep = new DataPrep(fileCW);
            // Mod for MeV dr = new DataReporter(preName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            int inCount = dataPrep.getNonZeroCount();
            
            
            if (ref.equalsIgnoreCase("Cy3")){
                fileCW.resetTwoColumnsAddFlagsRefColOne(1, 1);
            }else if(Parameter.pRefStr.equalsIgnoreCase("Cy5")){
                fileCW.resetTwoColumnsAddFlagsRefColTwo(1, 1);
            }
            
            // Mod for MeV
            //Output post-normalization results
            //String postName = super.proj.getProjPath() + "total_intensity" + FileBrowser.fsep + fileCW.getFileName() + "_post.prc";
            dataPrep = new DataPrep(fileCW);
            //dr = new DataReporter(postName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            int outCount = dataPrep.getNonZeroCount();
            
            /* Mod for MeV
            Hashtable hash = new Hashtable();
            hash.put(new String("pre_prc_name"), preName);
            hash.put(new String("post_prc_name"), postName);
            hash.put(new String("in_row_count"), new Integer(inCount));
            hash.put(new String("out_row_count"), new Integer(outCount));
            
            proj.insertReportItem("total_intensity_for_" + fileCW.getFileName(), hash);
            */
        }
        
        boolean[] totintFlag = fileCW.getRowFlagArray();
        boolean[] outputFlag = (new AndFlags(inputFlag, totintFlag)).getAndFlag();
        
        fileCW.setRowFlag(outputFlag);
        fCW = fileCW;
    }
    
    public final ColumnWorker getFileTotIntColumnWorker(){
        return fCW;
    }
}
