/*
 * Parameter.java
 *
 * Created on November 19, 2003, 12:12 PM
 * @author  wliang
 */

package org.tigr.midas.engine;

import java.io.*;
import java.util.*;
import java.math.*;
import java.lang.*;

public class Parameter {
    public static String    pSingleFileStr;
    public static String    pRefStr;
    public static String    pFolderStr;
    public static String    pLocfitModeStr;
    public static String    pIterLinRegModeStr;
    public static String    pMaAnovaStr;
    public static String    pFlipdyeCutOptionStr;
    public static String    pOutFileStr;
    public static boolean   pUseCh1FlagOpt;
    public static boolean   pUseCh2FlagOpt;
    public static boolean   pCh1BkgdOpt;
    public static boolean   pCh2BkgdOpt;
    public static boolean   pRatioStatsCIChkOpt;
    public static boolean   pBlockSDRegOpt;
    public static boolean   pSlideSDRegOpt;
    public static boolean   pUseCrossFileTrimOpt;
    public static boolean   pVtrimOpt;
    public static boolean   pReNumberOpt;
    public static boolean   pOutputTrimmedDataOpt;
    public static long      pCy3CutoffVal;
    public static long      pCy5CutoffVal;
    public static int       pSliceDataPopVal;
    public static int       pUseCh1FlagCol;
    public static int       pUseCh2FlagCol;
    public static int       pCh1BkgdCol;
    public static int       pCh2BkgdCol;
    public static int       pRatioStatsCIVal;
    public static int       pIdentifierCol;
    public static int       pTtestPValBase;
    public static int       pTtestSigMethod;
    public static float     pTtestAlpha;
    public static float     pBkgdSNRatioVal;
    public static float     pSmoothParaVal;
    public static float     pIterLinRegSDRangeVal;
    public static float     pIterLogMeanSDRangeVal;
    public static float     pSliceDataRangeLtVal;
    public static float     pSliceDataRangeGtVal;
    public static float     pFlipdyeDataKeepRangeVal;
    public static float     pTtestHypoMean;
    public static float     pCrossFilePct;
    public static Vector    pFilePairVec;
    public static Vector    pFolderFilesVec;
    public static Vector    pGroupFilesVec;
    public static Vector    pGroupFilesNdxVec;
    
    public Parameter() {
        pSingleFileStr          = "Please specify a file";
        pRefStr                 = "Cy3";
        pFolderStr              = "Please specify a directory";
        pLocfitModeStr          = "block";
        pIterLinRegModeStr      = "block";
        pMaAnovaStr             = "MAANOVA";
        pFlipdyeCutOptionStr    = "SD cut";
        pOutFileStr             = "";
        pUseCh1FlagOpt          = false;
        pUseCh2FlagOpt          = false;
        pCh1BkgdOpt             = false;
        pCh2BkgdOpt             = false;
        pRatioStatsCIChkOpt     = false;
        pBlockSDRegOpt          = true;
        pSlideSDRegOpt          = false;
        pUseCrossFileTrimOpt    = true;
        pVtrimOpt               = true;
        pReNumberOpt            = false;
        pOutputTrimmedDataOpt   = false;
        pCy3CutoffVal           = 10000;
        pCy5CutoffVal           = 10000;
        pSliceDataPopVal        = 50;
        pUseCh1FlagCol          = -1;
        pUseCh2FlagCol          = -1;
        pCh1BkgdCol             = -1;
        pCh2BkgdCol             = -1;
        pRatioStatsCIVal        = -1;
        pIdentifierCol          = 9;
        // Mod for MeV , ttest not needed eliminate Ttest dependence
        //pTtestPValBase          = Ttest.P_VAL_BASED_ON_TDISTRIBUTION;
        //pTtestSigMethod         = Ttest.JUST_ALPHA;
        pTtestAlpha             = 0.05f;
        pBkgdSNRatioVal         = 2.0f;
        pSmoothParaVal          = 0.33f;
        pIterLinRegSDRangeVal   = 2.00f;
        pIterLogMeanSDRangeVal  = 3.00f;
        pSliceDataRangeLtVal    = -1.00f;
        pSliceDataRangeGtVal    = -1.00f;
        pFlipdyeDataKeepRangeVal= 2.00f;
        pTtestHypoMean          = 0.0f;
        pCrossFilePct           = 0.50f;
        pFilePairVec            = new Vector();
        pFolderFilesVec         = new Vector();
        pGroupFilesVec          = new Vector();
        pGroupFilesNdxVec       = new Vector();
        
        //Clean MAANOVA parameters
        
        /* Mod for MeV
        MaAnovaParameter.elistSize = 0;
        MaAnovaParameter.dim = 0;
        MaAnovaParameter.pExpListStr = null;
        MaAnovaParameter.pFolderStr = null;
        MaAnovaParameter.anova_model = null;
        MaAnovaParameter.Matrix = null;
        MaAnovaParameter.AT = null;
        */
    }
}

/*
    public static String    pSingleFileStr          = "Please specify a file";
    public static String    pRefStr                 = "Cy3";
    public static String    pFolderStr              = "Please specify a directory";
    public static String    pLocfitModeStr          = "block";
    public static String    pIterLinRegModeStr      = "block";
    public static String    pFlipdyeCutOptionStr    = "SD cut";
    public static String    pOutFileStr             = "";
    public static boolean   pUseCh1FlagOpt          = false;
    public static boolean   pUseCh2FlagOpt          = false;
    public static boolean   pCh1BkgdOpt             = false;
    public static boolean   pCh2BkgdOpt             = false;
    public static boolean   pRatioStatsCIChkOpt     = false;
    public static boolean   pBlockSDRegOpt          = true;
    public static boolean   pSlideSDRegOpt          = false;
    public static boolean   pUseCrossFileTrimOpt    = true;
    public static boolean   pVtrimOpt               = true;
    public static boolean   pReNumberOpt            = false;
    public static boolean   pOutputTrimmedDataOpt   = false;
    public static long      pCy3CutoffVal           = 10000;
    public static long      pCy5CutoffVal           = 10000;
    public static int       pSliceDataPopVal        = 50;
    public static int       pUseCh1FlagCol          = -1;
    public static int       pUseCh2FlagCol          = -1;
    public static int       pCh1BkgdCol             = -1;
    public static int       pCh2BkgdCol             = -1;
    public static int       pRatioStatsCIVal        = -1;
    public static int       pIdentifierCol          = 9;
    public static int       pTtestPValBase          = Ttest.P_VAL_BASED_ON_TDISTRIBUTION;
    public static int       pTtestSigMethod         = Ttest.JUST_ALPHA;
    public static float     pTtestAlpha             = 0.05f;
    public static float     pBkgdSNRatioVal         = 2.0f;
    public static float     pSmoothParaVal          = 0.33f;
    public static float     pIterLinRegSDRangeVal   = 2.00f;
    public static float     pIterLogMeanSDRangeVal  = 3.00f;
    public static float     pSliceDataRangeLtVal    = -1.00f;
    public static float     pSliceDataRangeGtVal    = -1.00f;
    public static float     pFlipdyeDataKeepRangeVal= 2.00f;
    public static float     pTtestHypoMean           = 0.0f;
    public static float     pCrossFilePct           = 0.50f;
    public static Vector    pFilePairVec            = new Vector();
    public static Vector    pFolderFilesVec         = new Vector();
    public static Vector    pGroupFilesVec          = new Vector();
    public static Vector    pGroupFilesNdxVec       = new Vector();
 
 
    private void setFileOpener(String s, Vector pairVec, boolean ch1Flag, int ch1, boolean ch2Flag, int ch2, boolean ch1BgFlag, int ch2Bg, boolean ch2BgFlag, int ch1Bg, float sn){
        pSingleFileStr = s;
        pFilePairVec = pairVec;
        //pFolderStr              = "Please specify a directory";
        pUseCh1FlagOpt = ch1Flag;
        pUseCh2FlagOpt = ch2Flag;
        pUseCh1FlagCol = ch1;
        pUseCh2FlagCol = ch2;
        pCh1BkgdOpt = ch1BgFlag;
        pCh2BkgdOpt = ch2BgFlag;
        pCh1BkgdCol = ch1Bg;
        pCh2BkgdCol = ch2Bg;
        pBkgdSNRatioVal = sn;
    }
 
 
    private void setTotint(String cy){
        pRefStr = cy;
    }
 
    private void setLocfit(String mode, String cy){
        pLocfitModeStr = mode;
        pRefStr = cy;
    }
 
    private void setIterLinReg(String mode, float range, String cy){
        pIterLinRegModeStr =  mode;
        pIterLinRegSDRangeVal =  range;
        pRefStr = cy;
    }
 
    private void setIterLogMean(float range, String cy){
        pIterLogMeanSDRangeVal = range;
        pRefStr = cy;
    }
 
    private void setRatioStats(boolean CIcheckFlag, int CI, String cy){
        pRatioStatsCIChkOpt = CIcheckFlag;
        pRatioStatsCIVal = CI;
        pRefStr = cy;
    }
 
    private void setSDreg(boolean doBlock, boolean doSlide, String cy){
        pBlockSDRegOpt = doBlock;
        pSlideSDRegOpt =  doSlide;
        pRefStr = cy;
    }
 
    private void setFilter(long cy3, long cy5){
       pCy3CutoffVal =  cy3;
       pCy5CutoffVal =  cy5;
    }
 
    private void setSliceAnalysis(int pop, float upper, float lower){
        pSliceDataPopVal = pop;
        pSliceDataRangeLtVal = upper;
        pSliceDataRangeGtVal = lower;
    }
 
    private void setFlipDye(String cut, float range){
        pFlipdyeCutOptionStr = cut;
        pFlipdyeDataKeepRangeVal = range;
    }
 
    private void setInSlideRA(int col){
        pIdentifierCol = col;
    }
 
    private void write(boolean virtual, boolean outputTrim, boolean crossFile, float pct){
        pVtrimOpt = virtual;
        pOutputTrimmedDataOpt = outputTrim;
        pUseCrossFileTrimOpt = crossFile;
        pCrossFilePct = pct;
    }
 
}
 **/

