/*
 * Copyright @ 2001-2004, The Institute for Genomic Research (TIGR).
 * All rights reserved.
 *
 * IterativeLogMean.java
 *
 * Created on September 3, 2002, 4:42 PM
 * @author  wliang
 * @version
 */

package org.tigr.midas.engine;

import java.io.*;
import java.util.*;
import java.math.*;
import java.lang.*;
// Mod for MeV import org.tigr.midas.display.*;
import org.tigr.midas.math.*;
import org.tigr.midas.util.*;
import org.tigr.midas.Constant;

public class IterativeLogMean extends Module {
    
    private ColumnWorker fCW;
    //private int totalRowCount;
    private float[] cy3Column;
    private float[] cy5Column;
    private boolean[] inputFlag;
    private float[] logRatio;
    private float slideRawLogRatioMean;
    private float slideRawLogRatioSD;
    private float logRatioMean;
    private float logRatioSD;
    private int m = 1;
    private int[] withinRangeCounts = new int[100];
    private float[] logRatioMeans = new float[100];
    private float[] logRatioSDs = new float[100];
    
    public IterativeLogMean(ColumnWorker fileCW, float nSD, String ref) throws Exception{
        
        super();
        
        // Mod for MeV
        //FileBrowser projFolderFB = new FileBrowser(proj.getProjPath(), Constant.READ_FILE);
        //String iterLinRegFB = projFolderFB.createSubDir("iter_log_mean_centering");
        
        //Output pre-normalization RI results
        DataPrep dataPrep;
        // Mod for MeV DataReporter dr;
        // Mod for MeV preName = super.proj.getProjPath() + "iter_log_mean_centering" + FileBrowser.fsep + fileCW.getFileName() + "_pre.prc";
        dataPrep = new DataPrep(fileCW);
        // Mod for MeV dr = new DataReporter(preName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
        
        try{
            fCW = fileCW;
            
            cy3Column = fileCW.getColumnOneArray();
            cy5Column = fileCW.getColumnTwoArray();
            int totalRowCount = fCW.getRowCounts();
            
            boolean[] tempFlag = fileCW.getRowFlagArray();
            inputFlag = new boolean[tempFlag.length];
            System.arraycopy(tempFlag, 0, inputFlag, 0, tempFlag.length);
            
            boolean[] iterLogFlag = new boolean[fileCW.getRowCounts()];
            iterLogFlag = new NegateFlags(iterLogFlag).getNegateFlag();
            iterLogFlag = new AndFlags(iterLogFlag, inputFlag).getAndFlag();

            System.out.println("    Pre-normalized results outputing ...");
            //DataPrep dataPrep;
            // Mod for MeV DataReporter dr;
            // Mod for MeV
            //String prePrcName = super.proj.getProjPath() + "iter_log_mean_centering" + FileBrowser.fsep + fileCW.getFileName() + "_pre.prc";
            dataPrep = new DataPrep(fileCW);
            // Mod for MeV dr = new DataReporter(prePrcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));

            int lastQualiCount = 0;
            
            CyToLogProdRatio lpr = new CyToLogProdRatio(cy3Column, cy5Column, iterLogFlag);
            logRatio = lpr.getLogRatio();
            lastQualiCount = logRatio.length;
            
            //for (int i = 0; i < logRatio.length; i++){
            //    System.out.println("~~~~ i = " + i + ", logRatio = " + logRatio[i]);
            //}
            
            while (true){
                //Compute logRatioMean and logRatioSD
                StatsTools sTools = new StatsTools();
                sTools.computeMeanSD(logRatio);
                logRatioMean = sTools.getXMean();
                logRatioSD = sTools.getXSD();
                System.out.println("    ------ iteration " + m + " ------");
                System.out.println("    Within Range Count  = " + lastQualiCount);
                System.out.println("    logRatioMean        = " + logRatioMean);
                System.out.println("    logRatioSD          = " + logRatioSD);
                withinRangeCounts[m] = lastQualiCount;
                logRatioMeans[m] = logRatioMean;
                logRatioSDs[m] = logRatioSD;
                
                int qualifiedCount = 0;
                
                for (int rawNdx = 0; rawNdx < totalRowCount; rawNdx++){
                    if (cy3Column[rawNdx] > 1 && cy5Column[rawNdx] > 1 && iterLogFlag[rawNdx]){
                        //Normalization
                        if (ref.equalsIgnoreCase("Cy3")){         //We will change cy5 column
                            cy5Column[rawNdx] /= Math.pow(2.0, logRatioMean);
                        }else{                                                      //We will change cy3 column
                            cy3Column[rawNdx] *= Math.pow(2.0, logRatioMean);
                        }
                        //Get qualified data set
                        if ( Math.abs(MathTools.log2(cy5Column[rawNdx] / cy3Column[rawNdx])) < (logRatioSD * nSD) ){
                            logRatio[qualifiedCount] = MathTools.log2(cy5Column[rawNdx] / cy3Column[rawNdx]);
                            qualifiedCount++;
                        }else{
                            iterLogFlag[rawNdx] = false;
                        }
                    }else{}
                }
                if ( (qualifiedCount == lastQualiCount) || (m > 100)){              //Convergentcondition reached
                    System.out.println("    *********************************");
                    break;
                }else if (m > 100){                                                 //Avoid dead iteration, max iteration number = 100
                    System.out.println("    Maximum iteration number 100 reached! ");
                    break;
                }else{
                    float[] t = new float[logRatio.length];
                    System.arraycopy(logRatio, 0, t, 0, logRatio.length);
                    logRatio = new float[qualifiedCount];
                    System.arraycopy(t, 0, logRatio, 0, qualifiedCount);
                    lastQualiCount = qualifiedCount;
                    m++;
                }
            }
            
            //Prepare Insert Columns
            fCW.setColOneArray(cy3Column);
            fCW.setColTwoArray(cy5Column);
            
            //Output post-normalization RI results
            /* Mod for MeV
            String postPrcName = super.proj.getProjPath() + "iter_log_mean_centering" + FileBrowser.fsep + fileCW.getFileName() + "_post.prc";
            dataPrep = new DataPrep(fileCW);
            dr = new DataReporter(postPrcName, dataPrep.getLogProd(), dataPrep.getLogRatio(), new IndexAdjuster().addOne(dataPrep.getRawNdx()));
            int outCount = dataPrep.getNonZeroCount();
        
            Hashtable hash = new Hashtable();
            hash.put(new String("pre_prc_name"), prePrcName);
            hash.put(new String("post_prc_name"), postPrcName);
            hash.put(new String("iterations"), new Integer(m));
            hash.put(new String("out_row_count"), new Integer(outCount));
            proj.insertReportItem("iter_log_mean_for_" + fileCW.getFileName(), hash);
            */
            
        }catch (Exception ex){
            throw ex;
        }
    }
    
    public final ColumnWorker getIterLogMeanColumnWorker(){
        return fCW;
    }
    
    public final int getIterationCounts(){
        return m;
    }
    
    public final int[] getWithinRangeCounts(){
        return withinRangeCounts;
    }
    
    public final float[] getLogRatioMeans(){
        return logRatioMeans;
    }
        
    public final float[] getLogRatioSDs(){
        return logRatioSDs;
    }

    public static void main(String args[]) {
        
        
        try{
            ColumnWorker fileCW = new ColumnWorker("C:\\DataFiles0\\32K\\SimonData\\1233259D2F.tav");
            fileCW.setColumnsForMeta(2, 3);
            fileCW.setColumns(6, 7, 15, 16);
            fileCW.computeGoodRatiosAndLogRatios(0, 0);
            IterativeLogMean ilm = new IterativeLogMean(fileCW, 3.0f, "Cy3");
        }catch (FileNotFoundException nfex){
            nfex.printStackTrace();
        }catch (NumberFormatException nex){
            nex.printStackTrace();
        }catch (Exception ex){
            ex.printStackTrace();
        }
    }
}
