package DistLib;

/* data translated from C using perl script translate.pl */
/* script version 0.00                               */


import java.lang.*;
import java.lang.Math;
import java.lang.Double;

public class uniform 
  { 
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double density(double x, double a, double b);
     *
     *  DESCRIPTION
     *
     *    The density of the uniform distribution.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  density(double x, double a, double b)
    {
    /*!* #ifdef IEEE_754 /*4!*/
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b))
    	return x + a + b;
    /*!* #endif /*4!*/
        if (b <= a) {
    	throw new java.lang.ArithmeticException("Math Error: DOMAIN");
	//    	return Double.NaN;
        }
        if (a <= x && x <= b)
    	return 1.0 / (b - a);
        return 0.0;
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double cumulative(double x, double a, double b);
     *
     *  DESCRIPTION
     *
     *    The distribution function of the uniform distribution.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  cumulative(double x, double a, double b)
    {
    /*!* #ifdef IEEE_754 /*4!*/
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b))
    	return x + a + b;
    /*!* #endif /*4!*/
        if (b <= a) {
    	throw new java.lang.ArithmeticException("Math Error: DOMAIN");
	//    	return Double.NaN;
        }
        if (x <= a)
    	return 0.0;
        if (x >= b)
    	return 1.0;
        return (x - a) / (b - a);
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double density(double x, double a, double b);
     *
     *  DESCRIPTION
     *
     *    The quantile function of the uniform distribution.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  quantile(double x, double a, double b)
    {
    /*!* #ifdef IEEE_754 /*4!*/
        if (Double.isNaN(x) || Double.isNaN(a) || Double.isNaN(b))
    	return x + a + b;
    /*!* #endif /*4!*/
        if (b <= a || x < 0 || x > 1) {
    	throw new java.lang.ArithmeticException("Math Error: DOMAIN");
	//    	return Double.NaN;
        }
        return a + x * (b - a);
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double random(double a, double b);
     *
     *  DESCRIPTION
     *
     *    Random variates from the uniform distribution.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  random(double a, double b)
    {
        if (
    /*!* #ifdef IEEE_754 /*4!*/
	    Double.isInfinite(a) || Double.isInfinite(b) ||
    /*!* #endif /*4!*/
	    b < a) {
	  throw new java.lang.ArithmeticException("Math Error: DOMAIN");
	  //    	return Double.NaN;
        }
        if (a == b) 
    	return a;
        else 
    	return a + (b - a) * random();
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double random(void);
     *
     *  DESCRIPTION
     *
     *     Random variates from the standard uniform distribution, U(0,1).
     *
     *  REFERENCE
     *
     *    Wichmann, B. A. and I. D. Hill (1982).
     *    Algorithm AS 183: An efficient and portable
     *    pseudo-random number generator,
     *    Applied Statistics, 31, 188.
     */
    
    /*!* #include "DistLib.h"/*-> ../include/Random.h */ /*4!*/
    /*!* #include <time.h>/* for Randomize() */ /*4!*/
    
    /* ----------------
     * New Scheme: Allow CHOICE of Random Number Generator [RNG]
     *
     * For R, the setup here must be compatible with
     * GetSeeds(), SetSeeds(), SetRNG()  from  ../main/random.c
     *
     */

      static final int WICHMANN_HILL=0,
	               MARSAGLIA_MULTICARRY=1,
	               SUPER_DUPER=2,
	               RAND=3,
	               MERSENNE_TWISTER=4,
	               NUM_RNGS=5;

      static class RNGTAB {
	    static int kind;          /* above enum: 0,1,2... */
	    static String name;       /* print name */
	    static boolean is_seeded; /* False(0), True(1) */
	    static int n_seed;        /* length of seed vector */
	    static int i1_seed;
	    static int i_seed[];

	    public RNGTAB( int     in_kind, 
			   String  in_name, 
			   boolean in_is_seeded, 
			   int     in_n_seed, 
			   int     in_i1_seed)
	    {
		kind      = in_kind;
		name      = in_name;
		is_seeded = in_is_seeded;
		n_seed    = in_n_seed;
		i1_seed   = in_i1_seed;
		i_seed = new int[n_seed];
	    }
	}
      //#define i2_seed i_seed[0]
      //#define i_seed[1] i_seed[1]

    
    int dummy[] = new int[3];
    
    static RNGTAB RNG_Table[] ;

    public uniform() {
      RNGTAB Local_RNG_Table[] = {
	/* kind	  name		is_seeded seed-length	i1_s, *seed-vec */
	new RNGTAB( WICHMANN_HILL,        "Wichmann-Hill",        false,	3,	123),
	new RNGTAB( MARSAGLIA_MULTICARRY, "Marsaglia-MultiCarry", false,	2,	123),
	new RNGTAB( SUPER_DUPER,          "Super-Duper",          false,	2,	123),
	new RNGTAB( MERSENNE_TWISTER,     "Mersenne-Twister",     false,    1+624,	123),
	new RNGTAB( RAND,                 "Rand",		  false,	2,	-1 )
      };

      RNG_Table = Local_RNG_Table;
      
      for(int i=0; i < NUM_RNGS; i++)
	  FixupSeeds(i);

    }

    static int RNG_kind = WICHMANN_HILL;
    
    static java.util.Random JRandom = new java.util.Random();


    /* SEED vector:  Assume 32 __or more__ bits 
    
     * The first few are `unrolled' for speed
     * Here, use maximal seed length from above;
     *
     */
    
    /*unsigned long int i1_seed, i_seed[0], i_seed[1+624 - 2];
     */
    
    static private double  d2_32   = 4294967296./* = (double) */; 
    static private double  i2_32m1 = 2.328306437080797e-10/* = 1/(2^32 - 1) */; 
    
    /* do32bits(): Zero bits higher than 32
     * ----------
     * & 037.. really does nothing when long=32bits, 
     * however does every compiler optimize this?  -- optimize ourselves!
     */
    /*!* #ifdef LONG_32_BITS /*4!*/
    static private int  do32bits(int N){ return  (N);}
    /*!* #else /*4!*/
      //    static private double  do32bits(N) = ((N) & 037777777777)
    /*!* #endif /*4!*/
    
      // #define  I1  RNG_Table[RNG_kind].i1_seed
      // #define  I2 = RNG_Table[RNG_kind].i_seed[0]; 
      // #define  I3 = RNG_Table[RNG_kind].i_seed[1]; 
      // #define  ISd = RNG_Table[RNG_kind].i_seed; 
    
    public static double  random()
    {
        double value;
    
        switch(RNG_kind) {
    
        case WICHMANN_HILL:
    	RNG_Table[RNG_kind].i1_seed = RNG_Table[RNG_kind].i1_seed * 171 % 30269;
    	RNG_Table[RNG_kind].i_seed[0] = RNG_Table[RNG_kind].i_seed[0] * 172 % 30307;
    	RNG_Table[RNG_kind].i_seed[1] = RNG_Table[RNG_kind].i_seed[1] * 170 % 30323;
    	value =
    	  RNG_Table[RNG_kind].i1_seed / 30269.0 +
    	  RNG_Table[RNG_kind].i_seed[0] / 30307.0 +
    	  RNG_Table[RNG_kind].i_seed[1] / 30323.0;
    	return value - (int) value;/* in [0,1) */
    
        case MARSAGLIA_MULTICARRY:/* 0177777(octal) == 65535(decimal)*/
    	/* The following also works when 'usigned long' is > 32 bits : */
    	RNG_Table[RNG_kind].i1_seed= 36969*(RNG_Table[RNG_kind].i1_seed & 0177777) + (RNG_Table[RNG_kind].i1_seed>>16);
    	RNG_Table[RNG_kind].i_seed[0]= 18000*(RNG_Table[RNG_kind].i_seed[0] & 0177777) + (RNG_Table[RNG_kind].i_seed[0]>>16);
    	return (do32bits(RNG_Table[RNG_kind].i1_seed << 16)^(RNG_Table[RNG_kind].i_seed[0] & 0177777))
    	    * i2_32m1;/* in [0,1) */
    
        case SUPER_DUPER:
    
    	/* This is Reeds et al (1984) implementation; 
    	 * modified using __unsigned__  seeds instead of signed ones
    	 */
    	RNG_Table[RNG_kind].i1_seed ^= ((RNG_Table[RNG_kind].i1_seed >> 15) & 0377777);/*  Tausworthe */
    	RNG_Table[RNG_kind].i1_seed ^= do32bits(RNG_Table[RNG_kind].i1_seed << 17);
    /*!* #ifdef LONG_32_BITS /*4!*/
    	RNG_Table[RNG_kind].i_seed[0] *= 69069;		/* Congruential */
    /*!* #else /*4!*/
    	RNG_Table[RNG_kind].i_seed[0] = do32bits(69069 * RNG_Table[RNG_kind].i_seed[0]);
    /*!* #endif /*4!*/
    	return (RNG_Table[RNG_kind].i1_seed^RNG_Table[RNG_kind].i_seed[0]) * i2_32m1;/* in [0,1) */
    
        case RAND:
    	/* Use ANSI C_INTERNAL  (with which you can only SET a seed,
    	   but not get the current)*/
    
    	return JRandom.nextDouble();/* in [0,1) */
    
        case MERSENNE_TWISTER:
    
    	return 0.5;/*PLACE HOLDER*/
    
        default:/* can never happen (enum type)*/ return -1.;
      }
    }
    
    /*--- This are called from ../main/random.c : ---------*/
    
    void FixupSeeds(int kind)
    {
    /* Depending on RNG, set 0 values to non-0, etc. */
    
        int j; 
        int tkind;
    
        /* Set 0 to 1 : */
        if(RNG_Table[kind].i1_seed==0) RNG_Table[kind].i1_seed++;
        for(j=0; j <= RNG_Table[kind].n_seed - 2; j++)
    	if(RNG_Table[kind].i_seed[j]==0) RNG_Table[kind].i_seed[j]++;
    
        switch(kind) {
        case WICHMANN_HILL:
    	if(RNG_Table[kind].i1_seed >= 30269 ||
    	   RNG_Table[kind].i_seed[0] >= 30307 ||
    	   RNG_Table[kind].i_seed[1] >= 30323 ) {/*.Random.seed was screwed up */
    	    /* do 1 iteration */
    	    tkind = RNG_kind; RNG_kind = WICHMANN_HILL;
    	    random();
    	    RNG_kind = tkind;
    	}
    	return;
        case MARSAGLIA_MULTICARRY: 
    	return;
        case SUPER_DUPER:
    	/* RNG_Table[RNG_kind].i_seed[0] = Congruential: must be ODD */
    	RNG_Table[kind].i_seed[0] |= 1;
    	break;
    
        case RAND:/* no read-access to seed */
    
        case MERSENNE_TWISTER:
    
    	break;
        }
    }
    
    void MaybeAllocSeeds(int kind)
    {
        if(! RNG_Table[kind].is_seeded) { /* allocate ! */
    /*!* #ifdef DEBUG /*4!*/
    	System.out.println("Allocating seed (length " + 
			   ( RNG_Table[kind].n_seed - 1) + 
			   ") for RNG kind " + kind + "\n");

    /*!* #endif /*4!*/
    	RNG_Table[kind].i_seed = new int[RNG_Table[kind].n_seed - 1];
    	RNG_Table[kind].is_seeded = true;
        }
    }
    
    void RNG_Init(int kind, long seed)
    {
        int j;
    
        RNG_Table[kind].i1_seed = (int) seed;
        for(j=0; j < RNG_Table[RNG_kind].n_seed - 1; j++) {
    	seed = (69069 * seed) & 0xffffffff;
    	RNG_Table[kind].i_seed[j] = (int) seed;
        }
        FixupSeeds(kind);
    }
    
    void Randomize(int kind)
    {
    /* Only called by  GetRNGstate(), when there's no .Random.seed */
    
        MaybeAllocSeeds(kind);
    

	java.util.Random tmpRandom = new java.util.Random();
	/* Same as C: srand((int)time(null)); */
        
        RNG_Init(kind, JRandom.nextLong() | 01/* odd */);
    }
    
  }
