package DistLib;

/* data translated from C using perl script translate.pl */
/* script version 0.00                               */


import java.lang.*;
import java.lang.Math;
import java.lang.Double;

public class misc 
  { 
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka and the R Core team.
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     */
    
    /*  DESCRIPTION --> see below */
    
    
    /* From http://www.netlib.org/specfun/ribesl	
       Fortran translated by f2c,...
     *	------------------------------=#----	Martin Maechler, ETH Zurich
     */
    /*!* #include "DistLib.h" /*4!*/
    
    static private final double exparg = 709.;/* maximal x for UNscaled answer, see below */
    
    public static double  bessel_i(double x, double alpha, double expo)
    {
        long nb=0, ncalc=0, ize=0;
        double bi[];
    /*!* #ifdef IEEE_754 /*4!*/
        /* NaNs propagated correctly */
        if (Double.isNaN(x) || Double.isNaN(alpha)) return x + alpha;
    /*!* #endif /*4!*/
        ize = (long)expo;
/*!*     nb = 1+ (long)floor(alpha);!!!COMMENT!!! *!*/
        nb = 1+ (long)java.lang.Math.floor(alpha);/* nb-1 <= alpha < nb */
        alpha -= (nb-1);
        bi = I_bessel(x, alpha, nb, ize, ncalc);
        if(ncalc != nb) {/* error input */
    	if(ncalc < 0)
    	    System.out.println("bessel_i("+ x + "): ncalc (="+ncalc+
			       ") != nb (="+nb+"); alpha="+alpha+
			       ". Arg. out of range?\n" );

    	else
    	    System.out.println("bessel_i("+x+"+nu="+(alpha+nb-1)+
			       "): precision lost in result\n"+
			       "DistLib_h.DBL_EPSILON");
        }
        x = bi[(int)(nb-1)];
        return x;
    }
   

    /* -------------------------------------------------------------------
    
     This routine calculates Bessel functions I_(N+ALPHA) (X)
     for non-negative argument X, and non-negative order N+ALPHA,
     with or without exponential scaling.
    
    
     Explanation of variables in the calling sequence
    
     X     - Non-negative argument for which
    	 I's or exponentially scaled I's (I*EXP(-X))
    	 are to be calculated.	If I's are to be calculated,
    	 X must be less than EXPARG (see below).
     ALPHA - Fractional part of order for which
    	 I's or exponentially scaled I's (I*EXP(-X)) are
    	 to be calculated.  0 <= ALPHA < 1.0.
     NB    - Number of functions to be calculated, NB > 0.
    	 The first function calculated is of order ALPHA, and the
    	 last is of order (NB - 1 + ALPHA).
     IZE   - Type.	IZE = 1 if unscaled I's are to be calculated,
    		    = 2 if exponentially scaled I's are to be calculated.
     BI    - Output vector of length NB.	If the routine
    	 terminates normally (NCALC=NB), the vector BI contains the
    	 functions I(ALPHA,X) through I(NB-1+ALPHA,X), or the
    	 corresponding exponentially scaled functions.
     NCALC - Output variable indicating possible errors.
    	 Before using the vector BI, the user should check that
    	 NCALC=NB, i.e., all orders have been calculated to
    	 the desired accuracy.	See error returns below.
    
    
     *******************************************************************
     *******************************************************************
    
     Error returns
    
      In case of an error,	NCALC != NB, and not all I's are
      calculated to the desired accuracy.
    
      NCALC < 0:  An argument is out of range. For example,
         NB <= 0, IZE is not 1 or 2, or IZE=1 and ABS(X) >= EXPARG.
         In this case, the BI-vector is not calculated, and NCALC is
         set to MIN0(NB,0)-1 so that NCALC != NB.
    
      NB > NCALC > 0: Not all requested function values could
         be calculated accurately.	This usually occurs because NB is
         much larger than ABS(X).  In this case, BI[N] is calculated
         to the desired accuracy for N <= NCALC, but precision
         is lost for NCALC < N <= NB.  If BI[N] does not vanish
         for N > NCALC (because it is too small to be represented),
         and BI[N]/BI[NCALC] = 10**(-K), then only the first NSIG-K
         significant figures of BI[N] can be trusted.
    
    
     Intrinsic functions required are:
    
         DBLE, EXP, gamma_cody, INT, MAX, MIN, REAL, SQRT
    
    
     Acknowledgement
    
      This program is based on a program written by David J.
      Sookne (2) that computes values of the Bessel functions J or
      I of float argument and long order.  Modifications include
      the restriction of the computation to the I Bessel function
      of non-negative float argument, the extension of the computation
      to arbitrary positive order, the inclusion of optional
      exponential scaling, and the elimination of most underflow.
      An earlier version was published in (3).
    
     References: "A Note on Backward Recurrence Algorithms," Olver,
    	      F. W. J., and Sookne, D. J., Math. Comp. 26, 1972,
    	      pp 941-947.
    
    	     "Bessel Functions of Real Argument and Integer Order,"
    	      Sookne, D. J., NBS Jour. of Res. B. 77B, 1973, pp
    	      125-132.
    
    	     "ALGORITHM 597, Sequence of Modified Bessel Functions
    	      of the First Kind," Cody, W. J., Trans. Math. Soft.,
    	      1983, pp. 242-245.
    
      Latest modification: May 30, 1989
    
      Modified by: W. J. Cody and L. Stoltz
    	       Applied Mathematics Division
    	       Argonne National Laboratory
    	       Argonne, IL  60439
    */
    
        /*-------------------------------------------------------------------
          Mathematical constants
          -------------------------------------------------------------------*/
        static private final double const__ = 1.585;
    
    /* *******************************************************************
    
     Explanation of machine-dependent constants
    
       beta	  = Radix for the floating-point system
       minexp = Smallest representable power of beta
       maxexp = Smallest power of beta that overflows
       it	  = Number of bits in the mantissa of a working precision 
                    variable
       NSIG	  = Decimal significance desired.  Should be set to
    	    INT(LOG10(2)*it+1).	 Setting NSIG lower will result
    	    in decreased accuracy while setting NSIG higher will
    	    increase CPU time without increasing accuracy.  The
    	    truncation error is limited to a relative error of
    	    T=.5*10**(-NSIG).
       ENTEN  = 10.0 ** K, where K is the largest long such that
    	    ENTEN is machine-representable in working precision
       ENSIG  = 10.0 ** NSIG
       RTNSIG = 10.0 ** (-K) for the smallest long K such that
    	    K >= NSIG/4
       ENMTEN = Smallest ABS(X) such that X/4 does not underflow
       XLARGE = Upper limit on the magnitude of X when IZE=2.  Bear
    	    in mind that if ABS(X)=N, then at least N iterations
    	    of the backward recursion will be executed.	 The value
    	    of 10.0 ** 4 is used on every machine.
       EXPARG = Largest working precision argument that the library
    	    EXP routine can handle and upper limit on the
    	    magnitude of X when IZE=1; approximately
    	    LOG(beta**maxexp)
    
    
         Approximate values for some important machines are:
    
    		             	  beta	   minexp      maxexp	    it
    
      CRAY-1	(S.P.)	          2	   -8193	8191	    48
      Cyber 180/855
        under NOS	(S.P.)	  2	    -975	1070	    48
      IEEE (IBM/XT,
        SUN, etc.)	(S.P.)	  2	    -126	 128	    24
      IEEE (IBM/XT,
        SUN, etc.)	(D.P.)	  2	   -1022	1024	    53
      IBM 3033	(D.P.)	         16	     -65	  63	    14
      VAX		(S.P.)	  2	    -128	 127	    24
      VAX D-Format	(D.P.)	  2	    -128	 127	    56
      VAX G-Format	(D.P.)	  2	   -1024	1023	    53
    
    
    			       NSIG	   ENTEN       ENSIG	  RTNSIG
    
     CRAY-1	       (S.P.)	 15	  1.0E+2465   1.0E+15	  1.0E-4
     Cyber 180/855
       under NOS   (S.P.)	 15	  1.0E+322    1.0E+15	  1.0E-4
     IEEE (IBM/XT,
       SUN, etc.)  (S.P.)	  8	  1.0E+38     1.0E+8	  1.0E-2
     IEEE (IBM/XT,
       SUN, etc.)  (D.P.)	 16	  1.0D+308    1.0D+16	  1.0D-4
     IBM 3033      (D.P.)	  5	  1.0D+75     1.0D+5	  1.0D-2
     VAX	       (S.P.)	  8	  1.0E+38     1.0E+8	  1.0E-2
     VAX D-Format  (D.P.)	 17	  1.0D+38     1.0D+17	  1.0D-5
     VAX G-Format  (D.P.)	 16	  1.0D+307    1.0D+16	  1.0D-4
    
    
                                ENMTEN	     XLARGE   EXPARG
    
     CRAY-1       (S.P.)	1.84E-2466   1.0E+4    5677
     Cyber 180/855
       under NOS   (S.P.)	1.25E-293    1.0E+4	741
     IEEE (IBM/XT,
       SUN, etc.)  (S.P.)	4.70E-38     1.0E+4	 88
     IEEE (IBM/XT,
       SUN, etc.)  (D.P.)	8.90D-308    1.0D+4	709
     IBM 3033      (D.P.)	2.16D-78     1.0D+4	174
     VAX	       (S.P.)	1.17E-38     1.0E+4	 88
     VAX D-Format  (D.P.)	1.17D-38     1.0D+4	 88
     VAX G-Format  (D.P.)	2.22D-308    1.0D+4	709
    
     *******************************************************************
     -------------------------------------------------------------------
      Machine-dependent parameters
     -------------------------------------------------------------------
    */
    static double[] I_bessel(double x, double alpha, long nb, long ize, long ncalc)
    {

        final long   nsig   =   16;
        final double ensig  = 1e16;
        final double rtnsig = 1e-4;
        final double enmten = 8.9e-308;
        final double enten  = 1e308;
        final double xlarge = 1e4;
    
    /*!*     extern double gamma_cody(double);/*--> ./gamma.c */ /*!*/
    
        /* Builtin functions */
    /*!*     double java.lang.Math.pow(double *, long *) /*4!*/
    
        /* Local variables */
        long nend, intx, nbmx, k, l, n, nstart;
        double pold, test,	p, em, en, empal, emp2al, halfx,
    	aa, bb, cc, psave, plast, tover, psavel, sum, nu, twonu;
    
        /*Parameter adjustments */
        double bi[] = new double[(int)(nb+1)]; ;
        nu = alpha;
        twonu = nu + nu;
    
        /*-------------------------------------------------------------------
          Check for X, NB, OR IZE out of range.
          ------------------------------------------------------------------- */
        if (nb > 0 && x >= 0. &&	(0. <= nu && nu < 1.) &&
    	(1 <= ize && ize <= 2) ) {
    
    	ncalc = nb;
    	if((ize == 1 && x > exparg) ||
    	   (ize == 2 && x > xlarge)) {
    	    throw new java.lang.ArithmeticException("Math Error: RANGE");
	    //    	    for(k=1; k <= nb; k++)
	    //    		bi[k]=Double.POSITIVE_INFINITY;
	    //    	    return;
    	}
    	intx = (long) (x);
    	if (x >= rtnsig) { /* "non-small" x */
    /* -------------------------------------------------------------------
       Initialize the forward sweep, the P-sequence of Olver
       ------------------------------------------------------------------- */
    	    nbmx = nb - intx;
    	    n = intx + 1;
    	    en = (double) (n + n) + twonu;
    	    plast = 1.;
    	    p = en / x;
    	    /* ------------------------------------------------
    	       Calculate general significance test
    	       ------------------------------------------------ */
    	    test = ensig + ensig;
    	    if (intx << 1 > nsig * 5) {
/*!* 		test = sqrt(test * p); *!*/
    		test = java.lang.Math.sqrt(test * p);
    	    } else {
    		test /= java.lang.Math.pow(const__, intx);
    	    }
L120:	{
    	    if (nbmx >= 3) {
    		/* --------------------------------------------------
    		   Calculate P-sequence until N = NB-1
    		   Check for possible overflow.
    		   ------------------------------------------------ */
    		tover = enten / ensig;
    		nstart = intx + 2;
    		nend = nb - 1;
    		for (k = nstart; k <= nend; ++k) {
    		    n = k;
    		    en += 2.;
    		    pold = plast;
    		    plast = p;
    		    p = en * plast / x + pold;
    		    if (p > tover) {
    			/* ------------------------------------------------
    			   To avoid overflow, divide P-sequence by TOVER.
    			   Calculate P-sequence until ABS(P) > 1.
    			   ---------------------------------------------- */
    			tover = enten;
    			p /= tover;
    			plast /= tover;
    			psave = p;
    			psavel = plast;
    			nstart = n + 1;
    			do {
    			    ++n;
    			    en += 2.;
    			    pold = plast;
    			    plast = p;
    			    p = en * plast / x + pold;
    			}
    			while (p <= 1.);
    
    			bb = en / x;
    			/* ------------------------------------------------
    			   Calculate backward test, and find NCALC,
    			   the highest N such that the test is passed.
    			   ------------------------------------------------ */
    			test = pold * plast / ensig;
    			test *= .5 - .5 / (bb * bb);
    			p = plast * tover;
    			--n;
    			en -= 2.;
    			nend = Math.min(nb,n);
    L90:                {
    			for (l = nstart; l <= nend; ++l) {
    			    ncalc = l;
    			    pold = psavel;
    			    psavel = psave;
    			    psave = en * psavel / x + pold;
    			    if (psave * psavel > test) {
    				break L90;
    			    }
    			}
    			ncalc = nend + 1;
			} // L90:
    			--ncalc;
    			break L120;
    		    }
    		}
    		n = nend;
    		en = (double)(n + n) + twonu;
    		/*---------------------------------------------------
    		  Calculate special significance test for NBMX > 2.
    		  --------------------------------------------------- */
/*!* 		test = fmax2(test,sqrt(plast * ensig) * sqrt(p + p)); *!*/
    		test = fmax2(test,java.lang.Math.sqrt(plast * ensig) * java.lang.Math.sqrt(p + p));
    	    }
    	    /* --------------------------------------------------------
    	       Calculate P-sequence until significance test passed.
    	       -------------------------------------------------------- */
    	    do {
    		++n;
    		en += 2.;
    		pold = plast;
    		plast = p;
    		p = en * plast / x + pold;
    	    } while (p < test);
	    } // L120:
    /* -------------------------------------------------------------------
     Initialize the backward recursion and the normalization sum.
     ------------------------------------------------------------------- */
    	    ++n;
    	    en += 2.;
    	    bb = 0.;
    	    aa = 1. / p;
    	    em = (double) n - 1.;
    	    empal = em + nu;
    	    emp2al = em - 1. + twonu;
    	    sum = aa * empal * emp2al / em;
    	    nend = n - nb;
   L230:    {
   L220:    {
    	    if (nend < 0) {
    		/* -----------------------------------------------------
    		   N < NB, so store BI[N] and set higher orders to 0..
    		   ----------------------------------------------------- */
    		bi[(int) n] = aa;
    		nend = -nend;
    		for (l = 1; l <= nend; ++l) {
    		    bi[(int)(n + l)] = 0.;
    		}
    	    } else {
    		if (nend > 0) {
    		    /* -----------------------------------------------------
    		       Recur backward via difference equation,
    		       calculating (but not storing) BI[N], until N = NB.
    		       --------------------------------------------------- */
    		    for (l = 1; l <= nend; ++l) {
    			--n;
    			en -= 2.;
    			cc = bb;
    			bb = aa;
    			aa = en * bb / x + cc;
    			em -= 1.;
    			emp2al -= 1.;
    			if (n == 1) {
    			    break;
    			}
    			if (n == 2) {
    			    emp2al = 1.;
    			}
    			empal -= 1.;
    			sum = (sum + aa * empal) * emp2al / em;
    		    }
    		}
    		/* ---------------------------------------------------
    		   Store BI[NB]
    		   --------------------------------------------------- */
    		bi[(int) n] = aa;
    		if (nb <= 1) {
    		    sum = sum + sum + aa;
    		    break L230;
    		}
    		/* -------------------------------------------------
    		   Calculate and Store BI[NB-1]
    		   ------------------------------------------------- */
    		--n;
    		en -= 2.;
    		bi[(int)n] = en * aa / x + bb;
    		if (n == 1) {
    		    break L220;
    		}
    		em -= 1.;
    		if (n == 2)
    		    emp2al = 1.;
    		else
    		    emp2al -= 1.;
    
    		empal -= 1.;
    		sum = (sum + bi[(int)n] * empal) * emp2al / em;
    	    }
    	    nend = n - 2;
    	    if (nend > 0) {
    		/* --------------------------------------------
    		   Calculate via difference equation
    		   and store BI[(int) n], until N = 2.
    		   ------------------------------------------ */
    		for (l = 1; l <= nend; ++l) {
    		    --n;
    		    en -= 2.;
    		    bi[(int) n] = en * bi[(int) n + 1] / x + bi[(int) n + 2];
    		    em -= 1.;
    		    if (n == 2)
    			emp2al = 1.;
    		    else
    			emp2al -= 1.;
    		    empal -= 1.;
    		    sum = (sum + bi[(int) n] * empal) * emp2al / em;
    		}
    	    }
    	    /* ----------------------------------------------
    	       Calculate BI[1]
    	       -------------------------------------------- */
    	    bi[1] = 2. * empal * bi[2] / x + bi[3];

	    } //    L220:
    	    sum = sum + sum + bi[1];
    
	    }//    L230:
    	    /* ---------------------------------------------------------
    	       Normalize.  Divide all BI[(int) n] by sum.
    	       --------------------------------------------------------- */
    	    if (nu != 0.)
/*!* 		sum *= (gamma_cody(1. + nu) * pow(x * .5, -nu)); *!*/
    		sum *= (gamma_cody(1. + nu) * java.lang.Math.pow(x * .5, -nu));
    	    if (ize == 1)
/*!* 		sum *= exp(-(x)); *!*/
    		sum *= java.lang.Math.exp(-(x));
    	    aa = enmten;
    	    if (sum > 1.)
    		aa *= sum;
    	    for (n = 1; n <= nb; ++n) {
    		if (bi[(int) n] < aa)
    		    bi[(int) n] = 0.;
    		else
    		    bi[(int) n] /= sum;
    	    }
    	    {
		double[] retval = new double[(int) nb];
		int i=0;
		for (i=0; i<nb; i++)
		    retval[i] = bi[i+1];
		
		return(retval);
	    }
    	} else {
    	    /* -----------------------------------------------------------
    	       Two-term ascending series for small X.
    	       -----------------------------------------------------------*/
    	    aa = 1.;
    	    empal = 1. + nu;
    	    if (x > enmten)
    		halfx = .5 * x;
    	    else
    		halfx = 0.;
    	    if (nu != 0.)
/*!* 		aa = pow(halfx, nu) / gamma_cody(empal); *!*/
    		aa = java.lang.Math.pow(halfx, nu) / gamma_cody(empal);
    	    if (ize == 2)
/*!* 		aa *= exp(-(x)); *!*/
    		aa *= java.lang.Math.exp(-(x));
    	    if (x + 1. > 1.)
    		bb = halfx * halfx;
    	    else
    		bb = 0.;
    
    	    bi[1] = aa + aa * bb / empal;
    	    if (x != 0. && bi[1] == 0.)
    		ncalc = 0;
    	    if (nb > 1) {
    		if (x == 0.) {
    		    for (n = 2; n <= nb; ++n) {
    			bi[(int) n] = 0.;
    		    }
    		} else {
    		    /* -------------------------------------------------
    		       Calculate higher-order functions.
    		       ------------------------------------------------- */
    		    cc = halfx;
    		    tover = (enmten + enmten) / x;
    		    if (bb != 0.)
    			tover = enmten / bb;
    		    for (n = 2; n <= nb; ++n) {
    			aa /= empal;
    			empal += 1.;
    			aa *= cc;
    			if (aa <= tover * empal)
    			    bi[(int) n] = aa = 0.;
    			else
    			    bi[(int) n] = aa + aa * bb / empal;
    			if (bi[(int) n] == 0. && ncalc > n)
    			    ncalc = n - 1;
    		    }
    		}
    	    }
    	}
        } else {
    	ncalc = Math.min(nb,0) - 1;
        }

	{
	double[] retval = new double[(int) nb];
	int i=0;
	for (i=0; i<nb; i++)
	    retval[i] = bi[i+1];
		
	return(retval);
	}

    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka and the R Core team.
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     */
    
    /*  DESCRIPTION --> see below */
    
    
    /* From http://www.netlib.org/specfun/rjbesl	Fortran translated by f2c,...
     *	------------------------------=#----	Martin Maechler, ETH Zurich
     */
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  bessel_j(double x, double alpha)
    {
        long nb=0, ncalc=0;
        double bj[];
    /*!* #ifdef IEEE_754 /*4!*/
        /* NaNs propagated correctly */
        if (Double.isNaN(x) || Double.isNaN(alpha)) return x + alpha;
    /*!* #endif /*4!*/
        if (x < 0 || alpha < 0) {
          throw new java.lang.ArithmeticException("Math Error: RANGE");
	  //          return Double.NaN;
        }
/*!*     nb = 1+ (long)floor(alpha);!!!COMMENT!!! *!*/
        nb = 1+ (long)java.lang.Math.floor(alpha);/* nb-1 <= alpha < nb */
        alpha -= (nb-1);
        bj = J_bessel(x, alpha, nb, ncalc);
        if(ncalc != nb) {/* error input */
          if(ncalc < 0)
    	System.out.println("bessel_j("+x+"): ncalc (="+ncalc+") != nb (="+nb+
			   "); alpha="+alpha+". Arg. out of range?\n");
          else
    	System.out.println("bessel_j("+x+"+nu="+(alpha+nb-1)+
			   "): precision lost in result\n");
        }
        x = bj[(int) nb-1];
        return x;
    }
    
    static double[] J_bessel(double x, double alpha, long nb, long ncalc)
    {
    /* ---------------------------------------------------------------------
    
     This routine calculates Bessel functions J_(N+ALPHA) (X)
     for non-negative argument X, and non-negative order N+ALPHA.
    
    
      Explanation of variables in the calling sequence.
    
     X     - Non-negative argument for which
    	 J's are to be calculated.
     ALPHA - Fractional part of order for which
    	 J's or exponentially scaled J'r (J*exp(X)) are
    	 to be calculated.  0 <= ALPHA < 1.
     NB    - Number of functions to be calculated, NB > 0.
    	 The first function calculated is of order ALPHA, and the
    	 last is of order (NB - 1 + ALPHA).
     B     - Output vector of length NB.  If RJBESL
    	 terminates normally (NCALC=NB), the vector B contains the
    	 functions J/ALPHA/(X) through J/NB-1+ALPHA/(X), or the
    	 corresponding exponentially scaled functions.
     NCALC - Output variable indicating possible errors.
    	 Before using the vector B, the user should check that
    	 NCALC=NB, i.e., all orders have been calculated to
    	 the desired accuracy.	See Error Returns below.
    
    
     *******************************************************************
    
      Error returns
    
        In case of an error,  NCALC != NB, and not all J's are
        calculated to the desired accuracy.
    
        NCALC < 0:	An argument is out of range. For example,
           NBES <= 0, ALPHA < 0 or > 1, or X is too large.
           In this case, b[1] is set to zero, the remainder of the
           B-vector is not calculated, and NCALC is set to
           MIN(NB,0)-1 so that NCALC != NB.
    
        NB > NCALC > 0: Not all requested function values could
           be calculated accurately.  This usually occurs because NB is
           much larger than ABS(X).	 In this case, b[(int) n] is calculated
           to the desired accuracy for N <= NCALC, but precision
           is lost for NCALC < N <= NB.  If b[(int) n] does not vanish
           for N > NCALC (because it is too small to be represented),
           and b[(int) n]/B(NCALC) = 10**(-K), then only the first NSIG-K
           significant figures of b[(int) n] can be trusted.
    
    
      Intrinsic and other functions required are:
    
         ABS, AINT, COS, DBLE, GAMMA (or DGAMMA), INT, MAX, MIN,
    
         REAL, SIN, SQRT
    
    
      Acknowledgement
    
       This program is based on a program written by David J. Sookne
       (2) that computes values of the Bessel functions J or I of float
       argument and long order.  Modifications include the restriction
       of the computation to the J Bessel function of non-negative float
       argument, the extension of the computation to arbitrary positive
       order, and the elimination of most underflow.
    
      References: "A Note on Backward Recurrence Algorithms," Olver,
    	       F. W. J., and Sookne, D. J., Math. Comp. 26, 1972,
    	       pp 941-947.
    
    	      "Bessel Functions of Real Argument and Integer Order,"
    	       Sookne, D. J., NBS Jour. of Res. B. 77B, 1973, pp
    	       125-132.
    
      Latest modification: March 19, 1990
    
      Author: W. J. Cody
    	  Applied Mathematics Division
    	  Argonne National Laboratory
    	  Argonne, IL  60439
     *******************************************************************
     */
    
    /* ---------------------------------------------------------------------
      Mathematical constants
    
       PI2	  - 2 / PI
       TWOPI1 - first few significant digits of 2 * PI
       TWOPI2 - (2*PI - TWOPI1) to working precision, i.e.,
    	    TWOPI1 + TWOPI2 = 2 * PI to extra precision.
     --------------------------------------------------------------------- */
        final double pi2 = .636619772367581343075535;
        final double twopi1 = 6.28125;
        final double twopi2 =  .001935307179586476925286767;
    
    
    /********************************************************************
    
      Explanation of machine-dependent constants
    
       it    = Number of bits in the mantissa of a working precision
    	    variable
       NSIG  = Decimal significance desired.  Should be set to
    	    INT(LOG10(2)*it+1).	 Setting NSIG lower will result
    	    in decreased accuracy while setting NSIG higher will
    	    increase CPU time without increasing accuracy.  The
    	    truncation error is limited to a relative error of
    	    T=.5*10**(-NSIG).
       ENTEN  = 10.0 ** K, where K is the largest long such that
    	    ENTEN is machine-representable in working precision
       ENSIG  = 10.0 ** NSIG
       RTNSIG = 10.0 ** (-K) for the smallest long K such that
    	    K >= NSIG/4
       ENMTEN = Smallest ABS(X) such that X/4 does not underflow
       XLARGE = Upper limit on the magnitude of X.	If ABS(X)=N,
    	    then at least N iterations of the backward recursion
    	    will be executed.  The value of 10.0 ** 4 is used on
    	    every machine.
    
    
         Approximate values for some important machines are:
    
    			    it	  NSIG	  ENTEN	      ENSIG
    
      CRAY-1	 (S.P.)	    48	   15	 1.0E+2465   1.0E+15
      Cyber 180/855
      under NOS	 (S.P.)	    48	   15	 1.0E+322    1.0E+15
      IEEE (IBM/XT,
      SUN, etc.) (S.P.)	    24	    8	 1.0E+38     1.0E+8
      IEEE (IBM/XT,
      SUN, etc.) (D.P.)	    53	   16	 1.0D+308    1.0D+16
      IBM 3033	 (D.P.)	    14	    5	 1.0D+75     1.0D+5
      VAX	 (S.P.)	    24	    8	 1.0E+38     1.0E+8
      VAX D-Format (D.P.)   56	   17	 1.0D+38     1.0D+17
      VAX G-Format (D.P.)   53	   16	 1.0D+307    1.0D+16
    
    
    			   RTNSIG      ENMTEN	   XLARGE
    
      CRAY-1	 (S.P.)	   1.0E-4    1.84E-2466	  1.0E+4
      Cyber 180/855
      under NOS	 (S.P.)	   1.0E-4    1.25E-293	  1.0E+4
      IEEE (IBM/XT,
      SUN, etc.) (S.P.)	   1.0E-2    4.70E-38	  1.0E+4
      IEEE (IBM/XT,
      SUN, etc.) (D.P.)	   1.0E-4    8.90D-308	  1.0D+4
      IBM 3033	 (D.P.)	   1.0E-2    2.16D-78	  1.0D+4
      VAX	 (S.P.)	   1.0E-2    1.17E-38	  1.0E+4
      VAX D-Format (D.P.)  1.0E-5    1.17D-38	  1.0D+4
      VAX G-Format (D.P.)  1.0E-4    2.22D-308	  1.0D+4
    
     *******************************************************************
    */
    /*---------------------------------------------------------------------
      Machine-dependent parameters
     ---------------------------------------------------------------------*/
        final double enten = 1e308;
        final double ensig = 1e16;
        final double rtnsig = 1e-4;
        final double enmten = 8.90e-308;
        final double xlarge = 1e4;
    
    /*---------------------------------------------------------------------
     *  Factorial(N)
     *--------------------------------------------------------------------- */
        final double fact[] = { 1.,1.,2.,6.,24.,120.,720.,5040.,40320.,
    	    362880.,3628800.,39916800.,479001600.,6227020800.,87178291200.,
    	    1.307674368e12,2.0922789888e13,3.55687428096e14,6.402373705728e15,
    	    1.21645100408832e17,2.43290200817664e18,5.109094217170944e19,
    	    1.12400072777760768e21,2.585201673888497664e22,
    	    6.2044840173323943936e23 };
    
    /*!*     extern double gamma_cody(double); /*!*/


	double[] b = new double[(int) nb+1];
    
        /* Local variables */
        long nend, intx, nbmx, i, j, k, l, m, n, nstart;
    
        double nu, twonu, capp, capq, pold, vcos, test, vsin;
        double p, s, t, z, alpem, halfx, aa, bb, cc, psave, plast;
        double tover, t1, alp2em, em, en, xc, xk, xm, psavel, gnu, xin, sum;
    
    
        /* Parameter adjustment */
        nu = alpha;
        twonu = nu + nu;
    /*---------------------------------------------------------------------
     Check for out of range arguments.
     ---------------------------------------------------------------------*/
        if (nb > 0 && x >= 0. && 0. <= nu && nu < 1.) {
    
    	ncalc = nb;
    	if(x > xlarge) {
    	    throw new java.lang.ArithmeticException("Math Error: RANGE");
	    //    	    for(i=1; i <= nb; i++)
	    //    		b[i] = Double.POSITIVE_INFINITY;
	    //    	    return;
    	}
    	intx = (long) (x);
    	/* ----------------------------------------------------------
    	   Initialize result array to zero.
    	   -------------------------------------------------------- */
    	for (i = 1; i <= nb; ++i)
    	    b[(int)i] = 0.;
    
    /* ---------------------------------------------------------------------
     Branch to use 2-term ascending series for small X and asymptotic
     form for large X when NB is not too large.
     --------------------------------------------------------------------- */
    
    	if (x < rtnsig) {
    /* ---------------------------------------------------------------------
     Two-term ascending series for small X.
     --------------------------------------------------------------------- */
    	    aa = 1.;
    	    alpem = 1. + nu;
    	    halfx = 0.;
    	    if (x > enmten) {
    		halfx = .5 * x;
    	    }
    	    if (nu != 0.) {
/*!* 		aa = pow(halfx, nu) / (nu * gamma_cody(nu)); *!*/
    		aa = java.lang.Math.pow(halfx, nu) / (nu * gamma_cody(nu));
    	    }
    	    bb = 0.;
    	    if (x + 1. > 1.) {
    		bb = -halfx * halfx;
    	    }
    	    b[1] = aa + aa * bb / alpem;
    	    if (x != 0. && b[1] == 0.) {
    		ncalc = 0;
    	    }
    	    if (nb != 1) {
    		if (x <= 0.) {
    		    for (n = 2; n <= nb; ++n) {
    			b[(int) n] = 0.;
    		    }
    		} else {
    		    /* ----------------------------------------------
    		       Calculate higher order functions.
    		       ---------------------------------------------- */
    		    cc = halfx;
    		    tover = (enmten + enmten) / x;
    		    if (bb != 0.) {
    			tover = enmten / bb;
    		    }
    		    for (n = 2; n <= nb; ++n) {
    			aa /= alpem;
    			alpem += 1.;
    			aa *= cc;
    			if (aa <= tover * alpem) {
    			    aa = 0.;
    			}
    			b[(int) n] = aa + aa * bb / alpem;
    			if (b[(int) n] == 0. && ncalc > n) {
    			    ncalc = n - 1;
    			}
    		    }
    		}
    	    }
    	} else if (x > 25. && nb <= intx + 1) {
    /* ---------------------------------------------------------------------
     Asymptotic series for X > 25
     --------------------------------------------------------------------- */
/*!* 	    xc = sqrt(pi2 / x); *!*/
    	    xc = java.lang.Math.sqrt(pi2 / x);
    	    xin = 1 / (64 * x * x);
    	    if (x >= 130.)	m = 4;
    	    else if (x >= 35.) m = 8;
    	    else		m = 11;
    	    xm = 4. * (double) m;
    	    /* ------------------------------------------------------
    	       Argument reduction for SIN and COS routines.
    	       ------------------------------------------------------ */
    	    t = ftrunc(x / (twopi1 + twopi2) + .5);
    	    z = x - t * twopi1 - t * twopi2 - (nu + .5) / pi2;
/*!* 	    vsin = sin(z); *!*/
    	    vsin = java.lang.Math.sin(z);
/*!* 	    vcos = cos(z); *!*/
    	    vcos = java.lang.Math.cos(z);
    	    gnu = twonu;
    	    for (i = 1; i <= 2; ++i) {
    		s = (xm - 1. - gnu) * (xm - 1. + gnu) * xin * .5;
    		t = (gnu - (xm - 3.)) * (gnu + (xm - 3.));
    		capp = s * t / fact[(int) (m * 2)];
    		t1 = (gnu - (xm + 1.)) * (gnu + (xm + 1.));
    		capq = s * t1 / fact[(int)((m << 1) + 1)];
    		xk = xm;
    		k = m + m;
    		t1 = t;
    		for (j = 2; j <= m; ++j) {
    		    xk -= 4.;
    		    s = (xk - 1. - gnu) * (xk - 1. + gnu);
    		    t = (gnu - (xk - 3.)) * (gnu + (xk - 3.));
    		    capp = (capp + 1. / fact[(int)(k - 2)]) * s * t * xin;
    		    capq = (capq + 1. / fact[(int)(k - 1)]) * s * t1 * xin;
    		    k += -2;
    		    t1 = t;
    		}
    		capp += 1.;
    		capq = (capq + 1.) * (gnu * gnu - 1.) * (.125 / x);
    		b[(int) i] = xc * (capp * vcos - capq * vsin);
    		if (nb == 1) {
		    double retval[] = new double[(int) nb];
		    int counter;
		    for( counter=0; counter<nb; counter++)
			retval[counter] = b[counter+1];
		    
		    return(retval);
		    
    		}
    		t = vsin;
    		vsin = -vcos;
    		vcos = t;
    		gnu += 2.;
    	    }
    	    /* -----------------------------------------------
    	       If  NB > 2, compute J(X,ORDER+I)	 I = 2, NB-1
    	       ----------------------------------------------- */
    	    if (nb > 2) {
    		gnu = twonu + 2.;
    		for (j = 3; j <= nb; ++j) {
    		    b[(int)j] = gnu * b[(int)(j - 1)] / x - b[(int)(j - 2)];
    		    gnu += 2.;
    		}
    	    }
    	} else {
    /* ---------------------------------------------------------------------------
     rtnsig <= x <= 25 :	Use recurrence to generate results.
    			First initialize the calculation of P*S.
     --------------------------------------------------------------------------- */
    	    nbmx = nb - intx;
    	    n = intx + 1;
    	    en = (double)(n + n) + twonu;
    	    plast = 1.;
    	    p = en / x;
    	    /* ---------------------------------------------------
    	       Calculate general significance test.
    	       --------------------------------------------------- */
    	    test = ensig + ensig;
L190:	    {
    	    if (nbmx >= 3) {
    		/* ------------------------------------------------------------
    		   Calculate P*S until N = NB-1.  Check for possible overflow.
    		   ---------------------------------------------------------- */
    		tover = enten / ensig;
    		nstart = intx + 2;
    		nend = nb - 1;
    		en = (double) (nstart + nstart) - 2. + twonu;
    		for (k = nstart; k <= nend; ++k) {
    		    n = k;
    		    en += 2.;
    		    pold = plast;
    		    plast = p;
    		    p = en * plast / x - pold;
    		    if (p > tover) {
    			/* -------------------------------------------
    			   To avoid overflow, divide P*S by TOVER.
    			   Calculate P*S until ABS(P) > 1.
    			   -------------------------------------------*/
    			tover = enten;
    			p /= tover;
    			plast /= tover;
    			psave = p;
    			psavel = plast;
    			nstart = n + 1;
    			do {
    			    ++n;
    			    en += 2.;
    			    pold = plast;
    			    plast = p;
    			    p = en * plast / x - pold;
    			} while (p <= 1.);
    
    			bb = en / x;
    			/* -----------------------------------------------
    			   Calculate backward test and find NCALC,
    			   the highest N such that the test is passed.
    			   ----------------------------------------------- */
    			test = pold * plast * (.5 - .5 / (bb * bb));
    			test /= ensig;
    			p = plast * tover;
    			--n;
    			en -= 2.;
    			nend = Math.min(nb,n);
    			for (l = nstart; l <= nend; ++l) {
    			    pold = psavel;
    			    psavel = psave;
    			    psave = en * psavel / x - pold;
    			    if (psave * psavel > test) {
    				ncalc = l - 1;
    				break L190;
    			    }
    			}
    			ncalc = nend;
    			break L190;
    		    }
    		}
    		n = nend;
    		en = (double) (n + n) + twonu;
    		/* -----------------------------------------------------
    		   Calculate special significance test for NBMX > 2.
    		   -----------------------------------------------------*/
/*!* 		test = fmax2(test, sqrt(plast * ensig) * sqrt(p + p)); *!*/
    		test = fmax2(test, java.lang.Math.sqrt(plast * ensig) * java.lang.Math.sqrt(p + p));
    	    }
    	    /* ------------------------------------------------
    	       Calculate P*S until significance test passes. */
    	    do {
    		++n;
    		en += 2.;
    		pold = plast;
    		plast = p;
    		p = en * plast / x - pold;
    	    } while (p < test);
    
    /* ---------------------------------------------------------------------
     Initialize the backward recursion and the normalization sum.
     --------------------------------------------------------------------- */
	    } // L190:
    	    ++n;
    	    en += 2.;
    	    bb = 0.;
    	    aa = 1. / p;
    	    m = (n << 1) - (n / 2 << 2);
    	    sum = 0.;
/*!* 	    em = floor((double)n / 2);!!!COMMENT!!! *!*/
    	    em = java.lang.Math.floor((double)n / 2);/* integer division*/
    	    alpem = em - 1. + nu;
    	    alp2em = em + em + nu;
    	    if (m != 0) {
    		sum = aa * alpem * alp2em / em;
    	    }
    	    nend = n - nb;
    	    if (nend > 0) {
    		/* --------------------------------------------------------
    		   Recur backward via difference equation, calculating
    		   (but not storing) b[(int) n], until N = NB.
    		   -------------------------------------------------------- */
    		for (l = 1; l <= nend; ++l, --n) {
    		    en -= 2.;
    		    cc = bb;
    		    bb = aa;
    		    aa = en * bb / x - cc;
    		    m = 2 - m;
    		    if (m != 0) {
    			em -= 1.;
    			alp2em = em + em + nu;
    			if (n == 1) {
    			    break;
    			}
    			alpem = em - 1. + nu;
    			if (alpem == 0.)
    			    alpem = 1.;
    			sum = (sum + aa * alp2em) * alpem / em;
    		    }
    		}
    	    }
    	    /*--------------------------------------------------
    	      Store b[(int) nB].
    	      --------------------------------------------------*/
    	    b[(int) n] = aa;
	L250:	    {
	L240:	    {
    	    if (nend >= 0) {
    		if (nb <= 1) {
    		    alp2em = nu;
    		    if (nu + 1. == 1.) {
    			alp2em = 1.;
    		    }
    		    sum += b[1] * alp2em;
    		    break L250;
    		} else {
    		    /* -----------------------------------------
    		       Calculate and store b[(int) nB-1].
    		       -----------------------------------------*/
    		    --n;
    		    en -= 2.;
    		    b[(int) n] = en * aa / x - bb;
    		    if (n == 1) {
    			break L240;
    		    }
    		    m = 2 - m;
    		    if (m != 0) {
    			em -= 1.;
    			alp2em = em + em + nu;
    			alpem = em - 1. + nu;
    			if (alpem == 0.) {
    			    alpem = 1.;
    			}
    			sum = (sum + b[(int) n] * alp2em) * alpem / em;
    		    }
    		}
    	    }
    	    nend = n - 2;
    	    if (nend != 0) {
    /* ---------------------------------------------------------------------
     Calculate via difference equation and store b[(int) n], until N = 2.
     --------------------------------------------------------------------- */
    		for (l = 1; l <= nend; ++l) {
    		    --n;
    		    en -= 2.;
    		    b[(int) n] = en * b[(int) n + 1] / x - b[(int) n + 2];
    		    m = 2 - m;
    		    if (m != 0) {
    			em -= 1.;
    			alp2em = em + em + nu;
    			alpem = em - 1. + nu;
    			if (alpem == 0.) {
    			    alpem = 1.;
    			}
    			sum = (sum + b[(int) n] * alp2em) * alpem / em;
    		    }
    		}
    	    }
    	    /* ---------------------------------------
    	       Calculate b[1].
    	       -----------------------------------------*/
    	    b[1] = 2. * (nu + 1.) * b[2] / x - b[3];
	} // L240:
    	    em -= 1.;
    	    alp2em = em + em + nu;
    	    if (alp2em == 0.)
    		alp2em = 1.;
    	    sum += b[1] * alp2em;
    
	    } //    L250:
    	    /* ---------------------------------------------------
    	       Normalize.  Divide all b[(int) n] by sum.
    	       ---------------------------------------------------*/
    	    if (nu + 1. != 1.)
/*!* 		sum *= (gamma_cody(nu) * pow(.5* x, -nu)); *!*/
    		sum *= (gamma_cody(nu) * java.lang.Math.pow(.5* x, -nu));
    
    	    aa = enmten;
    	    if (sum > 1.)
    		aa *= sum;
    	    for (n = 1; n <= nb; ++n) {
/*!* 		if (fabs(b[(int) n]) < aa) *!*/
    		if (java.lang.Math.abs(b[(int) n]) < aa)
    		    b[(int) n] = 0.;
    		else
    		    b[(int) n] /= sum;
    	    }
    	}
    
        } else {
    	/* -----------------------------------------------------------------
    	   Error return -- X, NB, or ALPHA is out of range.
    	   -----------------------------------------------------------------*/
    	b[1] = 0.;
    	ncalc = Math.min(nb,0) - 1;
        }

	double[] retval = new double[(int) nb];
	int counter;
	for( counter=0; counter<nb; counter++)
	    retval[counter] = b[counter+1];

	return(retval);


    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka and the R Core team.
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     */
    
    /*  DESCRIPTION --> see below */
    
    
    /* From http://www.netlib.org/specfun/rkbesl	Fortran translated by f2c,...
     *	------------------------------=#----	Martin Maechler, ETH Zurich
     */
    /*!* #include "DistLib.h" /*4!*/
    
    static private final double xmax = 705.342;/* maximal x for UNscaled answer, see below */
    
    public static double  bessel_k(double x, double alpha, double expo)
    {
        long nb=0, ncalc=0, ize=0;
        double bk[];
    /*!* #ifdef IEEE_754 /*4!*/
        /* NaNs propagated correctly */
        if (Double.isNaN(x) || Double.isNaN(alpha)) return x + alpha;
    /*!* #endif /*4!*/
        ize = (long)expo;
/*!*     nb = 1+ (long)floor(fabs(alpha));!!!COMMENT!!! *!*/
        nb = 1+ (long)java.lang.Math.floor(java.lang.Math.abs(alpha));/* nb-1 <= alpha < nb */
        alpha -= (nb-1);
        bk = K_bessel(x, alpha, nb, ize, ncalc);
        if(ncalc != nb) {/* error input */
          if(ncalc < 0)
    	System.out.println("bessel_k("+x+"): ncalc (="+ncalc+") != nb (="+nb+
			   "); alpha="+alpha+". Arg. out of range?\n");

          else
    	System.out.println("bessel_k("+x+"+nu="+(alpha+nb-1)+
			   "): precision lost in result\n");
        }
        x = bk[(int) nb-1];
        return x;
    }
    
    static double[] K_bessel(double x, double alpha, long nb,
    	      long ize, long ncalc)
    {
	double bk[] = new double[(int) nb+1];

    /*-------------------------------------------------------------------
    
      This routine calculates modified Bessel functions
      of the third kind, K_(N+ALPHA) (X), for non-negative
      argument X, and non-negative order N+ALPHA, with or without
      exponential scaling.
    
      Explanation of variables in the calling sequence
    
     X     - Non-negative argument for which
    	 K's or exponentially scaled K's (K*EXP(X))
    	 are to be calculated.	If K's are to be calculated,
    	 X must not be greater than XMAX (see below).
     ALPHA - Fractional part of order for which
    	 K's or exponentially scaled K's (K*EXP(X)) are
    	 to be calculated.  0 <= ALPHA < 1.0.
     NB    - Number of functions to be calculated, NB > 0.
    	 The first function calculated is of order ALPHA, and the
    	 last is of order (NB - 1 + ALPHA).
     IZE   - Type.	IZE = 1 if unscaled K's are to be calculated,
    		    = 2 if exponentially scaled K's are to be calculated.
     BK    - Output vector of length NB.	If the
    	 routine terminates normally (NCALC=NB), the vector BK
    	 contains the functions K(ALPHA,X), ... , K(NB-1+ALPHA,X),
    	 or the corresponding exponentially scaled functions.
    	 If (0 < NCALC < NB), BK(I) contains correct function
    	 values for I <= NCALC, and contains the ratios
    	 K(ALPHA+I-1,X)/K(ALPHA+I-2,X) for the rest of the array.
     NCALC - Output variable indicating possible errors.
    	 Before using the vector BK, the user should check that
    	 NCALC=NB, i.e., all orders have been calculated to
    	 the desired accuracy.	See error returns below.
    
    
     *******************************************************************
    
     Error returns
    
      In case of an error, NCALC != NB, and not all K's are
      calculated to the desired accuracy.
    
      NCALC < -1:  An argument is out of range. For example,
    	NB <= 0, IZE is not 1 or 2, or IZE=1 and ABS(X) >= XMAX.
    	In this case, the B-vector is not calculated,
    	and NCALC is set to MIN0(NB,0)-2	 so that NCALC != NB.
      NCALC = -1:  Either  K(ALPHA,X) >= XINF  or
    	K(ALPHA+NB-1,X)/K(ALPHA+NB-2,X) >= XINF.	 In this case,
    	the B-vector is not calculated.	Note that again
    	NCALC != NB.
    
      0 < NCALC < NB: Not all requested function values could
    	be calculated accurately.  BK(I) contains correct function
    	values for I <= NCALC, and contains the ratios
    	K(ALPHA+I-1,X)/K(ALPHA+I-2,X) for the rest of the array.
    
    
     Intrinsic functions required are:
    
         ABS, AINT, EXP, INT, LOG, MAX, MIN, SINH, SQRT
    
    
     Acknowledgement
    
    	This program is based on a program written by J. B. Campbell
    	(2) that computes values of the Bessel functions K of float
    	argument and float order.  Modifications include the addition
    	of non-scaled functions, parameterization of machine
    	dependencies, and the use of more accurate approximations
    	for SINH and SIN.
    
     References: "On Temme's Algorithm for the Modified Bessel
    	      Functions of the Third Kind," Campbell, J. B.,
    	      TOMS 6(4), Dec. 1980, pp. 581-586.
    
    	     "A FORTRAN IV Subroutine for the Modified Bessel
    	      Functions of the Third Kind of Real Order and Real
    	      Argument," Campbell, J. B., Report NRC/ERB-925,
    	      National Research Council, Canada.
    
      Latest modification: May 30, 1989
    
      Modified by: W. J. Cody and L. Stoltz
    	       Applied Mathematics Division
    	       Argonne National Laboratory
    	       Argonne, IL  60439
    
     -------------------------------------------------------------------
    */
    
    /*
     ---------------------------------------------------------------------
      Machine dependent parameters
     ---------------------------------------------------------------------
      Explanation of machine-dependent constants
    
       beta	  = Radix for the floating-point system
       minexp = Smallest representable power of beta
       maxexp = Smallest power of beta that overflows
       EPS	  = The smallest positive floating-point number such that 1.0+EPS > 1.0
       SQXMIN = Square root of beta**minexp
       XINF	  = Largest positive machine number; approximately  beta**maxexp
    	    == Double.MAX_VALUE (defined in  #include <float.h>)
       XMIN	  = Smallest positive machine number; approximately beta**minexp
    
       XMAX	  = Upper limit on the magnitude of X when IZE=1;  Solution
    	    to equation:
    	       W(X) * (1-1/8X+9/128X**2) = beta**minexp
    	    where  W(X) = EXP(-X)*SQRT(PI/2X)
    
    
         Approximate values for some important machines are:
    
    			  beta	     minexp	 maxexp	     EPS
    
      CRAY-1	(S.P.)	    2	     -8193	  8191	  7.11E-15
      Cyber 180/185
        under NOS	(S.P.)	    2	      -975	  1070	  3.55E-15
      IEEE (IBM/XT,
        SUN, etc.)	(S.P.)	    2	      -126	   128	  1.19E-7
      IEEE (IBM/XT,
        SUN, etc.)	(D.P.)	    2	     -1022	  1024	  2.22D-16
      IBM 3033	(D.P.)	   16	       -65	    63	  2.22D-16
      VAX		(S.P.)	    2	      -128	   127	  5.96E-8
      VAX D-Format	(D.P.)	    2	      -128	   127	  1.39D-17
      VAX G-Format	(D.P.)	    2	     -1024	  1023	  1.11D-16
    
    
    			 SQXMIN	      XINF	  XMIN	    XMAX
    
     CRAY-1	       (S.P.)  6.77E-1234  5.45E+2465  4.59E-2467 5674.858
     Cyber 180/855
       under NOS   (S.P.)  1.77E-147   1.26E+322   3.14E-294   672.788
     IEEE (IBM/XT,
       SUN, etc.)  (S.P.)  1.08E-19	   3.40E+38    1.18E-38	    85.337
     IEEE (IBM/XT,
       SUN, etc.)  (D.P.)  1.49D-154   1.79D+308   2.23D-308   705.342
     IBM 3033      (D.P.)  7.35D-40	   7.23D+75    5.40D-79	   177.852
     VAX	       (S.P.)  5.42E-20	   1.70E+38    2.94E-39	    86.715
     VAX D-Format  (D.P.)  5.42D-20	   1.70D+38    2.94D-39	    86.715
     VAX G-Format  (D.P.)  7.46D-155   8.98D+307   5.57D-309   706.728
    
     *******************************************************************
     */
        /*static private double eps = 2.22e-16;*/
        /*static private double xinf = 1.79e308;*/
        /*static private double xmin = 2.23e-308;*/
        final double sqxmin = 1.49e-154;
    
        /*---------------------------------------------------------------------
         * Mathematical constants
         *	A = LOG(2) - Euler's constant
         *	D = SQRT(2/PI)
         ---------------------------------------------------------------------*/
        final double a = .11593151565841244881;
    
        /*---------------------------------------------------------------------
          P, Q - Approximation for LOG(GAMMA(1+ALPHA))/ALPHA + Euler's constant
          Coefficients converted from hex to decimal and modified
          by W. J. Cody, 2/26/82 */
        final double p[] = { .805629875690432845,20.4045500205365151,
    	    157.705605106676174,536.671116469207504,900.382759291288778,
    	    730.923886650660393,229.299301509425145,.822467033424113231 };
        final  double q[] = { 29.4601986247850434,277.577868510221208,
    	    1206.70325591027438,2762.91444159791519,3443.74050506564618,
    	    2210.63190113378647,572.267338359892221 };
        /* R, S - Approximation for (1-ALPHA*PI/SIN(ALPHA*PI))/(2.D0*ALPHA) */
        final  double r[] = { -.48672575865218401848,13.079485869097804016,
    	    -101.96490580880537526,347.65409106507813131,
    	    3.495898124521934782e-4 };
        final  double s[] = { -25.579105509976461286,212.57260432226544008,
    	    -610.69018684944109624,422.69668805777760407 };
        /* T    - Approximation for SINH(Y)/Y */
        final  double t[] = { 1.6125990452916363814e-10,
    	    2.5051878502858255354e-8,2.7557319615147964774e-6,
    	    1.9841269840928373686e-4,.0083333333333334751799,
    	    .16666666666666666446 };
        /*---------------------------------------------------------------------*/
        final  double estm[] = { 52.0583,5.7607,2.7782,14.4303,185.3004, 9.3715 };
        final  double estf[] = { 41.8341,7.1075,6.4306,42.511,1.35633,84.5096,20.};
    
        /* Local variables */
        int iend=0, i=0, j=0, k=0, m=0, ii=0, mplus1=0;
        double x2by4, twox, c, blpha, ratio, wminf;
        double d1, d2, d3, f0, f1, f2, p0, q0, t1, t2, twonu;
        double dm, ex, bk1, bk2, nu;
    
        ex = x;
        nu = alpha;
        ncalc = Math.min(nb,0) - 2;
        if (nb > 0 && (0. <= nu && nu < 1.) && (1 <= ize && ize <= 2)) {
    	if(ex <= 0 || (ize == 1 && ex > xmax)) {
    	    throw new java.lang.ArithmeticException("Math Error: RANGE");
	    //    	    ncalc = nb;
	    //    	    for(i=0; i < nb; i++)
	    //    		bk[i] = Double.POSITIVE_INFINITY;
	    //    	    return;
    	}
    	k = 0;
    	if (nu < sqxmin) {
    	    nu = 0.;
    	} else if (nu > .5) {
    	    k = 1;
    	    nu -= 1.;
    	}
    	twonu = nu + nu;
    	iend = (int) (nb + k - 1);
    	c = nu * nu;
    	d3 = -c;
	L420:	{
    	if (ex <= 1.) {
    	    /* ------------------------------------------------------------
    	       Calculation of P0 = GAMMA(1+ALPHA) * (2/X)*ALPHA
    			      Q0 = GAMMA(1-ALPHA) * (X/2)*ALPHA
    	       ------------------------------------------------------------ */
    	    d1 = 0.; d2 = p[0];
    	    t1 = 1.; t2 = q[0];
    	    for (i = 2; i <= 7; i += 2) {
    		d1 = c * d1 + p[i - 1];
    		d2 = c * d2 + p[i];
    		t1 = c * t1 + q[i - 1];
    		t2 = c * t2 + q[i];
    	    }
    	    d1 = nu * d1;
    	    t1 = nu * t1;
/*!* 	    f1 = log(ex); *!*/
    	    f1 = java.lang.Math.log(ex);
    	    f0 = a + nu * (p[7] - nu * (d1 + d2) / (t1 + t2)) - f1;
/*!* 	    q0 = exp(-nu * (a - nu * (p[7] + nu * (d1-d2) / (t1-t2)) - f1)); *!*/
    	    q0 = java.lang.Math.exp(-nu * (a - nu * (p[7] + nu * (d1-d2) / (t1-t2)) - f1));
    	    f1 = nu * f0;
/*!* 	    p0 = exp(f1); *!*/
    	    p0 = java.lang.Math.exp(f1);
    	    /* -----------------------------------------------------------
    	       Calculation of F0 =
    	       ----------------------------------------------------------- */
    	    d1 = r[4];
    	    t1 = 1.;
    	    for (i = 0; i < 4; ++i) {
    		d1 = c * d1 + r[i];
    		t1 = c * t1 + s[i];
    	    }
    	    /* d2 := sinh(f1)/ nu = sinh(f1)/(f1/f0)
    	     *	   = f0 * sinh(f1)/f1 */
/*!* 	    if (fabs(f1) <= .5) { *!*/
    	    if (java.lang.Math.abs(f1) <= .5) {
    		f1 *= f1;
    		d2 = 0.;
    		for (i = 0; i < 6; ++i) {
    		    d2 = f1 * d2 + t[i];
    		}
    		d2 = f0 + f0 * f1 * d2;
    	    } else {
    		d2 = VisualNumerics.math.Sfun.sinh(f1) / nu;
    	    }
    	    f0 = d2 - nu * d1 / (t1 * p0);
    	    if (ex <= 1e-10) {
    		/* ---------------------------------------------------------
    		   X <= 1.0E-10
    		   Calculation of K(ALPHA,X) and X*K(ALPHA+1,X)/K(ALPHA,X)
    		   --------------------------------------------------------- */
    		bk[0] = f0 + ex * f0;
    		if (ize == 1) {
    		    bk[0] -= ex * bk[0];
    		}
    		ratio = p0 / f0;
    		c = ex * Double.MAX_VALUE;
    		if (k != 0) {
    		    /* ---------------------------------------------------
    		       Calculation of K(ALPHA,X)
    		       and  XK(ALPHA+1,X)/K(ALPHA,X),	ALPHA >= 1/2
    		       --------------------------------------------------- */
    		    ncalc = -1;
    		    if (bk[0] >= c / ratio) {
			double[] retval = new double[(int) nb];
			int counter;
			for( counter=0; counter<nb; counter++)
			    retval[counter] = bk[counter+1];
			
			return(retval);

    		    }
    		    bk[0] = ratio * bk[0] / ex;
    		    twonu += 2.;
    		    ratio = twonu;
    		}
    		ncalc = 1;
    		if (nb == 1)
		    {
			double[] retval = new double[(int) nb];
			int counter;
			for( counter=0; counter<nb; counter++)
			    retval[counter] = bk[counter+1];
			
			return(retval);
		    }

    
    		/* -----------------------------------------------------
    		   Calculate  K(ALPHA+L,X)/K(ALPHA+L-1,X),
    		   L = 1, 2, ... , NB-1
    		   ----------------------------------------------------- */
    		ncalc = -1;
    		for (i = 1; i < nb; ++i) {
    		    if (ratio >= c)
			{
			    double[] retval = new double[(int) nb];
			    int counter;
			    for( counter=0; counter<nb; counter++)
				retval[counter] = bk[counter+1];
			    
			    return(retval);
			}
		    
    		    bk[i] = ratio / ex;
    		    twonu += 2.;
    		    ratio = twonu;
    		}
    		ncalc = 1;
    		break L420;
    	    } else {
    		/* ------------------------------------------------------
    		   10^-10 < X <= 1.0
    		   ------------------------------------------------------ */
    		c = 1.;
    		x2by4 = ex * ex / 4.;
    		p0 = .5 * p0;
    		q0 = .5 * q0;
    		d1 = -1.;
    		d2 = 0.;
    		bk1 = 0.;
    		bk2 = 0.;
    		f1 = f0;
    		f2 = p0;
    		do {
    		    d1 += 2.;
    		    d2 += 1.;
    		    d3 = d1 + d3;
    		    c = x2by4 * c / d2;
    		    f0 = (d2 * f0 + p0 + q0) / d3;
    		    p0 /= d2 - nu;
    		    q0 /= d2 + nu;
    		    t1 = c * f0;
    		    t2 = c * (p0 - d2 * f0);
    		    bk1 += t1;
    		    bk2 += t2;
/*!* 		} while (fabs(t1 / (f1 + bk1)) > DistLib_h.DBL_EPSILON || *!*/
    		} while (java.lang.Math.abs(t1 / (f1 + bk1)) > DistLib_h.DBL_EPSILON ||
/*!* 			 fabs(t2 / (f2 + bk2)) > DistLib_h.DBL_EPSILON); *!*/
    			 java.lang.Math.abs(t2 / (f2 + bk2)) > DistLib_h.DBL_EPSILON);
    		bk1 = f1 + bk1;
    		bk2 = 2. * (f2 + bk2) / ex;
    		if (ize == 2) {
/*!* 		    d1 = exp(ex); *!*/
    		    d1 = java.lang.Math.exp(ex);
    		    bk1 *= d1;
    		    bk2 *= d1;
    		}
    		wminf = estf[0] * ex + estf[1];
    	    }
    	} else if (DistLib_h.DBL_EPSILON * ex > 1.) {
    	    /* -------------------------------------------------
    	       X > 1./EPS
    	       ------------------------------------------------- */
    	    ncalc = nb;
/*!* 	    bk1 = 1. / (DistLib_h.M_SQRT_2dPI * sqrt(ex)); *!*/
    	    bk1 = 1. / (DistLib_h.M_SQRT_2dPI * java.lang.Math.sqrt(ex));
    	    for (i = 0; i < nb; ++i)
    		bk[i] = bk1;
	    {
		double[] retval = new double[(int) nb];
		int counter;
		for( counter=0; counter<nb; counter++)
		    retval[counter] = bk[counter+1];
		
		return(retval);
	    }
	    
    	} else {
    	    /* -------------------------------------------------------
    	       X > 1.0
    	       ------------------------------------------------------- */
    	    twox = ex + ex;
    	    blpha = 0.;
    	    ratio = 0.;
    	    if (ex <= 4.) {
    		/* ----------------------------------------------------------
    		   Calculation of K(ALPHA+1,X)/K(ALPHA,X),  1.0 <= X <= 4.0
    		   ----------------------------------------------------------*/
    		d2 = ftrunc(estm[0] / ex + estm[1]);
    		m = (int) d2;
    		d1 = d2 + d2;
    		d2 -= .5;
    		d2 *= d2;
    		for (i = 2; i <= m; ++i) {
    		    d1 -= 2.;
    		    d2 -= d1;
    		    ratio = (d3 + d2) / (twox + d1 - ratio);
    		}
    		/* -----------------------------------------------------------
    		   Calculation of I(|ALPHA|,X) and I(|ALPHA|+1,X) by backward
    		   recurrence and K(ALPHA,X) from the wronskian
    		   -----------------------------------------------------------*/
    		d2 = ftrunc(estm[2] * ex + estm[3]);
    		m = (int) d2;
/*!* 		c = fabs(nu); *!*/
    		c = java.lang.Math.abs(nu);
    		d3 = c + c;
    		d1 = d3 - 1.;
    		f1 = Double.MIN_VALUE;
    		f0 = (2. * (c + d2) / ex + .5 * ex / (c + d2 + 1.)) * Double.MIN_VALUE;
    		for (i = 3; i <= m; ++i) {
    		    d2 -= 1.;
    		    f2 = (d3 + d2 + d2) * f0;
    		    blpha = (1. + d1 / d2) * (f2 + blpha);
    		    f2 = f2 / ex + f1;
    		    f1 = f0;
    		    f0 = f2;
    		}
    		f1 = (d3 + 2.) * f0 / ex + f1;
    		d1 = 0.;
    		t1 = 1.;
    		for (i = 1; i <= 7; ++i) {
    		    d1 = c * d1 + p[i - 1];
    		    t1 = c * t1 + q[i - 1];
    		}
/*!* 		p0 = exp(c * (a + c * (p[7] - c * d1 / t1) - log(ex))) / ex; *!*/
    		p0 = java.lang.Math.exp(c * (a + c * (p[7] - c * d1 / t1) - java.lang.Math.log(ex))) / ex;
    		f2 = (c + .5 - ratio) * f1 / ex;
    		bk1 = p0 + (d3 * f0 - f2 + f0 + blpha) / (f2 + f1 + f0) * p0;
    		if (ize == 1) {
/*!* 		    bk1 *= exp(-ex); *!*/
    		    bk1 *= java.lang.Math.exp(-ex);
    		}
    		wminf = estf[2] * ex + estf[3];
    	    } else {
    		/* ---------------------------------------------------------
    		   Calculation of K(ALPHA,X) and K(ALPHA+1,X)/K(ALPHA,X), by
    		   backward recurrence, for  X > 4.0
    		   ----------------------------------------------------------*/
    		dm = ftrunc(estm[4] / ex + estm[5]);
    		m = (int) dm;
    		d2 = dm - .5;
    		d2 *= d2;
    		d1 = dm + dm;
    		for (i = 2; i <= m; ++i) {
    		    dm -= 1.;
    		    d1 -= 2.;
    		    d2 -= d1;
    		    ratio = (d3 + d2) / (twox + d1 - ratio);
    		    blpha = (ratio + ratio * blpha) / dm;
    		}
/*!* 		bk1 = 1. / ((DistLib_h.M_SQRT_2dPI + DistLib_h.M_SQRT_2dPI * blpha) * sqrt(ex)); *!*/
    		bk1 = 1. / ((DistLib_h.M_SQRT_2dPI + DistLib_h.M_SQRT_2dPI * blpha) * java.lang.Math.sqrt(ex));
    		if (ize == 1)
/*!* 		    bk1 *= exp(-ex); *!*/
    		    bk1 *= java.lang.Math.exp(-ex);
/*!* 		wminf = estf[4] * (ex - fabs(ex - estf[6])) + estf[5]; *!*/
    		wminf = estf[4] * (ex - java.lang.Math.abs(ex - estf[6])) + estf[5];
    	    }
    	    /* ---------------------------------------------------------
    	       Calculation of K(ALPHA+1,X)
    	       from K(ALPHA,X) and  K(ALPHA+1,X)/K(ALPHA,X)
    	       --------------------------------------------------------- */
    	    bk2 = bk1 + bk1 * (nu + .5 - ratio) / ex;
    	}
    	/*--------------------------------------------------------------------
    	  Calculation of 'NCALC', K(ALPHA+I,X),	I  =  0, 1, ... , NCALC-1,
    	  &	  K(ALPHA+I,X)/K(ALPHA+I-1,X),	I = NCALC, NCALC+1, ... , NB-1
    	  -------------------------------------------------------------------*/
    	ncalc = nb;
    	bk[0] = bk1;
    	if (iend == 0)
	    {
		double[] retval = new double[(int) nb];
		int counter;
		for( counter=0; counter<nb; counter++)
		    retval[counter] = bk[counter+1];
		
		return(retval);
	    }
	
    	j = 1 - k;
    	if (j >= 0)
    	    bk[j] = bk2;
    
    	if (iend == 1)
	    {
		double[] retval = new double[(int) nb];
		int counter;
		for( counter=0; counter<nb; counter++)
		    retval[counter] = bk[counter+1];
		
		return(retval);
	    }
	
    	m = Math.min( (int) (wminf - nu),iend);
    	for (i = 2; i <= m; ++i) {
    	    t1 = bk1;
    	    bk1 = bk2;
    	    twonu += 2.;
    	    if (ex < 1.) {
    		if (bk1 >= Double.MAX_VALUE / twonu * ex)
    		    break;
    	    } else {
    		if (bk1 / ex >= Double.MAX_VALUE / twonu)
    		    break;
    	    }
    	    bk2 = twonu / ex * bk1 + t1;
    	    ii = i;
    	    ++j;
    	    if (j >= 0) {
    		bk[j] = bk2;
    	    }
    	}
    
    	m = ii;
    	if (m == iend) {
	    {
		double[] retval = new double[(int) nb];
		int counter;
		for( counter=0; counter<nb; counter++)
		    retval[counter] = bk[counter+1];
		
		return(retval);
	    }
    	}
    	ratio = bk2 / bk1;
    	mplus1 = m + 1;
    	ncalc = -1;
    	for (i = mplus1; i <= iend; ++i) {
    	    twonu += 2.;
    	    ratio = twonu / ex + 1./ratio;
    	    ++j;
    	    if (j >= 1) {
    		bk[j] = ratio;
    	    } else {
    		if (bk2 >= Double.MAX_VALUE / ratio)
		    {
			double[] retval = new double[(int) nb];
			int counter;
			for( counter=0; counter<nb; counter++)
			    retval[counter] = bk[counter+1];
			
			return(retval);
		    }
		
    		bk2 *= ratio;
    	    }
    	}
    	ncalc = Math.max(1, mplus1 - k);
    	if (ncalc == 1)
    	    bk[0] = bk2;
    	if (nb == 1)
	    {
		double[] retval = new double[(int) nb];
		int counter;
		for( counter=0; counter<nb; counter++)
		    retval[counter] = bk[counter+1];
		
		return(retval);
	    }
	
	} // L420:
    	for (i = (int) ncalc; i < nb; ++i) { /* i == *ncalc */
    /*!* #ifndef IEEE_754 /*4!*/
    	    if (bk[i-1] >= Double.MAX_VALUE / bk[i])
		{
		    double[] retval = new double[(int) nb];
		    int counter;
		    for( counter=0; counter<nb; counter++)
			retval[counter] = bk[counter+1];
		    
		    return(retval);
		}
	    /*!* #endif /*4!*/
    	    bk[i] *= bk[i-1];
    	    ncalc++;
    	}
        }

	{
	double[] retval = new double[(int) nb];
	int counter;
	for( counter=0; counter<nb; counter++)
	    retval[counter] = bk[counter+1];

	return(retval);
	}



    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka and the R Core team.
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     */
    
    /*  DESCRIPTION --> see below */
    
    
    /* From http://www.netlib.org/specfun/rybesl	Fortran translated by f2c,...
     *	------------------------------=#----	Martin Maechler, ETH Zurich
     */
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  bessel_y(double x, double alpha)
    {
        long nb=0, ncalc=0;
        double by[];
    /*!* #ifdef IEEE_754 /*4!*/
        /* NaNs propagated correctly */
        if (Double.isNaN(x) || Double.isNaN(alpha)) return x + alpha;
    /*!* #endif /*4!*/
/*!*     nb = 1+ (long)floor(alpha);!!!COMMENT!!! *!*/
        nb = 1+ (int)java.lang.Math.floor(alpha);/* nb-1 <= alpha < nb */
        alpha -= (nb-1);
        by = Y_bessel(x, alpha, nb, ncalc);
        if(ncalc != nb) {/* error input */
    	if(ncalc == -1)
    	    return Double.POSITIVE_INFINITY;
    	else if(ncalc < -1)
    	    System.out.println("bessel_y("+x+"): ncalc (="+ncalc+") != nb (="+
			       nb+"); alpha="+alpha+". Arg. out of range?\n");

    	else /* ncalc >= 0 */
    	    System.out.println("bessel_y("+x+"+nu="+(alpha+nb-1)+
			       "): precision lost in result\n");
        }
        x = by[(int) nb-1];
        return x;
    }
    
    static double[] Y_bessel(double x, double alpha, long nb, long ncalc)
    {
	double by[] = new double[(int) nb+1];

    /* ----------------------------------------------------------------------
    
     This routine calculates Bessel functions Y_(N+ALPHA) (X)
     for non-negative argument X, and non-negative order N+ALPHA.
    
    
     Explanation of variables in the calling sequence
    
     X     - Non-negative argument for which
    	 Y's are to be calculated.
     ALPHA - Fractional part of order for which
    	 Y's are to be calculated.  0 <= ALPHA < 1.0.
     NB    - Number of functions to be calculated, NB > 0.
    	 The first function calculated is of order ALPHA, and the
    	 last is of order (NB - 1 + ALPHA).
     BY    - Output vector of length NB.	If the
    	 routine terminates normally (NCALC=NB), the vector BY
    	 contains the functions Y(ALPHA,X), ... , Y(NB-1+ALPHA,X),
    	 If (0 < NCALC < NB), BY(I) contains correct function
    	 values for I <= NCALC, and contains the ratios
    	 Y(ALPHA+I-1,X)/Y(ALPHA+I-2,X) for the rest of the array.
     NCALC - Output variable indicating possible errors.
    	 Before using the vector BY, the user should check that
    	 NCALC=NB, i.e., all orders have been calculated to
    	 the desired accuracy.	See error returns below.
    
    
     *******************************************************************
    
     Error returns
    
      In case of an error, NCALC != NB, and not all Y's are
      calculated to the desired accuracy.
    
      NCALC < -1:  An argument is out of range. For example,
    	NB <= 0, IZE is not 1 or 2, or IZE=1 and ABS(X) >=
    	XMAX.  In this case, BY[0] = 0.0, the remainder of the
    	BY-vector is not calculated, and NCALC is set to
    	MIN0(NB,0)-2  so that NCALC != NB.
      NCALC = -1:  Y(ALPHA,X) >= XINF.  The requested function
    	values are set to 0.0.
      1 < NCALC < NB: Not all requested function values could
    	be calculated accurately.  BY(I) contains correct function
    	values for I <= NCALC, and and the remaining NB-NCALC
    	array elements contain 0.0.
    
    
     Intrinsic functions required are:
    
         DBLE, EXP, INT, MAX, MIN, REAL, SQRT
    
    
     Acknowledgement
    
    	This program draws heavily on Temme's Algol program for Y(a,x)
    	and Y(a+1,x) and on Campbell's programs for Y_nu(x).	Temme's
    	scheme is used for  x < THRESH, and Campbell's scheme is used
    	in the asymptotic region.  Segments of code from both sources
    	have been translated into Fortran 77, merged, and heavily modified.
    	Modifications include parameterization of machine dependencies,
    	use of a new approximation for ln(gamma(x)), and built-in
    	protection against over/underflow.
    
     References: "Bessel functions J_nu(x) and Y_nu(x) of float
    	      order and float argument," Campbell, J. B.,
    	      Comp. Phy. Comm. 18, 1979, pp. 133-142.
    
    	     "On the numerical evaluation of the ordinary
    	      Bessel function of the second kind," Temme,
    	      N. M., J. Comput. Phys. 21, 1976, pp. 343-350.
    
      Latest modification: March 19, 1990
    
      Modified by: W. J. Cody
    	       Applied Mathematics Division
    	       Argonne National Laboratory
    	       Argonne, IL  60439
     ----------------------------------------------------------------------*/
    
    
    /* ----------------------------------------------------------------------
      Mathematical constants
        FIVPI = 5*PI
        PIM5 = 5*PI - 15
     ----------------------------------------------------------------------*/
        final  double fivpi = 15.707963267948966192;
        final  double pim5	=   .70796326794896619231;
    
    
    /* *******************************************************************
    
     Explanation of machine-dependent constants
    
       beta	  = Radix for the floating-point system
       p	  = Number of significant base-beta digits in the
    	    significand of a floating-point number
       minexp = Smallest representable power of beta
       maxexp = Smallest power of beta that overflows
       EPS	  = beta ** (-p)  == DistLib_h.DBL_EPSILON
       DEL	  = Machine number below which sin(x)/x = 1; approximately SQRT(EPS).
       XMIN	  = Smallest acceptable argument for RBESY; approximately
    	    max(2*beta**minexp,2/XINF), rounded up
       XINF	  = Largest positive machine number; approximately beta**maxexp
    	    == Double.MAX_VALUE (defined in  #include <float.h>)
       THRESH = Lower bound for use of the asymptotic form;
    	    approximately AINT(-LOG10(EPS/2.0))+1.0
       XLARGE = Upper bound on X;
    	    approximately 1/DEL, because the sine and cosine functions
    	    have lost about half of their precision at that point.
    
         Approximate values for some important machines are:
    
    			          beta	p     minexp	  maxexp      EPS
    
      CRAY-1	        (S.P.)	  2    48     -8193	   8191	   3.55E-15
      Cyber 180/185
        under NOS	(S.P.)	  2    48      -975	   1070	   3.55E-15
      IEEE (IBM/XT,
        SUN, etc.)	(S.P.)	  2    24      -126	    128	   5.96E-8
      IEEE (IBM/XT,
        SUN, etc.)	(D.P.)	  2    53     -1022	   1024	   1.11D-16
      IBM 3033	        (D.P.)	 16    14	-65	     63	   1.39D-17
      VAX		(S.P.)	  2    24      -128	    127	   5.96E-8
      VAX D-Format	(D.P.)	  2    56      -128	    127	   1.39D-17
      VAX G-Format	(D.P.)	  2    53     -1024	   1023	   1.11D-16
    
    
       			   DEL	   XMIN	      XINF        THRESH  XLARGE
    
     CRAY-1	   (S.P.)  5.0E-8  3.67E-2466 5.45E+2465  15.0E0  2.0E7
     Cyber 180/855
       under NOS   (S.P.)  5.0E-8  6.28E-294  1.26E+322   15.0E0  2.0E7
     IEEE (IBM/XT,
       SUN, etc.)  (S.P.)  1.0E-4  2.36E-38   3.40E+38     8.0E0  1.0E4
     IEEE (IBM/XT,
       SUN, etc.)  (D.P.)  1.0D-8  4.46D-308  1.79D+308   16.0D0  1.0D8
     IBM 3033      (D.P.)  1.0D-8  2.77D-76   7.23D+75    17.0D0  1.0D8
     VAX	   (S.P.)  1.0E-4  1.18E-38   1.70E+38     8.0E0  1.0E4
     VAX D-Format  (D.P.)  1.0D-9  1.18D-38   1.70D+38    17.0D0  1.0D9
     VAX G-Format  (D.P.)  1.0D-8  2.23D-308  8.98D+307   16.0D0  1.0D8
    
     *******************************************************************
    
     ----------------------------------------------------------------------
      Machine-dependent constants
     ----------------------------------------------------------------------*/
    
    /*    static private double xmin = 4.46e-308;
     *    static private double xinf = 1.79e308;
     */
        final  double del = 2.1491193328908e-8;/* x < del  <==>  sin(x)/x ~= 1 */
        final  double thresh = 16.;
        final  double xlarge = 1e8;
    
        /*----------------------------------------------------------------------
          Coefficients for Chebyshev polynomial expansion of
          1/gamma(1-x), abs(x) <= .5
          ----------------------------------------------------------------------*/
        final  double ch[] = { -6.7735241822398840964e-24,
    	    -6.1455180116049879894e-23,2.9017595056104745456e-21,
    	    1.3639417919073099464e-19,2.3826220476859635824e-18,
    	    -9.0642907957550702534e-18,-1.4943667065169001769e-15,
    	    -3.3919078305362211264e-14,-1.7023776642512729175e-13,
    	    9.1609750938768647911e-12,2.4230957900482704055e-10,
    	    1.7451364971382984243e-9,-3.3126119768180852711e-8,
    	    -8.6592079961391259661e-7,-4.9717367041957398581e-6,
    	    7.6309597585908126618e-5,.0012719271366545622927,
    	    .0017063050710955562222,-.07685284084478667369,
    	    -.28387654227602353814,.92187029365045265648 };
    
        /* Local variables */
        int i, k, na;
    
        double alfa, div, ddiv, even, gamma, term, cosmu, sinmu,
    	b, c, d, e, f, g, h, p, q, r, s, d1, d2, q0, pa,pa1, qa,qa1,
    	en, en1=0.0, nu, ex,  ya=0.0, ya1=0.0, twobyx, den, odd, aye, dmu, x2, xna;
    
        ex = x;
        nu = alpha;
        if (nb > 0 && 0. <= nu && nu < 1.) {
    	if(ex < Double.MIN_VALUE || ex > xlarge) {
    	    throw new java.lang.ArithmeticException("Math Error: RANGE");
	    //    	    ncalc = nb;
	    //    	    if(ex > xlarge)  by[0]=Double.POSITIVE_INFINITY;
	    //    	    if(ex < Double.MIN_VALUE) by[0]=Double.NEGATIVE_INFINITY;
	    //    	    for(i=0; i < nb; i++)
	    //    		by[i] = by[0];
	    //    	    return;
    	}
    	xna = ftrunc(nu + .5);
    	na = (int) xna;
    	if (na == 1) {/* <==>  .5 <= *alpha < 1	 <==>  -5. <= nu < 0 */
    	    nu -= xna;
    	}
    	if (nu == -.5) {
/*!* 	    p = DistLib_h.M_SQRT_2dPI / sqrt(ex); *!*/
    	    p = DistLib_h.M_SQRT_2dPI / java.lang.Math.sqrt(ex);
/*!* 	    ya = p * sin(ex); *!*/
    	    ya = p * java.lang.Math.sin(ex);
/*!* 	    ya1 = -p * cos(ex); *!*/
    	    ya1 = -p * java.lang.Math.cos(ex);
    	} else if (ex < 3.) {
    	    /* -------------------------------------------------------------
    	       Use Temme's scheme for small X
    	       ------------------------------------------------------------- */
    	    b = ex * .5;
/*!* 	    d = -log(b); *!*/
    	    d = -java.lang.Math.log(b);
    	    f = nu * d;
/*!* 	    e = pow(b, -nu); *!*/
    	    e = java.lang.Math.pow(b, -nu);
/*!* 	    if (fabs(nu) < del) *!*/
    	    if (java.lang.Math.abs(nu) < del)
    		c = DistLib_h.M_1_PI;
    	    else
/*!* 		c = nu / sin(nu * DistLib_h.M_PI); *!*/
    		c = nu / java.lang.Math.sin(nu * DistLib_h.M_PI);
    
    	    /* ------------------------------------------------------------
    	       Computation of sinh(f)/f
    	       ------------------------------------------------------------ */
/*!* 	    if (fabs(f) < 1.) { *!*/
    	    if (java.lang.Math.abs(f) < 1.) {
    		x2 = f * f;
    		en = 19.;
    		s = 1.;
    		for (i = 1; i <= 9; ++i) {
    		    s = s * x2 / en / (en - 1.) + 1.;
    		    en -= 2.;
    		}
    	    } else {
    		s = (e - 1. / e) * .5 / f;
    	    }
    	    /* --------------------------------------------------------
    	       Computation of 1/gamma(1-a) using Chebyshev polynomials */
    	    x2 = nu * nu * 8.;
    	    aye = ch[0];
    	    even = 0.;
    	    alfa = ch[1];
    	    odd = 0.;
    	    for (i = 3; i <= 19; i += 2) {
    		even = -(aye + aye + even);
    		aye = -even * x2 - aye + ch[i - 1];
    		odd = -(alfa + alfa + odd);
    		alfa = -odd * x2 - alfa + ch[i];
    	    }
    	    even = (even * .5 + aye) * x2 - aye + ch[20];
    	    odd = (odd + alfa) * 2.;
    	    gamma = odd * nu + even;
    	    /* End of computation of 1/gamma(1-a)
    	       ----------------------------------------------------------- */
    	    g = e * gamma;
    	    e = (e + 1. / e) * .5;
    	    f = 2. * c * (odd * e + even * s * d);
    	    e = nu * nu;
    	    p = g * c;
    	    q = DistLib_h.M_1_PI / g;
    	    c = nu * DistLib_h.M_PI_2;
/*!* 	    if (fabs(c) < del) *!*/
    	    if (java.lang.Math.abs(c) < del)
    		r = 1.;
    	    else
/*!* 		r = sin(c) / c; *!*/
    		r = java.lang.Math.sin(c) / c;
    
    	    r = DistLib_h.M_PI * c * r * r;
    	    c = 1.;
    	    d = -b * b;
    	    h = 0.;
    	    ya = f + r * q;
    	    ya1 = p;
    	    en = 1.;
    
/*!* 	    while (fabs(g / (1. + fabs(ya))) + *!*/
    	    while (java.lang.Math.abs(g / (1. + java.lang.Math.abs(ya))) +
/*!* 		   fabs(h / (1. + fabs(ya1))) > DistLib_h.DBL_EPSILON) { *!*/
    		   java.lang.Math.abs(h / (1. + java.lang.Math.abs(ya1))) > DistLib_h.DBL_EPSILON) {
    		f = (f * en + p + q) / (en * en - e);
    		c *= (d / en);
    		p /= en - nu;
    		q /= en + nu;
    		g = c * (f + r * q);
    		h = c * p - en * g;
    		ya += g;
    		ya1+= h;
    		en += 1.;
    	    }
    	    ya = -ya;
    	    ya1 = -ya1 / b;
    	} else if (ex < thresh) {
    	    /* --------------------------------------------------------------
    	       Use Temme's scheme for moderate X :  3 <= x < 16
    	       -------------------------------------------------------------- */
    	    c = (.5 - nu) * (.5 + nu);
    	    b = ex + ex;
/*!* 	    e = ex * DistLib_h.M_1_PI * cos(nu * DistLib_h.M_PI) / DistLib_h.DBL_EPSILON; *!*/
    	    e = ex * DistLib_h.M_1_PI * java.lang.Math.cos(nu * DistLib_h.M_PI) / DistLib_h.DBL_EPSILON;
    	    e *= e;
    	    p = 1.;
    	    q = -ex;
    	    r = 1. + ex * ex;
    	    s = r;
    	    en = 2.;
    	    while (r * en * en < e) {
    		en1 = en + 1.;
    		d = (en - 1. + c / en) / s;
    		p = (en + en - p * d) / en1;
    		q = (-b + q * d) / en1;
    		s = p * p + q * q;
    		r *= s;
    		en = en1;
    	    }
    	    f = p / s;
    	    p = f;
    	    g = -q / s;
    	    q = g;
    	    en -= 1.;
	    for(; en > 0. ; en -= 1.) //L220:
		{
		    r = en1 * (2. - p) - 2.;
		    s = b + en1 * q;
		    d = (en - 1. + c / en) / (r * r + s * s);
		    p = d * r;
		    q = d * s;
		    e = f + 1.;
		    f = p * e - g * q;
		    g = q * e + p * g;
		    en1 = en;
		    // goto L220;
		}
    	    f = 1. + f;
    	    d = f * f + g * g;
    	    pa = f / d;
    	    qa = -g / d;
    	    d = nu + .5 - p;
    	    q += ex;
    	    pa1 = (pa * q - qa * d) / ex;
    	    qa1 = (qa * q + pa * d) / ex;
    	    b = ex - DistLib_h.M_PI_2 * (nu + .5);
/*!* 	    c = cos(b); *!*/
    	    c = java.lang.Math.cos(b);
/*!* 	    s = sin(b); *!*/
    	    s = java.lang.Math.sin(b);
/*!* 	    d = DistLib_h.M_SQRT_2dPI / sqrt(ex); *!*/
    	    d = DistLib_h.M_SQRT_2dPI / java.lang.Math.sqrt(ex);
    	    ya = d * (pa * s + qa * c);
    	    ya1 = d * (qa1 * s - pa1 * c);
    	} else { /* x > thresh */
    	    /* ----------------------------------------------------------
    	       Use Campbell's asymptotic scheme.
    	       ---------------------------------------------------------- */
    	    na = 0;
    	    d1 = ftrunc(ex / fivpi);
    	    i =  (int) d1;
    	    dmu = ex - 15. * d1 - d1 * pim5 - (alpha + .5) * DistLib_h.M_PI_2;
    	    if (i - (i / 2 << 1) == 0) {
/*!* 		cosmu = cos(dmu); *!*/
    		cosmu = java.lang.Math.cos(dmu);
/*!* 		sinmu = sin(dmu); *!*/
    		sinmu = java.lang.Math.sin(dmu);
    	    } else {
/*!* 		cosmu = -cos(dmu); *!*/
    		cosmu = -java.lang.Math.cos(dmu);
/*!* 		sinmu = -sin(dmu); *!*/
    		sinmu = -java.lang.Math.sin(dmu);
    	    }
    	    ddiv = 8. * ex;
    	    dmu = alpha;
/*!* 	    den = sqrt(ex); *!*/
    	    den = java.lang.Math.sqrt(ex);
    	    for (k = 1; k <= 2; ++k) {
    		p = cosmu;
    		cosmu = sinmu;
    		sinmu = -p;
    		d1 = (2. * dmu - 1.) * (2. * dmu + 1.);
    		d2 = 0.;
    		div = ddiv;
    		p = 0.;
    		q = 0.;
    		q0 = d1 / div;
    		term = q0;
    		for (i = 2; i <= 20; ++i) {
    		    d2 += 8.;
    		    d1 -= d2;
    		    div += ddiv;
    		    term = -term * d1 / div;
    		    p += term;
    		    d2 += 8.;
    		    d1 -= d2;
    		    div += ddiv;
    		    term *= (d1 / div);
    		    q += term;
/*!* 		    if (fabs(term) <= DistLib_h.DBL_EPSILON) { *!*/
    		    if (java.lang.Math.abs(term) <= DistLib_h.DBL_EPSILON) {
    			break;
    		    }
    		}
    		p += 1.;
    		q += q0;
    		if (k == 1)
    		    ya = DistLib_h.M_SQRT_2dPI * (p * cosmu - q * sinmu) / den;
    		else
    		    ya1 = DistLib_h.M_SQRT_2dPI * (p * cosmu - q * sinmu) / den;
    		dmu += 1.;
    	    }
    	}
    	if (na == 1) {
    	    h = 2. * (nu + 1.) / ex;
    	    if (h > 1.) {
/*!* 		if (fabs(ya1) > Double.MAX_VALUE / h) { *!*/
    		if (java.lang.Math.abs(ya1) > Double.MAX_VALUE / h) {
    		    h = 0.;
    		    ya = 0.;
    		}
    	    }
    	    h = h * ya1 - ya;
    	    ya = ya1;
    	    ya1 = h;
    	}
    
    	/* ---------------------------------------------------------------
    	   Now have first one or two Y's
    	   --------------------------------------------------------------- */
    	by[0] = ya;
    	ncalc = 1;
	L450: {
    	if(nb > 1) {
    	    by[1] = ya1;
    	    if (ya1 != 0.) {
    		aye = 1. + alpha;
    		twobyx = 2. / ex;
    		ncalc = 2;
    		for (i = 2; i < nb; ++i) {
    		    if (twobyx < 1.) {
/*!* 			if (fabs(by[i - 1]) * twobyx >= Double.MAX_VALUE / aye) *!*/
    			if (java.lang.Math.abs(by[i - 1]) * twobyx >= Double.MAX_VALUE / aye)
    			    break L450;
    		    } else {
/*!* 			if (fabs(by[i - 1]) >= Double.MAX_VALUE / aye / twobyx) *!*/
    			if (java.lang.Math.abs(by[i - 1]) >= Double.MAX_VALUE / aye / twobyx)
    			    break L450;
    		    }
    		    by[i] = twobyx * aye * by[i - 1] - by[i - 2];
    		    aye += 1.;
    		    ++ncalc;
    		}
    	    }
    	}
	} //    L450:
    	for (i = (int) ncalc; i < nb; ++i)
    	    by[i] = Double.NEGATIVE_INFINITY;/* was 0 */
    
        } else {
    	by[0] = 0.;
    	ncalc = Math.min(nb,0) - 1;
        }

	double[] retval = new double[(int) nb];
	int ii=0;
	for (ii=0; ii<nb; ii++)
	    retval[ii] = by[ii+1];
		
	return(retval);



    }
    
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double beta(double a, double b);
     *
     *  DESCRIPTION
     *
     *    This function returns the value of the beta function
     *    evaluated with arguments a and b.
     *
     *  NOTES
     *
     *    This routine is a translation into C of a Fortran subroutine
     *    by W. Fullerton of Los Alamos Scientific Laboratory.
     *    Some modifications have been made so that the routines
     *    conform to the IEEE 754 standard.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  beta(double a, double b)
    {
        double xmax = 0;
        double alnsml = 0;
        double val=0.0, xmin=0.0;
	double temp[];
    
        if (xmax == 0) {
	    temp = gammalims(xmin, xmax);
	    xmin = temp[0]; xmax=temp[1];
/*!* 	    alnsml = log(d1mach(1)); *!*/
    	    alnsml = java.lang.Math.log(d1mach(1));
        }
    
    /*!* #ifdef IEEE_754 /*4!*/
        /* NaNs propagated correctly */
        if(Double.isNaN(a) || Double.isNaN(b)) return a + b;
    /*!* #endif /*4!*/
    
        if (a < 0 || b < 0) {
    	throw new java.lang.ArithmeticException("Math Error: DOMAIN");
	//    	return Double.NaN;
        }
        else if (a == 0 || b == 0) {
    	return Double.POSITIVE_INFINITY;
        }
    /*!* #ifdef IEEE_754 /*4!*/
        else if (Double.isInfinite(a) || Double.isInfinite(b)) {
    	return 0;
        }
    /*!* #endif /*4!*/
    
        if (a + b < xmax)
    	return gammafn(a) * gammafn(b) / gammafn(a+b);
    
        val = lbeta(a, b);
        if (val < alnsml) {
    	/* a and/or b so big that beta underflows */
    	throw new java.lang.ArithmeticException("Math Error: UNDERFLOW");
	//    	return (Double.MIN_VALUE * Double.MIN_VALUE);
        }
/*!*     return exp(val); *!*/
        return java.lang.Math.exp(val);
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    int chebyshev_init(double *dos, int nos, double eta)
     *    double chebyshev_eval(double x, double *a, int n)
     *
     *  DESCRIPTION
     *
     *    "chebyshev_init" determines the number of terms for the
     *    double precision orthogonal series "dos" needed to insure
     *    the error is no larger than "eta".  Ordinarily eta will be
     *    chosen to be one-tenth machine precision.
     *
     *    "chebyshev_eval" evaluates the n-term Chebyshev series
     *    "a" at "x".
     *
     *  NOTES
     *
     *    These routines are translations into C of Fortran routines
     *    by W. Fullerton of Los Alamos Scientific Laboratory.
     *
     *    Based on the Fortran routine dcsevl by W. Fullerton.
     *    Adapted from R. Broucke, Algorithm 446, CACM., 16, 254 (1973).
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    /* NaNs propagated correctly */
    
    
    static int chebyshev_init(double dos[], int nos, double eta)
    {
        int i, ii;
        double err;
    
        if (nos < 1)
    	return 0;
    
        err = 0.0;
        i = 0;			/* just to avoid compiler warnings */
        for (ii=1; ii<=nos; ii++) {
    	i = nos - ii;
/*!* 	err += fabs(dos[i]); *!*/
    	err += java.lang.Math.abs(dos[i]);
    	if (err > eta) {
    	    return i;
    	}
        }
        return i;
    }
    
    
    public static double  chebyshev_eval(double x, double a[], int n)
    {
        double b0, b1, b2, twox;
        int i;
    
        if (n < 1 || n > 1000) {
    	throw new java.lang.ArithmeticException("Math Error: DOMAIN");
	//    	return Double.NaN;
        }
    
        if (x < -1.1 || x > 1.1) {
    	throw new java.lang.ArithmeticException("Math Error: DOMAIN");
	//    	return Double.NaN;
        }
    
        twox = x * 2;
        b2 = b1 = 0;
        b0 = 0;
        for (i = 1; i <= n; i++) {
    	b2 = b1;
    	b1 = b0;
    	b0 = twox * b1 - b2 + a[(int) n - i];
        }
        return (b0 - b2) * 0.5;
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double choose(double n, double k);
     *    double fastchoose(double n, double k);
     *    double lchoose(double n, double k);
     *    double lfastchoose(double n, double k);
     *
     *  DESCRIPTION
     *
     *    Binomial coefficients.
     */
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  lfastchoose(double n, double k)
    {
    	return lgammafn(n + 1.0) - lgammafn(k + 1.0) - lgammafn(n - k + 1.0);
    }
    
    public static double  fastchoose(double n, double k)
    {
/*!* 	return exp(lfastchoose(n, k)); *!*/
    	return java.lang.Math.exp(lfastchoose(n, k));
    }
    
    public static double  lchoose(double n, double k)
    {
/*!* 	n = floor(n + 0.5); *!*/
    	n = java.lang.Math.floor(n + 0.5);
/*!* 	k = floor(k + 0.5); *!*/
    	k = java.lang.Math.floor(k + 0.5);
    /*!* #ifdef IEEE_754 /*4!*/
    	/* NaNs propagated correctly */
    	if(Double.isNaN(n) || Double.isNaN(k)) return n + k;
    /*!* #endif /*4!*/
    	if (k < 0 || n < k) {
    	    throw new java.lang.ArithmeticException("Math Error: DOMAIN");
	    //    	    return Double.NaN;
            }
    	return lfastchoose(n, k);
    }
    
    public static double  choose(double n, double k)
    {
/*!* 	n = floor(n + 0.5); *!*/
    	n = java.lang.Math.floor(n + 0.5);
/*!* 	k = floor(k + 0.5); *!*/
    	k = java.lang.Math.floor(k + 0.5);
    /*!* #ifdef IEEE_754 /*4!*/
    	/* NaNs propagated correctly */
    	if(Double.isNaN(n) || Double.isNaN(k)) return n + k;
    /*!* #endif /*4!*/
    	if (k < 0 || n < k) {
    	    throw new java.lang.ArithmeticException("Math Error: DOMAIN");
	    //    	    return Double.NaN;
            }
/*!* 	return floor(exp(lfastchoose(n, k)) + 0.5); *!*/
    	return java.lang.Math.floor(java.lang.Math.exp(lfastchoose(n, k)) + 0.5);
    }
    /*
     *  DistLib - A Mathematical Function Library
     *  Copyright (C) 1998  Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     */
    
    /* NaNs propagated correctly */
    
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  d1mach(int i)
    {
        switch(i) {
        case 1: return Double.MIN_VALUE;
        case 2: return Double.MAX_VALUE;
    
/*!*     case 3: return pow((double)i1mach(10), -(double)i1mach(14)); *!*/
        case 3: return java.lang.Math.pow((double)i1mach(10), -(double)i1mach(14));
/*!*     case 4: return pow((double)i1mach(10), 1-(double)i1mach(14)); *!*/
        case 4: return java.lang.Math.pow((double)i1mach(10), 1-(double)i1mach(14));
    
        case 5: return VisualNumerics.math.Sfun.log10(2.0);
    
        default: return 0.0;
        }
    }
    
    public static double  d1mach_(int i)
    {
    	return d1mach(i);
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double fcube(double x);
     *
     *  DESCRIPTION
     *
     *    This function returns the cube of its argument.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  fcube(double x)
    {
        return x * x * x;
    }
    /*
     *  R : A Computer Langage for Statistical Data Analysis
     *  Copyright (C) 1995, 1996  Robert Gentleman and Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  fmax2(double x, double y)
    {
    /*!* #ifdef IEEE_754 /*4!*/
    	if (Double.isNaN(x) || Double.isNaN(y))
    		return x + y;
    /*!* #endif /*4!*/
    	return (x < y) ? y : x;
    }
    /*
     *  R : A Computer Langage for Statistical Data Analysis
     *  Copyright (C) 1995, 1996  Robert Gentleman and Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  fmin2(double x, double y)
    {
    /*!* #ifdef IEEE_754 /*4!*/
    	if (Double.isNaN(x) || Double.isNaN(y))
    		return x + y;
    /*!* #endif /*4!*/
    	return (x < y) ? x : y;
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double fmod(double x, double y);
     *
     *  DESCRIPTION
     *
     *    Floating-point remainder of x / y;
     *
     *  NOTES
     *
     *    It may be better to use the system version of this function,
     *    but this version is portable.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  fmod(double x, double y)
    {
        double quot;
    /*!* #ifdef IEEE_754 /*4!*/
        if (Double.isNaN(x) || Double.isNaN(y))
    	return x + y;
    /*!* #endif /*4!*/
        quot = x / y;
/*!*     return x - (quot < 0.0 ? ceil(quot) : floor(quot)) * y; *!*/
        return x - (quot < 0.0 ? java.lang.Math.ceil(quot) : java.lang.Math.floor(quot)) * y;
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double fprec(double x, double digits);
     *
     *  DESCRIPTION
     *
     *    Returns the value of x rounded to "digits" significant
     *    decimal digits.
     *
     *  NOTES
     *
     *    This routine is a translation into C of a Fortran subroutine
     *    by W. Fullerton of Los Alamos Scientific Laboratory.
     *    Some modifications have been made so that the routines
     *    conform to the IEEE 754 standard.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    /* Improvements by Martin Maechler, May 1997 */
    /* Note that the code could be further improved by using */
    /* java.lang.Math.pow(x, i)	 instead of  pow(x, (double)i) */
    
    static final double  MAXPLACES = DistLib_h.DBL_DIG; 
    
    public static double  fprec(double x, double digits)
    {
        double l10, pow10, sgn, p10, P10;
        int e10, e2;
	boolean do_round;
        /* Max.expon. of 10 (=308.2547) */
        final  double max10e = DistLib_h.DBL_MAX_EXP * DistLib_h.M_LOG10_2;
    
    /*!* #ifdef IEEE_754 /*4!*/
        if (Double.isNaN(x) || Double.isNaN(digits))
    	return x + digits;
        if (Double.isInfinite(x)) return x;
        if (Double.isInfinite(digits)) {
    	if(digits > 0) return x;
    	else return 0;
        }
    /*!* #endif /*4!*/
        if(x == 0) return x;
/*!*     digits = floor(digits+0.5); *!*/
        digits = java.lang.Math.floor(digits+0.5);
        if (digits > MAXPLACES) {
    	return x;
        } else if (digits < 1)
    	digits = 1;
    
        sgn = 1.0;
        if(x < 0.0) {
    	sgn = -sgn;
    	x = -x;
        }
        l10 = VisualNumerics.math.Sfun.log10(x);
/*!*     e10 = (int)(digits-1-floor(l10)); *!*/
        e10 = (int)(digits-1-java.lang.Math.floor(l10));
/*!*     if(fabs(l10) < max10e - 2) { *!*/
        if(java.lang.Math.abs(l10) < max10e - 2) {
/*!* 	pow10 = pow(10.0, (double)e10); *!*/
    	pow10 = java.lang.Math.pow(10.0, (double)e10);
/*!* 	return(sgn*floor(x*pow10+0.5)/pow10); *!*/
    	return(sgn*java.lang.Math.floor(x*pow10+0.5)/pow10);
        } else { /* -- LARGE or small -- */
/*!* 	do_round = max10e - l10	 >= pow(10.0, -digits); *!*/
    	do_round = max10e - l10	 >= java.lang.Math.pow(10.0, -digits);
    	e2 = (e10>0)? 16 : -16;
/*!* 	p10 = pow(10.0, (double)e2);		x *= p10; *!*/
    	p10 = java.lang.Math.pow(10.0, (double)e2);		x *= p10;
/*!* 	P10 = pow(10.0, (double)e10-e2);	x *= P10; *!*/
    	P10 = java.lang.Math.pow(10.0, (double)e10-e2);	x *= P10;
    	/*-- p10 * P10 = 10 ^ e10 */
    	if(do_round) x += 0.5;
/*!* 	x = floor(x) / p10; *!*/
    	x = java.lang.Math.floor(x) / p10;
    	return(sgn*x/P10);
        }
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double fround(double x, double digits);
     *
     *  DESCRIPTION
     *
     *    Rounds "x" to "digits" decimal digits.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    /*!* #ifndef HAVE_RINT /*4!*/
    /*!* #define USE_BUILTIN_RINT /*4!*/
    /*!* #endif /*4!*/
    
    /*!* #ifdef USE_BUILTIN_RINT /*4!*/
      // final  double  R_rint = static private_rint; 
    
    	/* The largest integer which can be represented */
    	/* exactly in floating point form. */
    
    static final  double  BIGGEST = 4503599627370496.0E0; 
	/* 2^52 for IEEE */
    
    static private double Rint(double x)
    {
    	final  double biggest = BIGGEST;
    	double tmp;
    
    	if (x != x) return x;			/* NaN */
    
/*!* 	if (fabs(x) >= biggest)			!!!COMMENT!!! *!*/
    	if (java.lang.Math.abs(x) >= biggest)			/* Already integer */
    		return x;
    
    	if(x >= 0) {
    		tmp = x + biggest;
    		return tmp - biggest;
    	}
    	else {
    		tmp = x - biggest;
    		return tmp + biggest;
    	}
    }
    
    /*!* #else /*4!*/
      //final  double  R_rint = rint; 
    /*!* #endif /*4!*/
    
    public static double  fround(double x, double digits)
    {
    	double pow10, sgn, intx;
    	final  double maxdigits = DistLib_h.DBL_DIG - 1;
    
    /*!* #ifdef IEEE_754 /*4!*/
    	if (Double.isNaN(x) || Double.isNaN(digits))
    		return x + digits;
    	if(Double.isInfinite(x)) return x;
    /*!* #endif /*4!*/
    
/*!* 	digits = floor(digits + 0.5); *!*/
    	digits = java.lang.Math.floor(digits + 0.5);
    	if (digits > maxdigits)
    		digits = maxdigits;
/*!* 	pow10 = pow(10.0, digits); *!*/
    	pow10 = java.lang.Math.pow(10.0, digits);
    	sgn = 1.0;
    	if(x < 0.0) {
    		sgn = -sgn;
    		x = -x;
    	}
    	if (digits > 0.0) {
/*!* 		intx = floor(x); *!*/
    		intx = java.lang.Math.floor(x);
    		x = x - intx;
    	} else {
    		intx = 0.0;
    	}
    	return sgn * (intx + java.lang.Math.rint(x * pow10) / pow10);
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double fsign(double x, double y);
     *
     *  DESCRIPTION
     *
     *    This function performs transfer of sign.  The result is:
     *
     *                        |x| * signum(y)
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  fsign(double x, double y)
    {
    /*!* #ifdef IEEE_754 /*4!*/
        if (Double.isNaN(x) || Double.isNaN(y))
    	return x + y;
    /*!* #endif /*4!*/
/*!*     return ((y >= 0) ? fabs(x) : -fabs(x)); *!*/
        return ((y >= 0) ? java.lang.Math.abs(x) : -java.lang.Math.abs(x));
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double fsquare(double x);
     *
     *  DESCRIPTION
     *
     *    This function returns the square of its argument.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  fsquare(double x)
    {
        return x * x;
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double ftrunc(double x);
     *
     *  DESCRIPTION
     *
     *    Truncation toward zero.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  ftrunc(double x)
    {
/*!* 	if(x >= 0) return floor(x); *!*/
    	if(x >= 0) return java.lang.Math.floor(x);
/*!* 	else return ceil(x); *!*/
    	else return java.lang.Math.ceil(x);
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double gammafn(double x);
     *
     *  DESCRIPTION
     *
     *    This function computes the value of the gamma function.
     *
     *  NOTES
     *
     *    This function is a translation into C of a Fortran subroutine
     *    by W. Fullerton of Los Alamos Scientific Laboratory.
     *
     *    The accuracy of this routine compares (very) favourably
     *    with those of the Sun Microsystems portable mathematical
     *    library.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
        static final  double gamcs[] = {
    	+.8571195590989331421920062399942e-2,
    	+.4415381324841006757191315771652e-2,
    	+.5685043681599363378632664588789e-1,
    	-.4219835396418560501012500186624e-2,
    	+.1326808181212460220584006796352e-2,
    	-.1893024529798880432523947023886e-3,
    	+.3606925327441245256578082217225e-4,
    	-.6056761904460864218485548290365e-5,
    	+.1055829546302283344731823509093e-5,
    	-.1811967365542384048291855891166e-6,
    	+.3117724964715322277790254593169e-7,
    	-.5354219639019687140874081024347e-8,
    	+.9193275519859588946887786825940e-9,
    	-.1577941280288339761767423273953e-9,
    	+.2707980622934954543266540433089e-10,
    	-.4646818653825730144081661058933e-11,
    	+.7973350192007419656460767175359e-12,
    	-.1368078209830916025799499172309e-12,
    	+.2347319486563800657233471771688e-13,
    	-.4027432614949066932766570534699e-14,
    	+.6910051747372100912138336975257e-15,
    	-.1185584500221992907052387126192e-15,
    	+.2034148542496373955201026051932e-16,
    	-.3490054341717405849274012949108e-17,
    	+.5987993856485305567135051066026e-18,
    	-.1027378057872228074490069778431e-18,
    	+.1762702816060529824942759660748e-19,
    	-.3024320653735306260958772112042e-20,
    	+.5188914660218397839717833550506e-21,
    	-.8902770842456576692449251601066e-22,
    	+.1527474068493342602274596891306e-22,
    	-.2620731256187362900257328332799e-23,
    	+.4496464047830538670331046570666e-24,
    	-.7714712731336877911703901525333e-25,
    	+.1323635453126044036486572714666e-25,
    	-.2270999412942928816702313813333e-26,
    	+.3896418998003991449320816639999e-27,
    	-.6685198115125953327792127999999e-28,
    	+.1146998663140024384347613866666e-28,
    	-.1967938586345134677295103999999e-29,
    	+.3376448816585338090334890666666e-30,
    	-.5793070335782135784625493333333e-31
        };
    
    public static double  gammafn(double x)
    {
        int ngam = 0;
        double xmin = 0.;
        double xmax = 0.;
        double xsml = 0.;
        double dxrel = 0.;
	double temp[];
    
        int i, n;
        double y;
        double sinpiy, value;
    
        if (ngam == 0) {
    	ngam = chebyshev_init(gamcs, 42, 0.1 * d1mach(3));
    	temp = gammalims(xmin, xmax);
	xmin=temp[0]; xmax=temp[1];
/*!* 	xsml = exp(fmax2(log(d1mach(1)), -log(d1mach(2)))+0.01); *!*/
    	xsml = java.lang.Math.exp(fmax2(java.lang.Math.log(d1mach(1)), -java.lang.Math.log(d1mach(2)))+0.01);
/*!* 	dxrel = sqrt(d1mach(4)); *!*/
    	dxrel = java.lang.Math.sqrt(d1mach(4));
        }
    
    /*!* #ifdef IEEE_754 /*4!*/
        if(Double.isNaN(x)) return x;
    /*!* #endif /*4!*/
    
/*!*     y = fabs(x); *!*/
        y = java.lang.Math.abs(x);
    
        if (y <= 10) {
    
    	/* Compute gamma(x) for -10 <= x <= 10. */
    	/* Reduce the interval and find gamma(1 + y) for */
    	/* 0 <= y < 1 first of all. */
    
    	n = (int) x;
    	if(x < 0) --n;
    	y = x - n;/* n = floor(x)  ==>	y in [ 0, 1 ) */
    	--n;
    	value = chebyshev_eval(y * 2 - 1, gamcs, ngam) + .9375;
    	if (n == 0)
    	    return value;/* x = 1.dddd = 1+y */
    
    	if (n < 0) {
    	    /* compute gamma(x) for -10 <= x < 1 */
    
    	    /* If the argument is exactly zero or a negative integer */
    	    /* then return NaN. */
    	    if (x == 0 || (x < 0 && x == n + 2)) {
    		throw new java.lang.ArithmeticException("Math Error: RANGE");
		//    		return Double.NaN;
    	    }
    
    	    /* The answer is less than half precision */
    	    /* because x too near a negative integer. */
/*!* 	    if (x < -0.5 && fabs(x - (int)(x - 0.5) / x) < dxrel) { *!*/
    	    if (x < -0.5 && java.lang.Math.abs(x - (int)(x - 0.5) / x) < dxrel) {
    		throw new java.lang.ArithmeticException("Math Error: PRECISION");
    	    }
    
    	    /* The argument is so close to 0 that the result would overflow. */
    	    if (y < xsml) {
    		throw new java.lang.ArithmeticException("Math Error: RANGE");
		//    		if(x > 0) return Double.POSITIVE_INFINITY;
		//    		else return Double.NEGATIVE_INFINITY;
    	    }
    
    	    n = -n;
    
    	    for (i = 0; i < n; i++) {
    		value /= (x + i);
    	    }
    	    return value;
    	}
    	else {
    	    /* gamma(x) for 2 <= x <= 10 */
    
    	    for (i = 1; i <= n; i++) {
    		value *= (y + i);
    	    }
    	    return value;
    	}
        }
        else {
    	/* gamma(x) for	 y = |x| > 10. */
    
    	if (x > xmax) {			/* Overflow */
    	    throw new java.lang.ArithmeticException("Math Error: RANGE");
	    //    	    return Double.POSITIVE_INFINITY;
    	}
    
    	if (x < xmin) {			/* Underflow */
    	    throw new java.lang.ArithmeticException("Math Error: UNDERFLOW");
	    //    	    return (Double.MIN_VALUE * Double.MIN_VALUE);
    	}
    
/*!* 	value = exp((y - 0.5) * log(y) - y + DistLib_h.M_LN_SQRT_2PI + lgammacor(y)); *!*/
    	value = java.lang.Math.exp((y - 0.5) * java.lang.Math.log(y) - y + DistLib_h.M_LN_SQRT_2PI + lgammacor(y));
    
    	if (x > 0)
    	    return value;
    
/*!* 	if (fabs((x - (int)(x - 0.5))/x) < dxrel){ *!*/
    	if (java.lang.Math.abs((x - (int)(x - 0.5))/x) < dxrel){
    
    	    /* The answer is less than half precision because */
    	    /* the argument is too near a negative integer. */
    
    	    throw new java.lang.ArithmeticException("Math Error: PRECISION");
    	}
    
/*!* 	sinpiy = sin(DistLib_h.M_PI * y); *!*/
    	sinpiy = java.lang.Math.sin(DistLib_h.M_PI * y);
    	if (sinpiy == 0) {		/* Negative integer arg - overflow */
    	    throw new java.lang.ArithmeticException("Math Error: RANGE");
	    //    	    return Double.POSITIVE_INFINITY;
    	}
    
    	return -DistLib_h.M_PI / (y * sinpiy * value);
        }
    }
    /* From http://www.netlib.org/specfun/gamma	Fortran translated by f2c,...
     *	------------------------------#####	Martin Maechler, ETH Zurich
     *
     *=========== was part of	ribesl (Bessel I(.))
     *===========			~~~~~~
     */
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  gamma_cody(double x)
    {
    /* ----------------------------------------------------------------------
    
       This routine calculates the GAMMA function for a float argument X.
       Computation is based on an algorithm outlined in reference [1].
       The program uses rational functions that approximate the GAMMA
       function to at least 20 significant decimal digits.	Coefficients
       for the approximation over the interval (1,2) are unpublished.
       Those for the approximation for X >= 12 are from reference [2].
       The accuracy achieved depends on the arithmetic system, the
       compiler, the intrinsic functions, and proper selection of the
       machine-dependent constants.
    
       *******************************************************************
    
       Error returns
    
       The program returns the value XINF for singularities or
       when overflow would occur.	 The computation is believed
       to be free of underflow and overflow.
    
       Intrinsic functions required are:
    
       INT, DBLE, EXP, LOG, REAL, SIN
    
    
       References:
       [1]  "An Overview of Software Development for Special Functions",
    	W. J. Cody, Lecture Notes in Mathematics, 506,
    	Numerical Analysis Dundee, 1975, G. A. Watson (ed.),
    	Springer Verlag, Berlin, 1976.
    
       [2]  Computer Approximations, Hart, Et. Al., Wiley and sons, New York, 1968.
    
       Latest modification: October 12, 1989
    
       Authors: W. J. Cody and L. Stoltz
       Applied Mathematics Division
       Argonne National Laboratory
       Argonne, IL 60439
       ----------------------------------------------------------------------*/
    
    /* ----------------------------------------------------------------------
       Mathematical constants
       ----------------------------------------------------------------------*/
        final  double sqrtpi = .9189385332046727417803297; /* == ??? */
    
    /* *******************************************************************
    
       Explanation of machine-dependent constants
    
       beta	- radix for the floating-point representation
       maxexp - the smallest positive power of beta that overflows
       XBIG	- the largest argument for which GAMMA(X) is representable
    	in the machine, i.e., the solution to the equation
    	GAMMA(XBIG) = beta**maxexp
       XINF	- the largest machine representable floating-point number;
    	approximately beta**maxexp
       EPS	- the smallest positive floating-point number such that  1.0+EPS > 1.0
       XMININ - the smallest positive floating-point number such that
    	1/XMININ is machine representable
    
       Approximate values for some important machines are:
    
       beta	      maxexp	     XBIG
    
       CRAY-1		(S.P.)	      2		8191	    966.961
       Cyber 180/855
       under NOS	(S.P.)	      2		1070	    177.803
       IEEE (IBM/XT,
       SUN, etc.)	(S.P.)	      2		 128	    35.040
       IEEE (IBM/XT,
       SUN, etc.)	(D.P.)	      2		1024	    171.624
       IBM 3033	(D.P.)	     16		  63	    57.574
       VAX D-Format	(D.P.)	      2		 127	    34.844
       VAX G-Format	(D.P.)	      2		1023	    171.489
    
       XINF	 EPS	    XMININ
    
       CRAY-1		(S.P.)	 5.45E+2465   7.11E-15	  1.84E-2466
       Cyber 180/855
       under NOS	(S.P.)	 1.26E+322    3.55E-15	  3.14E-294
       IEEE (IBM/XT,
       SUN, etc.)	(S.P.)	 3.40E+38     1.19E-7	  1.18E-38
       IEEE (IBM/XT,
       SUN, etc.)	(D.P.)	 1.79D+308    2.22D-16	  2.23D-308
       IBM 3033	(D.P.)	 7.23D+75     2.22D-16	  1.39D-76
       VAX D-Format	(D.P.)	 1.70D+38     1.39D-17	  5.88D-39
       VAX G-Format	(D.P.)	 8.98D+307    1.11D-16	  1.12D-308
    
       *******************************************************************
    
       ----------------------------------------------------------------------
       Machine dependent parameters
       ----------------------------------------------------------------------
       */
    
    
        final  double xbig = 171.624;
        /* ML_POSINF ==   static private double xinf = 1.79e308;*/
        /* DistLib_h.DBL_EPSILON = static private double eps = 2.22e-16;*/
        /* Double.MIN_VALUE ==   static private double xminin = 2.23e-308;*/
    
        /*----------------------------------------------------------------------
          Numerator and denominator coefficients for rational minimax
          approximation over (1,2).
          ----------------------------------------------------------------------*/
	//        final  double p[8] = {
        final  double p[] = {
    	-1.71618513886549492533811,
    	24.7656508055759199108314,-379.804256470945635097577,
    	629.331155312818442661052,866.966202790413211295064,
    	-31451.2729688483675254357,-36144.4134186911729807069,
    	66456.1438202405440627855 };
	//        final  double q[8] = { 
        final  double q[] = {
   	-30.8402300119738975254353,
    	315.350626979604161529144,-1015.15636749021914166146,
    	-3107.77167157231109440444,22538.1184209801510330112,
    	4755.84627752788110767815,-134659.959864969306392456,
    	-115132.259675553483497211 };
        /*----------------------------------------------------------------------
          Coefficients for minimax approximation over (12, INF).
          ----------------------------------------------------------------------*/
	//        final  double c[7] = {
        final  double c[] = {
    	-.001910444077728,8.4171387781295e-4,
    	-5.952379913043012e-4,7.93650793500350248e-4,
    	-.002777777777777681622553,.08333333333333333331554247,
    	.0057083835261 };
    
        /* Local variables */
        long i, n;
        boolean parity;/*logical*/
        double fact, xden, xnum, y, z, y1, res, sum, ysq;
    
        parity = false;
        fact = 1.;
        n = 0;
        y = x;
    L_end: {
	  if (y <= 0.) {
	    /* -------------------------------------------------------------
	       Argument is negative
	       ------------------------------------------------------------- */
	    y = -x;
	    y1 = ftrunc(y);
	    res = y - y1;
	    if (res != 0.) {
	      if (y1 != ftrunc(y1 * .5) * 2.)
    		parity = true;
	      /*!* 	    fact = -DistLib_h.M_PI / sin(DistLib_h.M_PI * res); *!*/
	      fact = -DistLib_h.M_PI / java.lang.Math.sin(DistLib_h.M_PI * res);
	      y += 1.;
	    } else {
	      res = Double.POSITIVE_INFINITY;
	      break L_end;
	    }
	  }
	  /* -----------------------------------------------------------------
	     Argument is positive
	     -----------------------------------------------------------------*/
	  if (y < DistLib_h.DBL_EPSILON) {
	    /* --------------------------------------------------------------
	       Argument < EPS
	       -------------------------------------------------------------- */
	    if (y >= Double.MIN_VALUE) {
	      res = 1. / y;
	    } else {
	      res = Double.POSITIVE_INFINITY;
	      break L_end;
	    }
	  } else if (y < 12.) {
	    y1 = y;
	    if (y < 1.) {
	      /* ---------------------------------------------------------
		 EPS < argument < 1
		 --------------------------------------------------------- */
	      z = y;
	      y += 1.;
	    } else {
	      /* -----------------------------------------------------------
		 1 <= argument < 12, reduce argument if necessary
		 ----------------------------------------------------------- */
	      n = (long) y - 1;
	      y -= (double) n;
	      z = y - 1.;
	    }
	    /* ---------------------------------------------------------
	       Evaluate approximation for 1.0 < argument < 2.0
	       ---------------------------------------------------------*/
	    xnum = 0.;
	    xden = 1.;
	    for (i = 0; i < 8; ++i) {
	      xnum = (xnum + p[(int) i]) * z;
	      xden = xden * z + q[(int) i];
	    }
	    res = xnum / xden + 1.;
	    if (y1 < y) {
	      /* --------------------------------------------------------
		 Adjust result for case  0.0 < argument < 1.0
		 -------------------------------------------------------- */
	      res /= y1;
	    } else if (y1 > y) {
	      /* ----------------------------------------------------------
		 Adjust result for case  2.0 < argument < 12.0
		 ---------------------------------------------------------- */
	      for (i = 0; i < n; ++i) {
    		res *= y;
    		y += 1.;
	      }
	    }
	  } else {
	    /* -------------------------------------------------------------
	       Evaluate for argument >= 12.0,
	       ------------------------------------------------------------- */
	    if (y <= xbig) {
	      ysq = y * y;
	      sum = c[6];
	      for (i = 0; i < 6; ++i) {
    		sum = sum / ysq + c[(int) i];
	      }
	      sum = sum / y - y + sqrtpi;
	      /*!* 	    sum += (y - .5) * log(y); *!*/
	      sum += (y - .5) * java.lang.Math.log(y);
	      /*!* 	    res = exp(sum); *!*/
	      res = java.lang.Math.exp(sum);
	    } else {
	      res = Double.POSITIVE_INFINITY;
	      break L_end;
	    }
	  }
	  /* ----------------------------------------------------------------------
	     Final adjustments and return
	     ----------------------------------------------------------------------*/
	  if (parity)
	    res = -res;
	  if (fact != 1.)
	    res = fact / res;
    
	} // L_end:
        return res;
    }
    
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    void gammalims(double *xmin, double *xmax);
     *
     *  DESCRIPTION
     *
     *    This function alculates the minimum and maximum legal bounds
     *    for x in gammafn(x).  These are not the only bounds, but they
     *    are the only non-trivial ones to calculate.
     *
     *  NOTES
     *
     *    This routine is a translation into C of a Fortran subroutine
     *    by W. Fullerton of Los Alamos Scientific Laboratory.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    /* FIXME: We need an ifdef'ed version of this which gives  */
    /* the exact values when we are using IEEE 754 arithmetic. */
    
    static double[] gammalims(double xmin, double xmax)
    {
        double alnbig, alnsml, xln, xold;
        int i;
    
/*!*     alnsml = log(d1mach(1)); *!*/
        alnsml = java.lang.Math.log(d1mach(1));
        xmin = -alnsml;
    find_xmax: {
        for (i=1; i<=10; ++i) {
	    xold = xmin;
/*!* 	xln = log(*xmin); *!*/
	    xln = java.lang.Math.log(xmin);
	    xmin -= xmin * ((xmin + .5) * xln - xmin - .2258 + alnsml) /
    		(xmin * xln + .5);
/*!* 	if (fabs(xmin - xold) < .005) { *!*/
	    if (java.lang.Math.abs(xmin - xold) < .005) {
		xmin = -(xmin) + .01;
		break find_xmax;
	    }
        }
    
        /* unable to find xmin */
    
        throw new java.lang.ArithmeticException("Math Error: NOCONV");
        // xmin = xmax = Double.NaN;
    
	} //    find_xmax:
    
/*!*     alnbig = log(d1mach(2)); *!*/
        alnbig = java.lang.Math.log(d1mach(2));
        xmax = alnbig;
    done: {
        for (i=1; i<=10; ++i) {
	    xold = xmax;
/*!* 	xln = log(*xmax); *!*/
	    xln = java.lang.Math.log(xmax);
	    xmax -= xmax * ((xmax - .5) * xln - xmax + .9189 - alnbig) /
    		(xmax * xln - .5);
/*!* 	if (fabs(xmax - xold) < .005) { *!*/
	    if (java.lang.Math.abs(xmax - xold) < .005) {
		xmax += -.01;
		break done;
	    }
        }
    
        /* unable to find xmax */
    
        throw new java.lang.ArithmeticException("Math Error: NOCONV");
        // xmin = xmax = Double.NaN;
    
	} //    done:
        xmin = fmax2(xmin, -(xmax) + 1);

	double retval[] = new double[2];
	retval[0] = xmin;
	retval[1] = xmax;
	return(retval);
    }
    /*
     *  DistLib - A Mathematical Function Library
     *  Copyright (C) 1998  Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     */
     
    /*!* #include "DistLib.h" /*4!*/
    
    public static int i1mach(int i)
    {
        switch(i) {
    
        case  1: return 5;
        case  2: return 6;
        case  3: return 0;
        case  4: return 0;
    
        case  5: /*return CHAR_BIT * sizeof(int);*/ throw new java.lang.RuntimeException("Unimplemented Feature.");
        case  6: /*return sizeof(int)/sizeof(char);*/ throw new java.lang.RuntimeException("Unimplemented Feature.");
    
        case  7: return 2;
        case  8: /*return CHAR_BIT * sizeof(int) - 1;*/ throw new java.lang.RuntimeException("Unimplemented Feature.");
        case  9: return java.lang.Integer.MAX_VALUE; /*INT_MAX;*/
    
        case 10: return DistLib_h.FLT_RADIX;
    
        case 11: return DistLib_h.FLT_MANT_DIG;
        case 12: return DistLib_h.FLT_MIN_EXP;
        case 13: return DistLib_h.FLT_MAX_EXP;
    
        case 14: return DistLib_h.DBL_MANT_DIG;
        case 15: return DistLib_h.DBL_MAX_EXP;
        case 16: return DistLib_h.DBL_MIN_EXP;
    
        default: return 0;
        }
    }
    
    int i1mach_(int i)
    {
    	return i1mach(i);
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    int imax2(int x, int y);
     *
     *  DESCRIPTION
     *
     *    Compute maximum of two integers.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    int imax2(int x, int y)
    {
        return (x < y) ? y : x;
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    int Math.min(int x, int y);
     *
     *  DESCRIPTION
     *
     *    Compute minimum of two integers.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    int imin2(int x, int y)
    {
        return (x < y) ? x : y;
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double lbeta(double a, double b);
     *
     *  DESCRIPTION
     *
     *    This function returns the value of the log beta function.
     *
     *  NOTES
     *
     *    This routine is a translation into C of a Fortran subroutine
     *    by W. Fullerton of Los Alamos Scientific Laboratory.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  lbeta(double a, double b)
    {
        double corr, p, q;
    
        p = q = a;
        if(b < p) p = b;/* := min(a,b) */
        if(b > q) q = b;/* := max(a,b) */
    
    /*!* #ifdef IEEE_754 /*4!*/
        if(Double.isNaN(a) || Double.isNaN(b))
    	return a + b;
    /*!* #endif /*4!*/
    
        /* both arguments must be >= 0 */
    
        if (p < 0) {
    	throw new java.lang.ArithmeticException("Math Error: DOMAIN");
	//    	return Double.NaN;
        }
        else if (p == 0) {
    	return Double.POSITIVE_INFINITY;
        }
    /*!* #ifdef IEEE_754 /*4!*/
        else if (Double.isInfinite(q)) {
    	return Double.NEGATIVE_INFINITY;
        }
    /*!* #endif /*4!*/
    
        if (p >= 10) {
    	/* p and q are big. */
    	corr = lgammacor(p) + lgammacor(q) - lgammacor(p + q);
/*!* 	return log(q) * -0.5 + DistLib_h.M_LN_SQRT_2PI + corr *!*/
    	return java.lang.Math.log(q) * -0.5 + DistLib_h.M_LN_SQRT_2PI + corr
/*!* 		+ (p - 0.5) * log(p / (p + q)) + q * logrelerr(-p / (p + q)); *!*/
    		+ (p - 0.5) * java.lang.Math.log(p / (p + q)) + q * logrelerr(-p / (p + q));
        }
        else if (q >= 10) {
    	/* p is small, but q is big. */
    	corr = lgammacor(q) - lgammacor(p + q);
/*!* 	return lgammafn(p) + corr + p - p * log(p + q) *!*/
    	return lgammafn(p) + corr + p - p * java.lang.Math.log(p + q)
    		+ (q - 0.5) * logrelerr(-p / (p + q));
        }
        else
    	/* p and q are small: p <= q > 10. */
/*!* 	return log(gammafn(p) * (gammafn(q) / gammafn(p + q))); *!*/
    	return java.lang.Math.log(gammafn(p) * (gammafn(q) / gammafn(p + q)));
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    extern int signgam;
     *    double lgammafn(double x);
     *
     *  DESCRIPTION
     *
     *    This function computes log|gamma(x)|.  At the same time
     *    the variable "signgam" is set to the sign of the gamma
     *    function.
     *
     *  NOTES
     *
     *    This routine is a translation into C of a Fortran subroutine
     *    by W. Fullerton of Los Alamos Scientific Laboratory.
     *
     *    The accuracy of this routine compares (very) favourably
     *    with those of the Sun Microsystems portable mathematical
     *    library.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    static int signgam;
    
    public static double  lgammafn(double x)
    {
        double xmax = 0.;
        double dxrel = 0.;
        double ans, y, sinpiy;
    
        if (xmax == 0) {
/*!* 	xmax = d1mach(2)/log(d1mach(2)); *!*/
    	xmax = d1mach(2)/java.lang.Math.log(d1mach(2));
    	dxrel = java.lang.Math.sqrt (d1mach(4));
        }
    
        signgam = 1;
    
    /*!* #ifdef IEEE_754 /*4!*/
        if(Double.isNaN(x)) return x;
    /*!* #endif /*4!*/
    
        if (x <= 0 && x == (int)x) { /* Negative integer argument */
    	throw new java.lang.ArithmeticException("Math Error: RANGE");
	//    	return Double.POSITIVE_INFINITY;/* +Inf, since lgamma(x) = log|gamma(x)| */
        }
    
/*!*     y = fabs(x); *!*/
        y = java.lang.Math.abs(x);
    
        if (y <= 10) {
/*!* 	return log(fabs(gammafn(x))); *!*/
    	return java.lang.Math.log(java.lang.Math.abs(gammafn(x)));
        }
        else { /* y = |x| > 10  */
    
    	if (y > xmax) {
    	    throw new java.lang.ArithmeticException("Math Error: RANGE");
	    //    	    return Double.POSITIVE_INFINITY;
    	}
    
    	if (x > 0)
/*!* 	  return DistLib_h.M_LN_SQRT_2PI + (x - 0.5) * log(x) - x + lgammacor(y); *!*/
    	  return DistLib_h.M_LN_SQRT_2PI + (x - 0.5) * java.lang.Math.log(x) - x + lgammacor(y);
    
    	/* else: x < -10 */
/*!* 	sinpiy = fabs(sin(DistLib_h.M_PI * y)); *!*/
    	sinpiy = java.lang.Math.abs(java.lang.Math.sin(DistLib_h.M_PI * y));
    
    	if (sinpiy == 0) { /* Negative integer argument ===
    			      Now UNNECESSARY: caught above */
    	    System.out.println(" ** should NEVER happen! *** [lgamma.c: Neg.int+ y=%g]\n"+y);
    	    throw new java.lang.ArithmeticException("Math Error: DOMAIN");
	    //    	    return Double.NaN;
    	}
    
/*!* 	ans = DistLib_h.M_LN_SQRT_PId2 + (x - 0.5) * log(y) - x *!*/
    	ans = DistLib_h.M_LN_SQRT_PId2 + (x - 0.5) * java.lang.Math.log(y) - x
/*!* 	      - log(sinpiy) - lgammacor(y); *!*/
    	      - java.lang.Math.log(sinpiy) - lgammacor(y);
    
/*!* 	if(fabs((x - (int)(x - 0.5)) * ans / x) < dxrel) { *!*/
    	if(java.lang.Math.abs((x - (int)(x - 0.5)) * ans / x) < dxrel) {
    
    	    /* The answer is less than half precision because */
    	    /* the argument is too near a negative integer. */
    
    	    throw new java.lang.ArithmeticException("Math Error: PRECISION");
    	}
    
    	if (x > 0)
    	  return ans;
    	else if (((int)(-x))%2 == 0)
    	  signgam = -1;
    	return ans;
        }
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double lgammacor(double x);
     *
     *  DESCRIPTION
     *
     *    Compute the log gamma correction factor for x >= 10 so that
     *
     *    log(gamma(x)) = log(sqrt(2*pi))+(x-.5)*log(x)-x+lgammacor(x)
     *
     *  NOTES
     *
     *    This routine is a translation into C of a Fortran subroutine
     *    written by W. Fullerton of Los Alamos Scientific Laboratory.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  lgammacor(double x)
    {
        final  double algmcs[] /*[15]*/ = { 
    	+.1666389480451863247205729650822e+0,
    	-.1384948176067563840732986059135e-4,
    	+.9810825646924729426157171547487e-8,
    	-.1809129475572494194263306266719e-10,
    	+.6221098041892605227126015543416e-13,
    	-.3399615005417721944303330599666e-15,
    	+.2683181998482698748957538846666e-17,
    	-.2868042435334643284144622399999e-19,
    	+.3962837061046434803679306666666e-21,
    	-.6831888753985766870111999999999e-23,
    	+.1429227355942498147573333333333e-24,
    	-.3547598158101070547199999999999e-26,
    	+.1025680058010470912000000000000e-27,
    	-.3401102254316748799999999999999e-29,
    	+.1276642195630062933333333333333e-30
        };
        int nalgm = 0;
        double xbig = 0;
        double xmax = 0;
        double tmp;
    
        if (nalgm == 0) {
    	nalgm = chebyshev_init(algmcs, 15, d1mach(3));
/*!* 	xbig = 1 / sqrt(d1mach(3)); *!*/
    	xbig = 1 / java.lang.Math.sqrt(d1mach(3));
/*!* 	xmax = exp(fmin2(log(d1mach(2) / 12), -log(12 * d1mach(1)))); *!*/
    	xmax = java.lang.Math.exp(fmin2(java.lang.Math.log(d1mach(2) / 12), -java.lang.Math.log(12 * d1mach(1))));
        }
    
        if (x < 10) {
            throw new java.lang.ArithmeticException("Math Error: DOMAIN");
	    //            return Double.NaN;
        }
        else if (x >= xmax) {
            throw new java.lang.ArithmeticException("Math Error: UNDERFLOW");
	    //            return (Double.MIN_VALUE * Double.MIN_VALUE);
        }
        else if (x < xbig) {
            tmp = 10 / x;
            return chebyshev_eval(tmp * tmp * 2 - 1, algmcs, nalgm) / x;
        }
        else return 1 / (x * 12);
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double dlnrel(double x);
     *
     *  DESCRIPTION
     *
     *    Compute the relative error logarithm.
     *
     *                      log(1 + x)
     *
     *  NOTES
     *
     *    This code is a translation of a Fortran subroutine of the
     *    same name written by W. Fullerton of Los Alamos Scientific
     *    Laboratory.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  logrelerr(double x)
    {
        /* series for alnr on the interval -3.75000e-01 to  3.75000e-01 */
        /*                               with weighted error   6.35e-32 */
        /*                                log weighted error  31.20     */
        /*                      significant figures required  30.93     */
        /*                           decimal places required  32.01     */
        final  double alnrcs[] /*[43]*/ = {
    	+.10378693562743769800686267719098e+1,
    	-.13364301504908918098766041553133e+0,
    	+.19408249135520563357926199374750e-1,
    	-.30107551127535777690376537776592e-2,
    	+.48694614797154850090456366509137e-3,
    	-.81054881893175356066809943008622e-4,
    	+.13778847799559524782938251496059e-4,
    	-.23802210894358970251369992914935e-5,
    	+.41640416213865183476391859901989e-6,
    	-.73595828378075994984266837031998e-7,
    	+.13117611876241674949152294345011e-7,
    	-.23546709317742425136696092330175e-8,
    	+.42522773276034997775638052962567e-9,
    	-.77190894134840796826108107493300e-10,
    	+.14075746481359069909215356472191e-10,
    	-.25769072058024680627537078627584e-11,
    	+.47342406666294421849154395005938e-12,
    	-.87249012674742641745301263292675e-13,
    	+.16124614902740551465739833119115e-13,
    	-.29875652015665773006710792416815e-14,
    	+.55480701209082887983041321697279e-15,
    	-.10324619158271569595141333961932e-15,
    	+.19250239203049851177878503244868e-16,
    	-.35955073465265150011189707844266e-17,
    	+.67264542537876857892194574226773e-18,
    	-.12602624168735219252082425637546e-18,
    	+.23644884408606210044916158955519e-19,
    	-.44419377050807936898878389179733e-20,
    	+.83546594464034259016241293994666e-21,
    	-.15731559416479562574899253521066e-21,
    	+.29653128740247422686154369706666e-22,
    	-.55949583481815947292156013226666e-23,
    	+.10566354268835681048187284138666e-23,
    	-.19972483680670204548314999466666e-24,
    	+.37782977818839361421049855999999e-25,
    	-.71531586889081740345038165333333e-26,
    	+.13552488463674213646502024533333e-26,
    	-.25694673048487567430079829333333e-27,
    	+.48747756066216949076459519999999e-28,
    	-.92542112530849715321132373333333e-29,
    	+.17578597841760239233269760000000e-29,
    	-.33410026677731010351377066666666e-30,
    	+.63533936180236187354180266666666e-31,
        };
        int nlnrel = 0;
        double xmin = 0.;
    
        if (nlnrel == 0) {
            nlnrel = chebyshev_init(alnrcs, 43, 0.1 * d1mach(3));
/*!*         xmin = -1.0 + sqrt(d1mach(4)); *!*/
            xmin = -1.0 + java.lang.Math.sqrt(d1mach(4));
        }
    
        if (x <= -1) {
    	throw new java.lang.ArithmeticException("Math Error: DOMAIN");
	//    	return Double.NaN;
        }
    
        if (x < xmin) {
    	/* answer less than half precision because x too near -1 */
    	throw new java.lang.ArithmeticException("Math Error: PRECISION");
        }
    
/*!*     if (fabs(x) <= .375) *!*/
        if (java.lang.Math.abs(x) <= .375)
    	return x * (1 - x * chebyshev_eval(x / .375, alnrcs, nlnrel));
        else
/*!* 	return log(x + 1); *!*/
    	return java.lang.Math.log(x + 1);
    }
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    /*!* #ifdef IEEE_754 /*4!*/
    /* These are used in IEEE exception handling */
    static double m_zero = 0;
    static double m_one = 1;
    static double m_tiny = Double.MIN_VALUE;
    /*!* #endif /*4!*/
    
    /*!* #ifndef IEEE_754 /*4!*/
    
      /*
    void ml_error(int n)
    {
        switch(n) {
    
        case "Math Error: NONE":
    	(!!!!fixme!!!!) = 0;
    	break;
    
        case "Math Error: DOMAIN":
        case "Math Error: NOCONV":
    	(!!!!fixme!!!!) = EDOM;
    	break;
    
        case "Math Error: RANGE":
    	(!!!!fixme!!!!) = ERANGE;
    	break;
    
        default:
    	break;
        }
    }
    
      */
    /*!* #endif /*4!*/
    /*
     *  DistLib : A C Library of Special Functions
     *  Copyright (C) 1998 Ross Ihaka
     *
     *  This program is free software; you can redistribute it and/or modify
     *  it under the terms of the GNU General Public License as published by
     *  the Free Software Foundation; either version 2 of the License, or
     *  (at your option) any later version.
     *
     *  This program is distributed in the hope that it will be useful,
     *  but WITHOUT ANY WARRANTY; without even the implied warranty of
     *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     *  GNU General Public License for more details.
     *
     *  You should have received a copy of the GNU General Public License
     *  along with this program; if not, write to the Free Software
     *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     *
     *  SYNOPSIS
     *
     *    #include "DistLib.h"
     *    double sign(double x);
     *
     *  DESCRIPTION
     *
     *    This function computes the  'signum(.)' function:
     *
     *    	sign(x) =  1  if x > 0
     *    	sign(x) =  0  if x == 0
     *    	sign(x) = -1  if x < 0
     */
    
    /*!* #include "DistLib.h" /*4!*/
    
    public static double  sign(double x)
    {
    /*!* #ifdef IEEE_754 /*4!*/
        if (Double.isNaN(x))
    	return x;
    /*!* #endif /*4!*/
        return ((x > 0) ? 1 : ((x == 0)? 0 : -1));
    }
  }
