package SBEAMS::ProteinStructure::Tables;

###############################################################################
# Program     : SBEAMS::ProteinStructure::Tables
# Author      : Eric Deutsch <edeutsch@systemsbiology.org>
# $Id: Tables.pm 3256 2005-03-21 20:44:11Z lmendoza $
#
# Description : This is part of the SBEAMS::ProteinStructure module which provides
#               a level of abstraction to the database tables.
#
###############################################################################


use strict;

use SBEAMS::Connection::Settings;


use vars qw(@ISA @EXPORT 
    $TB_ORGANISM
    $TBBL_POLYMER_TYPE

    $TBPS_BIOSEQUENCE_SET
    $TBPS_DBXREF
    $TBPS_BIOSEQUENCE
    $TBPS_BIOSEQUENCE_PROPERTY_SET
    $TBPS_QUERY_OPTION

    $TBPS_DOMAIN_MATCH
    $TBPS_DOMAIN_MATCH_TYPE
    $TBPS_DOMAIN_MATCH_SOURCE

    $TBPS_DOMAIN
    $TBPS_BIOSEQUENCE_ANNOTATION
);


require Exporter;
@ISA = qw (Exporter);

@EXPORT = qw (
    $TB_ORGANISM
    $TBBL_POLYMER_TYPE

    $TBPS_BIOSEQUENCE_SET
    $TBPS_DBXREF
    $TBPS_BIOSEQUENCE
    $TBPS_BIOSEQUENCE_PROPERTY_SET
    $TBPS_QUERY_OPTION

    $TBPS_DOMAIN_MATCH
    $TBPS_DOMAIN_MATCH_TYPE
    $TBPS_DOMAIN_MATCH_SOURCE

    $TBPS_DOMAIN
    $TBPS_BIOSEQUENCE_ANNOTATION

);


#### Get the appropriate database prefixes for the SBEAMS core and this module
my $core = $DBPREFIX{Core};
my $mod = $DBPREFIX{ProteinStructure};
my $BioLink = $DBPREFIX{BioLink};

$TB_ORGANISM                      = "${core}organism";
$TBBL_POLYMER_TYPE                = "${BioLink}polymer_type";

$TBPS_BIOSEQUENCE_SET             = "${mod}biosequence_set";
$TBPS_DBXREF                      = "${mod}dbxref";
$TBPS_BIOSEQUENCE                 = "${mod}biosequence";
$TBPS_BIOSEQUENCE_PROPERTY_SET    = "${mod}biosequence_property_set";
$TBPS_QUERY_OPTION                = "${mod}query_option";

$TBPS_DOMAIN_MATCH                = "${mod}domain_match";
$TBPS_DOMAIN_MATCH_TYPE           = "${mod}domain_match_type";
$TBPS_DOMAIN_MATCH_SOURCE         = "${mod}domain_match_source";

$TBPS_DOMAIN                      = "${mod}domain";
$TBPS_BIOSEQUENCE_ANNOTATION      = "${mod}biosequence_annotation";

