/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.unitTests;

import csplugins.isb.pshannon.experiment.ExperimentRepository;
import csplugins.isb.pshannon.experiment.ExperimentRepositoryFactory;
import csplugins.isb.pshannon.experiment.datamatrix.DataMatrix;
import csplugins.isb.pshannon.experiment.metadata.Condition;
import csplugins.isb.pshannon.experiment.metadata.DataSetDescription;
import csplugins.isb.pshannon.experiment.metadata.MetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ExperimentRepositoryTest
extends TestCase {
    static /* synthetic */ Class class$csplugins$isb$pshannon$experiment$unitTests$ExperimentRepositoryTest;

    public void testFileRepository() throws Exception {
        System.out.println("testFileRepository");
        String string2 = "../sampleData";
        ExperimentRepository experimentRepository = ExperimentRepositoryFactory.create(string2);
        ExperimentRepositoryTest.assertTrue((boolean)experimentRepository.getProtocol().equals("file"));
        ExperimentRepositoryTest.assertTrue((boolean)experimentRepository.getPath().equals("../sampleData"));
        ExperimentRepositoryTest.assertTrue((boolean)experimentRepository.getUri().equals(string2));
        ExperimentRepositoryTest.assertTrue((boolean)this.validRepository(experimentRepository));
    }

    public void notestWebDirectRepository() throws Exception {
        System.out.println("testWebDirectRepository");
        String string2 = "http://db:8060/halo/data/unitTests";
        ExperimentRepository experimentRepository = ExperimentRepositoryFactory.create(string2);
        ExperimentRepositoryTest.assertTrue((boolean)experimentRepository.getProtocol().equals("http"));
        ExperimentRepositoryTest.assertTrue((boolean)experimentRepository.getPath().equals("db:8060/halo/data/unitTests"));
        ExperimentRepositoryTest.assertTrue((boolean)experimentRepository.getUri().equals(string2));
        ExperimentRepositoryTest.assertTrue((boolean)this.validRepository(experimentRepository));
    }

    public void notestWebIndirectRepositoryWithUserPasswordFromPropsFile() throws Exception {
        System.out.println("testWebIndirectRepositoryWithUserPasswordFromPropsFile");
        String string2 = "httpIndirect://db.systemsbiology.net:8080/halo/DataFetcher.py";
        ExperimentRepository experimentRepository = ExperimentRepositoryFactory.create(string2);
        ExperimentRepositoryTest.assertTrue((boolean)experimentRepository.getProtocol().equals("httpIndirect"));
        ExperimentRepositoryTest.assertTrue((boolean)this.validRepository(experimentRepository));
    }

    public void notestWebIndirectRepositoryWithExplicitIncorrectPassword() throws Exception {
        System.out.println("testWebIndirectRepositoryWithExplicitIncorrectPassword");
        String string2 = "httpIndirect://db.systemsbiology.net:8080/halo/DataFetcher.py";
        ExperimentRepository experimentRepository = ExperimentRepositoryFactory.create(string2, "tester0", "bogus");
        ExperimentRepositoryTest.assertTrue((boolean)experimentRepository.getProtocol().equals("httpIndirect"));
        String[] stringArray = experimentRepository.getExperimentNames();
        ExperimentRepositoryTest.assertTrue((stringArray.length == 0 ? 1 : 0) != 0);
    }

    public void testWebIndirectRepositoryWithExplicitUserPassword() throws Exception {
        System.out.println("testWebIndirectRepositoryWithExplicitUserPassword");
        String string2 = "httpIndirect://db.systemsbiology.net:8080/halo/DataFetcher.py";
        boolean bl = false;
        ExperimentRepository experimentRepository = ExperimentRepositoryFactory.create(string2, "tester0", "pw0", bl);
        ExperimentRepositoryTest.assertTrue((boolean)experimentRepository.getProtocol().equals("httpIndirect"));
        ExperimentRepositoryTest.assertTrue((boolean)this.validRepository(experimentRepository));
    }

    private boolean validRepository(ExperimentRepository experimentRepository) throws Exception {
        Object[] objectArray = experimentRepository.getExperimentNames();
        Arrays.sort(objectArray);
        ExperimentRepositoryTest.assertTrue((objectArray.length > 0 ? 1 : 0) != 0);
        ExperimentRepositoryTest.assertTrue((Arrays.binarySearch(objectArray, "sample.xml") >= 0 ? 1 : 0) != 0);
        MetaData metaData = experimentRepository.getMetaData("sample.xml");
        ExperimentRepositoryTest.assertTrue((boolean)this.sampleMetaDataHasExpectedContents(metaData));
        DataSetDescription[] dataSetDescriptionArray = metaData.getDataSetDescriptions();
        ExperimentRepositoryTest.assertTrue((boolean)this.sampleMatricesHaveExpectedContents(experimentRepository, dataSetDescriptionArray));
        ExperimentRepositoryTest.assertTrue((dataSetDescriptionArray.length == 2 ? 1 : 0) != 0);
        return true;
    }

    private boolean sampleMatricesHaveExpectedContents(ExperimentRepository experimentRepository, DataSetDescription[] dataSetDescriptionArray) throws Exception {
        for (int i = 0; i < dataSetDescriptionArray.length; ++i) {
            DataMatrix dataMatrix = experimentRepository.getDataSet(dataSetDescriptionArray[i]);
            ExperimentRepositoryTest.assertTrue((dataMatrix.getRowCount() == 2400 ? 1 : 0) != 0);
            ExperimentRepositoryTest.assertTrue((dataMatrix.getColumnCount() == 16 ? 1 : 0) != 0);
        }
        return true;
    }

    private boolean sampleMetaDataHasExpectedContents(MetaData metaData) {
        ExperimentRepositoryTest.assertTrue((boolean)metaData.getTitle().equals("gamma"));
        ExperimentRepositoryTest.assertTrue((boolean)metaData.getDate().equals("2004-02-01"));
        HashMap hashMap = metaData.getPredicates();
        ExperimentRepositoryTest.assertTrue((boolean)hashMap.get("species").equals("Halobacterium NRC-1"));
        ExperimentRepositoryTest.assertTrue((boolean)hashMap.get("strain").equals("wild type"));
        ExperimentRepositoryTest.assertTrue((boolean)hashMap.get("manipulationType").equals("environmental"));
        ExperimentRepositoryTest.assertTrue((boolean)hashMap.get("manipulatedVariable").equals("gamma irradiation"));
        DataSetDescription[] dataSetDescriptionArray = metaData.getDataSetDescriptions();
        ExperimentRepositoryTest.assertTrue((dataSetDescriptionArray.length == 2 ? 1 : 0) != 0);
        String string2 = dataSetDescriptionArray[0].getUri();
        ExperimentRepositoryTest.assertTrue((boolean)string2.endsWith("sample.ratio"));
        ExperimentRepositoryTest.assertTrue((boolean)dataSetDescriptionArray[0].getStatus().equals("primary"));
        ExperimentRepositoryTest.assertTrue((boolean)dataSetDescriptionArray[0].getType().equals("log10 ratios"));
        string2 = dataSetDescriptionArray[1].getUri();
        ExperimentRepositoryTest.assertTrue((boolean)string2.endsWith("sample.lambda"));
        ExperimentRepositoryTest.assertTrue((boolean)dataSetDescriptionArray[1].getStatus().equals("derived"));
        ExperimentRepositoryTest.assertTrue((boolean)dataSetDescriptionArray[1].getType().equals("lambdas"));
        HashMap hashMap2 = metaData.getVariableSummary();
        Object[] objectArray = hashMap2.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        ExperimentRepositoryTest.assertTrue((boolean)Arrays.equals(objectArray, new String[]{"gamma irradiation", "time"}));
        HashMap hashMap3 = (HashMap)hashMap2.get("gamma irradiation");
        HashMap hashMap4 = (HashMap)hashMap2.get("time");
        objectArray = hashMap3.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        ExperimentRepositoryTest.assertTrue((boolean)Arrays.equals(objectArray, new String[]{"false", "true"}));
        ExperimentRepositoryTest.assertTrue((hashMap3.get("false") == null ? 1 : 0) != 0);
        objectArray = hashMap4.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        ExperimentRepositoryTest.assertTrue((boolean)Arrays.equals(objectArray, new String[]{"0", "10", "240", "30", "60"}));
        ExperimentRepositoryTest.assertTrue((boolean)((String)hashMap4.get("0")).equals("minutes"));
        Condition[] conditionArray = metaData.getConditions();
        ExperimentRepositoryTest.assertTrue((conditionArray.length == 10 ? 1 : 0) != 0);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < conditionArray.length; ++i) {
            arrayList.add(conditionArray[i].getAlias());
        }
        Object[] objectArray2 = arrayList.toArray(new String[0]);
        Arrays.sort(objectArray2);
        Object[] objectArray3 = new String[]{"C0", "C10", "C240", "C30", "C60", "G0", "G10", "G240", "G30", "G60"};
        Arrays.sort(objectArray3);
        ExperimentRepositoryTest.assertTrue((boolean)Arrays.equals(objectArray2, objectArray3));
        return true;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(class$csplugins$isb$pshannon$experiment$unitTests$ExperimentRepositoryTest == null ? (class$csplugins$isb$pshannon$experiment$unitTests$ExperimentRepositoryTest = ExperimentRepositoryTest.class$("csplugins.isb.pshannon.experiment.unitTests.ExperimentRepositoryTest")) : class$csplugins$isb$pshannon$experiment$unitTests$ExperimentRepositoryTest));
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

