/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.readers.unitTests;

import csplugins.isb.pshannon.experiment.metadata.Condition;
import csplugins.isb.pshannon.experiment.metadata.DataSetDescription;
import csplugins.isb.pshannon.experiment.metadata.MetaData;
import csplugins.isb.pshannon.experiment.readers.MetaDataXmlParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class MetaDataXmlParserTest
extends TestCase {
    static /* synthetic */ Class class$csplugins$isb$pshannon$experiment$readers$unitTests$MetaDataXmlParserTest;

    public void testCtor() throws Exception {
        System.out.println("testCtor");
        String string2 = "file://../../sampleData/zinc.xml";
        MetaDataXmlParser metaDataXmlParser = new MetaDataXmlParser(string2);
    }

    public void testLocalXmlFile() throws Exception {
        System.out.println("testLocalXmlFile");
        String string2 = "file://../../sampleData/sample.xml";
        MetaDataXmlParser metaDataXmlParser = new MetaDataXmlParser(string2);
        MetaData metaData = metaDataXmlParser.getMetaData();
        MetaDataXmlParserTest.assertTrue((boolean)this.hasExpectedContents(metaData));
    }

    public void testHttpDirectXmlFile() throws Exception {
        System.out.println("testHttpDirectXmlFile");
        String string2 = "http://db.systemsbiology.net:8060/halo/data/unitTests/sample.xml";
        MetaDataXmlParser metaDataXmlParser = new MetaDataXmlParser(string2);
        MetaData metaData = metaDataXmlParser.getMetaData();
        MetaDataXmlParserTest.assertTrue((boolean)this.hasExpectedContents(metaData));
    }

    public void testHttpIndirectXmlFile() throws Exception {
        System.out.println("testHttpIndirectXmlFile");
        String string2 = "httpIndirect://db.systemsbiology.net:8080/halo/DataFetcher.py";
        String string3 = "sample.xml";
        String string4 = string2 + "/" + string3;
        MetaDataXmlParser metaDataXmlParser = new MetaDataXmlParser(string4);
        MetaData metaData = metaDataXmlParser.getMetaData();
        MetaDataXmlParserTest.assertTrue((boolean)this.hasExpectedContents(metaData));
    }

    private boolean hasExpectedContents(MetaData metaData) {
        MetaDataXmlParserTest.assertTrue((boolean)metaData.getTitle().equals("gamma"));
        MetaDataXmlParserTest.assertTrue((boolean)metaData.getDate().equals("2004-02-01"));
        HashMap hashMap = metaData.getPredicates();
        MetaDataXmlParserTest.assertTrue((boolean)hashMap.get("species").equals("Halobacterium NRC-1"));
        MetaDataXmlParserTest.assertTrue((boolean)hashMap.get("strain").equals("wild type"));
        MetaDataXmlParserTest.assertTrue((boolean)hashMap.get("manipulationType").equals("environmental"));
        MetaDataXmlParserTest.assertTrue((boolean)hashMap.get("manipulatedVariable").equals("gamma irradiation"));
        DataSetDescription[] dataSetDescriptionArray = metaData.getDataSetDescriptions();
        MetaDataXmlParserTest.assertTrue((dataSetDescriptionArray.length == 2 ? 1 : 0) != 0);
        String string2 = dataSetDescriptionArray[0].getUri();
        MetaDataXmlParserTest.assertTrue((string2.indexOf("sample.ratio") > 0 ? 1 : 0) != 0);
        MetaDataXmlParserTest.assertTrue((boolean)dataSetDescriptionArray[0].getStatus().equals("primary"));
        MetaDataXmlParserTest.assertTrue((boolean)dataSetDescriptionArray[0].getType().equals("log10 ratios"));
        String string3 = "file://../sampleData/sample.lambda";
        string2 = dataSetDescriptionArray[1].getUri();
        MetaDataXmlParserTest.assertTrue((string2.indexOf("sample.lambda") > 0 ? 1 : 0) != 0);
        MetaDataXmlParserTest.assertTrue((boolean)dataSetDescriptionArray[1].getStatus().equals("derived"));
        MetaDataXmlParserTest.assertTrue((boolean)dataSetDescriptionArray[1].getType().equals("lambdas"));
        HashMap hashMap2 = metaData.getVariableSummary();
        Object[] objectArray = hashMap2.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        MetaDataXmlParserTest.assertTrue((boolean)Arrays.equals(objectArray, new String[]{"gamma irradiation", "time"}));
        HashMap hashMap3 = (HashMap)hashMap2.get("gamma irradiation");
        HashMap hashMap4 = (HashMap)hashMap2.get("time");
        objectArray = hashMap3.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        MetaDataXmlParserTest.assertTrue((boolean)Arrays.equals(objectArray, new String[]{"false", "true"}));
        MetaDataXmlParserTest.assertTrue((hashMap3.get("false") == null ? 1 : 0) != 0);
        objectArray = hashMap4.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        MetaDataXmlParserTest.assertTrue((boolean)Arrays.equals(objectArray, new String[]{"0", "10", "240", "30", "60"}));
        MetaDataXmlParserTest.assertTrue((boolean)((String)hashMap4.get("0")).equals("minutes"));
        Condition[] conditionArray = metaData.getConditions();
        MetaDataXmlParserTest.assertTrue((conditionArray.length == 10 ? 1 : 0) != 0);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < conditionArray.length; ++i) {
            arrayList.add(conditionArray[i].getAlias());
        }
        Object[] objectArray2 = arrayList.toArray(new String[0]);
        Arrays.sort(objectArray2);
        Object[] objectArray3 = new String[]{"C0", "C10", "C240", "C30", "C60", "G0", "G10", "G240", "G30", "G60"};
        Arrays.sort(objectArray3);
        MetaDataXmlParserTest.assertTrue((boolean)Arrays.equals(objectArray2, objectArray3));
        return true;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(class$csplugins$isb$pshannon$experiment$readers$unitTests$MetaDataXmlParserTest == null ? (class$csplugins$isb$pshannon$experiment$readers$unitTests$MetaDataXmlParserTest = MetaDataXmlParserTest.class$("csplugins.isb.pshannon.experiment.readers.unitTests.MetaDataXmlParserTest")) : class$csplugins$isb$pshannon$experiment$readers$unitTests$MetaDataXmlParserTest));
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

