/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.readers;

import csplugins.isb.pshannon.experiment.metadata.Condition;
import csplugins.isb.pshannon.experiment.metadata.DataSetDescription;
import csplugins.isb.pshannon.experiment.metadata.MetaData;
import csplugins.isb.pshannon.experiment.metadata.Variable;
import csplugins.isb.pshannon.experiment.readers.TextHttpIndirectFileReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class MetaDataXmlParser {
    SAXBuilder builder = new SAXBuilder();
    Document doc;
    String documentSource = "unknown";
    MetaData metaData;

    public MetaDataXmlParser(String string2) throws Exception {
        boolean bl;
        boolean bl2 = bl = string2.indexOf("://") > 0;
        if (!bl || string2.startsWith("file://")) {
            String string3 = bl ? string2.substring(7) : string2;
            this.doc = this.builder.build((InputStream)new FileInputStream(string3));
            this.documentSource = "localFile";
        } else if (string2.startsWith("http://")) {
            this.doc = this.builder.build(string2);
            this.documentSource = "web";
        } else if (string2.startsWith("httpIndirect://")) {
            TextHttpIndirectFileReader textHttpIndirectFileReader = new TextHttpIndirectFileReader(string2);
            textHttpIndirectFileReader.read();
            String string4 = textHttpIndirectFileReader.getText();
            File file = File.createTempFile("gaggle", "xml");
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string4, 0, string4.length());
            fileWriter.close();
            this.doc = this.builder.build((InputStream)new FileInputStream(file.getAbsolutePath()));
            this.documentSource = "webIndirect";
            file.delete();
        } else {
            throw new IllegalArgumentException("unrecognized data source protocol in uri: " + string2);
        }
        this.parseDocument(this.doc);
    }

    protected void parseDocument(Document document) {
        Element element = document.getRootElement();
        String string2 = element.getAttribute("name").getValue();
        String string3 = element.getAttribute("date").getValue();
        this.metaData = new MetaData(string2, string3);
        this.metaData.setPredicates(this.parsePredicates(element));
        this.metaData.setDataSetDescriptions(this.parseDataSetDescriptions(element));
        Condition[] conditionArray = this.parseConditions(element);
        for (int i = 0; i < conditionArray.length; ++i) {
            this.metaData.addCondition(conditionArray[i]);
        }
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    protected HashMap parsePredicates(Element element) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Element[] elementArray = element.getChildren("predicate").toArray(new Element[0]);
        for (int i = 0; i < elementArray.length; ++i) {
            Element element2 = elementArray[i];
            String string2 = element2.getAttribute("category").getValue();
            String string3 = element2.getAttribute("value").getValue();
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    protected ArrayList parseDataSetDescriptions(Element element) {
        ArrayList<DataSetDescription> arrayList = new ArrayList<DataSetDescription>();
        Element[] elementArray = element.getChildren("dataset").toArray(new Element[0]);
        for (int i = 0; i < elementArray.length; ++i) {
            Element element2 = elementArray[i];
            String string2 = element2.getAttribute("status").getValue();
            String string3 = element2.getAttribute("type").getValue();
            String string4 = element2.getChild("uri").getTextTrim();
            DataSetDescription dataSetDescription = new DataSetDescription(string4, string2, string3);
            arrayList.add(dataSetDescription);
        }
        return arrayList;
    }

    protected Condition[] parseConditions(Element element) {
        Element[] elementArray = element.getChildren("condition").toArray(new Element[0]);
        ArrayList<Condition> arrayList = new ArrayList<Condition>();
        for (int i = 0; i < elementArray.length; ++i) {
            Element element2 = elementArray[i];
            String string2 = element2.getAttribute("alias").getValue();
            Condition condition = new Condition(string2);
            Element[] elementArray2 = element2.getChildren("variable").toArray(new Element[0]);
            for (int j = 0; j < elementArray2.length; ++j) {
                Element element3 = elementArray2[j];
                String string3 = element3.getAttribute("name").getValue();
                String string4 = element3.getAttribute("value").getValue();
                Attribute attribute = element3.getAttribute("units");
                String string5 = null;
                if (attribute != null) {
                    string5 = attribute.getValue();
                }
                condition.addVariable(new Variable(string3, string4, string5));
            }
            arrayList.add(condition);
        }
        return arrayList.toArray(new Condition[0]);
    }
}

