/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.metadata.unitTests;

import csplugins.isb.pshannon.experiment.metadata.Condition;
import csplugins.isb.pshannon.experiment.metadata.DataSetDescription;
import csplugins.isb.pshannon.experiment.metadata.MetaData;
import csplugins.isb.pshannon.experiment.metadata.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class MetaDataTest
extends TestCase {
    private HashMap createExperimentPredicates() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("species", "Halobacterium NRC-1");
        hashMap.put("strain", "wild type");
        hashMap.put("manipulation", "environmental");
        return hashMap;
    }

    private MetaData createMetaDataTestObject() {
        String string2 = "gamma";
        String string3 = "2004-02-01";
        MetaData metaData = new MetaData(string2, string3);
        metaData.setPredicates(this.createExperimentPredicates());
        ArrayList<DataSetDescription> arrayList = new ArrayList<DataSetDescription>();
        String string4 = "/users/pshannon/data/halo/microarrayXml/unitTests/gamma.ratio";
        String string5 = "primary";
        String string6 = "log10 ratios";
        DataSetDescription dataSetDescription = new DataSetDescription(string4, string5, string6);
        arrayList.add(dataSetDescription);
        string4 = "/users/pshannon/data/halo/microarrayXml/unitTests/gamma.lambda";
        string5 = "derived";
        string6 = "lambdas";
        DataSetDescription dataSetDescription2 = new DataSetDescription(string4, string5, string6);
        arrayList.add(dataSetDescription2);
        metaData.setDataSetDescriptions(arrayList);
        Condition condition = new Condition("C0");
        condition.addVariable(new Variable("gamma irradiation", "false"));
        condition.addVariable(new Variable("time", "0", "minutes"));
        metaData.addCondition(condition);
        Condition condition2 = new Condition("C10");
        condition2.addVariable(new Variable("gamma irradiation", "false"));
        condition2.addVariable(new Variable("time", "10", "minutes"));
        metaData.addCondition(condition2);
        Condition condition3 = new Condition("C20");
        condition3.addVariable(new Variable("gamma irradiation", "false"));
        condition3.addVariable(new Variable("time", "20", "minutes"));
        metaData.addCondition(condition3);
        Condition condition4 = new Condition("G0");
        condition4.addVariable(new Variable("gamma irradiation", "true"));
        condition4.addVariable(new Variable("time", "0", "minutes"));
        metaData.addCondition(condition4);
        Condition condition5 = new Condition("G10");
        condition5.addVariable(new Variable("gamma irradiation", "true"));
        condition5.addVariable(new Variable("time", "10", "minutes"));
        metaData.addCondition(condition5);
        Condition condition6 = new Condition("G20");
        condition6.addVariable(new Variable("gamma irradiation", "true"));
        condition6.addVariable(new Variable("time", "20", "minutes"));
        metaData.addCondition(condition6);
        return metaData;
    }

    public void testHighLevelContents() throws Exception {
        System.out.println("testHighLevelContents");
        MetaData metaData = this.createMetaDataTestObject();
        MetaDataTest.assertTrue((boolean)metaData.getTitle().equals("gamma"));
        MetaDataTest.assertTrue((boolean)metaData.getDate().equals("2004-02-01"));
        MetaDataTest.assertTrue((metaData.getPredicates().size() == 3 ? 1 : 0) != 0);
        MetaDataTest.assertTrue((metaData.getDataSetDescriptions().length == 2 ? 1 : 0) != 0);
        MetaDataTest.assertTrue((metaData.getConditions().length == 6 ? 1 : 0) != 0);
    }

    public void testPredicates() throws Exception {
        System.out.println("testPredicates");
        MetaData metaData = this.createMetaDataTestObject();
        HashMap hashMap = metaData.getPredicates();
        Object[] objectArray = metaData.getPredicateNamesSorted();
        Object[] objectArray2 = new String[]{"manipulation", "species", "strain"};
        MetaDataTest.assertTrue((boolean)Arrays.equals(objectArray, objectArray2));
        MetaDataTest.assertTrue((boolean)metaData.getPredicate("species").equals("Halobacterium NRC-1"));
        MetaDataTest.assertTrue((boolean)metaData.getPredicate("strain").equals("wild type"));
        MetaDataTest.assertTrue((boolean)metaData.getPredicate("manipulation").equals("environmental"));
    }

    public void testDataSetDescriptions() throws Exception {
        System.out.println("testDataSetDescriptions");
        MetaData metaData = this.createMetaDataTestObject();
        DataSetDescription[] dataSetDescriptionArray = metaData.getDataSetDescriptions();
        MetaDataTest.assertTrue((dataSetDescriptionArray.length == 2 ? 1 : 0) != 0);
        MetaDataTest.assertTrue((boolean)dataSetDescriptionArray[0].getUri().equals("/users/pshannon/data/halo/microarrayXml/unitTests/gamma.ratio"));
        MetaDataTest.assertTrue((boolean)dataSetDescriptionArray[0].getStatus().equals("primary"));
        MetaDataTest.assertTrue((boolean)dataSetDescriptionArray[0].getType().equals("log10 ratios"));
        MetaDataTest.assertTrue((boolean)dataSetDescriptionArray[1].getUri().equals("/users/pshannon/data/halo/microarrayXml/unitTests/gamma.lambda"));
        MetaDataTest.assertTrue((boolean)dataSetDescriptionArray[1].getStatus().equals("derived"));
        MetaDataTest.assertTrue((boolean)dataSetDescriptionArray[1].getType().equals("lambdas"));
    }

    public void testConditions() throws Exception {
        System.out.println("testConditions");
        MetaData metaData = this.createMetaDataTestObject();
        Condition[] conditionArray = metaData.getConditions();
        MetaDataTest.assertTrue((conditionArray.length == 6 ? 1 : 0) != 0);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < conditionArray.length; ++i) {
            arrayList.add(conditionArray[i].getAlias());
        }
        Object[] objectArray = arrayList.toArray(new String[0]);
        Arrays.sort(objectArray);
        MetaDataTest.assertTrue((boolean)Arrays.equals(new String[]{"C0", "C10", "C20", "G0", "G10", "G20"}, objectArray));
        Object[] objectArray2 = metaData.getConditionAliases();
        Arrays.sort(objectArray2);
        MetaDataTest.assertTrue((boolean)Arrays.equals(objectArray, objectArray2));
    }

    public void testVariableSummary() throws Exception {
        System.out.println("testVariableSummary");
        MetaData metaData = this.createMetaDataTestObject();
        HashMap hashMap = metaData.getVariableSummary();
        Object[] objectArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        Object[] objectArray2 = new String[]{"gamma irradiation", "time"};
        MetaDataTest.assertTrue((boolean)Arrays.equals(objectArray, objectArray2));
    }

    public void testVariableAccess() throws Exception {
        System.out.println("testVariableAcess");
        MetaData metaData = this.createMetaDataTestObject();
        Object[] objectArray = metaData.getVariableNames();
        Object[] objectArray2 = new String[]{"gamma irradiation", "time"};
        Arrays.sort(objectArray);
        MetaDataTest.assertTrue((boolean)Arrays.equals(objectArray2, objectArray));
        Object[] objectArray3 = metaData.getSortedVariableValues("gamma irradiation");
        objectArray2 = new String[]{"false", "true"};
        MetaDataTest.assertTrue((boolean)Arrays.equals(objectArray3, objectArray2));
        Object[] objectArray4 = metaData.getSortedVariableValues("time");
        objectArray2 = new String[]{"0", "10", "20"};
        MetaDataTest.assertTrue((boolean)Arrays.equals(objectArray4, objectArray2));
        MetaDataTest.assertTrue((boolean)metaData.getUnits("time", "0").equals("minutes"));
        MetaDataTest.assertTrue((boolean)metaData.getUnits("time", "10").equals("minutes"));
        MetaDataTest.assertTrue((boolean)metaData.getUnits("time", "20").equals("minutes"));
        MetaDataTest.assertTrue((metaData.getUnits("gamma irradiation", "false") == null ? 1 : 0) != 0);
        MetaDataTest.assertTrue((metaData.getUnits("gamma irradiation", "true") == null ? 1 : 0) != 0);
    }

    public void testColumnSelected() throws Exception {
        System.out.println("testColumnSelection");
        MetaData metaData = this.createMetaDataTestObject();
        metaData.addSelectionCriterion("gamma irradiation", "true");
        Condition condition = new Condition("C0");
        condition.addVariable(new Variable("gamma irradiation", "false"));
        condition.addVariable(new Variable("time", "0", "minutes"));
        Condition condition2 = new Condition("C10");
        condition2.addVariable(new Variable("gamma irradiation", "false"));
        condition2.addVariable(new Variable("time", "10", "minutes"));
        Condition condition3 = new Condition("C20");
        condition3.addVariable(new Variable("gamma irradiation", "false"));
        condition3.addVariable(new Variable("time", "20", "minutes"));
        Condition condition4 = new Condition("G0");
        condition4.addVariable(new Variable("gamma irradiation", "true"));
        condition4.addVariable(new Variable("time", "0", "minutes"));
        Condition condition5 = new Condition("G10");
        condition5.addVariable(new Variable("gamma irradiation", "true"));
        condition5.addVariable(new Variable("time", "10", "minutes"));
        Condition condition6 = new Condition("G20");
        condition6.addVariable(new Variable("gamma irradiation", "true"));
        condition6.addVariable(new Variable("time", "20", "minutes"));
        MetaDataTest.assertTrue((boolean)metaData.columnSelected(condition4, metaData.getSelectionCriteria()));
        MetaDataTest.assertTrue((boolean)metaData.columnSelected(condition5, metaData.getSelectionCriteria()));
        MetaDataTest.assertTrue((boolean)metaData.columnSelected(condition6, metaData.getSelectionCriteria()));
        MetaDataTest.assertTrue((!metaData.columnSelected(condition, metaData.getSelectionCriteria()) ? 1 : 0) != 0);
        MetaDataTest.assertTrue((!metaData.columnSelected(condition2, metaData.getSelectionCriteria()) ? 1 : 0) != 0);
        MetaDataTest.assertTrue((!metaData.columnSelected(condition3, metaData.getSelectionCriteria()) ? 1 : 0) != 0);
        metaData.addSelectionCriterion("time", "10");
        MetaDataTest.assertTrue((boolean)metaData.columnSelected(condition5, metaData.getSelectionCriteria()));
        MetaDataTest.assertTrue((!metaData.columnSelected(condition4, metaData.getSelectionCriteria()) ? 1 : 0) != 0);
        MetaDataTest.assertTrue((!metaData.columnSelected(condition6, metaData.getSelectionCriteria()) ? 1 : 0) != 0);
        MetaDataTest.assertTrue((!metaData.columnSelected(condition, metaData.getSelectionCriteria()) ? 1 : 0) != 0);
        MetaDataTest.assertTrue((!metaData.columnSelected(condition2, metaData.getSelectionCriteria()) ? 1 : 0) != 0);
        MetaDataTest.assertTrue((!metaData.columnSelected(condition3, metaData.getSelectionCriteria()) ? 1 : 0) != 0);
        metaData.addSelectionCriterion("time", "0");
        MetaDataTest.assertTrue((boolean)metaData.columnSelected(condition4, metaData.getSelectionCriteria()));
        MetaDataTest.assertTrue((boolean)metaData.columnSelected(condition5, metaData.getSelectionCriteria()));
        MetaDataTest.assertTrue((!metaData.columnSelected(condition6, metaData.getSelectionCriteria()) ? 1 : 0) != 0);
        MetaDataTest.assertTrue((!metaData.columnSelected(condition, metaData.getSelectionCriteria()) ? 1 : 0) != 0);
        MetaDataTest.assertTrue((!metaData.columnSelected(condition2, metaData.getSelectionCriteria()) ? 1 : 0) != 0);
        MetaDataTest.assertTrue((!metaData.columnSelected(condition3, metaData.getSelectionCriteria()) ? 1 : 0) != 0);
        metaData.clearSelectionCriteria();
        metaData.addSelectionCriterion("time", "20");
        MetaDataTest.assertTrue((!metaData.columnSelected(condition4, metaData.getSelectionCriteria()) ? 1 : 0) != 0);
        MetaDataTest.assertTrue((!metaData.columnSelected(condition5, metaData.getSelectionCriteria()) ? 1 : 0) != 0);
        MetaDataTest.assertTrue((boolean)metaData.columnSelected(condition6, metaData.getSelectionCriteria()));
        MetaDataTest.assertTrue((!metaData.columnSelected(condition, metaData.getSelectionCriteria()) ? 1 : 0) != 0);
        MetaDataTest.assertTrue((!metaData.columnSelected(condition2, metaData.getSelectionCriteria()) ? 1 : 0) != 0);
        MetaDataTest.assertTrue((boolean)metaData.columnSelected(condition3, metaData.getSelectionCriteria()));
    }

    public void testSelection() throws Exception {
        System.out.println("testSelection");
        MetaData metaData = this.createMetaDataTestObject();
        MetaDataTest.assertTrue((metaData.getSelectedConditions().length == 0 ? 1 : 0) != 0);
        metaData.addSelectionCriterion("gamma irradiation", "true");
        MetaDataTest.assertTrue((boolean)Arrays.equals(metaData.getNamesOfSelectedVariables(), new String[]{"gamma irradiation"}));
        Object[] objectArray = metaData.getSelectedConditionsAsAliases();
        MetaDataTest.assertTrue((boolean)Arrays.equals(objectArray, new String[]{"G0", "G10", "G20"}));
        metaData.clearSelectionCriteria();
        metaData.addSelectionCriterion("gamma irradiation", "false");
        MetaDataTest.assertTrue((boolean)Arrays.equals(metaData.getNamesOfSelectedVariables(), new String[]{"gamma irradiation"}));
        objectArray = metaData.getSelectedConditionsAsAliases();
        MetaDataTest.assertTrue((boolean)Arrays.equals(objectArray, new String[]{"C0", "C10", "C20"}));
        metaData.clearSelectionCriteria();
        metaData.addSelectionCriterion("time", "10");
        MetaDataTest.assertTrue((boolean)Arrays.equals(metaData.getNamesOfSelectedVariables(), new String[]{"time"}));
        objectArray = metaData.getSelectedConditionsAsAliases();
        MetaDataTest.assertTrue((boolean)Arrays.equals(objectArray, new String[]{"C10", "G10"}));
        metaData.addSelectionCriterion("time", "20");
        MetaDataTest.assertTrue((boolean)Arrays.equals(metaData.getNamesOfSelectedVariables(), new String[]{"time"}));
        objectArray = metaData.getSelectedConditionsAsAliases();
        MetaDataTest.assertTrue((boolean)Arrays.equals(objectArray, new String[]{"C10", "C20", "G10", "G20"}));
        metaData.addSelectionCriterion("gamma irradiation", "true");
        String[] stringArray = metaData.getNamesOfSelectedVariables();
        MetaDataTest.assertTrue((boolean)Arrays.equals(metaData.getNamesOfSelectedVariables(), new String[]{"gamma irradiation", "time"}));
        objectArray = metaData.getSelectedConditionsAsAliases();
        MetaDataTest.assertTrue((boolean)Arrays.equals(objectArray, new String[]{"G10", "G20"}));
        metaData.clearSelectionCriteria();
        MetaDataTest.assertTrue((metaData.getSelectedConditions().length == 0 ? 1 : 0) != 0);
        MetaDataTest.assertTrue((boolean)Arrays.equals(metaData.getNamesOfSelectedVariables(), new String[0]));
        objectArray = metaData.getSelectedConditionsAsAliases();
        MetaDataTest.assertTrue((boolean)Arrays.equals(objectArray, new String[0]));
        metaData.selectAllConditions();
        objectArray = metaData.getSelectedConditionsAsAliases();
        MetaDataTest.assertTrue((boolean)Arrays.equals(objectArray, new String[]{"C0", "C10", "C20", "G0", "G10", "G20"}));
    }

    private void displaySelectionState(String string2, MetaData metaData) {
        HashMap hashMap = metaData.getSelectionCriteria();
        String[] stringArray = hashMap.keySet().toArray(new String[0]);
        System.out.println("------------ selection criteria: " + string2);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            System.out.print(string3);
            String[] stringArray2 = ((ArrayList)hashMap.get(string3)).toArray(new String[0]);
            for (int j = 0; j < stringArray2.length; ++j) {
                System.out.print("  " + stringArray2[j]);
            }
            System.out.println();
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(MetaDataTest.class));
    }
}

