/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.metadata.unitTests;

import csplugins.isb.pshannon.experiment.metadata.MetaData;
import csplugins.isb.pshannon.experiment.metadata.MetaDataNavigator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class MetaDataNavigatorTest
extends TestCase {
    static final /* synthetic */ boolean $assertionsDisabled;

    public void testSimple() throws Exception {
        Object object;
        Object[] objectArray;
        System.out.println(".testSimple");
        String string2 = "file://../sampleData/reposTiny";
        MetaDataNavigator metaDataNavigator = new MetaDataNavigator(string2);
        Object[] objectArray2 = metaDataNavigator.getExperimentNames();
        int n = objectArray2.length;
        MetaDataNavigatorTest.assertTrue((n == 8 ? 1 : 0) != 0);
        Object[] objectArray3 = new String[]{"boa1.xml", "boa4.xml", "bop.xml", "copper.xml", "iron.xml", "manganese.xml", "zinc.xml", "zincAndSink.xml"};
        Arrays.sort(objectArray2);
        MetaDataNavigatorTest.assertTrue((boolean)Arrays.equals(objectArray2, objectArray3));
        Object[] objectArray4 = new String[]{"boa1 knockout, light and oxygen", "boa4 knockout, light and oxygen", "bop knockout, light and oxygen", "copper concentrations", "iron concentrations", "manganese concentrations", "zinc and sink concentrations", "zinc concentrations"};
        Object[] objectArray5 = metaDataNavigator.getExperimentTitles();
        if (!$assertionsDisabled && objectArray5.length != 8) {
            throw new AssertionError();
        }
        Arrays.sort(objectArray5);
        MetaDataNavigatorTest.assertTrue((boolean)Arrays.equals(objectArray5, objectArray4));
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray = metaDataNavigator.getExperimentByName((String)objectArray2[i]);
            object = metaDataNavigator.getExperimentByTitle(objectArray.getTitle());
            Object[] objectArray6 = objectArray.getPredicateNamesSorted();
            Object[] objectArray7 = ((MetaData)object).getPredicateNamesSorted();
            MetaDataNavigatorTest.assertTrue((boolean)Arrays.equals(objectArray6, new String[]{"perturbation", "species", "strain"}));
            MetaDataNavigatorTest.assertTrue((boolean)Arrays.equals(objectArray6, objectArray7));
            MetaDataNavigatorTest.assertTrue((boolean)objectArray.toString().equals(((MetaData)object).toString()));
            HashMap hashMap = objectArray.getPredicates();
            String[] stringArray = objectArray.getVariableNames();
        }
        HashMap hashMap = metaDataNavigator.getExperimentsHashedByName();
        MetaDataNavigatorTest.assertTrue((hashMap.size() == n ? 1 : 0) != 0);
        objectArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        MetaDataNavigatorTest.assertTrue((boolean)Arrays.equals(objectArray, objectArray3));
        object = metaDataNavigator.getExperimentsHashedByTitle();
        MetaDataNavigatorTest.assertTrue((((HashMap)object).size() == n ? 1 : 0) != 0);
        objectArray = ((HashMap)object).keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        MetaDataNavigatorTest.assertTrue((boolean)Arrays.equals(objectArray, objectArray4));
    }

    public void testTree() throws Exception {
        System.out.println("testTree");
        String string2 = "file://../sampleData/reposTiny";
        MetaDataNavigator metaDataNavigator = new MetaDataNavigator(string2);
        HashMap hashMap = metaDataNavigator.getTree();
        MetaDataNavigatorTest.assertTrue((boolean)hashMap.containsKey("genetic"));
        MetaDataNavigatorTest.assertTrue((boolean)hashMap.containsKey("environmental"));
        HashMap hashMap2 = (HashMap)hashMap.get("genetic");
        HashMap hashMap3 = (HashMap)hashMap.get("environmental");
        MetaDataNavigatorTest.assertTrue((boolean)hashMap2.containsKey("knockout"));
        HashMap hashMap4 = (HashMap)hashMap2.get("knockout");
        MetaDataNavigatorTest.assertTrue((boolean)hashMap4.containsKey("boa1"));
        MetaDataNavigatorTest.assertTrue((boolean)hashMap4.containsKey("boa4"));
        MetaDataNavigatorTest.assertTrue((boolean)hashMap4.containsKey("bop"));
        MetaDataNavigatorTest.assertTrue((boolean)hashMap3.containsKey("metals"));
        HashMap hashMap5 = (HashMap)hashMap3.get("metals");
        MetaDataNavigatorTest.assertTrue((boolean)hashMap5.containsKey("copper"));
        MetaDataNavigatorTest.assertTrue((boolean)hashMap5.containsKey("zinc"));
        MetaDataNavigatorTest.assertTrue((boolean)hashMap5.containsKey("copper"));
        MetaDataNavigatorTest.assertTrue((boolean)hashMap5.containsKey("manganese"));
        HashMap hashMap6 = (HashMap)hashMap5.get("manganese");
        MetaDataNavigatorTest.assertTrue((boolean)hashMap6.containsKey("concentration"));
        HashMap hashMap7 = (HashMap)hashMap6.get("concentration");
        HashMap hashMap8 = (HashMap)hashMap6.get("concentration");
        Object[] objectArray = hashMap8.keySet().toArray(new String[0]);
        MetaDataNavigatorTest.assertTrue((objectArray.length == 3 ? 1 : 0) != 0);
        Object[] objectArray2 = new String[]{"1000", "1500", "800"};
        Arrays.sort(objectArray);
        MetaDataNavigatorTest.assertTrue((boolean)Arrays.equals(objectArray, objectArray2));
        for (int i = 0; i < objectArray2.length; ++i) {
            HashMap hashMap9 = (HashMap)hashMap8.get(objectArray2[i]);
            MetaDataNavigatorTest.assertTrue((hashMap9.size() == 0 ? 1 : 0) != 0);
        }
    }

    public void testLookupByPerturbationsString1() throws Exception {
        System.out.println("testLookupByPerturbationsString1");
        String string2 = "file://../sampleData/reposTiny";
        MetaDataNavigator metaDataNavigator = new MetaDataNavigator(string2);
        String[] stringArray = metaDataNavigator.getExperimentNames();
        String[] stringArray2 = metaDataNavigator.getExperimentTitles();
        int n = stringArray.length;
        String[] stringArray3 = new String[]{"genetic", "knockout", "boa1", "illumination", "Dark"};
        ArrayList arrayList = metaDataNavigator.findExperimentKeyForPerturbation(stringArray3);
        MetaDataNavigatorTest.assertTrue((arrayList.size() == 1 ? 1 : 0) != 0);
        String[] stringArray4 = (String[])arrayList.get(0);
        String string3 = stringArray4[0];
        String string4 = stringArray4[1];
        MetaDataNavigatorTest.assertTrue((boolean)string3.equals("genetic:knockout:boa1"));
        MetaDataNavigatorTest.assertTrue((boolean)string4.equals("illumination:Dark"));
    }

    public void testLookupByPerturbationsString2() throws Exception {
        System.out.println("testLookupByPerturbationsString2");
        String string2 = "file://../sampleData/reposTiny";
        MetaDataNavigator metaDataNavigator = new MetaDataNavigator(string2);
        String[] stringArray = metaDataNavigator.getExperimentNames();
        String[] stringArray2 = metaDataNavigator.getExperimentTitles();
        int n = stringArray.length;
        String[] stringArray3 = new String[]{"genetic", "knockout", "boa1"};
        ArrayList arrayList = metaDataNavigator.findExperimentKeyForPerturbation(stringArray3);
        MetaDataNavigatorTest.assertTrue((arrayList.size() == 1 ? 1 : 0) != 0);
        String[] stringArray4 = (String[])arrayList.get(0);
        MetaDataNavigatorTest.assertTrue((boolean)stringArray4[0].equals("genetic:knockout:boa1"));
        MetaDataNavigatorTest.assertTrue((stringArray4[1] == null ? 1 : 0) != 0);
    }

    public void testLookupByPerturbationsString3() throws Exception {
        System.out.println("testLookupByPerturbationsString3");
        String string2 = "file://../sampleData/reposTiny";
        MetaDataNavigator metaDataNavigator = new MetaDataNavigator(string2);
        String[] stringArray = metaDataNavigator.getExperimentNames();
        String[] stringArray2 = metaDataNavigator.getExperimentTitles();
        int n = stringArray.length;
        String[] stringArray3 = new String[]{"genetic", "knockout"};
        ArrayList arrayList = metaDataNavigator.findExperimentKeyForPerturbation(stringArray3);
        MetaDataNavigatorTest.assertTrue((arrayList.size() == 3 ? 1 : 0) != 0);
        Object[] objectArray = new String[]{"genetic:knockout:boa1", "genetic:knockout:boa4", "genetic:knockout:bop"};
        for (int i = 0; i < arrayList.size(); ++i) {
            String[] stringArray4 = (String[])arrayList.get(i);
            String string3 = stringArray4[0];
            MetaDataNavigatorTest.assertTrue((Arrays.binarySearch(objectArray, string3) >= 0 ? 1 : 0) != 0);
            if (!$assertionsDisabled && stringArray4[1] != null) {
                throw new AssertionError();
            }
        }
    }

    public void testLookupByPerturbationsString4() throws Exception {
        System.out.println("testLookupByPerturbationsString4");
        String string2 = "file://../sampleData/reposTiny";
        MetaDataNavigator metaDataNavigator = new MetaDataNavigator(string2);
        String[] stringArray = metaDataNavigator.getExperimentNames();
        String[] stringArray2 = metaDataNavigator.getExperimentTitles();
        int n = stringArray.length;
        String[] stringArray3 = new String[]{"environmental", "metals", "zinc"};
        ArrayList arrayList = metaDataNavigator.findExperimentKeyForPerturbation(stringArray3);
        MetaDataNavigatorTest.assertTrue((arrayList.size() == 1 ? 1 : 0) != 0);
        String[] stringArray4 = (String[])arrayList.get(0);
        MetaDataNavigatorTest.assertTrue((boolean)stringArray4[0].equals("environmental:metals:zinc"));
        MetaDataNavigatorTest.assertTrue((stringArray4[1] == null ? 1 : 0) != 0);
    }

    public void testGetWholeExperiments() throws Exception {
        System.out.println("testGetWholeExperiment");
        String string2 = "file://../sampleData/reposTiny";
        MetaDataNavigator metaDataNavigator = new MetaDataNavigator(string2);
        String[] stringArray = new String[]{"genetic", "knockout"};
        ArrayList arrayList = metaDataNavigator.findExperimentKeyForPerturbation(stringArray);
        MetaDataNavigatorTest.assertTrue((arrayList.size() == 3 ? 1 : 0) != 0);
        String[] stringArray2 = new String[]{"genetic:knockout:boa1", "genetic:knockout:boa4", "genetic:knockout:bop"};
        for (int i = 0; i < arrayList.size(); ++i) {
            String[] stringArray3 = (String[])arrayList.get(i);
            MetaDataNavigatorTest.assertTrue((stringArray3.length == 2 ? 1 : 0) != 0);
            String string3 = stringArray3[0];
            String string4 = stringArray3[1];
            MetaDataNavigatorTest.assertTrue((string4 == null ? 1 : 0) != 0);
        }
    }

    public void testGetWholeCondition() throws Exception {
        System.out.println("testGetWholeCondition");
        String string2 = "file://../sampleData/reposTiny";
        MetaDataNavigator metaDataNavigator = new MetaDataNavigator(string2);
        String[] stringArray = new String[]{"genetic", "knockout", "boa4", "oxygen"};
        ArrayList arrayList = metaDataNavigator.findExperimentKeyForPerturbation(stringArray);
        MetaDataNavigatorTest.assertTrue((arrayList.size() == 1 ? 1 : 0) != 0);
        String[] stringArray2 = (String[])arrayList.get(0);
        String string3 = stringArray2[0];
        String string4 = stringArray2[1];
        MetaDataNavigatorTest.assertTrue((boolean)string3.equals("genetic:knockout:boa4"));
        MetaDataNavigatorTest.assertTrue((boolean)string4.equals("oxygen"));
    }

    public void testGetExperimentsByPerturbationList() throws Exception {
        System.out.println("testGetExperimentsByPerturbationList");
        String string2 = "file://../sampleData/reposTiny";
        MetaDataNavigator metaDataNavigator = new MetaDataNavigator(string2);
        MetaData[] metaDataArray = metaDataNavigator.getExperimentByPerturbationList("bogus:fake:trumpedUp");
        if (!$assertionsDisabled && metaDataArray.length != 0) {
            throw new AssertionError();
        }
        String[] stringArray = metaDataNavigator.getPerturbationStrings();
        for (int i = 0; i < stringArray.length; ++i) {
            metaDataArray = metaDataNavigator.getExperimentByPerturbationList(stringArray[i]);
            MetaDataNavigatorTest.assertTrue((metaDataArray.length >= 1 ? 1 : 0) != 0);
        }
    }

    public void testSameVariableFromMultipleFilesTest() throws Exception {
        System.out.println("sameVariableFromMultipleFilesTest");
        String string2 = "file://../sampleData/baitTest";
        MetaDataNavigator metaDataNavigator = new MetaDataNavigator(string2);
        Object[] objectArray = metaDataNavigator.getExperimentNames();
        Object[] objectArray2 = new String[]{"batVbat_cmyc1Vcmyc1.xml", "tfb-ABC-cmyc.xml"};
        Arrays.sort(objectArray);
        Arrays.sort(objectArray2);
        MetaDataNavigatorTest.assertTrue((boolean)Arrays.equals(objectArray, objectArray2));
        HashMap hashMap = metaDataNavigator.getTree();
        String string3 = "Protein-DNA";
        MetaDataNavigatorTest.assertTrue((boolean)hashMap.containsKey(string3));
        hashMap = (HashMap)hashMap.get(string3);
        string3 = "general TF";
        MetaDataNavigatorTest.assertTrue((boolean)hashMap.containsKey(string3));
        hashMap = (HashMap)hashMap.get(string3);
        string3 = "cmyc";
        MetaDataNavigatorTest.assertTrue((boolean)hashMap.containsKey(string3));
        hashMap = (HashMap)hashMap.get(string3);
        string3 = "bait";
        MetaDataNavigatorTest.assertTrue((boolean)hashMap.containsKey(string3));
        hashMap = (HashMap)hashMap.get(string3);
        Object[] objectArray3 = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray3);
        Object[] objectArray4 = new String[]{"bat", "cmyc1", "tfbA", "tfbB", "tfbC"};
        Arrays.sort(objectArray4);
        MetaDataNavigatorTest.assertTrue((boolean)Arrays.equals(objectArray3, objectArray4));
        for (int i = 0; i < objectArray3.length; ++i) {
            HashMap hashMap2 = (HashMap)hashMap.get(objectArray3[i]);
            MetaDataNavigatorTest.assertTrue((hashMap2.size() == 0 ? 1 : 0) != 0);
        }
    }

    public void testMultipleExperimentsWithTheSamePerturbation() throws Exception {
        System.out.println("multipleExperimentsWithTheSamePerturbation");
        String string2 = "file://../sampleData/baitTest";
        MetaDataNavigator metaDataNavigator = new MetaDataNavigator(string2);
        Object[] objectArray = metaDataNavigator.getExperimentNames();
        Object[] objectArray2 = new String[]{"batVbat_cmyc1Vcmyc1.xml", "tfb-ABC-cmyc.xml"};
        Arrays.sort(objectArray);
        Arrays.sort(objectArray2);
        MetaDataNavigatorTest.assertTrue((boolean)Arrays.equals(objectArray, objectArray2));
        HashMap hashMap = metaDataNavigator.getPerturbationExperimentHash();
        String[] stringArray = hashMap.keySet().toArray(new String[0]);
        MetaDataNavigatorTest.assertTrue((stringArray.length == 1 ? 1 : 0) != 0);
        MetaDataNavigatorTest.assertTrue((boolean)stringArray[0].equals("Protein-DNA:general TF:cmyc"));
        ArrayList arrayList = (ArrayList)hashMap.get(stringArray[0]);
        MetaDataNavigatorTest.assertTrue((arrayList.size() == 2 ? 1 : 0) != 0);
        MetaData metaData = (MetaData)arrayList.get(0);
        MetaData metaData2 = (MetaData)arrayList.get(1);
        MetaDataNavigatorTest.assertTrue((boolean)metaData.getTitle().equals("bat vs bat, cmyc1 vs cmyc1 ChIP-chip"));
        MetaDataNavigatorTest.assertTrue((boolean)metaData2.getTitle().equals("tfbABC ChIP-chip, cmyc tag"));
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(MetaDataNavigatorTest.class));
    }

    static {
        $assertionsDisabled = !MetaDataNavigatorTest.class.desiredAssertionStatus();
    }
}

