/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.metadata;

import csplugins.isb.pshannon.experiment.ExperimentRepository;
import csplugins.isb.pshannon.experiment.ExperimentRepositoryFactory;
import csplugins.isb.pshannon.experiment.metadata.MetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class MetaDataNavigator {
    String sourceUri;
    HashMap tree;
    HashMap titleToExperimentsHash;
    HashMap nameToExperimentsHash;
    HashMap perturbationsListToExperimentHash;

    public MetaDataNavigator(String string2) throws Exception {
        this.sourceUri = string2;
        this.tree = new HashMap();
        this.titleToExperimentsHash = new HashMap();
        this.nameToExperimentsHash = new HashMap();
        this.perturbationsListToExperimentHash = new HashMap();
        this.loadMetaData();
        this.buildSimpleTree();
    }

    public HashMap getPerturbationExperimentHash() {
        return this.perturbationsListToExperimentHash;
    }

    protected void loadMetaData() throws Exception {
        ExperimentRepository experimentRepository = ExperimentRepositoryFactory.create(this.sourceUri);
        Object[] objectArray = experimentRepository.getExperimentNames();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            MetaData metaData = experimentRepository.getMetaData((String)objectArray[i]);
            String string2 = metaData.getTitle();
            if (this.titleToExperimentsHash.containsKey(string2)) {
                String string3 = "warning!  skipping duplicate experiment title: " + string2 + " found in metadata.";
                System.err.println(string3);
            }
            this.titleToExperimentsHash.put(string2, metaData);
            this.nameToExperimentsHash.put(object, metaData);
        }
    }

    public String[] getExperimentNames() {
        return this.nameToExperimentsHash.keySet().toArray(new String[0]);
    }

    public String[] getExperimentTitles() {
        return this.titleToExperimentsHash.keySet().toArray(new String[0]);
    }

    public String[] getPerturbationStrings() {
        Object[] objectArray = this.perturbationsListToExperimentHash.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public HashMap getExperimentsHashedByName() {
        return this.nameToExperimentsHash;
    }

    public HashMap getExperimentsHashedByTitle() {
        return this.titleToExperimentsHash;
    }

    public MetaData getExperimentByTitle(String string2) {
        String[] stringArray = this.getExperimentTitles();
        if (this.titleToExperimentsHash.containsKey(string2)) {
            return (MetaData)this.titleToExperimentsHash.get(string2);
        }
        return null;
    }

    public MetaData getExperimentByName(String string2) {
        if (this.nameToExperimentsHash.containsKey(string2)) {
            return (MetaData)this.nameToExperimentsHash.get(string2);
        }
        return null;
    }

    protected String createColonSeparatedString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(":");
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public ArrayList findExperimentKeyForPerturbation(String[] stringArray) {
        String string2 = this.createColonSeparatedString(stringArray);
        boolean bl = false;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String[] stringArray2 = this.getPerturbationStrings();
        for (int i = 0; i < stringArray2.length; ++i) {
            boolean bl2;
            int n;
            String string3 = stringArray2[i];
            if (string2.equals(string3)) {
                arrayList.add(new String[]{string3, null});
                continue;
            }
            if (string2.indexOf(string3) == 0) {
                bl = true;
                n = string3.length() + 1;
                String string4 = string2.substring(n);
                arrayList.add(new String[]{string3, string4});
                continue;
            }
            if (string3.indexOf(string2) != 0) continue;
            n = string2.length();
            char c = string3.charAt(n);
            boolean bl3 = bl2 = c == ':';
            if (!bl2) break;
            arrayList.add(new String[]{string3, null});
        }
        return arrayList;
    }

    public MetaData[] getExperimentByPerturbationList(String string2) {
        if (this.perturbationsListToExperimentHash.containsKey(string2)) {
            ArrayList arrayList = (ArrayList)this.perturbationsListToExperimentHash.get(string2);
            return arrayList.toArray(new MetaData[0]);
        }
        return new MetaData[0];
    }

    public HashMap getTree() {
        return this.tree;
    }

    protected void buildSimpleTree() {
        String[] stringArray = this.getExperimentTitles();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            MetaData metaData = this.getExperimentByTitle(string2);
            String string3 = metaData.getPredicate("species");
            String string4 = metaData.getPredicate("strain");
            HashMap hashMap = metaData.getPredicates();
            if (!hashMap.containsKey("perturbation")) continue;
            String string5 = (String)hashMap.get("perturbation");
            String[] stringArray2 = string5.split(":");
            ArrayList arrayList = new ArrayList();
            if (this.perturbationsListToExperimentHash.containsKey(string5)) {
                arrayList = (ArrayList)this.perturbationsListToExperimentHash.get(string5);
            }
            arrayList.add(metaData);
            this.perturbationsListToExperimentHash.put(string5, arrayList);
            this.addToTree(metaData, stringArray2);
        }
    }

    protected void addToTree(MetaData metaData, String[] stringArray) {
        HashMap hashMap = this.tree;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!hashMap.containsKey(string2)) {
                hashMap.put(string2, new HashMap());
            }
            hashMap = (HashMap)hashMap.get(string2);
            if (i != stringArray.length - 1) continue;
            String[] stringArray2 = metaData.getVariableNames();
            for (int j = 0; j < stringArray2.length; ++j) {
                String string3 = stringArray2[j];
                if (!hashMap.containsKey(string3)) {
                    hashMap.put(string3, new HashMap());
                }
                HashMap hashMap2 = metaData.getVariableValuesWithUnits(string3);
                String[] stringArray3 = hashMap2.keySet().toArray(new String[0]);
                for (int k = 0; k < stringArray3.length; ++k) {
                    HashMap hashMap3 = (HashMap)hashMap.get(string3);
                    hashMap3.put(stringArray3[k], new HashMap());
                }
            }
        }
    }

    public void dumpTree(HashMap hashMap, String string2) {
        if (hashMap.size() == 0) {
            return;
        }
        Object[] objectArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        string2 = string2 + "  ";
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            System.out.println(string2 + (String)object);
            this.dumpTree((HashMap)hashMap.get(object), string2);
        }
    }
}

