/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.metadata;

import csplugins.isb.pshannon.experiment.metadata.Condition;
import csplugins.isb.pshannon.experiment.metadata.DataSetDescription;
import csplugins.isb.pshannon.experiment.metadata.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class MetaData {
    String title;
    String date;
    HashMap predicates;
    ArrayList dataSetDescriptions;
    ArrayList conditions;
    HashMap variableSummary;
    HashMap selectionCriteria;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MetaData(String string2, String string3) {
        this.title = string2;
        this.date = string3;
        this.predicates = new HashMap();
        this.dataSetDescriptions = new ArrayList();
        this.conditions = new ArrayList();
        this.variableSummary = new HashMap();
        this.selectionCriteria = new HashMap();
    }

    public MetaData(String string2) {
        this(string2, null);
    }

    public String getTitle() {
        return this.title;
    }

    public String getDate() {
        return this.date;
    }

    public void setPredicates(HashMap hashMap) {
        this.predicates = hashMap;
    }

    public HashMap getPredicates() {
        return this.predicates;
    }

    public String[] getPredicateNamesSorted() {
        Object[] objectArray = this.predicates.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public String getPredicate(String string2) {
        if (this.predicates.containsKey(string2)) {
            return (String)this.predicates.get(string2);
        }
        return null;
    }

    public void setDataSetDescriptions(ArrayList arrayList) {
        this.dataSetDescriptions = arrayList;
    }

    public DataSetDescription[] getDataSetDescriptions() {
        return this.dataSetDescriptions.toArray(new DataSetDescription[0]);
    }

    public HashMap getVariableSummary() {
        return this.variableSummary;
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
        this.updateVariableSummary(condition);
    }

    protected void updateVariableSummary(Condition condition) {
        String[] stringArray = condition.getVariableNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Variable variable = condition.getVariable(stringArray[i]);
            String string2 = variable.getName();
            String string3 = variable.getValue();
            String string4 = variable.getUnits();
            HashMap hashMap = !this.variableSummary.containsKey(string2) ? new HashMap() : (HashMap)this.variableSummary.get(string2);
            if (!hashMap.containsKey(string3)) {
                hashMap.put(string3, string4);
            }
            this.variableSummary.put(string2, hashMap);
        }
    }

    public Condition[] getConditions() {
        return this.conditions.toArray(new Condition[0]);
    }

    public String[] getVariableNames() {
        return this.variableSummary.keySet().toArray(new String[0]);
    }

    public HashMap getVariableValuesWithUnits(String string2) {
        if (!this.variableSummary.containsKey(string2)) {
            return null;
        }
        return (HashMap)this.variableSummary.get(string2);
    }

    public String getUnits(String string2, String string3) {
        if (!this.variableSummary.containsKey(string2)) {
            return null;
        }
        HashMap hashMap = (HashMap)this.variableSummary.get(string2);
        if (!hashMap.containsKey(string3)) {
            return null;
        }
        return (String)hashMap.get(string3);
    }

    public String[] getSortedVariableValues(String string2) {
        if (!this.variableSummary.containsKey(string2)) {
            return new String[0];
        }
        HashMap hashMap = this.getVariableValuesWithUnits(string2);
        Object[] objectArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public String[] getNamesOfSelectedVariables() {
        Object[] objectArray = this.selectionCriteria.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public boolean columnSelected(Condition condition, HashMap hashMap) {
        boolean bl = true;
        String[] stringArray = this.getNamesOfSelectedVariables();
        Variable[] variableArray = condition.getVariables();
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < variableArray.length; ++i) {
            ArrayList arrayList;
            Variable variable = variableArray[i];
            String string2 = variable.getName();
            String string3 = variable.getValue();
            if (!hashMap.containsKey(string2) || (arrayList = (ArrayList)hashMap.get(string2)).size() == 0) continue;
            if (arrayList.contains(string3)) {
                bl2 = true;
                continue;
            }
            bl3 = true;
        }
        return bl2 && !bl3;
    }

    public Condition[] getSelectedConditions() {
        if (this.selectionCriteria.size() == 0) {
            return new Condition[0];
        }
        ArrayList<Condition> arrayList = new ArrayList<Condition>();
        for (int i = 0; i < this.conditions.size(); ++i) {
            Condition condition = (Condition)this.conditions.get(i);
            if (!this.columnSelected(condition, this.selectionCriteria)) continue;
            arrayList.add(condition);
        }
        return arrayList.toArray(new Condition[0]);
    }

    public String[] getSelectedConditionsAsAliases() {
        Condition[] conditionArray = this.getSelectedConditions();
        Object[] objectArray = new String[conditionArray.length];
        for (int i = 0; i < conditionArray.length; ++i) {
            objectArray[i] = conditionArray[i].getAlias();
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public void clearSelectionCriteria() {
        this.selectionCriteria = new HashMap();
    }

    public HashMap getSelectionCriteria() {
        return this.selectionCriteria;
    }

    public void selectConditionByName(String string2) {
        if (!$assertionsDisabled && !this.variableSummary.containsKey(string2)) {
            throw new AssertionError();
        }
        HashMap hashMap = this.getVariableValuesWithUnits(string2);
        String[] stringArray = hashMap.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            this.addSelectionCriterion(string2, stringArray[i]);
        }
    }

    public void selectAllConditions() {
        String[] stringArray = this.getVariableNames();
        for (int i = 0; i < stringArray.length; ++i) {
            HashMap hashMap = this.getVariableValuesWithUnits(stringArray[i]);
            String[] stringArray2 = hashMap.keySet().toArray(new String[0]);
            for (int j = 0; j < stringArray2.length; ++j) {
                this.addSelectionCriterion(stringArray[i], stringArray2[j]);
            }
        }
    }

    public void addSelectionCriterion(String string2, String string3) {
        if (!this.variableSummary.containsKey(string2)) {
            return;
        }
        HashMap hashMap = (HashMap)this.variableSummary.get(string2);
        if (!((HashMap)this.variableSummary.get(string2)).containsKey(string3)) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        if (this.selectionCriteria.containsKey(string2)) {
            arrayList = (ArrayList)this.selectionCriteria.get(string2);
        }
        arrayList.add(string3);
        this.selectionCriteria.put(string2, arrayList);
    }

    public void setConditions(ArrayList arrayList) {
        this.conditions = arrayList;
    }

    public String[] getConditionAliases() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Condition[] conditionArray = this.getConditions();
        for (int i = 0; i < conditionArray.length; ++i) {
            arrayList.add(conditionArray[i].getAlias());
        }
        return arrayList.toArray(new String[0]);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("title: ");
        stringBuffer.append(this.title);
        stringBuffer.append("\n");
        stringBuffer.append("datasets: ");
        DataSetDescription[] dataSetDescriptionArray = this.getDataSetDescriptions();
        for (int i = 0; i < dataSetDescriptionArray.length; ++i) {
            stringBuffer.append(dataSetDescriptionArray[i].toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("predicates: ");
        String[] stringArray = this.predicates.keySet().toArray(new String[0]);
        for (n = 0; n < stringArray.length; ++n) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append("\n");
        }
        stringBuffer.append("variableDefinitions: ");
        stringBuffer.append(this.getVariableSummary());
        stringBuffer.append("\n");
        stringBuffer.append("conditions: ");
        for (n = 0; n < this.conditions.size(); ++n) {
            stringBuffer.append(this.getConditions()[n].toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    static {
        $assertionsDisabled = !MetaData.class.desiredAssertionStatus();
    }
}

