/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.gui.actions;

import csplugins.isb.pshannon.experiment.datamatrix.LensedDataMatrix;
import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DataMatrixMovieDialog
extends JDialog {
    private JPanel mainPanel;
    private JPanel edgedPanel;
    private JPanel conditionsPanel;
    private JPanel speedPanel;
    private JPanel playPanel;
    private JPanel statusPanel;
    private JPanel loopPanel;
    private JPanel buttonPanel;
    private JPanel dismissPanel;
    private JLabel fileLabel;
    private JLabel speedLabel;
    private JLabel[] conditionLabels;
    private JTextField fileField;
    private JButton browseButton;
    private JSlider conditionsSlider;
    private JSlider speedSlider;
    private ConditionsSliderListener conditionsListener;
    private JButton playButton;
    private JButton stopButton;
    private JButton pauseButton;
    private JButton dismissButton;
    private JCheckBox loop;
    private JProgressBar pBar;
    private LensedDataMatrix[] lenses;
    private String[] attributeNames;
    private int maxConditions = 0;
    private CytoscapeWindow cytoscapeWindow;
    private Timer timer;
    private static final int PLAYING = 0;
    private static final int PAUSED = 1;
    private static final int STOPPED = 2;
    private String startLabelText = "...";
    private int movieState = 2;
    private int movieFrame = -1;
    private boolean loopMovie = false;

    public DataMatrixMovieDialog(CytoscapeWindow cytoscapeWindow, LensedDataMatrix[] lensedDataMatrixArray, String[] stringArray) {
        this.cytoscapeWindow = cytoscapeWindow;
        this.lenses = lensedDataMatrixArray;
        this.attributeNames = stringArray;
        this.setTitle("Data Matrix Movie");
        this.findMaxColumns();
        System.out.println("max columns = " + this.maxConditions);
        int n = 2500;
        this.timer = new Timer(n, new TimerListener());
        this.timer.setRepeats(true);
        this.timer.setInitialDelay(n);
        this.createUI();
    }

    private void findMaxColumns() {
        this.maxConditions = 0;
        for (int i = 0; i < this.lenses.length; ++i) {
            int n = this.lenses[i].getColumnCount();
            if (n <= this.maxConditions) continue;
            this.maxConditions = n;
        }
    }

    protected void createUI() {
        int n;
        if (this.mainPanel != null) {
            this.mainPanel.removeAll();
        }
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.edgedPanel = new JPanel();
        this.edgedPanel.setLayout(new BoxLayout(this.edgedPanel, 1));
        this.edgedPanel.setBorder(BorderFactory.createEtchedBorder());
        this.conditionsPanel = new JPanel();
        this.conditionsPanel.setLayout(new BoxLayout(this.conditionsPanel, 1));
        this.conditionsPanel.setBorder(BorderFactory.createTitledBorder("Conditions"));
        String[] stringArray = this.lenses[0].getColumnTitles();
        this.conditionLabels = new JLabel[this.lenses.length];
        for (n = 0; n < this.lenses.length; ++n) {
            this.conditionLabels[n] = new JLabel(this.startLabelText);
            this.conditionsPanel.add(this.conditionLabels[n]);
        }
        n = stringArray.length;
        this.conditionsSlider = new JSlider(0, 0, n, 0);
        this.conditionsSlider.setMajorTickSpacing(1);
        this.conditionsSlider.setSnapToTicks(true);
        this.conditionsSlider.setPaintTicks(true);
        this.conditionsSlider.setPaintLabels(true);
        this.conditionsSlider.setEnabled(true);
        this.conditionsListener = new ConditionsSliderListener();
        this.conditionsSlider.addChangeListener(this.conditionsListener);
        this.conditionsPanel.add(this.conditionsSlider);
        this.conditionsPanel.add(Box.createRigidArea(new Dimension(8, 0)));
        this.edgedPanel.add(this.conditionsPanel);
        this.speedPanel = new JPanel();
        this.speedPanel.setLayout(new BoxLayout(this.speedPanel, 1));
        this.speedPanel.setBorder(BorderFactory.createTitledBorder("Speed - ms. between frames"));
        this.speedSlider = new JSlider(0, 0, 5000, 2500);
        this.speedSlider.setMajorTickSpacing(1000);
        this.speedSlider.setMinorTickSpacing(100);
        this.speedSlider.setSnapToTicks(true);
        this.speedSlider.setPaintTicks(true);
        this.speedSlider.setPaintLabels(true);
        this.speedSlider.addChangeListener(new SpeedSliderListener());
        this.speedPanel.add(this.speedSlider);
        this.speedPanel.add(Box.createRigidArea(new Dimension(8, 0)));
        this.edgedPanel.add(this.speedPanel);
        this.playPanel = new JPanel();
        this.playPanel.setLayout(new BoxLayout(this.playPanel, 1));
        this.playPanel.setBorder(BorderFactory.createTitledBorder("Play"));
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(1));
        ImageIcon imageIcon = this.createImageIcon("images/play.jpg");
        this.playButton = new JButton(imageIcon);
        this.playButton.addActionListener(new PlayActionListener());
        this.playButton.setToolTipText("Play");
        this.buttonPanel.add(this.playButton);
        this.buttonPanel.add(Box.createRigidArea(new Dimension(16, 0)));
        ImageIcon imageIcon2 = this.createImageIcon("images/pause.jpg");
        this.pauseButton = new JButton(imageIcon2);
        this.pauseButton.addActionListener(new PauseActionListener());
        this.pauseButton.setToolTipText("Pause");
        this.buttonPanel.add(this.pauseButton);
        this.buttonPanel.add(Box.createRigidArea(new Dimension(16, 0)));
        ImageIcon imageIcon3 = this.createImageIcon("images/stop.jpg");
        this.stopButton = new JButton(imageIcon3);
        this.stopButton.setVerticalTextPosition(0);
        this.stopButton.setHorizontalTextPosition(10);
        this.stopButton.addActionListener(new StopActionListener());
        this.stopButton.setToolTipText("Stop");
        this.buttonPanel.add(this.stopButton);
        this.playPanel.add(this.buttonPanel);
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(new FlowLayout());
        this.pBar = new JProgressBar();
        this.pBar.setStringPainted(true);
        this.pBar.setString("Movie Stopped.");
        this.loopPanel = new JPanel();
        this.loopPanel.setLayout(new BoxLayout(this.loopPanel, 0));
        this.loopPanel.setBorder(BorderFactory.createEtchedBorder());
        JLabel jLabel = new JLabel("Loop Movie");
        this.loop = new JCheckBox();
        this.loop.addActionListener(new LoopListener());
        this.statusPanel.add(this.pBar);
        this.loopPanel.add(this.loop);
        this.loopPanel.add(jLabel);
        this.statusPanel.add(this.loopPanel);
        this.playPanel.add(this.statusPanel);
        this.edgedPanel.add(this.playPanel);
        this.dismissPanel = new JPanel();
        this.dismissPanel.setLayout(new FlowLayout(1));
        this.dismissButton = new JButton("Dismiss");
        this.dismissButton.addActionListener(new DismissActionListener());
        this.dismissPanel.add(this.dismissButton);
        this.mainPanel.add(this.edgedPanel);
        this.mainPanel.add(this.dismissPanel);
        this.setContentPane(this.mainPanel);
    }

    private void clearAttributes() {
        GraphObjAttributes graphObjAttributes = this.cytoscapeWindow.getNodeAttributes();
        for (int i = 0; i < this.lenses.length; ++i) {
            LensedDataMatrix lensedDataMatrix = this.lenses[i];
            String string2 = lensedDataMatrix.getShortName();
            String string3 = this.attributeNames[i];
            if (null == string3 || "".equals(string3)) {
                string3 = string2;
            }
            for (int j = 0; j < lensedDataMatrix.getUnderlyingMatrix().getRowCount(); ++j) {
                String string4 = lensedDataMatrix.getUnderlyingMatrix().getRowTitles()[j];
                graphObjAttributes.set(string3, string4, 0.0);
            }
        }
        this.cytoscapeWindow.redrawGraph(false, true);
    }

    private void updateNodeAttributesAndRedraw(int n) {
        GraphObjAttributes graphObjAttributes = this.cytoscapeWindow.getNodeAttributes();
        for (int i = 0; i < this.lenses.length; ++i) {
            LensedDataMatrix lensedDataMatrix = this.lenses[i];
            String string2 = lensedDataMatrix.getShortName();
            String string3 = this.attributeNames[i];
            if (null == string3 || "".equals(string3)) {
                string3 = string2;
            }
            for (int j = 0; j < lensedDataMatrix.getUnderlyingMatrix().getRowCount(); ++j) {
                double d = this.lenses[i].getUnderlyingMatrix().get(j, n);
                String string4 = lensedDataMatrix.getUnderlyingMatrix().getRowTitles()[j];
                graphObjAttributes.set(string3, string4, d);
            }
        }
        this.cytoscapeWindow.redrawGraph(false, true);
    }

    protected ImageIcon createImageIcon(String string2) {
        URL uRL = this.getClass().getResource(string2);
        if (null != uRL) {
            return new ImageIcon(uRL);
        }
        System.err.println("----- Couldn't find file: " + string2 + " --------");
        System.err.flush();
        return null;
    }

    class ConditionsSliderListener
    implements ChangeListener {
        ConditionsSliderListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (DataMatrixMovieDialog.this.movieState == 0 || DataMatrixMovieDialog.this.movieState == 1) {
                return;
            }
            if (DataMatrixMovieDialog.this.conditionsSlider.getValueIsAdjusting()) {
                return;
            }
            int n = DataMatrixMovieDialog.this.conditionsSlider.getValue();
            if (n == -1) {
                DataMatrixMovieDialog.this.clearAttributes();
                for (int i = 0; i < DataMatrixMovieDialog.this.lenses.length; ++i) {
                    DataMatrixMovieDialog.this.conditionLabels[i].setText(DataMatrixMovieDialog.this.startLabelText);
                }
                return;
            }
            for (int i = 0; i < DataMatrixMovieDialog.this.lenses.length; ++i) {
                DataMatrixMovieDialog.this.conditionLabels[i].setText(DataMatrixMovieDialog.this.lenses[i].getColumnTitles()[n]);
            }
            DataMatrixMovieDialog.this.updateNodeAttributesAndRedraw(n);
        }
    }

    class SpeedSliderListener
    implements ChangeListener {
        SpeedSliderListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (DataMatrixMovieDialog.this.speedSlider.getValueIsAdjusting()) {
                return;
            }
            int n = DataMatrixMovieDialog.this.speedSlider.getValue();
            DataMatrixMovieDialog.this.timer.setDelay(n);
            DataMatrixMovieDialog.this.timer.setInitialDelay(n);
        }
    }

    class LoopListener
    implements ActionListener {
        LoopListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DataMatrixMovieDialog.this.loop.isSelected()) {
                DataMatrixMovieDialog.this.loopMovie = true;
            } else {
                DataMatrixMovieDialog.this.loopMovie = false;
            }
        }
    }

    class PauseActionListener
    extends AbstractAction {
        PauseActionListener() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DataMatrixMovieDialog.this.movieState == 2) {
                return;
            }
            if (DataMatrixMovieDialog.this.movieState == 1) {
                DataMatrixMovieDialog.this.playButton.doClick();
                return;
            }
            DataMatrixMovieDialog.this.movieState = 1;
            DataMatrixMovieDialog.this.pBar.setString("Movie Paused.");
            DataMatrixMovieDialog.this.timer.stop();
        }
    }

    class StopActionListener
    extends AbstractAction {
        StopActionListener() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DataMatrixMovieDialog.this.movieState == 2) {
                return;
            }
            DataMatrixMovieDialog.this.movieState = 2;
            DataMatrixMovieDialog.this.conditionsSlider.setEnabled(true);
            DataMatrixMovieDialog.this.pBar.setString("Movie Stopped.");
            DataMatrixMovieDialog.this.pBar.setIndeterminate(false);
            DataMatrixMovieDialog.this.timer.stop();
            DataMatrixMovieDialog.this.conditionsSlider.setValue(0);
            DataMatrixMovieDialog.this.clearAttributes();
        }
    }

    class PlayActionListener
    extends AbstractAction {
        PlayActionListener() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DataMatrixMovieDialog.this.movieState == 0) {
                return;
            }
            DataMatrixMovieDialog.this.movieState = 0;
            DataMatrixMovieDialog.this.pBar.setString("Playing Movie...");
            DataMatrixMovieDialog.this.conditionsSlider.setEnabled(false);
            DataMatrixMovieDialog.this.pBar.setIndeterminate(true);
            DataMatrixMovieDialog.this.timer.start();
        }
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (++DataMatrixMovieDialog.this.movieFrame > DataMatrixMovieDialog.this.maxConditions) {
                if (DataMatrixMovieDialog.this.loopMovie) {
                    DataMatrixMovieDialog.this.movieFrame = 0;
                    DataMatrixMovieDialog.this.conditionsSlider.setValue(0);
                    for (int i = 0; i < DataMatrixMovieDialog.this.lenses.length; ++i) {
                        DataMatrixMovieDialog.this.conditionLabels[i].setText(DataMatrixMovieDialog.this.startLabelText);
                    }
                } else {
                    DataMatrixMovieDialog.this.timer.stop();
                    DataMatrixMovieDialog.this.conditionsSlider.setEnabled(true);
                    DataMatrixMovieDialog.this.movieState = 2;
                    DataMatrixMovieDialog.this.movieFrame = -1;
                    DataMatrixMovieDialog.this.conditionsSlider.setValue(0);
                    for (int i = 0; i < DataMatrixMovieDialog.this.lenses.length; ++i) {
                        DataMatrixMovieDialog.this.conditionLabels[i].setText(DataMatrixMovieDialog.this.startLabelText);
                    }
                    DataMatrixMovieDialog.this.clearAttributes();
                    DataMatrixMovieDialog.this.pBar.setString("Movie Stopped.");
                    DataMatrixMovieDialog.this.pBar.setIndeterminate(false);
                }
                return;
            }
            DataMatrixMovieDialog.this.conditionsSlider.setValue(DataMatrixMovieDialog.this.movieFrame);
            if (DataMatrixMovieDialog.this.movieFrame == 0) {
                DataMatrixMovieDialog.this.clearAttributes();
                for (int i = 0; i < DataMatrixMovieDialog.this.lenses.length; ++i) {
                    DataMatrixMovieDialog.this.conditionLabels[i].setText(DataMatrixMovieDialog.this.startLabelText);
                }
            } else {
                for (int i = 0; i < DataMatrixMovieDialog.this.lenses.length; ++i) {
                    DataMatrixMovieDialog.this.conditionLabels[i].setText(DataMatrixMovieDialog.this.lenses[i].getColumnTitles()[DataMatrixMovieDialog.this.movieFrame - 1]);
                }
                DataMatrixMovieDialog.this.updateNodeAttributesAndRedraw(DataMatrixMovieDialog.this.movieFrame - 1);
            }
        }
    }

    class DismissActionListener
    extends AbstractAction {
        DismissActionListener() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataMatrixMovieDialog.this.dispose();
        }
    }
}

