/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.gui.actions;

import csplugins.isb.pshannon.experiment.datamatrix.DataMatrix;
import csplugins.isb.pshannon.experiment.datamatrix.LensedDataMatrix;
import csplugins.isb.pshannon.experiment.gui.DataMatrixBrowser;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class CreateNewMatrixFromSelection
extends AbstractAction {
    protected DataMatrixBrowser browser;

    public CreateNewMatrixFromSelection(DataMatrixBrowser dataMatrixBrowser) {
        super("Create from Selection");
        this.browser = dataMatrixBrowser;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        LensedDataMatrix lensedDataMatrix = this.browser.getCurrentLens();
        if (lensedDataMatrix.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this.browser, "No rows are selected!", "Selection Error", 0);
            return;
        }
        String string2 = JOptionPane.showInputDialog(this.browser, (Object)"Please enter a name for this matrix:");
        if (null == string2) {
            return;
        }
        try {
            DataMatrix dataMatrix = lensedDataMatrix.getVisibleMatrix();
            dataMatrix.setShortName(string2);
            this.browser.addMatrixToGui(dataMatrix);
            int n = this.browser.getAllTables().length - 1;
            if (!this.browser.getUnsorted()) {
                boolean bl = !this.browser.getSortOrderAscending();
                this.browser.doSort(n, bl);
            }
            this.browser.getTabbedPane().setSelectedIndex(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

