/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.gui.actions;

import csplugins.isb.pshannon.experiment.datamatrix.DataMatrix;
import csplugins.isb.pshannon.experiment.datamatrix.LensedDataMatrix;
import csplugins.isb.pshannon.experiment.gui.DataMatrixBrowser;
import csplugins.isb.pshannon.experiment.gui.actions.CorrelationFinder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CorrelationFinderDialog
extends JDialog
implements ActionListener {
    protected DataMatrixBrowser parentBrowser;
    private DataMatrix matrix;
    private LensedDataMatrix lens;
    private CorrelationFinder finder;
    private double currentCorrelationThreshold = 1.0;
    private ArrayList namesOfCorrelatedNodes = new ArrayList();
    private String[] namesOfReferenceNodes = new String[0];
    JTextField correlatedCountTextField;
    JTextField thresholdTextField;
    String correlationMode = "Positive";

    public CorrelationFinderDialog(DataMatrixBrowser dataMatrixBrowser) {
        this.setTitle("Correlation Finder");
        this.parentBrowser = dataMatrixBrowser;
        this.lens = this.parentBrowser.getCurrentLens();
        this.matrix = this.lens.getUnderlyingMatrix();
        this.createGui();
    }

    public void createGui() {
        int n = this.matrix.getRowCount();
        if (n < 1) {
            String string2 = "Please select one or more rows and try again.";
            JOptionPane.showMessageDialog(this.parentBrowser, string2);
            return;
        }
        this.namesOfReferenceNodes = this.lens.getRowTitles();
        this.finder = new CorrelationFinder(this.matrix);
        this.finder.buildCorrelationTable(this.namesOfReferenceNodes);
        Map map = this.finder.getCorrelationTable();
        JSlider jSlider = new JSlider(0, 0, 100, 100);
        jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        jSlider.setMajorTickSpacing(10);
        jSlider.setMinorTickSpacing(1);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(true);
        jSlider.addChangeListener(new SliderListener());
        JButton jButton = new JButton("Select in Browser");
        jButton.addActionListener(new SelectNodesAboveThreshold());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        String string3 = System.getProperty("line.separator");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 2, 10), BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 10))));
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.add(jPanel3);
        jPanel.add((Component)jPanel2, "Center");
        jPanel3.setLayout(new GridLayout(2, 2));
        this.correlatedCountTextField = new JTextField("0", 6);
        this.thresholdTextField = new JTextField("100", 6);
        jPanel3.add(new JLabel("Nodes meeting threshold "));
        jPanel3.add(this.correlatedCountTextField);
        jPanel3.add(new JLabel("Threshold "));
        jPanel3.add(this.thresholdTextField);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 3));
        JRadioButton jRadioButton = new JRadioButton("Positive", true);
        JRadioButton jRadioButton2 = new JRadioButton("Negative");
        JRadioButton jRadioButton3 = new JRadioButton("Both");
        jRadioButton.addActionListener(this);
        jRadioButton2.addActionListener(this);
        jRadioButton3.addActionListener(this);
        jPanel4.add(jRadioButton);
        jPanel4.add(jRadioButton2);
        jPanel4.add(jRadioButton3);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jPanel5.add((Component)jPanel4, "North");
        jPanel5.add((Component)jSlider, "Center");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        container.add((Component)jPanel6, "Center");
        jPanel6.add((Component)jPanel, "Center");
        jPanel6.add((Component)jPanel5, "South");
        JPanel jPanel7 = new JPanel();
        JButton jButton2 = new JButton("Dismiss");
        jButton2.addActionListener(new DismissAction());
        container.add((Component)jPanel7, "South");
        jPanel7.add(jButton);
        jPanel7.add(jButton2);
        this.pack();
        this.placeInCenter();
        this.setVisible(true);
        this.refreshSelection();
    }

    protected void refreshSelection() {
        int n = this.findCorrelatedNodes();
        String string2 = new Integer(n).toString();
        this.correlatedCountTextField.setText(string2);
    }

    private int findCorrelatedNodes() {
        Map map = this.finder.getCorrelationTable();
        String[] stringArray = map.keySet().toArray(new String[0]);
        this.namesOfCorrelatedNodes = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            double d = (Double)map.get(string2);
            boolean bl = false;
            if (d >= this.currentCorrelationThreshold && (this.correlationMode.equals("Positive") || this.correlationMode.equals("Both"))) {
                bl = true;
            }
            if (-1.0 * d >= this.currentCorrelationThreshold && (this.correlationMode.equals("Negative") || this.correlationMode.equals("Both"))) {
                bl = true;
            }
            if (!bl) continue;
            this.namesOfCorrelatedNodes.add(string2);
        }
        return this.namesOfCorrelatedNodes.size();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.correlationMode = actionEvent.getActionCommand();
        this.refreshSelection();
    }

    protected void placeInCenter() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n = (int)graphicsConfiguration.getBounds().getHeight();
        int n2 = (int)graphicsConfiguration.getBounds().getWidth();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        this.setLocation((n2 - n3) / 2, (n - n4) / 2);
    }

    public class DismissAction
    extends AbstractAction {
        DismissAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CorrelationFinderDialog.this.dispose();
        }
    }

    class SelectNodesAboveThreshold
    extends AbstractAction {
        SelectNodesAboveThreshold() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CorrelationFinderDialog.this.parentBrowser.clearAllSelections();
            for (int i = 0; i < CorrelationFinderDialog.this.namesOfReferenceNodes.length; ++i) {
                if (CorrelationFinderDialog.this.namesOfCorrelatedNodes.contains(CorrelationFinderDialog.this.namesOfReferenceNodes[i])) continue;
                CorrelationFinderDialog.this.namesOfCorrelatedNodes.add(CorrelationFinderDialog.this.namesOfReferenceNodes[i]);
            }
            String[] stringArray = CorrelationFinderDialog.this.namesOfCorrelatedNodes.toArray(new String[0]);
            CorrelationFinderDialog.this.parentBrowser.selectRowsByName(stringArray);
        }
    }

    protected class SliderListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (!jSlider.getValueIsAdjusting()) {
                int n = jSlider.getValue();
                CorrelationFinderDialog.this.thresholdTextField.setText(new Integer(n).toString());
                CorrelationFinderDialog.this.currentCorrelationThreshold = (double)n / 100.0;
                CorrelationFinderDialog.this.refreshSelection();
            }
        }
    }
}

