/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.gui;

import csplugins.isb.dtenenbaum.nameHelper.NameHelper;
import csplugins.isb.dtenenbaum.nameHelper.NameHelperFactory;
import csplugins.isb.dtenenbaum.plot2d.Plot2D;
import csplugins.isb.pshannon.experiment.datamatrix.DataMatrix;
import csplugins.isb.pshannon.experiment.datamatrix.LensedDataMatrix;
import csplugins.isb.pshannon.experiment.gui.CheckBoxHeader;
import csplugins.isb.pshannon.experiment.gui.DataMatrixTableModel;
import csplugins.isb.pshannon.experiment.gui.MutableList;
import csplugins.isb.pshannon.experiment.gui.actions.CreateNewMatrixFromSelection;
import csplugins.isb.pshannon.experiment.gui.actions.ExportMatrix;
import csplugins.isb.pshannon.experiment.gui.actions.FindCorrelations;
import csplugins.isb.pshannon.experiment.gui.actions.GetSelectionsFromNetwork;
import csplugins.isb.pshannon.experiment.gui.actions.PyConsoleLauncher;
import csplugins.isb.pshannon.experiment.gui.actions.RunMovie;
import csplugins.isb.pshannon.experiment.gui.actions.SelectionPlotter;
import csplugins.isb.pshannon.experiment.metadata.MetaData;
import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DataMatrixBrowser
extends JPanel
implements ClipboardOwner {
    protected int preferredTableWidth = 600;
    protected int preferredTableHeight = 100;
    protected JTabbedPane tabbedPane;
    protected File currentDirectory;
    private SelectionPlotter selectionPlotter;
    protected NameHelper nameHelper;
    protected MetaData metaData = null;
    ArrayList matrixList;
    ArrayList lensList;
    ArrayList nodeAttributeNameTextFieldList;
    ArrayList selectionCountTextFieldList;
    int matrixCount = 0;
    protected CytoscapeWindow cytoscapeWindow;
    protected ArrayList tableList = new ArrayList();
    protected boolean[][] columnState;
    protected int[][] columnOrder;
    protected ArrayList columnCheckBoxHeaderMaps = new ArrayList();
    protected JPanel buttonPanel;
    private Vector selectedRows = new Vector();
    private Vector colOrder = new Vector();
    private Vector enabled = new Vector();
    private Vector colMap = new Vector();
    private JComboBox cbNameType;
    private boolean sortOrderAscending = false;
    private boolean unsorted = true;
    private Timer dragTimer;
    private int dragFrom = -1;
    private int dragTo = -1;
    private ArrayList rowHeaders = new ArrayList();
    private int defaultNameType = 0;
    private DataMatrix[] matrices;
    protected JToolBar toolbar;
    private boolean updateSelectionsToCytoscape = true;
    static /* synthetic */ Class class$csplugins$isb$pshannon$experiment$gui$DataMatrixBrowser;

    public DataMatrixBrowser(CytoscapeWindow cytoscapeWindow, DataMatrix[] dataMatrixArray, MetaData metaData) throws Exception {
        this.matrices = dataMatrixArray;
        this.currentDirectory = new File(System.getProperty("user.dir"));
        this.cytoscapeWindow = cytoscapeWindow;
        this.metaData = metaData;
        this.nameHelper = NameHelperFactory.getNameHelper();
        this.matrixList = new ArrayList();
        this.lensList = new ArrayList();
        this.toolbar = new JToolBar();
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolbar, "North");
        this.addActions();
        this.dragTimer = new Timer(100, new DragTimerListener());
        this.add((Component)this.createGui(dataMatrixArray), "Center");
    }

    public DataMatrixBrowser(CytoscapeWindow cytoscapeWindow, DataMatrix[] dataMatrixArray) throws Exception {
        this(cytoscapeWindow, dataMatrixArray, null);
    }

    private int[] calculateColumnWidths(JTable jTable, DataMatrix dataMatrix) {
        String[] stringArray = dataMatrix.getColumnTitles();
        int n = stringArray.length;
        int n2 = 100;
        int[] nArray = new int[n];
        FontMetrics fontMetrics = jTable.getFontMetrics(jTable.getFont());
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            int n3 = fontMetrics.stringWidth(string2);
            int n4 = (int)((double)n3 * 1.4);
            nArray[i] = n4 > n2 ? n4 : n2;
        }
        return nArray;
    }

    JTabbedPane createGui(DataMatrix[] dataMatrixArray) {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setUI(new MyTabbedPaneUI());
        class PaneListener
        implements ChangeListener {
            PaneListener() {
            }

            public void stateChanged(ChangeEvent changeEvent) {
                if (DataMatrixBrowser.this.tableList == null) {
                    return;
                }
                DataMatrixBrowser.this.cbNameType.setSelectedIndex(DataMatrixBrowser.this.defaultNameType);
                JTable jTable = null;
                if (DataMatrixBrowser.this.getCurrentTabAndTableIndex() <= -1) {
                    return;
                }
                jTable = (JTable)DataMatrixBrowser.this.tableList.get(DataMatrixBrowser.this.getCurrentTabAndTableIndex());
                if (null != jTable.getSelectedRows() && jTable.getSelectedRows().length >= 1) {
                    DataMatrixBrowser.this.resetPlotter(true);
                }
            }
        }
        this.tabbedPane.addChangeListener(new PaneListener());
        this.nodeAttributeNameTextFieldList = new ArrayList();
        this.selectionCountTextFieldList = new ArrayList();
        for (int i = 0; i < dataMatrixArray.length; ++i) {
            this.addMatrixToGui(dataMatrixArray[i]);
        }
        return this.tabbedPane;
    }

    public DataMatrix[] getMatrices() {
        return this.matrixList.toArray(new DataMatrix[0]);
    }

    public void addMatrixToGui(DataMatrix dataMatrix) {
        Object object;
        JComponent jComponent;
        Object object2;
        this.matrixList.add(dataMatrix);
        try {
            this.lensList.add(new LensedDataMatrix(dataMatrix));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        DataMatrixTableModel dataMatrixTableModel = new DataMatrixTableModel(dataMatrix);
        HashMap<String, CheckBoxHeader> hashMap = new HashMap<String, CheckBoxHeader>();
        this.columnCheckBoxHeaderMaps.add(hashMap);
        JTable jTable = new JTable(dataMatrixTableModel);
        jTable.setShowGrid(true);
        int[] nArray = this.calculateColumnWidths(jTable, dataMatrix);
        MutableList mutableList = new MutableList(dataMatrix.getRowTitles());
        mutableList.setFixedCellWidth(100);
        mutableList.setFixedCellHeight(jTable.getRowHeight());
        mutableList.setCellRenderer(new RowHeaderRenderer(jTable));
        this.rowHeaders.add(mutableList);
        this.tableList.add(jTable);
        jTable.getColumnModel().addColumnModelListener(new TableColumnMovedListener());
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            ((TableColumn)object2).setPreferredWidth(nArray[n]);
            jComponent = new CheckBoxHeader(new TableHeaderCheckboxListener());
            object = dataMatrix.getColumnTitles()[n];
            hashMap.put((String)object, (CheckBoxHeader)jComponent);
            ((TableColumn)object2).setHeaderRenderer((TableCellRenderer)((Object)jComponent));
            ++n;
        }
        object2 = jTable.getSelectionModel();
        object2.addListSelectionListener(new TableSelectionListener(jTable, dataMatrix));
        jTable.setSelectionModel((ListSelectionModel)object2);
        jTable.setPreferredScrollableViewportSize(new Dimension(this.preferredTableWidth, this.preferredTableHeight));
        jComponent = new JScrollPane(jTable);
        ((JScrollPane)jComponent).setRowHeaderView(mutableList);
        ((JScrollPane)jComponent).setHorizontalScrollBarPolicy(32);
        jTable.setAutoResizeMode(0);
        object = new JPanel();
        ((Container)object).setLayout(new BorderLayout());
        String string2 = dataMatrix.getShortName();
        String string3 = "";
        int n2 = string2.lastIndexOf(".");
        if (n2 > 0 && n2 < string2.length() - 1) {
            string3 = string2.substring(n2 + 1);
        }
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JLabel jLabel = new JLabel("Name Type:");
        String string4 = "<html>Change the type of name displayed<br>in the row headers</HTML>";
        jLabel.setToolTipText(string4);
        jPanel3.add(jLabel);
        this.cbNameType = new JComboBox();
        this.cbNameType.addItem("Canonical");
        this.cbNameType.addItem("Common");
        this.cbNameType.setSelectedIndex(this.defaultNameType);
        this.cbNameType.setToolTipText(string4);
        this.cbNameType.addItemListener(new NameTypeChangeListener());
        jPanel3.add(this.cbNameType);
        JButton jButton = new JButton("Sort");
        jButton.setToolTipText("<html>Sort data in alphanumeric order (in all matrices)<br>sorting by the currently selected name type.<BR>Toggles between descending and ascending sort order.</html>");
        jButton.addActionListener(new SortButtonListener());
        jPanel3.add(jButton);
        jPanel4.add(new JLabel("Node attribute name: "));
        JTextField jTextField = new JTextField(string3, 10);
        this.nodeAttributeNameTextFieldList.add(jTextField);
        jPanel4.add(jTextField);
        JTextField jTextField2 = new JTextField("0", 5);
        jTextField2.setEditable(false);
        this.selectionCountTextFieldList.add(jTextField2);
        jPanel4.add(new JLabel("Selected Rows: "));
        jPanel4.add(jTextField2);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel.add(jPanel2);
        ((Container)object).add((Component)jPanel, "North");
        ((Container)object).add((Component)jComponent, "Center");
        this.tabbedPane.add(string2, (Component)object);
    }

    protected void addActions() {
        this.addActionToToolbar(new FindCorrelations(this));
        this.selectionPlotter = new SelectionPlotter(this, this.nameHelper);
        this.addActionToToolbar(this.selectionPlotter);
        this.addActionToToolbar(new CreateNewMatrixFromSelection(this));
        this.addActionToToolbar(new PyConsoleLauncher(this));
        if (null != this.cytoscapeWindow) {
            this.addActionToToolbar(new GetSelectionsFromNetwork(this, this.cytoscapeWindow));
            this.addActionToToolbar(new RunMovie(this, this.cytoscapeWindow));
        }
        this.addActionToToolbar(new ExportMatrix(this));
    }

    public void addActionToToolbar(AbstractAction abstractAction) {
        this.toolbar.add(abstractAction);
    }

    public LensedDataMatrix[] getAllLenses() {
        return this.lensList.toArray(new LensedDataMatrix[0]);
    }

    public LensedDataMatrix getCurrentLens() {
        return this.getLens(this.getCurrentTabAndTableIndex());
    }

    public JTable getCurrentTable() {
        return this.getTable(this.getCurrentTabAndTableIndex());
    }

    public LensedDataMatrix getLens(int n) {
        return (LensedDataMatrix)this.lensList.get(n);
    }

    private String extendMatrixWithNodeAttributes(String string2) {
        GraphObjAttributes graphObjAttributes = this.cytoscapeWindow.getNodeAttributes();
        String[] stringArray = string2.split("\n");
        String[] stringArray2 = graphObjAttributes.getAttributeNames();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0]);
        for (int i = 0; i < stringArray2.length; ++i) {
            stringBuffer.append("\t");
            stringBuffer.append(stringArray2[i]);
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer2.append("\n");
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i].split("\t");
            String string3 = stringArray3[0];
            StringBuffer stringBuffer3 = new StringBuffer();
            stringBuffer3.append(stringArray[i]);
            stringBuffer3.append("\t");
            for (int j = 0; j < stringArray2.length; ++j) {
                Object object;
                String string4 = stringArray2[j];
                if (graphObjAttributes.hasAttribute(string4, string3) && (object = graphObjAttributes.getValue(stringArray2[j], string3)) != null) {
                    String string5 = object.toString();
                    stringBuffer3.append(string5);
                }
                if (j >= stringArray2.length - 1) continue;
                stringBuffer3.append("\t");
            }
            stringBuffer3.append("\n");
            stringBuffer2.append(stringBuffer3.toString());
        }
        return stringBuffer2.toString();
    }

    private void setPreferredColumnWidths(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = jTable.getModel().getColumnCount();
        tableColumnModel.getColumn(0).setPreferredWidth(80);
    }

    private void placeInCenter() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n = (int)graphicsConfiguration.getBounds().getHeight();
        int n2 = (int)graphicsConfiguration.getBounds().getWidth();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        this.setLocation((n2 - n3) / 2, (n - n4) / 2);
    }

    private void resetPlotter(boolean bl) {
        Plot2D plot2D = null;
        plot2D = this.selectionPlotter.getPlotter();
        if (null != plot2D) {
            plot2D.populateFromLens(this.getCurrentLens(), bl);
        }
    }

    private int[] toIntArray(ArrayList arrayList) {
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    public void enableColumnsByName(String[] stringArray) {
        JTable[] jTableArray = this.tableList.toArray(new JTable[0]);
        for (int i = 0; i < jTableArray.length; ++i) {
            this.enableColumnsByName(i, stringArray);
        }
    }

    public boolean getSortOrderAscending() {
        return this.sortOrderAscending;
    }

    public void doSort(int n, boolean bl) {
        Object[] objectArray;
        this.updateSelectionsToCytoscape = false;
        Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>();
        MutableList mutableList = (MutableList)this.rowHeaders.get(n);
        JTable jTable = (JTable)this.tableList.get(n);
        Hashtable<Object[], String> hashtable2 = new Hashtable<Object[], String>();
        for (int i = 0; i < jTable.getSelectedRowCount(); ++i) {
            objectArray = (Object[])mutableList.getContents().getElementAt(jTable.getSelectedRows()[i]);
            hashtable2.put(objectArray, "nothing");
        }
        Object[] objectArray2 = new Object[mutableList.getContents().size()];
        objectArray = new Object[mutableList.getOriginalValues().size()];
        mutableList.getContents().copyInto(objectArray2);
        mutableList.getOriginalValues().copyInto(objectArray);
        if (bl) {
            Arrays.sort(objectArray2);
        } else {
            Arrays.sort(objectArray2, new Comparator(){

                public int compare(Object object, Object object2) {
                    Comparable comparable = (Comparable)object;
                    Comparable comparable2 = (Comparable)object2;
                    return comparable2.compareTo(comparable);
                }
            });
        }
        mutableList.changeList(objectArray2);
        for (int i = 0; i < objectArray.length; ++i) {
            hashtable.put(objectArray[i], new Integer(i));
        }
        int[] nArray = new int[mutableList.getContents().size()];
        for (int i = 0; i < objectArray2.length; ++i) {
            int n2;
            nArray[i] = n2 = ((Integer)hashtable.get(objectArray2[i])).intValue();
        }
        DataMatrixTableModel dataMatrixTableModel = (DataMatrixTableModel)jTable.getModel();
        dataMatrixTableModel.setNewRowIndices(nArray);
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        if (!listSelectionModel.isSelectionEmpty()) {
            jTable.clearSelection();
            for (int i = 0; i < jTable.getRowCount(); ++i) {
                String string2 = (String)mutableList.getContents().getElementAt(i);
                if (null == hashtable2.get(string2)) continue;
                jTable.addRowSelectionInterval(i, i);
            }
        }
        jTable.repaint();
    }

    protected void enableColumnsByName(int n, String[] stringArray) {
        Object object;
        int n2;
        HashMap hashMap = (HashMap)this.columnCheckBoxHeaderMaps.get(n);
        JTable jTable = (JTable)this.tableList.get(n);
        String[] stringArray2 = hashMap.keySet().toArray(new String[0]);
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            object = (CheckBoxHeader)hashMap.get(stringArray2[n2]);
            ((AbstractButton)object).setSelected(false);
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            object = stringArray[n2];
            boolean bl = hashMap.containsKey(object);
            if (!bl) continue;
            CheckBoxHeader checkBoxHeader = (CheckBoxHeader)hashMap.get(object);
            checkBoxHeader.setSelected(true);
        }
        jTable.getTableHeader().resizeAndRepaint();
    }

    public void disableAllColumnsInCurrentlyVisibleTable() {
        int n = this.getCurrentTabAndTableIndex();
        HashMap hashMap = (HashMap)this.columnCheckBoxHeaderMaps.get(n);
        String[] stringArray = hashMap.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            CheckBoxHeader checkBoxHeader = (CheckBoxHeader)hashMap.get(stringArray[i]);
            checkBoxHeader.setSelected(false);
        }
        JTable jTable = (JTable)this.tableList.get(n);
        jTable.getTableHeader().resizeAndRepaint();
    }

    protected void enableColumnsByNameInCurrentlyVisibleTable(String[] stringArray) {
        HashMap hashMap = (HashMap)this.columnCheckBoxHeaderMaps.get(this.getCurrentTabAndTableIndex());
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            boolean bl = hashMap.containsKey(string2);
            if (!bl) continue;
            CheckBoxHeader checkBoxHeader = (CheckBoxHeader)hashMap.get(string2);
            checkBoxHeader.setSelected(true);
        }
        JTable jTable = (JTable)this.tableList.get(this.getCurrentTabAndTableIndex());
        jTable.getTableHeader().resizeAndRepaint();
    }

    public void clearAllSelections() {
        JTable[] jTableArray = this.tableList.toArray(new JTable[0]);
        for (int i = 0; i < jTableArray.length; ++i) {
            jTableArray[i].clearSelection();
        }
    }

    public void selectRowsByName(String[] stringArray) {
        JTable[] jTableArray = this.tableList.toArray(new JTable[0]);
        for (int i = 0; i < jTableArray.length; ++i) {
            this.selectRowsByName(i, stringArray);
        }
    }

    public void selectRowsByName(int n, String[] stringArray) {
        JTable jTable = (JTable)this.tableList.get(n);
        List<String> list = Arrays.asList(stringArray);
        String[] stringArray2 = ((DataMatrix)this.matrixList.get(n)).getRowTitles();
        int n2 = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            String string2 = stringArray2[i];
            boolean bl = list.contains(string2);
            if (!bl) continue;
            jTable.getSelectionModel().addSelectionInterval(i, i);
            ++n2;
        }
        String string3 = new Integer(n2).toString();
        ((JTextField)this.selectionCountTextFieldList.get(n)).setText(string3);
    }

    protected boolean columnNamesIntersect(String[] stringArray) {
        HashMap hashMap = (HashMap)this.columnCheckBoxHeaderMaps.get(this.getCurrentTabAndTableIndex());
        String[] stringArray2 = hashMap.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!hashMap.containsKey(string2)) continue;
            return true;
        }
        return false;
    }

    protected boolean rowNamesIntersect(String[] stringArray) {
        int n = this.getCurrentTabAndTableIndex();
        List<String> list = Arrays.asList(stringArray);
        String[] stringArray2 = ((DataMatrix)this.matrixList.get(n)).getRowTitles();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!list.contains(stringArray2[i])) continue;
            return true;
        }
        return false;
    }

    public void selectSubTableInCurrentlyVisibleTable(String[] stringArray, String[] stringArray2) {
        this.clearAllSelections();
        this.disableAllColumnsInCurrentlyVisibleTable();
        if (!this.columnNamesIntersect(stringArray2)) {
            return;
        }
        if (!this.rowNamesIntersect(stringArray)) {
            return;
        }
        this.selectRowsByNameInCurrentlyVisibleTable(stringArray);
        this.disableAllColumnsInCurrentlyVisibleTable();
        this.enableColumnsByNameInCurrentlyVisibleTable(stringArray2);
    }

    public void selectRowsByNameInCurrentlyVisibleTable(String[] stringArray) {
        int n = this.getCurrentTabAndTableIndex();
        JTable jTable = (JTable)this.tableList.get(n);
        List<String> list = Arrays.asList(stringArray);
        String[] stringArray2 = ((DataMatrix)this.matrixList.get(n)).getRowTitles();
        int n2 = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            String string2 = stringArray2[i];
            boolean bl = list.contains(string2);
            if (!bl) continue;
            jTable.getSelectionModel().addSelectionInterval(i, i);
            ++n2;
        }
        String string3 = new Integer(n2).toString();
        ((JTextField)this.selectionCountTextFieldList.get(n)).setText(string3);
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public JTable getTable() {
        JTable jTable = (JTable)this.tableList.get(this.getCurrentTabAndTableIndex());
        return jTable;
    }

    public JTable getTable(int n) {
        return (JTable)this.tableList.get(n);
    }

    public boolean getUnsorted() {
        return this.unsorted;
    }

    public JTable[] getAllTables() {
        return this.tableList.toArray(new JTable[0]);
    }

    public MutableList getRowHeader(int n) {
        return (MutableList)this.rowHeaders.get(n);
    }

    public String[] getMatrixAliases() {
        int n = this.matrixList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((JTextField)this.nodeAttributeNameTextFieldList.get(i)).getText();
        }
        return stringArray;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    protected int getCurrentTabAndTableIndex() {
        if (this.tabbedPane == null) {
            return -1;
        }
        return this.tabbedPane.getSelectedIndex();
    }

    class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        RowHeaderRenderer(JTable jTable) {
            JTableHeader jTableHeader = jTable.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(jTableHeader.getForeground());
            this.setBackground(jTableHeader.getBackground());
            JLabel jLabel = new JLabel();
            this.setBackground(jLabel.getBackground());
            this.setFont(jTableHeader.getFont());
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            DataMatrixTableModel dataMatrixTableModel = (DataMatrixTableModel)DataMatrixBrowser.this.getCurrentTable().getModel();
            int n2 = dataMatrixTableModel.getCorrectRowIndex(n);
            String string2 = DataMatrixBrowser.this.getCurrentLens().getUnderlyingMatrix().getRowTitles()[n2];
            String string3 = DataMatrixBrowser.this.nameHelper.getName(DataMatrixBrowser.this.nameHelper.getCategoryList()[1], string2);
            this.setText(object == null ? "" : object.toString());
            if (null != object) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string2);
                if (!string3.equals(string2)) {
                    stringBuffer.append(" (" + string3 + ")");
                }
                this.setToolTipText(stringBuffer.toString());
            }
            return this;
        }
    }

    class TableSelectionListener
    implements ListSelectionListener {
        JTable table;
        DataMatrix matrix;

        TableSelectionListener(JTable jTable, DataMatrix dataMatrix) {
            this.table = jTable;
            this.matrix = dataMatrix;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = DataMatrixBrowser.this.getCurrentTabAndTableIndex();
            DataMatrixTableModel dataMatrixTableModel = (DataMatrixTableModel)this.table.getModel();
            MutableList mutableList = (MutableList)DataMatrixBrowser.this.rowHeaders.get(n);
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            DataMatrixBrowser.this.getCurrentLens().disableAllRows();
            int[] nArray = this.table.getSelectedRows();
            System.out.println("TableSelectionListener.valueChanged, count: " + nArray.length);
            ((JTextField)DataMatrixBrowser.this.selectionCountTextFieldList.get(n)).setText("" + nArray.length);
            int[] nArray2 = new int[nArray.length];
            String[] stringArray = new String[nArray2.length];
            for (int i = 0; i < nArray.length; ++i) {
                String string2;
                String string3 = (String)mutableList.getContents().get(nArray[i]);
                stringArray[i] = string2 = mutableList.getOriginalName(string3);
                nArray2[i] = DataMatrixBrowser.this.getCurrentLens().getRowIndex(string2);
            }
            DataMatrixBrowser.this.getCurrentLens().enableRows(nArray2);
            if (DataMatrixBrowser.this.cytoscapeWindow != null && DataMatrixBrowser.this.updateSelectionsToCytoscape) {
                DataMatrixBrowser.this.cytoscapeWindow.selectNodesByName(stringArray);
            }
            if (!listSelectionModel.isSelectionEmpty()) {
                DataMatrixBrowser.this.resetPlotter(false);
            }
        }
    }

    public class ExportAction
    extends AbstractAction {
        ExportAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            int n = DataMatrixBrowser.this.getCurrentTabAndTableIndex();
            JTable jTable = (JTable)DataMatrixBrowser.this.tableList.get(n);
            int[] nArray = jTable.getSelectedRows();
            int n2 = nArray.length;
            if (n2 == 0) {
                object = "No rows are selected in this table.  Do you wish to export all rows to R?";
                int n3 = JOptionPane.showConfirmDialog(DataMatrixBrowser.this, object, "No selections", 0);
                if (n3 == 1) {
                    return;
                }
                int n4 = ((DataMatrix)DataMatrixBrowser.this.matrixList.get(n)).getRowCount();
                nArray = new int[n4];
                for (int i = 0; i < n4; ++i) {
                    nArray[i] = i;
                }
            }
            object = DataMatrixBrowser.this.getCurrentLens();
            ((LensedDataMatrix)object).disableAllRows();
            ((LensedDataMatrix)object).enableRows(nArray);
            String string2 = ((LensedDataMatrix)object).toString();
            String string3 = DataMatrixBrowser.this.extendMatrixWithNodeAttributes(string2);
            JFileChooser jFileChooser = new JFileChooser(DataMatrixBrowser.this.currentDirectory);
            if (jFileChooser.showSaveDialog(DataMatrixBrowser.this) == 0) {
                String string4 = jFileChooser.getSelectedFile().toString();
                DataMatrixBrowser.this.currentDirectory = jFileChooser.getCurrentDirectory();
                File file = jFileChooser.getSelectedFile();
                try {
                    FileWriter fileWriter = new FileWriter(file);
                    fileWriter.write(string2);
                    fileWriter.close();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, iOException.toString(), "Error Writing to \"" + file.getName() + "\"", 0);
                }
            }
        }
    }

    class TableColumnMovedListener
    implements TableColumnModelListener {
        TableColumnMovedListener() {
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            if (tableColumnModelEvent.getFromIndex() == tableColumnModelEvent.getToIndex()) {
                return;
            }
            DataMatrixBrowser.this.dragTo = tableColumnModelEvent.getToIndex();
            if (!DataMatrixBrowser.this.dragTimer.isRunning()) {
                DataMatrixBrowser.this.dragFrom = tableColumnModelEvent.getFromIndex();
                DataMatrixBrowser.this.dragTimer.start();
                return;
            }
        }

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    class DragTimerListener
    implements ActionListener {
        DragTimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)DataMatrixBrowser.this.tableList.get(DataMatrixBrowser.this.getCurrentTabAndTableIndex());
            JTableHeader jTableHeader = jTable.getTableHeader();
            TableColumn tableColumn = jTableHeader.getDraggedColumn();
            if (null == tableColumn) {
                DataMatrixBrowser.this.dragTimer.stop();
                if (DataMatrixBrowser.this.dragFrom == DataMatrixBrowser.this.dragTo) {
                    return;
                }
                int n = DataMatrixBrowser.this.getCurrentTabAndTableIndex();
                ((LensedDataMatrix)DataMatrixBrowser.this.lensList.get(n)).changeColumnPosition(DataMatrixBrowser.this.dragFrom, DataMatrixBrowser.this.dragTo);
                DataMatrixBrowser.this.resetPlotter(true);
            }
        }
    }

    class MyTabbedPaneUI
    extends BasicTabbedPaneUI {
        protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
            super.paintTab(graphics, n, rectangleArray, n2, rectangle, rectangle2);
            Rectangle rectangle3 = rectangleArray[n2];
            graphics.setColor(Color.black);
            graphics.drawRect(rectangle3.x + 5, rectangle3.y + 5, 10, 10);
            graphics.drawLine(rectangle3.x + 5, rectangle3.y + 5, rectangle3.x + 15, rectangle3.y + 15);
            graphics.drawLine(rectangle3.x + 15, rectangle3.y + 5, rectangle3.x + 5, rectangle3.y + 15);
        }

        protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
            return super.calculateTabWidth(n, n2, fontMetrics) + 20;
        }

        protected MouseListener createMouseListener() {
            return new MyMouseHandler();
        }

        static /* synthetic */ DataMatrixBrowser access$1100(MyTabbedPaneUI myTabbedPaneUI) {
            return myTabbedPaneUI.DataMatrixBrowser.this;
        }

        class MyMouseHandler
        extends BasicTabbedPaneUI.MouseHandler {
            public MyMouseHandler() {
                super(MyTabbedPaneUI.this);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                int n3 = -1;
                int n4 = MyTabbedPaneUI.this.tabPane.getTabCount();
                for (int i = 0; i < n4; ++i) {
                    if (!MyTabbedPaneUI.this.rects[i].contains(n, n2)) continue;
                    n3 = i;
                    break;
                }
                if (n3 >= 0) {
                    Rectangle rectangle = MyTabbedPaneUI.this.rects[n3];
                    if ((n -= rectangle.x) >= 5 && n <= 15 && (n2 -= rectangle.y) >= 5 && n2 <= 15) {
                        try {
                            SwingUtilities.invokeLater(new Runnable(this){
                                private final /* synthetic */ MyMouseHandler this$2;
                                {
                                    this.this$2 = myMouseHandler;
                                }

                                public void run() {
                                    int n = MyTabbedPaneUI.access$1100(MyMouseHandler.access$1000(this.this$2)).getCurrentTabAndTableIndex();
                                    MyTabbedPaneUI.access$1100((MyTabbedPaneUI)MyMouseHandler.access$1000((MyMouseHandler)this.this$2)).tabbedPane.remove(n);
                                    MyTabbedPaneUI.access$1100((MyTabbedPaneUI)MyMouseHandler.access$1000((MyMouseHandler)this.this$2)).tableList.remove(n);
                                    MyTabbedPaneUI.access$1100((MyTabbedPaneUI)MyMouseHandler.access$1000((MyMouseHandler)this.this$2)).lensList.remove(n);
                                    MyTabbedPaneUI.access$1100((MyTabbedPaneUI)MyMouseHandler.access$1000((MyMouseHandler)this.this$2)).matrixList.remove(n);
                                    MyTabbedPaneUI.access$1100((MyTabbedPaneUI)MyMouseHandler.access$1000((MyMouseHandler)this.this$2)).selectionCountTextFieldList.remove(n);
                                    MyTabbedPaneUI.access$1100((MyTabbedPaneUI)MyMouseHandler.access$1000((MyMouseHandler)this.this$2)).nodeAttributeNameTextFieldList.remove(n);
                                }
                            });
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }

            static /* synthetic */ MyTabbedPaneUI access$1000(MyMouseHandler myMouseHandler) {
                return myMouseHandler.MyTabbedPaneUI.this;
            }
        }
    }

    class TableHeaderCheckboxListener
    implements ItemListener {
        TableHeaderCheckboxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            int n = DataMatrixBrowser.this.getCurrentTabAndTableIndex();
            if (n < 0) {
                return;
            }
            Object object = itemEvent.getSource();
            if (!(object instanceof AbstractButton)) {
                return;
            }
            String string2 = ((AbstractButton)object).getText();
            boolean bl = itemEvent.getStateChange() == 1;
            int n2 = ((CheckBoxHeader)itemEvent.getItem()).getColumn();
            ((LensedDataMatrix)DataMatrixBrowser.this.lensList.get(n)).setColumnState(n2, bl);
            DataMatrixBrowser.this.resetPlotter(true);
        }
    }

    class NameTypeChangeListener
    implements ItemListener {
        static final /* synthetic */ boolean $assertionsDisabled;

        NameTypeChangeListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            DataMatrixBrowser.this.updateSelectionsToCytoscape = false;
            JComboBox jComboBox = (JComboBox)itemEvent.getSource();
            DataMatrixBrowser.this.defaultNameType = jComboBox.getSelectedIndex();
            if (DataMatrixBrowser.this.getCurrentTabAndTableIndex() == -1) {
                return;
            }
            String[] stringArray = ((DataMatrix)DataMatrixBrowser.this.matrixList.get(DataMatrixBrowser.this.getCurrentTabAndTableIndex())).getRowTitles();
            for (int i = 0; i < DataMatrixBrowser.this.tableList.size(); ++i) {
                int n;
                String string2;
                String string3;
                MutableList mutableList = (MutableList)DataMatrixBrowser.this.rowHeaders.get(i);
                Vector<String> vector = new Vector<String>();
                for (int j = 0; j < mutableList.getOriginalValues().size(); ++j) {
                    String string4 = (String)mutableList.getOriginalValues().get(j);
                    string3 = null;
                    string2 = stringArray[j];
                    if (!$assertionsDisabled && !string2.equals(mutableList.getOriginalName(string4))) {
                        throw new AssertionError();
                    }
                    string3 = DataMatrixBrowser.this.nameHelper.getName(DataMatrixBrowser.this.nameHelper.getCategoryList()[1], string4);
                    if (jComboBox.getSelectedIndex() == 0) {
                        vector.add(string2);
                        continue;
                    }
                    if (null != string3) {
                        vector.add(string3);
                        continue;
                    }
                    vector.add(string4 == null ? "" : string4);
                }
                mutableList.setOriginalValues(vector);
                Object[] objectArray = new String[mutableList.getModel().getSize()];
                if (jComboBox.getSelectedIndex() == 0) {
                    for (n = 0; n < mutableList.getModel().getSize(); ++n) {
                        string3 = (String)mutableList.getModel().getElementAt(n);
                        objectArray[n] = mutableList.getOriginalName(string3);
                    }
                } else {
                    for (n = 0; n < mutableList.getModel().getSize(); ++n) {
                        string3 = (String)mutableList.getModel().getElementAt(n);
                        string2 = null;
                        string2 = DataMatrixBrowser.this.nameHelper.getName(DataMatrixBrowser.this.nameHelper.getCategoryList()[1], string3);
                        objectArray[n] = null != string2 ? string2 : (string3 == null ? "" : string3);
                    }
                }
                mutableList.changeList(objectArray);
                DataMatrixBrowser.this.updateSelectionsToCytoscape = true;
            }
        }

        static {
            $assertionsDisabled = !(class$csplugins$isb$pshannon$experiment$gui$DataMatrixBrowser == null ? (class$csplugins$isb$pshannon$experiment$gui$DataMatrixBrowser = DataMatrixBrowser.class$("csplugins.isb.pshannon.experiment.gui.DataMatrixBrowser")) : class$csplugins$isb$pshannon$experiment$gui$DataMatrixBrowser).desiredAssertionStatus();
        }
    }

    class SortButtonListener
    implements ActionListener {
        SortButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataMatrixBrowser.this.unsorted = false;
            for (int i = 0; i < DataMatrixBrowser.this.tableList.size(); ++i) {
                DataMatrixBrowser.this.doSort(i, DataMatrixBrowser.this.sortOrderAscending);
            }
            DataMatrixBrowser.this.sortOrderAscending = !DataMatrixBrowser.this.sortOrderAscending;
            DataMatrixBrowser.this.updateSelectionsToCytoscape = true;
        }
    }
}

