/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.datamatrix.unitTests;

import csplugins.isb.pshannon.experiment.datamatrix.DataMatrix;
import csplugins.isb.pshannon.experiment.datamatrix.MatrixCombiner;
import csplugins.isb.pshannon.experiment.readers.DataMatrixFileReader;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class MatrixCombinerTest
extends TestCase {
    static /* synthetic */ Class class$csplugins$isb$pshannon$experiment$datamatrix$unitTests$MatrixCombinerTest;

    public MatrixCombinerTest(String string2) {
        super(string2);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testCombine1() throws Exception {
        System.out.println("testCombine1");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://../../sampleData/simpleMatrix.txt");
        dataMatrixFileReader.read();
        DataMatrix dataMatrix = dataMatrixFileReader.get();
        MatrixCombiner matrixCombiner = new MatrixCombiner(new DataMatrix[]{dataMatrix});
        DataMatrix dataMatrix2 = matrixCombiner.combine();
        MatrixCombinerTest.assertTrue((dataMatrix2.getRowCount() == 4 ? 1 : 0) != 0);
        MatrixCombinerTest.assertTrue((dataMatrix2.getColumnCount() == 3 ? 1 : 0) != 0);
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dataMatrix.getColumnTitles(), dataMatrix2.getColumnTitles()));
        double[][] dArray = dataMatrix.get();
        double[][] dArray2 = dataMatrix2.get();
        MatrixCombinerTest.assertTrue((dArray.length == dArray2.length ? 1 : 0) != 0);
        MatrixCombinerTest.assertTrue((dArray.length == 4 ? 1 : 0) != 0);
        for (int i = 0; i < dArray.length; ++i) {
            MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray[i], dArray2[i]));
        }
    }

    public void testCombine2() throws Exception {
        System.out.println("testCombine2");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://../../sampleData/simpleMatrix.txt");
        dataMatrixFileReader.read();
        DataMatrix dataMatrix = dataMatrixFileReader.get();
        dataMatrixFileReader = new DataMatrixFileReader("file://../../sampleData/simpleMatrix2.txt");
        dataMatrixFileReader.read();
        DataMatrix dataMatrix2 = dataMatrixFileReader.get();
        MatrixCombiner matrixCombiner = new MatrixCombiner(new DataMatrix[]{dataMatrix, dataMatrix2});
        DataMatrix dataMatrix3 = matrixCombiner.combine();
        MatrixCombinerTest.assertTrue((dataMatrix3.getRowCount() == 6 ? 1 : 0) != 0);
        MatrixCombinerTest.assertTrue((dataMatrix3.getColumnCount() == 6 ? 1 : 0) != 0);
        Object[] objectArray = new String[]{"cond0", "cond1", "cond2", "cond3", "cond4", "cond5"};
        Object[] objectArray2 = dataMatrix3.getColumnTitles();
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(objectArray, objectArray2));
        objectArray = new String[]{"a", "b", "c", "d", "e", "f"};
        objectArray2 = dataMatrix3.getRowTitles();
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(objectArray2, objectArray));
        double[] dArray = new double[]{12.2, 13.8, 4.0, 82.2, 83.8, 84.0};
        double[] dArray2 = dataMatrix3.get("a");
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(objectArray2, objectArray));
        double d = Double.NaN;
        dArray = new double[]{-1.2, -8.0, -32.3333, d, d, d};
        dArray2 = dataMatrix3.get("b");
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray2, dArray));
        dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        dArray2 = dataMatrix3.get("c");
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray2, dArray));
        dArray = new double[]{999.0, 99.0, 9.0, d, d, d};
        dArray2 = dataMatrix3.get("d");
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray2, dArray));
        dArray = new double[]{d, d, d, 888.0, 88.0, 8.0};
        dArray2 = dataMatrix3.get("e");
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray2, dArray));
        dArray = new double[]{d, d, d, 8.0, 8.88, 7.888};
        dArray2 = dataMatrix3.get("f");
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray2, dArray));
    }

    public void testCombine3() throws Exception {
        System.out.println("testCombine3");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://../../sampleData/simpleMatrix.txt");
        dataMatrixFileReader.read();
        DataMatrix dataMatrix = dataMatrixFileReader.get();
        dataMatrixFileReader = new DataMatrixFileReader("file://../../sampleData/simpleMatrix2.txt");
        dataMatrixFileReader.read();
        DataMatrix dataMatrix2 = dataMatrixFileReader.get();
        dataMatrixFileReader = new DataMatrixFileReader("file://../../sampleData/simpleMatrix3.txt");
        dataMatrixFileReader.read();
        DataMatrix dataMatrix3 = dataMatrixFileReader.get();
        MatrixCombiner matrixCombiner = new MatrixCombiner(new DataMatrix[]{dataMatrix, dataMatrix2, dataMatrix3});
        DataMatrix dataMatrix4 = matrixCombiner.combine();
        MatrixCombinerTest.assertTrue((dataMatrix4.getRowCount() == 7 ? 1 : 0) != 0);
        MatrixCombinerTest.assertTrue((dataMatrix4.getColumnCount() == 7 ? 1 : 0) != 0);
        Object[] objectArray = new String[]{"cond0", "cond1", "cond2", "cond3", "cond4", "cond5", "cond6"};
        Object[] objectArray2 = dataMatrix4.getColumnTitles();
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(objectArray2, objectArray));
        objectArray = new String[]{"a", "b", "c", "d", "e", "f", "g"};
        objectArray2 = dataMatrix4.getRowTitles();
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(objectArray2, objectArray));
        double[] dArray = new double[]{12.2, 13.8, 4.0, 82.2, 83.8, 84.0, 1.1};
        double[] dArray2 = dataMatrix4.get("a");
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray2, dArray));
        double d = Double.NaN;
        dArray = new double[]{-1.2, -8.0, -32.3333, d, d, d, 2.2};
        dArray2 = dataMatrix4.get("b");
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray2, dArray));
        dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.3};
        dArray2 = dataMatrix4.get("c");
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray2, dArray));
        dArray = new double[]{999.0, 99.0, 9.0, d, d, d, 4.4};
        dArray2 = dataMatrix4.get("d");
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray2, dArray));
        dArray = new double[]{d, d, d, 888.0, 88.0, 8.0, 5.5};
        dArray2 = dataMatrix4.get("e");
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray2, dArray));
        dArray = new double[]{d, d, d, 8.0, 8.88, 7.888, 6.6};
        dArray2 = dataMatrix4.get("f");
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray2, dArray));
        dArray = new double[]{d, d, d, d, d, d, 7.7};
        dArray2 = dataMatrix4.get("g");
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray2, dArray));
    }

    public void testCombine2CheckForAlphabetizedColumnNames() throws Exception {
        System.out.println("testCombine2CheckForAlphabetizedColumnNames");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://../../sampleData/simpleMatrix.txt");
        dataMatrixFileReader.read();
        DataMatrix dataMatrix = dataMatrixFileReader.get();
        dataMatrixFileReader = new DataMatrixFileReader("file://../../sampleData/simpleMatrix2.txt");
        dataMatrixFileReader.read();
        DataMatrix dataMatrix2 = dataMatrixFileReader.get();
        MatrixCombiner matrixCombiner = new MatrixCombiner(new DataMatrix[]{dataMatrix2, dataMatrix});
        DataMatrix dataMatrix3 = matrixCombiner.combine();
        MatrixCombinerTest.assertTrue((dataMatrix3.getRowCount() == 6 ? 1 : 0) != 0);
        MatrixCombinerTest.assertTrue((dataMatrix3.getColumnCount() == 6 ? 1 : 0) != 0);
        Object[] objectArray = new String[]{"cond0", "cond1", "cond2", "cond3", "cond4", "cond5"};
        Object[] objectArray2 = dataMatrix3.getColumnTitles();
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(objectArray, objectArray2));
        objectArray = new String[]{"a", "b", "c", "d", "e", "f"};
        objectArray2 = dataMatrix3.getRowTitles();
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(objectArray2, objectArray));
        double[] dArray = new double[]{12.2, 13.8, 4.0, 82.2, 83.8, 84.0};
        double[] dArray2 = dataMatrix3.get("a");
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(objectArray2, objectArray));
        double d = Double.NaN;
        dArray = new double[]{-1.2, -8.0, -32.3333, d, d, d};
        dArray2 = dataMatrix3.get("b");
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray2, dArray));
        dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        dArray2 = dataMatrix3.get("c");
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray2, dArray));
        dArray = new double[]{999.0, 99.0, 9.0, d, d, d};
        dArray2 = dataMatrix3.get("d");
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray2, dArray));
        dArray = new double[]{d, d, d, 888.0, 88.0, 8.0};
        dArray2 = dataMatrix3.get("e");
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray2, dArray));
        dArray = new double[]{d, d, d, 8.0, 8.88, 7.888};
        dArray2 = dataMatrix3.get("f");
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray2, dArray));
    }

    public void testCombine2WithOneEmpty() throws Exception {
        System.out.println("testCombine2WithOneEmpty");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://../../sampleData/simpleMatrix.txt");
        dataMatrixFileReader.read();
        DataMatrix dataMatrix = dataMatrixFileReader.get();
        Object[] objectArray = dataMatrix.getColumnTitles();
        Object[] objectArray2 = new String[]{"cond0", "cond1", "cond2"};
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(objectArray, objectArray2));
        dataMatrixFileReader = new DataMatrixFileReader("file://../../sampleData/simpleMatrix2.txt");
        dataMatrixFileReader.read();
        DataMatrix dataMatrix2 = dataMatrixFileReader.get();
        objectArray = dataMatrix2.getColumnTitles();
        objectArray2 = new String[]{"cond3", "cond4", "cond5"};
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(objectArray, objectArray2));
        DataMatrix dataMatrix3 = new DataMatrix();
        dataMatrix3.setSize(0, 4);
        dataMatrix3.setRowTitlesTitle("gene");
        dataMatrix3.setColumnTitles(dataMatrix2.getColumnTitles());
        MatrixCombiner matrixCombiner = new MatrixCombiner(new DataMatrix[]{dataMatrix, dataMatrix3});
        DataMatrix dataMatrix4 = matrixCombiner.combine();
        MatrixCombinerTest.assertTrue((dataMatrix4.getRowCount() == 4 ? 1 : 0) != 0);
        MatrixCombinerTest.assertTrue((dataMatrix4.getColumnCount() == 6 ? 1 : 0) != 0);
        MatrixCombinerTest.assertTrue((boolean)dataMatrix4.getRowTitlesTitle().equals("gene"));
        objectArray = dataMatrix4.getColumnTitles();
        objectArray2 = new String[]{"cond0", "cond1", "cond2", "cond3", "cond4", "cond5"};
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(objectArray, objectArray2));
        Object[] objectArray3 = dataMatrix4.getRowTitles();
        objectArray2 = new String[]{"a", "b", "c", "d"};
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(objectArray3, objectArray2));
        double d = Double.NaN;
        double[] dArray = new double[]{12.2, 13.8, 4.0, d, d, d};
        double[] dArray2 = dataMatrix4.get(0);
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray, dArray2));
        dArray2 = dataMatrix4.get(1);
        dArray = new double[]{-1.2, -8.0, -32.3333, d, d, d};
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray, dArray2));
        dArray2 = dataMatrix4.get(2);
        dArray = new double[]{0.0, 0.0, 0.0, d, d, d};
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray, dArray2));
        dArray2 = dataMatrix4.get(3);
        dArray = new double[]{999.0, 99.0, 9.0, d, d, d};
        MatrixCombinerTest.assertTrue((boolean)Arrays.equals(dArray, dArray2));
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(class$csplugins$isb$pshannon$experiment$datamatrix$unitTests$MatrixCombinerTest == null ? (class$csplugins$isb$pshannon$experiment$datamatrix$unitTests$MatrixCombinerTest = MatrixCombinerTest.class$("csplugins.isb.pshannon.experiment.datamatrix.unitTests.MatrixCombinerTest")) : class$csplugins$isb$pshannon$experiment$datamatrix$unitTests$MatrixCombinerTest));
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

