/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.datamatrix.unitTests;

import csplugins.isb.pshannon.experiment.datamatrix.DataMatrix;
import csplugins.isb.pshannon.experiment.datamatrix.LensedDataMatrix;
import csplugins.isb.pshannon.experiment.readers.DataMatrixFileReader;
import csplugins.isb.pshannon.experiment.readers.DataMatrixReader;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LensedDataMatrixTest
extends TestCase {
    static /* synthetic */ Class class$csplugins$isb$pshannon$experiment$datamatrix$unitTests$LensedDataMatrixTest;

    public LensedDataMatrixTest(String string2) {
        super(string2);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testColumnEnabling() throws Exception {
        System.out.println("testColumnEnabling");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://simpleMatrix.txt");
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix dataMatrix = ((DataMatrixReader)dataMatrixFileReader).get();
        LensedDataMatrix lensedDataMatrix = new LensedDataMatrix(dataMatrix);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnCount() == 3 ? 1 : 0) != 0);
        boolean[] blArray = lensedDataMatrix.getColumnState();
        LensedDataMatrixTest.assertTrue((blArray.length == 3 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((blArray[0] ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((blArray[1] ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((blArray[2] ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnState(0) ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnState(1) ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnState(2) ? 1 : 0) != 0);
        lensedDataMatrix.setColumnState(1, false);
        LensedDataMatrixTest.assertTrue((!lensedDataMatrix.getColumnState(1) ? 1 : 0) != 0);
        blArray = lensedDataMatrix.getColumnState();
        LensedDataMatrixTest.assertTrue((blArray[0] ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((!blArray[1] ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((blArray[2] ? 1 : 0) != 0);
        lensedDataMatrix.setColumnState(0, false);
        lensedDataMatrix.setColumnState(2, false);
        LensedDataMatrixTest.assertTrue((blArray.length == 3 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((!lensedDataMatrix.getColumnState(0) ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((!lensedDataMatrix.getColumnState(1) ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((!lensedDataMatrix.getColumnState(2) ? 1 : 0) != 0);
        lensedDataMatrix.clear();
        LensedDataMatrixTest.assertTrue((blArray.length == 3 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnState(0) ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnState(1) ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnState(2) ? 1 : 0) != 0);
    }

    public void testColumnOrdering() throws Exception {
        System.out.println("testColumnOrdering");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://simpleMatrix.txt");
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix dataMatrix = ((DataMatrixReader)dataMatrixFileReader).get();
        LensedDataMatrix lensedDataMatrix = new LensedDataMatrix(dataMatrix);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnCount() == 3 ? 1 : 0) != 0);
        for (int i = 0; i < lensedDataMatrix.getColumnCount(); ++i) {
            LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnOrder(i) == i ? 1 : 0) != 0);
        }
        lensedDataMatrix.changeColumnPosition(2, 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnOrder(0) == 2 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnOrder(1) == 0 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnOrder(2) == 1 ? 1 : 0) != 0);
    }

    public void testGetColumn() throws Exception {
        System.out.println("testGetColumn");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://simpleMatrix.txt");
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix dataMatrix = ((DataMatrixReader)dataMatrixFileReader).get();
        String string2 = dataMatrix.toString();
        String string3 = "gene\tcond0\tcond1\tcond2\na\t12.2\t13.8\t4.0\nb\t-1.2\t-8.0\t-32.3333\nc\t0.0\t0.0\t0.0\nd\t999.0\t99.0\t9.0\n";
        LensedDataMatrixTest.assertTrue((boolean)string3.equals(string2));
        LensedDataMatrix lensedDataMatrix = new LensedDataMatrix(dataMatrix);
        lensedDataMatrix.enableAllRows();
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnCount() == 3 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getRowCount() == 4 ? 1 : 0) != 0);
        for (int i = 0; i < lensedDataMatrix.getColumnCount(); ++i) {
            LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnOrder(i) == i ? 1 : 0) != 0);
        }
        lensedDataMatrix.changeColumnPosition(2, 0);
        double[] dArray = lensedDataMatrix.getColumn(0);
        LensedDataMatrixTest.assertTrue((dArray.length == 4 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[0] == 4.0 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[1] == -32.3333 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[2] == 0.0 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[3] == 9.0 ? 1 : 0) != 0);
        double[] dArray2 = lensedDataMatrix.getColumn("cond2");
        LensedDataMatrixTest.assertTrue((dArray2.length == 4 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray2[0] == 4.0 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray2[1] == -32.3333 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray2[2] == 0.0 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray2[3] == 9.0 ? 1 : 0) != 0);
    }

    public void testGetDataWithOrderingAndEnabling_1() throws Exception {
        System.out.println("testGetDataWithOrderingAndEnabling_1");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://simpleMatrix.txt");
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix dataMatrix = ((DataMatrixReader)dataMatrixFileReader).get();
        LensedDataMatrix lensedDataMatrix = new LensedDataMatrix(dataMatrix);
        lensedDataMatrix.enableAllRows();
        String string2 = dataMatrix.toString();
        String string3 = "gene\tcond0\tcond1\tcond2\na\t12.2\t13.8\t4.0\nb\t-1.2\t-8.0\t-32.3333\nc\t0.0\t0.0\t0.0\nd\t999.0\t99.0\t9.0\n";
        LensedDataMatrixTest.assertTrue((boolean)string3.equals(string2));
        lensedDataMatrix.changeColumnPosition(2, 0);
        lensedDataMatrix.changeColumnPosition(2, 1);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnOrder(0) == 2 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnOrder(1) == 1 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnOrder(2) == 0 ? 1 : 0) != 0);
        double[] dArray = lensedDataMatrix.get(0);
        LensedDataMatrixTest.assertTrue((dArray.length == 3 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[0] == 4.0 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[1] == 13.8 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[2] == 12.2 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[2] == dataMatrix.get(0, 0) ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[1] == dataMatrix.get(0, 1) ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[0] == dataMatrix.get(0, 2) ? 1 : 0) != 0);
        lensedDataMatrix.setColumnState(0, false);
        dArray = lensedDataMatrix.get(0);
        LensedDataMatrixTest.assertTrue((dArray.length == 2 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[0] == 13.8 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[1] == 12.2 ? 1 : 0) != 0);
        lensedDataMatrix.enableAllRows();
        double[][] dArray2 = lensedDataMatrix.get();
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getRowCount() == 4 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnCount() == 2 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray2.length == 4 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray2[0].length == 2 ? 1 : 0) != 0);
        lensedDataMatrix.clear();
        lensedDataMatrix.enableAllRows();
        dArray = lensedDataMatrix.get(0);
        LensedDataMatrixTest.assertTrue((dArray.length == 3 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[0] == 12.2 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[1] == 13.8 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[2] == 4.0 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[0] == dataMatrix.get(0, 0) ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[1] == dataMatrix.get(0, 1) ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[2] == dataMatrix.get(0, 2) ? 1 : 0) != 0);
    }

    public void testGetDataWithOrderingAndEnabling_2() throws Exception {
        System.out.println("testGetDataWithOrderingAndEnabling_2");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://simpleMatrix.txt");
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix dataMatrix = ((DataMatrixReader)dataMatrixFileReader).get();
        String string2 = dataMatrix.toString();
        String string3 = "gene\tcond0\tcond1\tcond2\na\t12.2\t13.8\t4.0\nb\t-1.2\t-8.0\t-32.3333\nc\t0.0\t0.0\t0.0\nd\t999.0\t99.0\t9.0\n";
        LensedDataMatrix lensedDataMatrix = new LensedDataMatrix(dataMatrix);
        lensedDataMatrix.enableAllColumns();
        lensedDataMatrix.enableAllRows();
        lensedDataMatrix.changeColumnPosition(2, 0);
        lensedDataMatrix.changeColumnPosition(2, 1);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnOrder(0) == 2 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnOrder(1) == 1 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnOrder(2) == 0 ? 1 : 0) != 0);
        double[] dArray = lensedDataMatrix.get(0);
        LensedDataMatrixTest.assertTrue((dArray[0] == 4.0 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[1] == 13.8 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[2] == 12.2 ? 1 : 0) != 0);
        lensedDataMatrix.setColumnState(0, true);
        lensedDataMatrix.setColumnState(1, false);
        dArray = lensedDataMatrix.get(0);
        LensedDataMatrixTest.assertTrue((dArray[0] == 4.0 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[1] == 12.2 ? 1 : 0) != 0);
    }

    public void testGetDataWithOrderingAndEnabling_3() throws Exception {
        System.out.println("testGetDataWithOrderingAndEnabling_3");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://simpleMatrix.txt");
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix dataMatrix = ((DataMatrixReader)dataMatrixFileReader).get();
        String string2 = dataMatrix.toString();
        String string3 = "gene\tcond0\tcond1\tcond2\na\t12.2\t13.8\t4.0\nb\t-1.2\t-8.0\t-32.3333\nc\t0.0\t0.0\t0.0\nd\t999.0\t99.0\t9.0\n";
        LensedDataMatrix lensedDataMatrix = new LensedDataMatrix(dataMatrix);
        lensedDataMatrix.enableAllRows();
        double[] dArray = lensedDataMatrix.get(0);
        LensedDataMatrixTest.assertTrue((dArray[0] == 12.2 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[1] == 13.8 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[2] == 4.0 ? 1 : 0) != 0);
        lensedDataMatrix.changeColumnPosition(2, 1);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnOrder(0) == 0 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnOrder(1) == 2 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnOrder(2) == 1 ? 1 : 0) != 0);
        dArray = lensedDataMatrix.get(0);
        LensedDataMatrixTest.assertTrue((dArray[0] == 12.2 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[1] == 4.0 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[2] == 13.8 ? 1 : 0) != 0);
        lensedDataMatrix.changeColumnPosition(0, 1);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnOrder(0) == 2 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnOrder(1) == 0 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnOrder(2) == 1 ? 1 : 0) != 0);
        dArray = lensedDataMatrix.get(0);
        LensedDataMatrixTest.assertTrue((dArray[0] == 4.0 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[1] == 12.2 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dArray[2] == 13.8 ? 1 : 0) != 0);
    }

    public void testColumnTitleLensing() throws Exception {
        System.out.println("testColumnTitleLensing");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://simpleMatrix.txt");
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix dataMatrix = ((DataMatrixReader)dataMatrixFileReader).get();
        String string2 = dataMatrix.toString();
        String string3 = "gene\tcond0\tcond1\tcond2\na\t12.2\t13.8\t4.0\nb\t-1.2\t-8.0\t-32.3333\nc\t0.0\t0.0\t0.0\nd\t999.0\t99.0\t9.0\n";
        LensedDataMatrix lensedDataMatrix = new LensedDataMatrix(dataMatrix);
        lensedDataMatrix.enableAllColumns();
        lensedDataMatrix.enableAllRows();
        String[] stringArray = lensedDataMatrix.getColumnTitles();
        LensedDataMatrixTest.assertTrue((stringArray.length == 3 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((boolean)stringArray[0].equals("cond0"));
        LensedDataMatrixTest.assertTrue((boolean)stringArray[1].equals("cond1"));
        LensedDataMatrixTest.assertTrue((boolean)stringArray[2].equals("cond2"));
        lensedDataMatrix.setColumnState(1, false);
        String[] stringArray2 = lensedDataMatrix.getColumnTitles();
        LensedDataMatrixTest.assertTrue((stringArray2.length == 2 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((boolean)stringArray2[0].equals("cond0"));
        LensedDataMatrixTest.assertTrue((boolean)stringArray2[1].equals("cond2"));
        lensedDataMatrix.setColumnState(1, true);
        lensedDataMatrix.changeColumnPosition(1, 0);
        String[] stringArray3 = lensedDataMatrix.getColumnTitles();
        LensedDataMatrixTest.assertTrue((stringArray3.length == 3 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((boolean)stringArray3[0].equals("cond1"));
        LensedDataMatrixTest.assertTrue((boolean)stringArray3[1].equals("cond0"));
        LensedDataMatrixTest.assertTrue((boolean)stringArray3[2].equals("cond2"));
        lensedDataMatrix.changeColumnPosition(2, 1);
        String[] stringArray4 = lensedDataMatrix.getColumnTitles();
        LensedDataMatrixTest.assertTrue((stringArray4.length == 3 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((boolean)stringArray4[0].equals("cond1"));
        LensedDataMatrixTest.assertTrue((boolean)stringArray4[1].equals("cond2"));
        LensedDataMatrixTest.assertTrue((boolean)stringArray4[2].equals("cond0"));
        lensedDataMatrix.setColumnState(1, false);
        String[] stringArray5 = lensedDataMatrix.getColumnTitles();
        LensedDataMatrixTest.assertTrue((stringArray5.length == 2 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((boolean)stringArray5[0].equals("cond1"));
        LensedDataMatrixTest.assertTrue((boolean)stringArray5[1].equals("cond0"));
        String string4 = lensedDataMatrix.toString();
        String string5 = "gene\tcond1\tcond0\na\t13.8\t12.2\nb\t-8.0\t-1.2\nc\t0.0\t0.0\nd\t99.0\t999.0\n";
        LensedDataMatrixTest.assertTrue((boolean)string5.equals(string4));
    }

    public void testRowSelection() throws Exception {
        System.out.println("testRowSelection");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://simpleMatrix.txt");
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix dataMatrix = ((DataMatrixReader)dataMatrixFileReader).get();
        LensedDataMatrix lensedDataMatrix = new LensedDataMatrix(dataMatrix);
        lensedDataMatrix.disableAllRows();
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getRowCount() == 0 ? 1 : 0) != 0);
        lensedDataMatrix.enableRows(new int[]{3, 1});
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.adjustRowIndexForRowState(0) == 1 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.adjustRowIndexForRowState(1) == 3 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getRowCount() == 2 ? 1 : 0) != 0);
        DataMatrix dataMatrix2 = lensedDataMatrix.getUnderlyingMatrix();
        LensedDataMatrixTest.assertTrue((dataMatrix2.getRowCount() == 4 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.get(0, 2) == -32.3333 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnCount() == 3 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnCount() == lensedDataMatrix.getColumnTitles().length ? 1 : 0) != 0);
        lensedDataMatrix.setColumnState(1, false);
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.getColumnCount() == 2 ? 1 : 0) != 0);
        Object[] objectArray = lensedDataMatrix.getColumnTitles();
        LensedDataMatrixTest.assertTrue((objectArray.length == 2 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((boolean)Arrays.equals(objectArray, new String[]{"cond0", "cond2"}));
        LensedDataMatrixTest.assertTrue((lensedDataMatrix.get(0, 1) == -32.3333 ? 1 : 0) != 0);
        String[] stringArray = lensedDataMatrix.getRowTitles();
        LensedDataMatrixTest.assertTrue((stringArray.length == lensedDataMatrix.getRowCount() ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((boolean)stringArray[0].equals("b"));
        LensedDataMatrixTest.assertTrue((boolean)stringArray[1].equals("d"));
        String string2 = "gene\tcond0\tcond2\nb\t-1.2\t-32.3333\nd\t999.0\t9.0\n";
        DataMatrix dataMatrix3 = lensedDataMatrix.getVisibleMatrix();
        LensedDataMatrixTest.assertTrue((boolean)dataMatrix3.toString().equals(string2));
        String string3 = lensedDataMatrix.toString();
        LensedDataMatrixTest.assertTrue((boolean)string3.equals(string2));
    }

    public void testGetVisibleMatrix() throws Exception {
        System.out.println("testGetVisibleMatrix");
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader("file://simpleMatrix.txt");
        ((DataMatrixReader)dataMatrixFileReader).read();
        DataMatrix dataMatrix = ((DataMatrixReader)dataMatrixFileReader).get();
        String string2 = dataMatrix.toString();
        String string3 = "gene\tcond0\tcond1\tcond2\na\t12.2\t13.8\t4.0\nb\t-1.2\t-8.0\t-32.3333\nc\t0.0\t0.0\t0.0\nd\t999.0\t99.0\t9.0\n";
        LensedDataMatrix lensedDataMatrix = new LensedDataMatrix(dataMatrix);
        lensedDataMatrix.enableAllRows();
        lensedDataMatrix.enableAllColumns();
        DataMatrix dataMatrix2 = lensedDataMatrix.getVisibleMatrix();
        LensedDataMatrixTest.assertTrue((boolean)dataMatrix.equals(dataMatrix2));
        lensedDataMatrix.disableAllRows();
        lensedDataMatrix.enableRows(new int[]{1, 2});
        DataMatrix dataMatrix3 = lensedDataMatrix.getVisibleMatrix();
        LensedDataMatrixTest.assertTrue((dataMatrix3.getRowCount() == 2 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dataMatrix3.getColumnCount() == 3 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((boolean)Arrays.equals(dataMatrix3.getRowTitles(), new String[]{"b", "c"}));
        LensedDataMatrixTest.assertTrue((boolean)Arrays.equals(dataMatrix3.getColumnTitles(), new String[]{"cond0", "cond1", "cond2"}));
        LensedDataMatrixTest.assertTrue((boolean)Arrays.equals(dataMatrix3.get(0), new double[]{-1.2, -8.0, -32.3333}));
        LensedDataMatrixTest.assertTrue((boolean)Arrays.equals(dataMatrix3.get(1), new double[]{0.0, 0.0, 0.0}));
        lensedDataMatrix.setColumnState(0, false);
        DataMatrix dataMatrix4 = lensedDataMatrix.getVisibleMatrix();
        LensedDataMatrixTest.assertTrue((dataMatrix4.getRowCount() == 2 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((dataMatrix4.getColumnCount() == 2 ? 1 : 0) != 0);
        LensedDataMatrixTest.assertTrue((boolean)Arrays.equals(dataMatrix4.getColumnTitles(), new String[]{"cond1", "cond2"}));
        LensedDataMatrixTest.assertTrue((boolean)Arrays.equals(dataMatrix4.get(0), new double[]{-8.0, -32.3333}));
        LensedDataMatrixTest.assertTrue((boolean)Arrays.equals(dataMatrix4.get(1), new double[]{0.0, 0.0}));
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)new TestSuite(class$csplugins$isb$pshannon$experiment$datamatrix$unitTests$LensedDataMatrixTest == null ? (class$csplugins$isb$pshannon$experiment$datamatrix$unitTests$LensedDataMatrixTest = LensedDataMatrixTest.class$("csplugins.isb.pshannon.experiment.datamatrix.unitTests.LensedDataMatrixTest")) : class$csplugins$isb$pshannon$experiment$datamatrix$unitTests$LensedDataMatrixTest));
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

