/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.datamatrix;

import csplugins.isb.pshannon.experiment.datamatrix.DataMatrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class MatrixCombiner {
    DataMatrix[] matrices;
    String[] newColumnTitles;
    String[] newRowTitles;
    HashMap columnTitleHash;
    HashMap rowTitleHash;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MatrixCombiner(DataMatrix[] dataMatrixArray) {
        this.matrices = dataMatrixArray;
        this.newColumnTitles = this.createNonRedundantTitleList("column");
        this.newRowTitles = this.createNonRedundantTitleList("row");
        this.columnTitleHash = this.createTitleHash(this.newColumnTitles);
        this.rowTitleHash = this.createTitleHash(this.newRowTitles);
    }

    public DataMatrix combine() {
        DataMatrix dataMatrix = new DataMatrix();
        dataMatrix.setSize(this.newRowTitles.length, this.newColumnTitles.length);
        dataMatrix.setRowTitles(this.newRowTitles);
        dataMatrix.setRowTitlesTitle(this.matrices[0].getRowTitlesTitle());
        dataMatrix.setColumnTitles(this.newColumnTitles);
        dataMatrix.setDefault(Double.NaN);
        for (int i = 0; i < this.matrices.length; ++i) {
            DataMatrix dataMatrix2 = this.matrices[i];
            double[][] dArray = dataMatrix2.get();
            for (int j = 0; j < dataMatrix2.getRowCount(); ++j) {
                for (int k = 0; k < dataMatrix2.getColumnCount(); ++k) {
                    int[] nArray = this.newIndices(dataMatrix2, j, k);
                    double d = dArray[j][k];
                    dataMatrix.set(nArray[0], nArray[1], d);
                }
            }
        }
        return dataMatrix;
    }

    protected int[] newIndices(DataMatrix dataMatrix, int n, int n2) {
        String string2 = dataMatrix.getRowTitles()[n];
        String string3 = dataMatrix.getColumnTitles()[n2];
        int n3 = (Integer)this.rowTitleHash.get(string2);
        int n4 = (Integer)this.columnTitleHash.get(string3);
        return new int[]{n3, n4};
    }

    protected String[] createNonRedundantTitleList(String string2) {
        if (!($assertionsDisabled || string2.equals("row") || string2.equals("column"))) {
            throw new AssertionError();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.matrices.length; ++i) {
            DataMatrix dataMatrix = this.matrices[i];
            String[] stringArray = string2.equals("row") ? dataMatrix.getRowTitles() : dataMatrix.getColumnTitles();
            for (int j = 0; j < stringArray.length; ++j) {
                String string3 = stringArray[j];
                if (arrayList.contains(string3)) continue;
                arrayList.add(string3);
            }
        }
        Object[] objectArray = arrayList.toArray(new String[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public HashMap createTitleHash(String[] stringArray) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], new Integer(i));
        }
        return hashMap;
    }

    protected DataMatrix createEmptyMatrix(String[] stringArray) {
        DataMatrix dataMatrix = new DataMatrix();
        dataMatrix.setSize(0, stringArray.length);
        dataMatrix.setColumnTitles(stringArray);
        return dataMatrix;
    }

    static {
        $assertionsDisabled = !MatrixCombiner.class.desiredAssertionStatus();
    }
}

