/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment;

import csplugins.isb.pshannon.experiment.ExperimentRepository;
import csplugins.isb.pshannon.experiment.datamatrix.DataMatrix;
import csplugins.isb.pshannon.experiment.metadata.DataSetDescription;
import csplugins.isb.pshannon.experiment.metadata.MetaData;
import csplugins.isb.pshannon.experiment.readers.DataMatrixFileReader;
import csplugins.isb.pshannon.experiment.readers.MetaDataXmlParser;
import csplugins.isb.pshannon.experiment.readers.TextHttpIndirectFileReader;
import java.io.File;
import java.io.IOException;

public class HttpIndirectRepository
extends ExperimentRepository {
    TextHttpIndirectFileReader indirectReader;

    public HttpIndirectRepository(String string2, String string3, String string4) throws Exception {
        this(string2, string3, string4, false);
    }

    public HttpIndirectRepository(String string2, String string3, String string4, boolean bl) throws Exception {
        super(string2, bl);
        this.indirectReader = new TextHttpIndirectFileReader(string2, string3, string4, bl);
    }

    public HttpIndirectRepository(String string2) throws Exception {
        this(string2, null, null);
    }

    public String[] getExperimentNames() throws Exception {
        int n = this.indirectReader.read(this.uri);
        String string2 = this.indirectReader.getText();
        String[] stringArray = string2.split("\n");
        if (stringArray.length == 1 && stringArray[0].trim().length() == 0) {
            return new String[0];
        }
        return stringArray;
    }

    public MetaData getMetaData(String string2) throws Exception {
        int n;
        String string3 = this.protocol + "://" + this.path + "/" + string2;
        try {
            n = this.indirectReader.read(string3);
        }
        catch (Exception exception) {
            throw new IOException("HttpIndirectRepository.getMetaData failed to read " + string3);
        }
        if (this.debug) {
            System.err.println("HttpIndirectRepository, bytes read: " + n);
        }
        File file = this.indirectReader.writeToTemporaryFile();
        MetaDataXmlParser metaDataXmlParser = new MetaDataXmlParser(file.getPath());
        MetaData metaData = metaDataXmlParser.getMetaData();
        if (!this.debug) {
            file.delete();
        }
        return metaData;
    }

    public DataMatrix getDataSet(DataSetDescription dataSetDescription) throws Exception {
        int n;
        String string2 = dataSetDescription.getUri();
        try {
            n = this.indirectReader.read(string2);
        }
        catch (Exception exception) {
            throw new IOException("HttpIndirectRepository.getDataSet failed to read " + string2);
        }
        if (this.debug) {
            System.err.println("HttpIndirectRepository.getDataSet, bytes read: " + n);
        }
        File file = this.indirectReader.writeToTemporaryFile();
        DataMatrixFileReader dataMatrixFileReader = new DataMatrixFileReader(file.getPath());
        dataMatrixFileReader.read();
        DataMatrix dataMatrix = dataMatrixFileReader.get();
        if (!this.debug) {
            file.delete();
        }
        return dataMatrix;
    }
}

