/*
 * Decompiled with CFR 0.152.
 */
package djr.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class MakeJarRunnable {
    public static void main(String[] args) throws IOException {
        JarEntry entry;
        Attributes a;
        String oldMainClass;
        JarInputStream jarIn;
        Manifest manifest;
        if (args.length != 3) {
            System.out.println("Usage: MakeJarRunnable <jar file> <Main-Class> <output>");
            System.exit(0);
        }
        if ((manifest = (jarIn = new JarInputStream(new FileInputStream(args[0]))).getManifest()) == null) {
            manifest = new Manifest();
        }
        if ((oldMainClass = (a = manifest.getMainAttributes()).putValue("Main-Class", args[1])) != null) {
            System.out.println("Warning: old Main-Class value is: " + oldMainClass);
            System.exit(1);
        }
        System.out.println("Writing to " + args[2] + "...");
        JarOutputStream jarOut = new JarOutputStream((OutputStream)new FileOutputStream(args[2]), manifest);
        byte[] buf = new byte[4096];
        while ((entry = jarIn.getNextJarEntry()) != null) {
            int read;
            if ("META-INF/MANIFEST.MF".equals(entry.getName())) continue;
            jarOut.putNextEntry(entry);
            while ((read = jarIn.read(buf)) != -1) {
                jarOut.write(buf, 0, read);
            }
            jarOut.closeEntry();
        }
        jarOut.flush();
        jarOut.close();
        jarIn.close();
    }
}

