/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Vector;

public class Exec {
    String[] cmd;
    Vector stdoutResults;
    Vector stderrResults;
    String stringToSendToStandardInput;
    boolean runInBackground = false;
    String stdout;
    String stderr;

    public Exec() {
        this((String[])null);
    }

    public Exec(String cmd) {
        this(new String[]{cmd});
    }

    public Exec(String[] cmd) {
        this.cmd = cmd;
        this.stdoutResults = new Vector(100);
        this.stderrResults = new Vector(10);
    }

    public void setStandardInput(String input) {
        this.stringToSendToStandardInput = input;
    }

    public void setRunInBackground(boolean newValue) {
        this.runInBackground = newValue;
        int length = this.cmd.length;
        String[] revisedCmd = new String[length + 1];
        for (int i = 0; i < length; ++i) {
            revisedCmd[i] = this.cmd[i];
        }
        revisedCmd[length] = " &";
        this.cmd = revisedCmd;
    }

    public String getCmd() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.cmd.length; ++i) {
            sb.append(this.cmd[i]);
            sb.append(" ");
        }
        return sb.toString();
    }

    public int run() {
        int execExitValue = -1;
        StringBuffer cmdSB = new StringBuffer();
        for (int i = 0; i < this.cmd.length; ++i) {
            cmdSB.append(this.cmd[i]);
            cmdSB.append(" ");
        }
        try {
            String stderrResult;
            String stdoutResult;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(cmdSB.toString());
            BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader stderrReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            if (this.stringToSendToStandardInput != null) {
                PrintStream stdinWriter = new PrintStream(process.getOutputStream(), true);
                stdinWriter.print(this.stringToSendToStandardInput);
                stdinWriter.close();
            }
            try {
                execExitValue = process.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while ((stdoutResult = stdoutReader.readLine()) != null) {
                this.stdoutResults.addElement(stdoutResult);
            }
            while ((stderrResult = stderrReader.readLine()) != null) {
                this.stderrResults.addElement(stderrResult);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return execExitValue;
    }

    public int runThreaded() throws Exception {
        int execExitValue = -1;
        StringBuffer cmdSB = new StringBuffer();
        for (int i = 0; i < this.cmd.length; ++i) {
            cmdSB.append(this.cmd[i]);
            cmdSB.append(" ");
        }
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(cmdSB.toString());
        final BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        final BufferedReader stderrReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        final StringBuffer stdoutSB = new StringBuffer();
        final StringBuffer stderrSB = new StringBuffer();
        Thread stdoutReadingThread = new Thread(){

            public void run() {
                try {
                    String s;
                    while ((s = stdoutReader.readLine()) != null) {
                        stdoutSB.append(s + "\n");
                    }
                }
                catch (Exception exc0) {
                    System.out.println("--- error: " + exc0.getMessage());
                    exc0.printStackTrace();
                }
            }
        };
        Thread stderrReadingThread = new Thread(){

            public void run() {
                try {
                    String s;
                    while ((s = stderrReader.readLine()) != null) {
                        stderrSB.append(s + "\n");
                    }
                }
                catch (Exception exc1) {
                    System.out.println("--- error: " + exc1.getMessage());
                    exc1.printStackTrace();
                }
            }
        };
        stdoutReadingThread.start();
        stderrReadingThread.start();
        execExitValue = process.waitFor();
        this.stdout = stdoutSB.toString();
        this.stderr = stderrSB.toString();
        return execExitValue;
    }

    public Vector getStdout() {
        return this.stdoutResults;
    }

    public Vector getStderr() {
        return this.stderrResults;
    }

    public String getStdoutAsString() {
        return this.stdout;
    }

    public String getStderrAsString() {
        return this.stderr;
    }
}

