/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata.handlers.sbeams;

import csplugins.isb.dreiss.httpdata.handlers.db.DBSynonymHandler;
import csplugins.isb.dreiss.httpdata.handlers.sbeams.SBEAMSDataHandler;
import csplugins.isb.dreiss.httpdata.xmlrpc.MyXmlRpcServer;
import java.util.Map;
import java.util.Vector;

public class SBEAMSSynonymHandler
extends SBEAMSDataHandler {
    public static final String serviceName = "synonym";
    protected static DBSynonymHandler synonymHandler = null;

    public SBEAMSSynonymHandler() throws Exception {
    }

    public SBEAMSSynonymHandler(String userName, String password) throws Exception {
        super(userName, password);
    }

    static DBSynonymHandler getDBSynonymHandler() throws Exception {
        if (synonymHandler != null) {
            return synonymHandler;
        }
        synonymHandler = new DBSynonymHandler("synonyms");
        return synonymHandler;
    }

    public boolean put(String name1, String name2, String species) throws Exception {
        return SBEAMSSynonymHandler.getDBSynonymHandler().put(name1, name2, species);
    }

    public boolean putSynonymsString(String name, String strng, String species) throws Exception {
        return SBEAMSSynonymHandler.getDBSynonymHandler().putSynonymsString(name, strng, species);
    }

    public Vector getSynonyms(String name1, String species) throws Exception {
        Vector<String> list = new Vector<String>();
        try {
            name1 = this.preprocessName(name1);
            String synString = this.getSynonymsString(name1, species);
            if ("|".equals(synString)) {
                throw new Exception("get outta here");
            }
            if (!this.isSubstringAValidDescriptor(synString.toUpperCase(), name1.toUpperCase())) {
                throw new Exception("get outta here");
            }
            String[] toks = synString.split("\\|");
            for (int i = 0; i < toks.length; ++i) {
                String ttok;
                String tok = toks[i].trim();
                if (tok.endsWith(",") || tok.endsWith(";")) {
                    tok = tok.substring(0, tok.length() - 1);
                }
                if (i > 0 && toks[i - 1].trim().equals("gi")) {
                    tok = "GI" + tok;
                }
                if (tok.length() > 3 && !tok.equalsIgnoreCase(name1) && !list.contains(tok)) {
                    list.add(tok);
                }
                if (tok.indexOf(32) <= 0) continue;
                String[] ttoks = tok.split(" ");
                for (int j = 0; j < ttoks.length; ++j) {
                    String ttok2 = ttoks[j].trim();
                    if (!ttok2.equals("") && ttok2.indexOf(58) > 0) {
                        String ntok;
                        if (ttok2.endsWith(",") || ttok2.endsWith(";")) {
                            ttok2 = ttok2.substring(0, ttok2.length() - 1);
                        }
                        if (ttok2.length() > 3 && !ttok2.equalsIgnoreCase(name1) && !list.contains(ttok2)) {
                            list.add(ttok2);
                        }
                        if ((ntok = ttok2.substring(ttok2.indexOf(58) + 1)).length() <= 3 || ntok.equalsIgnoreCase(name1) || list.contains(ntok)) continue;
                        list.add(ntok);
                        continue;
                    }
                    if (!ttok2.startsWith("/") || ttok2.startsWith("/len=") || ttok2.startsWith("/clone_end")) continue;
                    if (ttok2.startsWith("/gb=")) {
                        ttok2 = ttok2.substring("/gb=".length());
                    } else if (ttok2.startsWith("/gi=")) {
                        ttok2 = "GI" + ttok2.substring("/gi=".length());
                    } else if (ttok2.startsWith("/ug=")) {
                        ttok2 = ttok2.substring("/ug=".length());
                    }
                    if (tok.startsWith("/") || ttok2.length() <= 3 || ttok2.equalsIgnoreCase(name1) || list.contains(ttok2)) continue;
                    list.add(ttok2);
                }
                String taxID = "Tax_Id=9606";
                int ind = tok.indexOf(taxID);
                if (ind > 0 && ind + taxID.length() < tok.length() - 3) {
                    ttok = tok.substring(ind + taxID.length() + 1);
                    if (ttok.endsWith(",") || ttok.endsWith(";")) {
                        ttok = ttok.substring(0, ttok.length() - 1);
                    }
                    if (ttok.length() > 3 && !ttok.equalsIgnoreCase(name1) && !list.contains(ttok)) {
                        list.add(ttok);
                    }
                }
                if (tok.indexOf(" /") <= 0) continue;
                ttok = tok.substring(0, tok.indexOf(" /"));
                if (ttok.endsWith(",") || ttok.endsWith(";")) {
                    ttok = ttok.substring(0, ttok.length() - 1);
                }
                if (ttok.length() <= 3 || ttok.equalsIgnoreCase(name1) || list.contains(ttok)) continue;
                list.add(ttok);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return list;
    }

    public Vector getSynonyms(Vector names, String species) throws Exception {
        Vector<Vector> out = new Vector<Vector>();
        int sz = names.size();
        for (int i = 0; i < sz; ++i) {
            out.add(this.getSynonyms((String)names.get(i), species));
        }
        return out;
    }

    public Vector getSynonyms(Vector names, Vector species) throws Exception {
        Vector<Vector> out = new Vector<Vector>();
        int sz = names.size();
        for (int i = 0; i < sz; ++i) {
            out.add(this.getSynonyms((String)names.get(i), (String)species.get(i)));
        }
        return out;
    }

    public String getSynonymsString(String name, String species) throws Exception {
        String table;
        if ("".equals(name)) {
            return "";
        }
        name = this.preprocessName(name);
        String test = SBEAMSSynonymHandler.getDBSynonymHandler().getSynonymsString(name, species);
        if (test.indexOf("UNKNOWN") >= 0) {
            return "";
        }
        if (!"".equals(test)) {
            return test;
        }
        if (name.startsWith("gi|")) {
            test = SBEAMSSynonymHandler.getDBSynonymHandler().getSynonymsString("GI" + name.substring(3), species);
            if (test.indexOf("UNKNOWN") >= 0) {
                return "";
            }
            if (!"".equals(test)) {
                return test;
            }
        }
        if ((table = (String)speciesToTableMap.get(species)) == null) {
            return "";
        }
        Map[] parsedAndParams = this.getClientResponse(name, table);
        Map parsed = parsedAndParams[0];
        String out = "|";
        Vector names = (Vector)parsed.get("biosequence_name");
        if (names.size() <= 0) {
            Map params = parsedAndParams[1];
            params.remove("biosequence_name_constraint");
            params.put("biosequence_desc_constraint", "%" + name + "%");
            String response = this.client.getResponse("https://db.systemsbiology.net/sbeams/cgi/Proteomics/BrowseBioSequence.cgi", params);
            parsed = this.client.parseResponse(response);
            names = (Vector)parsed.get("biosequence_name");
        }
        for (int i = 0; i < names.size(); ++i) {
            String gname = (String)names.get(i);
            if (gname != null && gname.length() > 3 && out.indexOf(gname + "|") < 0) {
                out = out + gname + "|";
            }
            if (parsed.get("gene_name") != null && (gname = (String)((Vector)parsed.get("gene_name")).get(i)) != null && gname.length() > 3 && out.indexOf(gname + "|") < 0) {
                out = out + gname + "|";
            }
            if (parsed.get("biosequence_gene_name") != null && (gname = (String)((Vector)parsed.get("biosequence_gene_name")).get(i)) != null && gname.length() > 3 && out.indexOf(gname + "|") < 0) {
                out = out + gname + "|";
            }
            if (parsed.get("biosequence_desc") == null || (gname = (String)((Vector)parsed.get("biosequence_desc")).get(i)) == null || gname.length() <= 3 || out.indexOf(gname + "|") >= 0) continue;
            out = out + gname + "|";
        }
        if (!"".equals(out) && !"|".equals(out)) {
            if (out.toUpperCase().indexOf("|" + name.toUpperCase() + "|") < 0) {
                out = "|" + name + out;
            }
            this.putSynonymsString(name, out, species);
        } else {
            this.putSynonymsString(name, "|UNKNOWN|", species);
        }
        return out;
    }

    public Vector getSynonymsString(Vector names, String species) throws Exception {
        Vector<String> out = new Vector<String>();
        int sz = names.size();
        for (int i = 0; i < sz; ++i) {
            out.add(this.getSynonymsString((String)names.get(i), species));
        }
        return out;
    }

    public Vector getSynonymsString(Vector names, Vector species) throws Exception {
        Vector<String> out = new Vector<String>();
        int sz = names.size();
        for (int i = 0; i < sz; ++i) {
            out.add(this.getSynonymsString((String)names.get(i), (String)species.get(i)));
        }
        return out;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: java csplugins.httpdata.handlers.sbeams.SBEAMSSynonymHandler <port> [<UserName> <Password>]");
            System.exit(-1);
        }
        try {
            MyXmlRpcServer server = new MyXmlRpcServer(args);
            if (args.length > 1) {
                server.addService(serviceName, "csplugins.httpdata.handlers.sbeams.SBEAMSSynonymHandler", args[1], args[2]);
            } else {
                server.addService(serviceName, "csplugins.httpdata.handlers.sbeams.SBEAMSSynonymHandler");
            }
        }
        catch (Exception e) {
            System.err.println("Could not start server: " + e.getMessage());
        }
    }
}

