/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata.handlers.sbeams;

import csplugins.isb.dreiss.httpdata.handlers.db.DBSequenceHandler;
import csplugins.isb.dreiss.httpdata.handlers.sbeams.SBEAMSDataHandler;
import csplugins.isb.dreiss.httpdata.xmlrpc.MyXmlRpcServer;
import java.util.Map;
import java.util.Vector;

public class SBEAMSSequenceHandler
extends SBEAMSDataHandler {
    public static final String serviceName = "sequence";
    public static DBSequenceHandler sequenceHandler = null;

    public SBEAMSSequenceHandler() throws Exception {
    }

    public SBEAMSSequenceHandler(String userName, String password) throws Exception {
        super(userName, password);
    }

    static DBSequenceHandler getDBSequenceHandler() throws Exception {
        if (sequenceHandler != null) {
            return sequenceHandler;
        }
        sequenceHandler = new DBSequenceHandler("sequences");
        return sequenceHandler;
    }

    public boolean put(String name, String species, String sequence) throws Exception {
        return SBEAMSSequenceHandler.getDBSequenceHandler().put(name, species, sequence);
    }

    public boolean put(String name, String species, String sequence, String type) throws Exception {
        return SBEAMSSequenceHandler.getDBSequenceHandler().put(name, species, sequence, type);
    }

    public String get(String name, String species) throws Exception {
        return this.get(name, species, "protein");
    }

    public String get(String name, String species, String type) throws Exception {
        String seq = "";
        if ("".equals(name)) {
            return seq;
        }
        try {
            name = this.preprocessName(name);
            seq = SBEAMSSequenceHandler.getDBSequenceHandler().get(name, species, type);
            if (seq == null || "UNKNOWN".equals(seq)) {
                return "";
            }
            if (!"".equals(seq)) {
                return seq;
            }
            String table = (String)speciesToTableMap.get(species + " " + type);
            if (table == null) {
                return seq;
            }
            Map[] parsedAndParams = this.getClientResponse(name, table);
            Map parsed = parsedAndParams[0];
            if (((Vector)parsed.get("biosequence_seq")).size() > 0) {
                Vector names = (Vector)parsed.get("biosequence_name");
                int ind = this.getBestResponse(names, name);
                if (ind >= 0) {
                    seq = (String)((Vector)parsed.get("biosequence_seq")).get(ind);
                }
            } else {
                Vector names;
                int ind;
                Map params = parsedAndParams[1];
                params.remove("biosequence_name_constraint");
                params.put("biosequence_desc_constraint", "%" + name + "%");
                String response = this.client.getResponse("https://db.systemsbiology.net/sbeams/cgi/Proteomics/BrowseBioSequence.cgi", params);
                parsed = this.client.parseResponse(response);
                if (((Vector)parsed.get("biosequence_seq")).size() > 0 && (ind = this.getBestResponse(names = (Vector)parsed.get("biosequence_desc"), name)) >= 0) {
                    seq = (String)((Vector)parsed.get("biosequence_seq")).get(ind);
                }
            }
            if (!"".equals(seq)) {
                SBEAMSSequenceHandler.getDBSequenceHandler().put(name, species, seq, type);
            } else {
                SBEAMSSequenceHandler.getDBSequenceHandler().put(name, species, "UNKNOWN", type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return seq;
    }

    public Vector get(Vector names, String species) throws Exception {
        return this.get(names, species, "protein");
    }

    public Vector get(Vector names, String species, String type) throws Exception {
        Vector<String> out = new Vector<String>();
        int sz = names.size();
        for (int i = 0; i < sz; ++i) {
            out.add(this.get((String)names.get(i), species, type));
        }
        return out;
    }

    public Vector get(Vector names, Vector species) throws Exception {
        return this.get(names, species, "protein");
    }

    public Vector get(Vector names, Vector species, String type) throws Exception {
        Vector<String> out = new Vector<String>();
        int sz = names.size();
        for (int i = 0; i < sz; ++i) {
            out.add(this.get((String)names.get(i), (String)species.get(i), type));
        }
        return out;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: java csplugins.httpdata.handlers.sbeams.SBEAMSSequenceHandler <port> <UserName> <Password>");
            System.exit(-1);
        }
        try {
            MyXmlRpcServer server = new MyXmlRpcServer(args);
            if (args.length > 1) {
                server.addService(serviceName, "csplugins.httpdata.handlers.sbeams.SBEAMSSequenceHandler", args[1], args[2]);
            } else {
                server.addService(serviceName, "csplugins.httpdata.handlers.sbeams.SBEAMSSequenceHandler");
            }
        }
        catch (Exception e) {
            System.err.println("Could not start server: " + e.getMessage());
        }
    }
}

