/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata.handlers.sbeams;

import csplugins.isb.dreiss.httpdata.handlers.sbeams.HttpsClient;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class SBEAMSClient
extends HttpsClient {
    String cookie = null;

    public SBEAMSClient() throws Exception {
        if (this.cookie == null) {
            String[] userPass = this.promptForUsernamePassword();
            this.cookie = SBEAMSClient.gimmieCookie(userPass[0], userPass[1]);
        }
    }

    public SBEAMSClient(String userName, String password) throws Exception {
        this.cookie = SBEAMSClient.gimmieCookie(userName, password);
    }

    public String getResponse(String url, String params) throws Exception {
        if (this.cookie == null) {
            String[] userPass = this.promptForUsernamePassword();
            this.cookie = SBEAMSClient.gimmieCookie(userPass[0], userPass[1]);
        }
        if (this.cookie != null) {
            if (params.indexOf("row_limit") < 0) {
                params = params + "&row+limit=20";
            }
            if (params.indexOf("output_mode=tsv") < 0) {
                params = params + "&output_mode=tsv";
            }
            if (params.indexOf("apply_action=QUERY") < 0) {
                params = params + "&apply_action=QUERY";
            }
            if (params.indexOf("action=QUERY") < 0) {
                params = params + "&action=QUERY";
            }
            HttpsClient.Resp res = SBEAMSClient.postRequest(url, params, this.cookie);
            return res.content;
        }
        throw new Exception("Got no cookie for sending request to SBEAMS");
    }

    public String getResponse(String url, Map params) throws Exception {
        StringBuffer out = new StringBuffer();
        if (params.get("row_limit") == null) {
            params.put("row_limit", "20");
        }
        if (params.get("output_mode") == null) {
            params.put("output_mode", "tsv");
        }
        if (params.get("apply_action") == null) {
            params.put("apply_action", "QUERY");
        }
        if (params.get("action") == null) {
            params.put("action", "QUERY");
        }
        Iterator it = params.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            out.append(key + "=");
            out.append(URLEncoder.encode((String)params.get(key), "UTF8"));
            out.append("&");
        }
        return this.getResponse(url, out.toString());
    }

    public Map parseResponse(String response) {
        int i;
        HashMap out = new HashMap();
        String[] lines = response.split("\n");
        String[] heads = lines[0].split("\t");
        for (i = 0; i < heads.length; ++i) {
            out.put(heads[i], new Vector());
        }
        for (i = 1; i < lines.length; ++i) {
            String[] toks = lines[i].split("\t");
            for (int j = 0; j < toks.length; ++j) {
                if (toks[j].startsWith("\"")) {
                    toks[j] = toks[j].substring(1);
                }
                if (toks[j].endsWith("\"")) {
                    toks[j] = toks[j].substring(0, toks[j].length() - 1);
                }
                ((Vector)out.get(heads[j])).add(toks[j]);
            }
        }
        return out;
    }

    protected String[] promptForUsernamePassword() {
        String line;
        BufferedReader stdin;
        String[] out = new String[2];
        System.out.print("Enter SBEAMS Username: ");
        try {
            stdin = new BufferedReader(new InputStreamReader(System.in));
            while ((line = stdin.readLine()) == null) {
            }
            out[0] = line;
        }
        catch (Exception e) {
            out[0] = "unknown";
        }
        System.out.print("Enter Password: ");
        try {
            stdin = new BufferedReader(new InputStreamReader(System.in));
            while ((line = stdin.readLine()) == null) {
            }
            out[1] = line;
        }
        catch (Exception e) {
            out[1] = "????????";
        }
        return out;
    }

    public static void main(String[] argv) throws Exception {
        String userName = argv.length >= 1 ? argv[0] : null;
        String password = argv.length >= 2 ? argv[1] : null;
        String url = "https://db.systemsbiology.net/sbeams/cgi/Proteomics/BrowseBioSequence.cgi";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("QUERY_NAME", "PR_BrowseBioSequence");
        params.put("row_limit", "20");
        params.put("biosequence_set_id", "14");
        params.put("biosequence_name_constraint", "YHL0%");
        SBEAMSClient client = userName != null ? new SBEAMSClient(userName, password) : new SBEAMSClient();
        String response = client.getResponse(url, params);
        System.out.println("RESPONSE: " + response);
        Map parsed = client.parseResponse(response);
        System.out.println("PARSED: " + parsed);
    }
}

