/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata.handlers.sbeams;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

public class HttpsClient {
    public static void main(String[] argv) throws Exception {
        String userName = argv[0];
        String password = argv[1];
        String url = "https://db.systemsbiology.net/sbeams/cgi/Proteomics/BrowseBioSequence.cgi";
        String params = "apply_action=QUERY&row_limit=20&QUERY_NAME=PR_BrowseBioSequence&biosequence_set_id=14&action=QUERY&biosequence_name_constraint=YHL040C%25&output_mode=tsv";
        String cookie = HttpsClient.gimmieCookie(userName, password);
        if (cookie != null) {
            System.out.println("Proceeding to POST with cookie: " + cookie);
            Resp res = HttpsClient.postRequest(url, params, cookie);
            System.out.println("Content-Type: " + res.contentType);
            System.out.println("Content:\n" + res.content);
        } else {
            System.out.println("Got no cookies");
        }
    }

    public static String gimmieCookie(String username, String password) throws Exception {
        String url = "https://db.systemsbiology.net/sbeams/cgi/main.cgi";
        StringBuffer params = new StringBuffer();
        params.append("username");
        params.append("=");
        params.append(URLEncoder.encode(username, "UTF8"));
        params.append("&");
        params.append("password");
        params.append("=");
        params.append(URLEncoder.encode(password, "UTF8"));
        params.append("&");
        params.append("login");
        params.append("=");
        params.append(URLEncoder.encode(" Login ", "UTF8"));
        Resp res = HttpsClient.postRequest(url, params.toString());
        return res.cookie;
    }

    public static Resp postRequest(String urlString, String params) throws Exception {
        String cookie = null;
        return HttpsClient.postRequest(urlString, params, cookie);
    }

    public static Resp postRequest(String urlString, String params, String cookie) throws Exception {
        String inputLine;
        URL url = new URL(urlString);
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        uc.setDoInput(true);
        uc.setDoOutput(true);
        uc.setUseCaches(false);
        uc.setAllowUserInteraction(false);
        uc.setRequestMethod("POST");
        uc.setRequestProperty("ContentType", "application/x-www-form-urlencoded");
        uc.setRequestProperty("User-Agent", "HelloThereEric");
        if (cookie != null) {
            uc.setRequestProperty("Cookie", cookie);
        }
        PrintStream out = new PrintStream(uc.getOutputStream());
        out.print(params);
        out.flush();
        out.close();
        uc.connect();
        StringBuffer sb = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(uc.getInputStream()));
        while ((inputLine = in.readLine()) != null) {
            sb.append(inputLine + "\n");
        }
        in.close();
        Resp res = new Resp();
        res.content = sb.toString();
        res.contentType = uc.getHeaderField("Content-Type");
        res.cookie = uc.getHeaderField("Set-Cookie");
        return res;
    }

    protected static class Resp {
        String contentType = null;
        String cookie = null;
        String content = null;

        protected Resp() {
        }
    }
}

