/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata.handlers.mysqldb;

import csplugins.isb.dreiss.httpdata.handlers.db.DBSynonymHandler;
import csplugins.isb.dreiss.httpdata.handlers.mysqldb.MySQLDBDataHandler;
import csplugins.isb.dreiss.httpdata.xmlrpc.MyXmlRpcServer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class MySQLDBSynonymHandler
extends DBSynonymHandler {
    public MySQLDBSynonymHandler(String dbURL, String tname) throws Exception {
        this.dbhandler = new MySQLDBDataHandler(dbURL, tname);
        this.tableName = tname;
    }

    public MySQLDBSynonymHandler(String tname) throws Exception {
        this.dbhandler = new MySQLDBDataHandler(tname);
        this.tableName = tname;
    }

    protected String createTable(String species) {
        String spec = species.replace(' ', '_');
        String table = this.tableName + "_" + spec;
        this.dbhandler.createTable(table, " ( id INT NOT NULL AUTO_INCREMENT, name VARCHAR(128) NOT NULL, synonyms TEXT, PRIMARY KEY (id), UNIQUE INDEX (name) )");
        return table;
    }

    public Vector getSynonyms(String name, String species) throws Exception {
        Vector out = super.getSynonyms(name, species);
        if (out == null || out.size() <= 0) {
            out = this.getSynonymsFromMasterTable(name);
            if (out != null && out.size() > 0) {
                String synString = "";
                for (int i = 0; i < out.size(); ++i) {
                    synString = synString + out.get(i) + "|";
                }
                this.putSynonymsString(name, synString, species);
            } else {
                this.putSynonymsString(name, "Unknown", species);
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Vector getSynonymsFromQuery(String query) throws Exception {
        Statement st;
        Vector list;
        block8: {
            if (this.dbhandler.debug()) {
                System.err.println("QUERY: " + query);
            }
            list = null;
            Connection conn = this.dbhandler.getConnection();
            st = null;
            ResultSet rs = null;
            try {
                try {
                    st = conn.createStatement();
                    rs = st.executeQuery(query);
                    ResultSetMetaData meta = rs.getMetaData();
                    list = this.parseSynonymsStrings(rs);
                }
                catch (Exception e) {
                    Object var8_9 = null;
                    if (rs != null) {
                        rs.close();
                    }
                    if (st == null) return list;
                    st.close();
                    return list;
                }
                Object var8_8 = null;
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (rs != null) {
                    rs.close();
                }
                if (st == null) throw throwable;
                st.close();
                throw throwable;
            }
            rs.close();
        }
        if (st == null) return list;
        st.close();
        return list;
    }

    public Vector getSynonymsFromMasterTable(String name) throws Exception {
        String table = "synonyms";
        String lookup = name;
        String temp = name.toUpperCase();
        if (temp.startsWith("NP_") || temp.startsWith("XP_") || temp.startsWith("NM_") || temp.startsWith("XM_")) {
            lookup = "ref:" + lookup;
        } else if (temp.startsWith("LOC")) {
            lookup = "loc:" + lookup.substring(3);
        } else if (temp.startsWith("GI") || temp.startsWith("GB")) {
            lookup = "gi:" + lookup.substring(2);
        } else if (temp.startsWith("HS.") || temp.startsWith("MM.") || temp.startsWith("DM.")) {
            lookup = "ug:" + lookup;
        }
        String query = "SELECT synonyms FROM " + table + " WHERE name = '" + lookup + "'";
        Vector list = this.getSynonymsFromQuery(query);
        if (list != null && list.size() > 0) {
            return list;
        }
        if (name.indexOf(58) >= 0) {
            name = name.substring(name.indexOf(58) + 1);
        }
        if (name.indexOf(61) >= 0) {
            name = name.substring(name.indexOf(61) + 1);
        }
        if (name.indexOf(124) >= 0) {
            name = name.substring(name.lastIndexOf(124) + 1);
        }
        if ((list = this.getSynonymsFromQuery(query = "SELECT synonyms FROM synonyms WHERE synonyms REGEXP '[=:;|]" + name + "[|;.]'")) == null) {
            list = new Vector();
        }
        return list;
    }

    protected Vector parseSynonymsStrings(ResultSet rs) throws Exception {
        Vector list = new Vector();
        HashMap<String, String> map = new HashMap<String, String>();
        while (rs.next()) {
            String val = (String)rs.getObject(1);
            if ("".equals(val)) continue;
            String[] toks = val.split("\\|");
            for (int i = 0; i < toks.length; ++i) {
                String tok = toks[i].trim();
                if ("".equals(tok)) continue;
                String key = tok.substring(0, tok.indexOf(61));
                String inMap = (String)map.get(key);
                if (inMap == null) {
                    map.put(key, tok);
                    continue;
                }
                String entry = tok.substring(tok.indexOf(61) + 1);
                map.remove(key);
                map.put(key, inMap + ";" + entry);
            }
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            list.add(map.get(it.next()));
        }
        return list;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: java csplugins.httpdata.handlers.mysqldb.MySQLDBSynonymHandler <port> <tableName>");
            System.exit(-1);
        }
        try {
            MyXmlRpcServer server = new MyXmlRpcServer(args);
            server.addService("synonym", "csplugins.httpdata.handlers.mysqldb.MySQLDBSynonymHandler", args[1]);
        }
        catch (Exception e) {
            System.err.println("Could not start server: " + e.getMessage());
        }
    }
}

