/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata.handlers.mysqldb;

import csplugins.isb.dreiss.httpdata.handlers.db.DBSequenceHandler;
import csplugins.isb.dreiss.httpdata.handlers.mysqldb.MySQLDBDataHandler;
import csplugins.isb.dreiss.httpdata.xmlrpc.MyXmlRpcServer;

public class MySQLDBSequenceHandler
extends DBSequenceHandler {
    public MySQLDBSequenceHandler(String dbURL, String tname) throws Exception {
        this.dbhandler = new MySQLDBDataHandler(dbURL, tname);
        this.tableName = tname;
    }

    public MySQLDBSequenceHandler(String tname) throws Exception {
        this.dbhandler = new MySQLDBDataHandler(tname);
        this.tableName = tname;
    }

    protected String createSequenceTable(String species, String type) {
        String spec = species.replace(' ', '_');
        String table = this.tableName + "_" + type + "_" + spec;
        this.dbhandler.createTable(table, " ( id INT NOT NULL AUTO_INCREMENT, name VARCHAR(128) NOT NULL, sequence TEXT NOT NULL, PRIMARY KEY (id), UNIQUE INDEX idxname (name) )");
        return table;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: java csplugins.httpdata.handlers.mysqldb.MySQLDBSequenceHandler <port> <tableName>");
            System.exit(-1);
        }
        try {
            MyXmlRpcServer server = new MyXmlRpcServer(args);
            server.addService("sequence", "csplugins.httpdata.handlers.mysqldb.MySQLDBSequenceHandler", args[1]);
        }
        catch (Exception e) {
            System.err.println("Could not start server: " + e.getMessage());
        }
    }
}

