/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata.handlers.mysqldb;

import csplugins.isb.dreiss.httpdata.handlers.db.DBInteractionHandler;
import csplugins.isb.dreiss.httpdata.handlers.mysqldb.MySQLDBDataHandler;
import csplugins.isb.dreiss.httpdata.xmlrpc.MyXmlRpcServer;

public class MySQLDBInteractionHandler
extends DBInteractionHandler {
    public MySQLDBInteractionHandler(String dbURL, String tname) throws Exception {
        this.dbhandler = new MySQLDBDataHandler(dbURL, tname);
        this.tableName = tname;
    }

    public MySQLDBInteractionHandler(String tname) throws Exception {
        this.dbhandler = new MySQLDBDataHandler(tname);
        this.tableName = tname;
    }

    protected String createInteractionTable(String species, String source) {
        String src;
        try {
            this.createSourcesTable();
        }
        catch (Exception e) {
            // empty catch block
        }
        String spec = species.replace(' ', '_');
        if ("".equals(spec)) {
            spec = "unknown_species";
        }
        if ("".equals(src = source.replace(' ', '_'))) {
            src = "unknown_source";
        }
        String table = this.tableName + "_" + src + "_" + spec;
        this.dbhandler.createTable(table, " ( id INT NOT NULL AUTO_INCREMENT, i1 VARCHAR(128) NOT NULL, itype VARCHAR(64) NOT NULL, i2 VARCHAR(128) NOT NULL, pval DOUBLE, info TEXT, PRIMARY KEY (id), UNIQUE INDEX (i1,itype,i2) )");
        return table;
    }

    protected void createSourcesTable() throws Exception {
        String table = "interaction_sources";
        if (this.dbhandler.createTable(table, " ( id INT NOT NULL AUTO_INCREMENT, source VARCHAR(64) NOT NULL, description VARCHAR(128) NOT NULL, PRIMARY KEY (id), UNIQUE INDEX (source,description) )")) {
            // empty if block
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: java csplugins.httpdata.handlers.mysqldb.MySQLDBInteractionHandler <port> <tableName>");
            System.exit(-1);
        }
        try {
            MyXmlRpcServer server = new MyXmlRpcServer(args);
            server.addService("interaction", "csplugins.httpdata.handlers.mysqldb.MySQLDBInteractionHandler", args[1]);
        }
        catch (Exception e) {
            System.err.println("Could not start server: " + e.getMessage());
        }
    }
}

