/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata.handlers.mysqldb;

import csplugins.isb.dreiss.httpdata.handlers.db.DBHomologHandler;
import csplugins.isb.dreiss.httpdata.handlers.mysqldb.MySQLDBDataHandler;
import csplugins.isb.dreiss.httpdata.xmlrpc.MyXmlRpcServer;

public class MySQLDBHomologHandler
extends DBHomologHandler {
    public MySQLDBHomologHandler(String dbURL, String tname) throws Exception {
        this.dbhandler = new MySQLDBDataHandler(dbURL, tname);
        this.tableName = tname;
    }

    public MySQLDBHomologHandler(String tname) throws Exception {
        this.dbhandler = new MySQLDBDataHandler(tname);
        this.tableName = tname;
    }

    protected String createHomologTable(String species, String hSpecies) throws Exception {
        try {
            this.createSpeciesTable();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (species.indexOf(32) < 0) {
            species = this.getSpeciesFullName(species);
        }
        if (hSpecies.indexOf(32) < 0) {
            hSpecies = this.getSpeciesFullName(hSpecies);
        }
        String spec = species.replace(' ', '_');
        String hspec = hSpecies.replace(' ', '_');
        String table = this.tableName + "_" + spec + "_" + hspec;
        this.dbhandler.createTable(table, " ( id INT NOT NULL AUTO_INCREMENT, prot VARCHAR(128) NOT NULL, homolog VARCHAR(128) NOT NULL, score DOUBLE, info TEXT, PRIMARY KEY (id), UNIQUE INDEX (PROT,HOMOLOG) )");
        return table;
    }

    protected void createSpeciesTable() throws Exception {
        String table = "homolog_species";
        this.dbhandler.createTable(table, " ( id INT NOT NULL AUTO_INCREMENT, spec VARCHAR(64) NOT NULL, fullname VARCHAR(128) NOT NULL, PRIMARY KEY (id), UNIQUE INDEX idx (SPEC,FULLNAME) )");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: java csplugins.httpdata.handlers.mysqldb.MySQLDBHomologHandler <port> <tableName>");
            System.exit(-1);
        }
        try {
            MyXmlRpcServer server = new MyXmlRpcServer(args);
            server.addService("homolog", "csplugins.httpdata.handlers.mysqldb.MySQLDBHomologHandler", args[1]);
        }
        catch (Exception e) {
            System.err.println("Could not start server: " + e.getMessage());
        }
    }
}

