/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata.handlers.mysqldb;

import csplugins.isb.dreiss.httpdata.handlers.db.DBFavoriteHomologHandler;
import csplugins.isb.dreiss.httpdata.handlers.mysqldb.MySQLDBDataHandler;
import csplugins.isb.dreiss.httpdata.xmlrpc.MyXmlRpcServer;

public class MySQLDBFavoriteHomologHandler
extends DBFavoriteHomologHandler {
    public MySQLDBFavoriteHomologHandler(String dbURL, String tname) {
        this.dbhandler = new MySQLDBDataHandler(dbURL, tname);
        this.tableName = tname;
    }

    public MySQLDBFavoriteHomologHandler(String tname) {
        this.dbhandler = new MySQLDBDataHandler(tname);
        this.tableName = tname;
    }

    protected String createTable(String species) {
        String spec = species.replace(' ', '_');
        String table = this.tableName + "_" + spec;
        this.dbhandler.createTable(table, " ( id INT NOT NULL AUTO_INCREMENT, user VARCHAR(32), source_sequence VARCHAR(128) NOT NULL, target_species VARCHAR(128) NOT NULL, target_sequence VARCHAR(128) NOT NULL, PRIMARY KEY (id), UNIQUE INDEX (user,source_sequence,target_species,target_sequence) )");
        return table;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: java csplugins.httpdata.handlers.mysqldb.MySQLDBFavoriteHomologHandler <port> <tableName>");
            System.exit(-1);
        }
        try {
            MyXmlRpcServer server = new MyXmlRpcServer(args);
            server.addService("favoriteHomolog", "csplugins.httpdata.handlers.mysqldb.MySQLDBFavoriteHomologHandler", args[1]);
        }
        catch (Exception e) {
            System.err.println("Could not start server: " + e.getMessage());
        }
    }
}

