/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata.handlers.db;

import csplugins.isb.dreiss.httpdata.handlers.db.DBDataHandler;
import csplugins.isb.dreiss.httpdata.xmlrpc.MyXmlRpcServer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Vector;

public class DBSynonymHandler {
    public static final String serviceName = "synonym";
    protected String tableName;
    protected DBDataHandler dbhandler;

    public DBSynonymHandler() {
    }

    public DBSynonymHandler(String tableName) throws Exception {
        this.dbhandler = new DBDataHandler(tableName);
        this.tableName = tableName;
    }

    protected String createTable(String species) {
        String spec = species.replace(' ', '_');
        String table = this.tableName + "_" + spec;
        this.dbhandler.createTable(table, " ( name VARCHAR NOT NULL, synonyms VARCHAR NOT NULL, CONSTRAINT UNIQUE_ID UNIQUE(name,synonyms) )");
        return table;
    }

    protected boolean createFullSynonymsTable() {
        return this.dbhandler.createTable("synonyms", " ( name VARCHAR NOT NULL, synonyms VARCHAR NOT NULL, CONSTRAINT UNIQUE_ID UNIQUE(name,synonyms) )");
    }

    public boolean addSynonym(String name1, String name2, String species) throws Exception {
        return this.put(name1, name2, species);
    }

    public boolean put(String name1, String name2, String species) throws Exception {
        String origName1 = name1.trim();
        String origName2 = name2.trim();
        if (name1.indexOf("'") >= 0) {
            name1 = name1.replaceAll("\\'", "\"");
        }
        if (name2.indexOf("'") >= 0) {
            name2 = name2.replaceAll("\\'", "\"");
        }
        if (origName1.indexOf(32) >= 0 || origName2.indexOf(32) >= 0) {
            return false;
        }
        name1 = origName1.toUpperCase();
        if (name1.equalsIgnoreCase(name2 = origName2.toUpperCase()) || "".equals(name1) || "".equals(name2)) {
            return false;
        }
        String table = this.createTable(species);
        String val = "";
        String query = "SELECT synonyms FROM " + table + " WHERE name = '" + name1 + "'";
        try {
            val = (String)this.dbhandler.query(query);
        }
        catch (Exception e) {
            val = "";
        }
        if (val == null || "".equals(val) || "null".equals(val)) {
            val = "|";
        }
        boolean update = !"|".equals(val);
        String origVal = new String(val);
        String ucVal = val.toUpperCase();
        if (ucVal.indexOf("|" + name1 + "|") < 0) {
            val = val + origName1 + "|";
        }
        if (ucVal.indexOf("|" + name2 + "|") < 0) {
            val = val + origName2 + "|";
        }
        val = val.replaceAll("\\'", "\"");
        if (!update) {
            query = "INSERT INTO " + table + " (name,synonyms) " + "VALUES ('" + name1 + "', '" + val + "')";
            try {
                this.dbhandler.update(query);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (!val.equals(origVal)) {
            query = "UPDATE " + table + " SET synonyms = '" + val + "' WHERE name = '" + name1 + "'";
            try {
                this.dbhandler.update(query);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean putSynonymsString(String name, String syns, String species) throws Exception {
        String table = this.createTable(species);
        if (name.indexOf("'") >= 0) {
            name = name.replaceAll("\\'", "\"");
        }
        if (syns.indexOf("'") >= 0) {
            syns = syns.replaceAll("\\'", "\"");
        }
        String query = "INSERT INTO " + table + " (name,synonyms) " + "VALUES ('" + name + "', '" + syns + "')";
        try {
            this.dbhandler.update(query);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public Vector getSynonyms(String name, String species) throws Exception {
        String table = this.createTable(species);
        String query = "SELECT synonyms FROM " + table + " WHERE name = '" + name + "'";
        if (this.dbhandler.debug()) {
            System.err.println("QUERY: " + query);
        }
        Vector<String> list = new Vector<String>();
        Connection conn = this.dbhandler.getConnection();
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(query);
            ResultSetMetaData meta = rs.getMetaData();
            while (rs.next()) {
                String val = (String)rs.getObject(1);
                if ("".equals(val)) continue;
                String[] toks = val.split("\\|");
                for (int i = 0; i < toks.length; ++i) {
                    String tok = toks[i].trim();
                    if ("".equals(tok) || this.isInvalidSynonym(tok) || tok.equalsIgnoreCase(name) || list.contains(tok)) continue;
                    list.add(tok);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return list;
    }

    public Vector getSynonyms(Vector names, String species) throws Exception {
        Vector<Vector> out = new Vector<Vector>();
        int sz = names.size();
        for (int i = 0; i < sz; ++i) {
            out.add(this.getSynonyms((String)names.get(i), species));
        }
        return out;
    }

    public Vector getSynonyms(Vector names, Vector species) throws Exception {
        Vector<Vector> out = new Vector<Vector>();
        int sz = names.size();
        for (int i = 0; i < sz; ++i) {
            out.add(this.getSynonyms((String)names.get(i), (String)species.get(i)));
        }
        return out;
    }

    public String getSynonymsString(String name, String species) throws Exception {
        String val = "";
        String table = this.createTable(species);
        String query = "SELECT synonyms FROM " + table + " WHERE name = '" + name + "'";
        try {
            val = (String)this.dbhandler.query(query);
        }
        catch (Exception e) {
            val = "";
        }
        if (val == null) {
            val = "";
        }
        return val;
    }

    public Vector getSynonymsString(Vector names, String species) throws Exception {
        Vector<String> out = new Vector<String>();
        int sz = names.size();
        for (int i = 0; i < sz; ++i) {
            out.add(this.getSynonymsString((String)names.get(i), species));
        }
        return out;
    }

    public Vector getSynonymsString(Vector names, Vector species) throws Exception {
        Vector<String> out = new Vector<String>();
        int sz = names.size();
        for (int i = 0; i < sz; ++i) {
            out.add(this.getSynonymsString((String)names.get(i), (String)species.get(i)));
        }
        return out;
    }

    protected boolean isInvalidSynonym(String syn) {
        if (syn.equalsIgnoreCase("ipi")) {
            return true;
        }
        if (syn.equalsIgnoreCase("ug")) {
            return true;
        }
        if (syn.equalsIgnoreCase("refseq")) {
            return true;
        }
        if (syn.equalsIgnoreCase("ref")) {
            return true;
        }
        if (syn.equalsIgnoreCase("sp")) {
            return true;
        }
        if (syn.equalsIgnoreCase("loc")) {
            return true;
        }
        if (syn.equalsIgnoreCase("ens")) {
            return true;
        }
        if (syn.equalsIgnoreCase("est")) {
            return true;
        }
        if (syn.equalsIgnoreCase("tr")) {
            return true;
        }
        if (syn.equalsIgnoreCase("gi")) {
            return true;
        }
        if (syn.equalsIgnoreCase("gb")) {
            return true;
        }
        if (syn.equalsIgnoreCase("emb")) {
            return true;
        }
        return syn.equalsIgnoreCase("gnl");
    }

    protected void addSubTokens(String tok, Vector list) {
        block6: {
            String[] toks;
            if (tok.indexOf("Tax_Id=9606") > 0) {
                toks = tok.split("Tax_Id=9606");
                String tt = toks[1].trim();
                if (!list.contains(tt)) {
                    list.add(tt);
                }
                tok = toks[0].trim();
            }
            if (tok.indexOf(32) <= 0 && tok.indexOf(59) <= 0) break block6;
            if (tok.indexOf(58) < 0) {
                toks = tok.split(";");
                for (int i = 0; i < toks.length; ++i) {
                    String tt = toks[i].trim();
                    if (list.contains(tt)) continue;
                    list.add(tt);
                }
            } else {
                toks = tok.split("[\\s:;]");
                for (int i = 0; i < toks.length; ++i) {
                    String tt = toks[i].trim();
                    if (tt.equalsIgnoreCase("REFSEQ_NP") || tt.equalsIgnoreCase("TREMBL") || tt.equalsIgnoreCase("ENSEMBL") || tt.equalsIgnoreCase("SWISS-PROT") || tt.equalsIgnoreCase("REFSEQ_XP") || list.contains(tt)) continue;
                    list.add(tt);
                }
            }
        }
    }

    public boolean setDebug(String deb) {
        return this.dbhandler.setDebug(deb);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: java csplugins.httpdata.handlers.db.DBSynonymHandler <port> <tableName>");
            System.exit(-1);
        }
        try {
            MyXmlRpcServer server = new MyXmlRpcServer(args);
            server.addService(serviceName, "csplugins.httpdata.handlers.db.DBSynonymHandler", args[1]);
        }
        catch (Exception e) {
            System.err.println("Could not start server: " + e.getMessage());
        }
    }
}

