/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata.handlers.db;

import csplugins.isb.dreiss.httpdata.handlers.db.DBDataHandler;
import csplugins.isb.dreiss.httpdata.xmlrpc.MyXmlRpcServer;
import java.util.Vector;

public class DBSequenceHandler {
    public static final String serviceName = "sequence";
    public static final String[] TYPES = new String[]{"DNA", "RNA", "protein", "upstream"};
    protected String tableName;
    protected DBDataHandler dbhandler;

    public DBSequenceHandler() {
    }

    public DBSequenceHandler(String tableName) throws Exception {
        this.dbhandler = new DBDataHandler(tableName);
        this.tableName = tableName;
    }

    protected String createSequenceTable(String species, String type) {
        String spec = species.replace(' ', '_');
        String table = this.tableName + "_" + type + "_" + spec;
        this.dbhandler.createTable(table, " ( name VARCHAR NOT NULL, sequence VARCHAR NOT NULL, CONSTRAINT UNIQUE_ID UNIQUE(NAME,SEQUENCE) )");
        return table;
    }

    public boolean put(String name, String species, String sequence) throws Exception {
        return this.put(name, species, sequence, "protein");
    }

    public boolean put(String name, String species, String sequence, String type) throws Exception {
        String table = this.createSequenceTable(species, type);
        String query = "INSERT INTO " + table + " (name,sequence) " + "VALUES ('" + name + "', '" + sequence + "')";
        try {
            this.dbhandler.update(query);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String get(String name, String species) throws Exception {
        return this.get(name, species, "protein");
    }

    public String get(String name, String species, String type) throws Exception {
        String[] stringArray;
        if (name.length() <= 0) {
            return "";
        }
        String table = this.createSequenceTable(species, type);
        if (name.indexOf(";") >= 0) {
            stringArray = name.split("\\;");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = name;
        }
        String[] prots = stringArray;
        String result = "";
        for (int i = 0; i < prots.length; ++i) {
            String lookup = prots[i];
            String query = "SELECT sequence FROM " + table + " WHERE name = '" + lookup + "'";
            try {
                result = this.dbhandler.query(query).toString();
            }
            catch (Exception e) {
                result = "";
            }
            if (result == null || result.length() <= 0) continue;
            return result;
        }
        return result;
    }

    public Vector get(Vector names, String species) throws Exception {
        return this.get(names, species, "protein");
    }

    public Vector get(Vector names, String species, String type) throws Exception {
        Vector<String> out = new Vector<String>();
        int sz = names.size();
        for (int i = 0; i < sz; ++i) {
            out.add(this.get((String)names.get(i), species, type));
        }
        return out;
    }

    public Vector get(Vector names, Vector species) throws Exception {
        return this.get(names, species, "protein");
    }

    public Vector get(Vector names, Vector species, String type) throws Exception {
        Vector<String> out = new Vector<String>();
        int sz = names.size();
        for (int i = 0; i < sz; ++i) {
            out.add(this.get((String)names.get(i), (String)species.get(i), type));
        }
        return out;
    }

    public boolean setDebug(String deb) {
        return this.dbhandler.setDebug(deb);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: java csplugins.httpdata.handlers.db.DBSequenceHandler <port> <tableName>");
            System.exit(-1);
        }
        try {
            MyXmlRpcServer server = new MyXmlRpcServer(args);
            server.addService(serviceName, "csplugins.httpdata.handlers.db.DBSequenceHandler", args[1]);
        }
        catch (Exception e) {
            System.err.println("Could not start server: " + e.getMessage());
        }
    }
}

