/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata.handlers.db;

import csplugins.isb.dreiss.httpdata.handlers.db.DBDataHandler;
import csplugins.isb.dreiss.httpdata.xmlrpc.MyXmlRpcServer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class DBInteractionHandler {
    public static final String serviceName = "interaction";
    protected String tableName;
    protected DBDataHandler dbhandler;
    protected HashMap sourcesMap = new HashMap();

    public DBInteractionHandler() {
    }

    public DBInteractionHandler(String tname) throws Exception {
        this.dbhandler = new DBDataHandler(tname);
        this.tableName = tname;
    }

    protected String createInteractionTable(String species, String source) {
        String src;
        try {
            this.createSourcesTable();
        }
        catch (Exception e) {
            // empty catch block
        }
        String spec = species.replace(' ', '_');
        if ("".equals(spec)) {
            spec = "unknown_species";
        }
        if ("".equals(src = source.replace(' ', '_'))) {
            src = "unknown_source";
        }
        String table = this.tableName + "_" + src + "_" + spec;
        this.dbhandler.createTable(table, " ( i1 VARCHAR NOT NULL, itype VARCHAR NOT NULL, i2 VARCHAR NOT NULL, pval DOUBLE, info VARCHAR, CONSTRAINT UNIQUE_ID UNIQUE(I1,ITYPE,I2) )");
        return table;
    }

    protected void createSourcesTable() throws Exception {
        String table = "interaction_sources";
        if (this.dbhandler.createTable(table, " ( source VARCHAR NOT NULL, description VARCHAR NOT NULL, level INT, CONSTRAINT UNIQUE_ID UNIQUE(SOURCE,DESCRIPTION) )")) {
            // empty if block
        }
    }

    public boolean setDebug(String deb) {
        return this.dbhandler.setDebug(deb);
    }

    public boolean addSource(String source, String desc) throws Exception {
        try {
            this.dbhandler.query("INSERT INTO interaction_sources (source,description) VALUES('" + source + "', '" + desc + "')");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean hasSource(String source) throws Exception {
        if (this.sourcesMap.containsKey(source)) {
            return true;
        }
        try {
            this.createSourcesTable();
        }
        catch (Exception e) {
            // empty catch block
        }
        String query = "SELECT description FROM interaction_sources WHERE source = '" + source + "'";
        boolean out = false;
        try {
            String result = this.dbhandler.query(query).toString();
            out = true;
            this.sourcesMap.put(source, new Boolean(true));
        }
        catch (Exception e) {
            out = false;
        }
        return out;
    }

    public Hashtable getSources(int userLevel) throws Exception {
        Hashtable<String, Object> map;
        block6: {
            try {
                this.createSourcesTable();
            }
            catch (Exception e) {
                // empty catch block
            }
            map = new Hashtable<String, Object>();
            String query = "SELECT source,description,level FROM interaction_sources";
            if (this.dbhandler.debug()) {
                System.err.println("QUERY: " + query);
            }
            Connection conn = this.dbhandler.getConnection();
            try {
                Statement st = conn.createStatement();
                ResultSet rs = st.executeQuery(query);
                while (rs.next()) {
                    String src = (String)rs.getObject(1);
                    int level = (Integer)rs.getObject(3);
                    if (userLevel < level) continue;
                    map.put(src, rs.getObject(2));
                }
            }
            catch (Exception e) {
                if (!this.dbhandler.debug()) break block6;
                e.printStackTrace();
            }
        }
        return map;
    }

    public boolean put(String i1, String itype, String i2, double pval, String source, String info, String species) throws Exception {
        String query;
        if (!this.hasSource(source)) {
            return false;
        }
        String table = this.createInteractionTable(species, source);
        if (!"None".equalsIgnoreCase(i1)) {
            query = "INSERT INTO " + table + " (i1,itype,i2,pval,info) " + "VALUES ('" + i1 + "', '" + itype + "', '" + i2 + "', '" + pval + "', '" + info + "')";
            try {
                this.dbhandler.update(query);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!"None".equalsIgnoreCase(i2) && !table.startsWith("prebind")) {
            info = this.reverseInfo(info);
            query = "INSERT INTO " + table + " (i1,itype,i2,pval,info) " + "VALUES ('" + i2 + "', '" + itype + "', '" + i1 + "', '" + pval + "', '" + info + "')";
            try {
                this.dbhandler.update(query);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    protected String reverseInfo(String info) {
        if (info.indexOf("2=") > 0) {
            if (info.indexOf("1=") <= 0) {
                info = info.replaceAll("2=", "1=");
            } else {
                info = info.replaceAll("2=", "ZZZQQQ=");
                info = info.replaceAll("1=", "2=");
                info = info.replaceAll("ZZZQQQ=", "1=");
            }
        }
        return info;
    }

    public boolean put(String i1, String itype, String i2, double pval, String source, String species) throws Exception {
        String query;
        if (!this.hasSource(source)) {
            return false;
        }
        String table = this.createInteractionTable(species, source);
        if (!"None".equalsIgnoreCase(i1)) {
            query = "INSERT INTO " + table + " (i1,itype,i2,pval) " + "VALUES ('" + i1 + "', '" + itype + "', '" + i2 + "', '" + pval + "')";
            try {
                this.dbhandler.update(query);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!"None".equalsIgnoreCase(i2) && !table.startsWith("prebind")) {
            query = "INSERT INTO " + table + " (i1,itype,i2,pval) " + "VALUES ('" + i2 + "', '" + itype + "', '" + i1 + "', '" + pval + "')";
            try {
                this.dbhandler.update(query);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean put(String i1, String itype, String i2, String source, String species) throws Exception {
        String query;
        if (!this.hasSource(source)) {
            return false;
        }
        String table = this.createInteractionTable(species, source);
        if (!"None".equalsIgnoreCase(i1)) {
            query = "INSERT INTO " + table + " (i1,itype,i2) " + "VALUES ('" + i1 + "', '" + itype + "', '" + i2 + "')";
            try {
                this.dbhandler.update(query);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!"None".equalsIgnoreCase(i2) && !table.startsWith("prebind")) {
            query = "INSERT INTO " + table + " (i1,itype,i2) " + "VALUES ('" + i2 + "', '" + itype + "', '" + i1 + "')";
            try {
                this.dbhandler.update(query);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean put(String i1, String itype, String i2, String species) throws Exception {
        String query;
        String table = this.createInteractionTable(species, "unknown");
        if (!"None".equalsIgnoreCase(i1)) {
            query = "INSERT INTO " + table + " (i1,itype,i2) " + "VALUES ('" + i1 + "', '" + itype + "', '" + i2 + "')";
            try {
                this.dbhandler.update(query);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!"None".equalsIgnoreCase(i2) && !table.startsWith("prebind")) {
            query = "INSERT INTO " + table + " (i1,itype,i2) " + "VALUES ('" + i2 + "', '" + itype + "', '" + i1 + "')";
            try {
                this.dbhandler.update(query);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean put(String i1, String itype, String i2, double pval, String species) throws Exception {
        String query;
        String table = this.createInteractionTable(species, "unknown");
        if (!"None".equalsIgnoreCase(i1)) {
            query = "INSERT INTO " + table + " (i1,itype,i2,pval) " + "VALUES ('" + i1 + "', '" + itype + "', '" + i2 + "', '" + pval + "')";
            try {
                this.dbhandler.update(query);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!"None".equalsIgnoreCase(i2) && !table.startsWith("prebind")) {
            query = "INSERT INTO " + table + " (i1,itype,i2,pval) " + "VALUES ('" + i2 + "', '" + itype + "', '" + i1 + "', '" + pval + "')";
            try {
                this.dbhandler.update(query);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean hasInteraction(String i1, String i2, String source, String species) throws Exception {
        if (!this.hasSource(source)) {
            return false;
        }
        String table = this.createInteractionTable(species, source);
        String query = "SELECT type FROM " + table + " WHERE i1 = '" + i1 + "' AND i2 = '" + i2 + "'";
        boolean out = false;
        try {
            String result = this.dbhandler.query(query).toString();
            out = true;
        }
        catch (Exception e) {
            out = false;
        }
        return out;
    }

    public Vector getAllInteractors(String i1, String species, String source) throws Exception {
        return this.getAllInteractors(i1, species, source, false);
    }

    public Vector getAllInteractors(String i1, String species, String source, boolean justOneWay) throws Exception {
        if (!this.hasSource(source)) {
            return new Vector();
        }
        String table = this.createInteractionTable(species, source);
        String query1 = "SELECT i2 FROM " + table + " WHERE i1 = '" + i1 + "'";
        String query2 = "SELECT i1 FROM " + table + " WHERE i2 = '" + i1 + "'";
        Vector<Object> list = new Vector<Object>();
        try {
            Connection conn = this.dbhandler.getConnection();
            if (this.dbhandler.debug()) {
                System.err.println("QUERY: " + query1);
            }
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(query1);
            while (rs.next()) {
                list.add(rs.getObject(1));
            }
            if (!justOneWay) {
                if (this.dbhandler.debug()) {
                    System.err.println("QUERY: " + query2);
                }
                rs = st.executeQuery(query2);
                while (rs.next()) {
                    list.add(rs.getObject(1));
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return list;
    }

    public Vector getAllInteractions(String i1, String species, String source) throws Exception {
        return this.getAllInteractions(i1, species, source, false);
    }

    public Vector getAllInteractions(String i1, String species, String source, boolean justOneWay) throws Exception {
        if (!this.hasSource(source)) {
            return new Vector();
        }
        String table = this.createInteractionTable(species, source);
        Vector list = new Vector();
        Connection conn = this.dbhandler.getConnection();
        for (int i = 0; !(i >= 2 || justOneWay && i == 1); ++i) {
            String query;
            String string = query = i == 0 ? "SELECT i2,itype FROM " + table + " WHERE i1 = '" + i1 + "'" : "SELECT i1,itype FROM " + table + " WHERE i2 = '" + i1 + "'";
            if (this.dbhandler.debug()) {
                System.err.println("QUERY: " + query);
            }
            try {
                Statement st = conn.createStatement();
                ResultSet rs = st.executeQuery(query);
                while (rs.next()) {
                    Hashtable<String, Object> map = new Hashtable<String, Object>();
                    map.put("partner", rs.getObject(1));
                    map.put("type", rs.getObject(2));
                    list.add(map);
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return list;
    }

    public Vector getAllInteractionsAndInfo(String i1, String species, String source) throws Exception {
        return this.getAllInteractionsAndInfo(i1, species, source, false);
    }

    public Vector getAllInteractionsAndInfo(String i1, String species, String source, boolean justOneWay) throws Exception {
        String[] stringArray;
        if (!this.hasSource(source)) {
            return new Vector();
        }
        String table = this.createInteractionTable(species, source);
        Vector list = new Vector();
        if (i1.indexOf(59) >= 0) {
            stringArray = i1.split("\\;");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = i1;
        }
        String[] prots = stringArray;
        Connection conn = this.dbhandler.getConnection();
        for (int j = 0; j < prots.length; ++j) {
            String lookup = prots[j];
            for (int i = 0; !(i >= 2 || justOneWay && i == 1); ++i) {
                String query;
                String string = query = i == 0 ? "SELECT i2,itype,pval,info FROM " + table + " WHERE i1 = '" + lookup + "'" : "SELECT i1,itype,pval,info FROM " + table + " WHERE i2 = '" + lookup + "'";
                if (this.dbhandler.debug()) {
                    System.err.println("QUERY: " + query);
                }
                try {
                    Statement st = conn.createStatement();
                    ResultSet rs = st.executeQuery(query);
                    while (rs.next()) {
                        String info;
                        Hashtable<String, Object> map = new Hashtable<String, Object>();
                        map.put("partner", rs.getObject(1));
                        map.put("type", rs.getObject(2));
                        map.put("pval", rs.getObject(3) != null ? rs.getObject(3) : "");
                        map.put("source", source);
                        String string2 = info = rs.getObject(4) != null ? rs.getObject(4) : "";
                        if (i == 1 && info.indexOf("2=") > 0) {
                            info = this.reverseInfo(info);
                        }
                        map.put("info", info);
                        list.add(map);
                    }
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return list;
    }

    public Vector getAllInteractionsAndInfo(String i1, String species, String source, String infoConstraint, boolean justOneWay) throws Exception {
        if (!this.hasSource(source)) {
            return new Vector();
        }
        Vector v = this.getAllInteractionsAndInfo(i1, species, source, justOneWay);
        boolean not = infoConstraint.startsWith("!");
        if (not) {
            infoConstraint = infoConstraint.substring(1);
        }
        Vector<Map> out = new Vector<Map>();
        int sz = v.size();
        for (int i = 0; i < sz; ++i) {
            Map map = (Map)v.get(i);
            String info = (String)map.get("info");
            if (info.indexOf(infoConstraint) >= 0) {
                if (not) continue;
                out.add(map);
                continue;
            }
            if (!not) continue;
            out.add(map);
        }
        if (v.size() > 0 && out.size() <= 0) {
            Hashtable<String, String> map = new Hashtable<String, String>();
            map.put("partner", "None");
            out.add(map);
        }
        return out;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: java csplugins.httpdata.handlers.db.DBInteractionHandler <port> <tableName>");
            System.exit(-1);
        }
        try {
            MyXmlRpcServer server = new MyXmlRpcServer(args);
            server.addService(serviceName, "csplugins.httpdata.handlers.db.DBInteractionHandler", args[1]);
        }
        catch (Exception e) {
            System.err.println("Could not start server: " + e.getMessage());
        }
    }
}

