/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata.handlers.db;

import csplugins.isb.dreiss.httpdata.handlers.db.DBDataHandler;
import csplugins.isb.dreiss.httpdata.xmlrpc.MyXmlRpcServer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class DBHomologHandler {
    public static final String serviceName = "homolog";
    protected Map availableSpecies = null;
    protected Map speciesMap = new HashMap();
    protected String tableName;
    protected DBDataHandler dbhandler;

    public DBHomologHandler() {
    }

    public DBHomologHandler(String tableName) throws Exception {
        this.dbhandler = new DBDataHandler(tableName);
        this.tableName = tableName;
    }

    protected String createHomologTable(String species, String hSpecies) throws Exception {
        try {
            this.createSpeciesTable();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (species.indexOf(32) < 0) {
            species = this.getSpeciesFullName(species);
        }
        if (hSpecies.indexOf(32) < 0) {
            hSpecies = this.getSpeciesFullName(hSpecies);
        }
        String spec = species.replace(' ', '_');
        String hspec = hSpecies.replace(' ', '_');
        String table = this.tableName + "_" + spec + "_" + hspec;
        this.dbhandler.createTable(table, " ( prot VARCHAR NOT NULL, homolog VARCHAR NOT NULL, score DOUBLE, info VARCHAR, CONSTRAINT UNIQUE_ID UNIQUE(PROT,HOMOLOG) )");
        return table;
    }

    protected void createSpeciesTable() throws Exception {
        String table = "homolog_species";
        if (this.dbhandler.createTable(table, " ( spec VARCHAR NOT NULL, fullname VARCHAR NOT NULL, CONSTRAINT UNIQUE_ID UNIQUE(SPEC,FULLNAME) )")) {
            // empty if block
        }
    }

    public boolean addSpecies(String spec, String fullname) throws Exception {
        try {
            this.dbhandler.query("INSERT INTO homolog_species (spec,fullname) VALUES('" + spec + "', '" + fullname + "')");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean hasSpecies(String spec) throws Exception {
        String result;
        if (this.speciesMap.containsKey(spec)) {
            return true;
        }
        try {
            this.createSpeciesTable();
        }
        catch (Exception e) {
            // empty catch block
        }
        String query = "SELECT spec FROM homolog_species WHERE fullname = '" + spec + "'";
        boolean out = false;
        try {
            result = this.dbhandler.query(query).toString();
            out = true;
            this.speciesMap.put(spec, new Boolean(true));
        }
        catch (Exception e) {
            out = false;
        }
        if (!out) {
            query = "SELECT fullname FROM homolog_species WHERE spec = '" + spec + "'";
            try {
                result = this.dbhandler.query(query).toString();
                out = true;
                this.speciesMap.put(spec, new Boolean(true));
            }
            catch (Exception e) {
                out = false;
            }
        }
        return out;
    }

    public String getSpeciesFullName(String spec) throws Exception {
        try {
            this.createSpeciesTable();
        }
        catch (Exception e) {
            // empty catch block
        }
        String query = "SELECT fullname FROM homolog_species WHERE spec = '" + spec + "'";
        String result = spec;
        try {
            result = this.dbhandler.query(query).toString();
        }
        catch (Exception e) {
            result = spec;
        }
        if (result.equals("???")) {
            result = spec;
        }
        return result;
    }

    public Hashtable getAvailableSpecies() throws Exception {
        try {
            this.createSpeciesTable();
        }
        catch (Exception e) {
            // empty catch block
        }
        Hashtable<Object, Object> map = new Hashtable<Object, Object>();
        Connection conn = this.dbhandler.getConnection();
        String query = "SELECT spec,fullname FROM homolog_species";
        if (this.dbhandler.debug()) {
            System.err.println("QUERY: " + query);
        }
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                map.put(rs.getObject(1), rs.getObject(2));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return map;
    }

    public boolean put(String prot, String homolog, double score, String info, String species1, String species2) throws Exception {
        if (!this.hasSpecies(species1)) {
            return false;
        }
        if (!this.hasSpecies(species2)) {
            return false;
        }
        String table = this.createHomologTable(species1, species2);
        String query = "INSERT INTO " + table + " (prot,homolog,score,info) " + "VALUES ('" + prot + "', '" + homolog + "', '" + score + "', '" + info + "')";
        try {
            this.dbhandler.update(query);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean put(String prot, String homolog, double score, String species1, String species2) throws Exception {
        if (!this.hasSpecies(species1)) {
            return false;
        }
        if (!this.hasSpecies(species2)) {
            return false;
        }
        String table = this.createHomologTable(species1, species2);
        String query = "INSERT INTO " + table + " (prot,homolog,score) " + "VALUES ('" + prot + "', '" + homolog + "', '" + score + "')";
        try {
            this.dbhandler.update(query);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean hasHomolog(String prot, String homolog, String species1, String species2) throws Exception {
        String[] stringArray;
        if (!this.hasSpecies(species1)) {
            return false;
        }
        if (!this.hasSpecies(species2)) {
            return false;
        }
        String table = this.createHomologTable(species1, species2);
        boolean out = false;
        if (prot.indexOf(";") >= 0) {
            stringArray = prot.split("\\;");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = prot;
        }
        String[] prots = stringArray;
        for (int i = 0; i < prots.length; ++i) {
            String lookup = prots[i];
            String query = "SELECT homolog FROM " + table + " WHERE prot = '" + lookup + "'";
            try {
                String result = this.dbhandler.query(query).toString();
                out = true;
                break;
            }
            catch (Exception e) {
                out = false;
                continue;
            }
        }
        return out;
    }

    public Vector getAllHomologs(String prot, String species1, String species2) throws Exception {
        String[] stringArray;
        if (!this.hasSpecies(species1)) {
            return new Vector();
        }
        if (!this.hasSpecies(species2)) {
            return new Vector();
        }
        String table = this.createHomologTable(species1, species2);
        Vector<Object> list = new Vector<Object>();
        if (prot.indexOf(";") >= 0) {
            stringArray = prot.split("\\;");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = prot;
        }
        String[] prots = stringArray;
        Connection conn = this.dbhandler.getConnection();
        for (int i = 0; i < prots.length; ++i) {
            String lookup = prots[i];
            String query = "SELECT homolog FROM " + table + " WHERE prot = '" + lookup + "'";
            try {
                if (this.dbhandler.debug()) {
                    System.err.println("QUERY: " + query);
                }
                Statement st = conn.createStatement();
                ResultSet rs = st.executeQuery(query);
                while (rs.next()) {
                    list.add(rs.getObject(1));
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return list;
    }

    public Vector getAllHomologs(String prot, String species1) throws Exception {
        if (!this.hasSpecies(species1)) {
            return new Vector();
        }
        Vector list = new Vector();
        if (this.availableSpecies == null) {
            this.availableSpecies = this.getAvailableSpecies();
        }
        Iterator it = this.availableSpecies.keySet().iterator();
        while (it.hasNext()) {
            String shortName = (String)it.next();
            String species2 = (String)this.availableSpecies.get(shortName);
            Vector v = this.getAllHomologs(prot, species1, species2);
            for (int i = 0; i < v.size(); ++i) {
                list.add(v.get(i));
            }
        }
        return list;
    }

    public Vector getAllHomologsAndInfo(String prot, String species1, String species2) throws Exception {
        String[] stringArray;
        if (!this.hasSpecies(species1)) {
            return new Vector();
        }
        if (!this.hasSpecies(species2)) {
            return new Vector();
        }
        String table = this.createHomologTable(species1, species2);
        Vector list = new Vector();
        if (prot.indexOf(";") >= 0) {
            stringArray = prot.split("\\;");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = prot;
        }
        String[] prots = stringArray;
        Connection conn = this.dbhandler.getConnection();
        for (int i = 0; i < prots.length; ++i) {
            String lookup = prots[i];
            String query = "SELECT homolog,score,info FROM " + table + " WHERE prot = '" + lookup + "'";
            if (this.dbhandler.debug()) {
                System.err.println("QUERY: " + query);
            }
            try {
                Statement st = conn.createStatement();
                ResultSet rs = st.executeQuery(query);
                while (rs.next()) {
                    Hashtable<String, Object> map = new Hashtable<String, Object>();
                    map.put(serviceName, rs.getObject(1));
                    map.put("score", rs.getObject(2));
                    map.put("species", species2);
                    map.put("info", rs.getObject(3) != null ? rs.getObject(3) : "");
                    list.add(map);
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return list;
    }

    public Vector getAllHomologsAndInfo(String prot, String species1) throws Exception {
        if (!this.hasSpecies(species1)) {
            return new Vector();
        }
        Vector list = new Vector();
        if (this.availableSpecies == null) {
            this.availableSpecies = this.getAvailableSpecies();
        }
        Iterator it = this.availableSpecies.keySet().iterator();
        while (it.hasNext()) {
            String shortName = (String)it.next();
            String species2 = (String)this.availableSpecies.get(shortName);
            Vector v = this.getAllHomologsAndInfo(prot, species1, species2);
            for (int i = 0; i < v.size(); ++i) {
                list.add(v.get(i));
            }
        }
        return list;
    }

    public Vector getAllHomologsAndInfo(String prot, String species1, String species2, double betterThan) throws Exception {
        if (!this.hasSpecies(species1)) {
            return new Vector();
        }
        if (!this.hasSpecies(species2)) {
            return new Vector();
        }
        Vector v = this.getAllHomologsAndInfo(prot, species1, species2);
        Vector<Map> out = new Vector<Map>();
        int sz = v.size();
        for (int i = 0; i < sz; ++i) {
            Map map = (Map)v.get(i);
            double score = (Double)map.get("score");
            if (!(score >= betterThan)) continue;
            out.add(map);
        }
        if (v.size() > 0 && out.size() <= 0) {
            Hashtable<String, String> map = new Hashtable<String, String>();
            map.put(serviceName, "None");
            out.add(map);
        }
        return out;
    }

    public Vector getAllHomologsAndInfo(String prot, String species1, double betterThan) throws Exception {
        if (!this.hasSpecies(species1)) {
            return new Vector();
        }
        Vector list = new Vector();
        if (this.availableSpecies == null) {
            this.availableSpecies = this.getAvailableSpecies();
        }
        Iterator it = this.availableSpecies.keySet().iterator();
        while (it.hasNext()) {
            String shortName = (String)it.next();
            String species2 = (String)this.availableSpecies.get(shortName);
            Vector v = this.getAllHomologsAndInfo(prot, species1, species2, betterThan);
            for (int i = 0; i < v.size(); ++i) {
                list.add(v.get(i));
            }
        }
        return list;
    }

    public boolean setDebug(String deb) {
        return this.dbhandler.setDebug(deb);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: java csplugins.httpdata.handlers.db.DBHomologHandler <port> <tableName>");
            System.exit(-1);
        }
        try {
            MyXmlRpcServer server = new MyXmlRpcServer(args);
            server.addService(serviceName, "csplugins.httpdata.handlers.db.DBHomologHandler", args[1]);
        }
        catch (Exception e) {
            System.err.println("Could not start server: " + e.getMessage());
        }
    }
}

