/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata.handlers.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class DBDataHandler {
    protected Map createdTables = new HashMap();
    protected String tableName;
    protected Connection conn;
    protected int updates = 0;
    protected int totalUpdates = 0;
    protected boolean debug = true;
    protected boolean allowUpdates = true;
    protected String CREATE_TABLE = "CREATE TEXT TABLE ";
    protected boolean CONVERT_TABLES = false;

    public DBDataHandler() {
    }

    public DBDataHandler(String tname) {
        this.initialize(tname);
    }

    protected void initialize(String tname) {
        block5: {
            this.tableName = tname;
            System.err.println("STARTING HANDLER: " + this.tableName);
            try {
                Class.forName("org.hsqldb.jdbcDriver");
                this.conn = DriverManager.getConnection("jdbc:hsqldb:db_dir/" + this.tableName, "sa", "");
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        try {
                            DBDataHandler.this.shutdown();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                try {
                    this.query("SET IGNORECASE TRUE");
                    if (this.CONVERT_TABLES) break block5;
                    this.query("SET WRITE_DELAY TRUE");
                    this.query("SET LOGSIZE 10");
                    this.query("SET AUTOCOMMIT TRUE");
                    if (!this.allowUpdates) {
                        this.query("SET READONLY TRUE");
                        break block5;
                    }
                    this.query("SET READONLY FALSE");
                }
                catch (Exception e) {}
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public boolean debug() {
        return this.debug;
    }

    public boolean createTable(String table, String desc) {
        if (this.createdTables.get(table) != null) {
            return false;
        }
        String newtab = table;
        if (this.CONVERT_TABLES) {
            table = table + "_old";
        }
        if (this.debug) {
            System.err.println("Creating table: " + table);
        }
        boolean out = false;
        try {
            this.query(this.CREATE_TABLE + " " + table + " " + desc);
            this.setTableSource(table, newtab);
            out = true;
        }
        catch (Exception e) {
            out = false;
        }
        this.createdTables.put(table, new Boolean(true));
        if (this.CONVERT_TABLES) {
            this.convertTableFromText(table, newtab);
            try {
                this.query("DROP TABLE " + table + " IF EXISTS;");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.createdTables.remove(table);
            this.createdTables.put(newtab, new Boolean(true));
        }
        return out;
    }

    public void convertTableFromText(String oldtable, String table) {
        try {
            this.query("DROP TABLE " + table + " IF EXISTS;");
            this.query("SELECT * INTO CACHED " + table + " FROM " + oldtable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void convertTableToText(String table) {
        try {
            this.query("SELECT * INTO TEXT " + table + " FROM");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTableSource(String table, String csvName) {
        if (this.CREATE_TABLE.indexOf(" TEXT TABLE ") >= 0) {
            if (this.debug) {
                System.err.println("Setting table source to text file: " + csvName + ".csv");
            }
            try {
                this.query("SET TABLE " + table + " SOURCE \"" + csvName + ".csv\"");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void shutdown() throws SQLException {
        System.out.println("IN SHUTDOWN: " + this.tableName);
        try {
            if (this.totalUpdates > 0) {
                this.query("SHUTDOWN COMPACT");
            } else {
                this.query("SHUTDOWN");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.conn.close();
    }

    public Object query(String expression) throws SQLException {
        if (this.debug) {
            System.err.println("QUERY: " + expression);
        }
        Statement st = this.conn.createStatement();
        ResultSet rs = st.executeQuery(expression);
        try {
            rs.next();
            Object out = rs.getObject(1);
            st.close();
            return out;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void queryAndDump(String expression) throws SQLException {
        if (this.debug) {
            System.err.println("QUERY: " + expression);
        }
        Statement st = this.conn.createStatement();
        ResultSet rs = st.executeQuery(expression);
        try {
            DBDataHandler.dump(rs);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void update(String expression) throws SQLException {
        if (this.debug) {
            System.err.println("UPDATE: " + expression);
        }
        if (this.allowUpdates) {
            Statement st = this.conn.createStatement();
            int i = st.executeUpdate(expression);
            if (i == -1) {
                System.out.println("db error : " + expression);
            }
            ++this.updates;
            ++this.totalUpdates;
            if (this.updates > 1000) {
                if (this.debug) {
                    System.err.println("CHECKPOINTING: " + this.tableName);
                }
                st.executeUpdate("COMMIT");
                st.executeUpdate("CHECKPOINT");
                this.updates = 0;
            }
            st.close();
        }
    }

    public static void dump(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int colmax = meta.getColumnCount();
        while (rs.next()) {
            for (int i = 0; i < colmax; ++i) {
                Object o = rs.getObject(i + 1);
                System.out.print(o.toString() + " ");
            }
            System.out.println(" ");
        }
    }

    public boolean setDebug(String db) {
        this.debug = Boolean.valueOf(db);
        return this.debug;
    }
}

