/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata.handlers;

import csplugins.isb.dreiss.httpdata.LocalBlast;
import csplugins.isb.dreiss.httpdata.SGDBlast;
import csplugins.isb.dreiss.httpdata.xmlrpc.MyXmlRpcServer;
import csplugins.isb.dreiss.httpdata.xmlrpc.XmlRpcUtils;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public class BlastHandler {
    public static final String serviceName = "blast";
    boolean useSGDBlast = false;
    File executable;
    File sequenceDataDirectory;
    int invocations = 0;
    Vector sequenceFileNames;
    LocalBlast localBlast;

    public BlastHandler(String pathToBlastExe, String sequenceDataDir) throws Exception {
        File pathToBlastExecutable = new File(pathToBlastExe);
        File sequenceDataDirectory = new File(sequenceDataDir);
        if (!pathToBlastExecutable.canRead()) {
            throw new IllegalArgumentException("cannot read blast executable: " + this.executable.getPath());
        }
        if (!sequenceDataDirectory.canRead()) {
            throw new IllegalArgumentException("cannot read sequenceDirectory: " + sequenceDataDirectory.getPath());
        }
        this.executable = pathToBlastExecutable;
        this.sequenceDataDirectory = sequenceDataDirectory;
        this.deduceSequenceFileNames();
    }

    public BlastHandler() throws Exception {
        this.useSGDBlast = true;
    }

    private synchronized void deduceSequenceFileNames() {
        File[] allFiles = this.sequenceDataDirectory.listFiles();
        this.sequenceFileNames = new Vector();
        for (int f = 0; f < allFiles.length; ++f) {
            String name = allFiles[f].getName();
            String[] tokens = name.split("\\.");
            String choppedName = "";
            for (int t = 0; t < tokens.length - 1; ++t) {
                choppedName = choppedName + tokens[t];
                if (t >= tokens.length - 2) continue;
                choppedName = choppedName + ".";
            }
            if (this.sequenceFileNames.contains(choppedName)) continue;
            this.sequenceFileNames.add(choppedName);
        }
    }

    public synchronized Vector getSequenceFileNames() {
        return this.sequenceFileNames;
    }

    public synchronized boolean setup(String blastVariant, String sequence, String sequenceName, String sourceSpecies, String targetSequenceFile) throws Exception {
        if (!this.useSGDBlast) {
            this.localBlast = new LocalBlast(blastVariant, sequence, sequenceName, sourceSpecies, targetSequenceFile);
            this.localBlast.setSequenceFileDirectory(this.sequenceDataDirectory.getAbsolutePath() + "/");
            this.localBlast.setBlastCommand(this.executable.getAbsolutePath());
        } else {
            this.localBlast = new SGDBlast(blastVariant, sequence, sequenceName, sourceSpecies, targetSequenceFile);
        }
        return true;
    }

    public synchronized boolean setup(String blastVariant, String sequence, String sequenceName, String sourceSpecies, String targetSequenceFile, double evalue) throws Exception {
        if (!this.useSGDBlast) {
            this.localBlast = new LocalBlast(blastVariant, sequence, sequenceName, sourceSpecies, targetSequenceFile);
            this.localBlast.setSequenceFileDirectory(this.sequenceDataDirectory.getAbsolutePath() + "/");
            this.localBlast.setBlastCommand(this.executable.getAbsolutePath());
        } else {
            this.localBlast = new SGDBlast(blastVariant, sequence, sequenceName, sourceSpecies, targetSequenceFile);
        }
        this.localBlast.setEValueThreshold(evalue);
        return true;
    }

    public synchronized boolean setMatrix(String newValue) {
        this.localBlast.setMatrix(newValue);
        return true;
    }

    public synchronized boolean setCostToOpenGap(int newValue) {
        this.localBlast.setCostToOpenGap(newValue);
        return true;
    }

    public synchronized boolean setCostToExtendGap(int newValue) {
        this.localBlast.setCostToExtendGap(newValue);
        return true;
    }

    public synchronized boolean run() throws Exception {
        ++this.invocations;
        this.localBlast.run();
        return true;
    }

    public synchronized int getInvocationCount() {
        return this.invocations;
    }

    public synchronized String getBlastCommand() {
        return this.localBlast.getActualBlastCommand();
    }

    public synchronized String getErrorMessage() {
        return this.localBlast.getErrorMessage();
    }

    public synchronized Hashtable getResults() {
        Hashtable tab = XmlRpcUtils.GetObjectAsStruct(this.localBlast.getResults());
        return tab;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.err.println("Usage: java csplugins.httpdata.handlers.BlastHandler <port> <pathToBlastExecutable> <pathToSequenceDataDirectory>");
            System.exit(-1);
        }
        File executable = new File(args[1]);
        File dataDirectory = new File(args[2]);
        if (!executable.canRead()) {
            throw new IllegalArgumentException("cannot read blast executable: " + executable.getPath());
        }
        if (!dataDirectory.canRead()) {
            throw new IllegalArgumentException("cannot read data directory: " + dataDirectory.getPath());
        }
        if (!dataDirectory.isDirectory()) {
            throw new IllegalArgumentException("data directory is not a directory: " + dataDirectory.getPath());
        }
        try {
            MyXmlRpcServer server = new MyXmlRpcServer(args);
            server.addService(serviceName, "csplugins.httpdata.BlastHandler", executable.getAbsolutePath(), dataDirectory.getAbsolutePath());
        }
        catch (Exception e) {
            System.err.println("Could not start server: " + e.getMessage());
        }
    }
}

