/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata;

import csplugins.isb.dreiss.httpdata.Homolog;
import csplugins.isb.dreiss.httpdata.HomologSet;
import csplugins.isb.dreiss.httpdata.LocalBlast;
import csplugins.isb.dreiss.httpdata.NCBIUtils;

public class SGDBlast
extends LocalBlast {
    public SGDBlast(String blastVariant, String sequence, String sequenceName, String sourceSpecies, String targetSequenceFile) throws Exception {
        super(blastVariant, sequence, sequenceName, sourceSpecies, targetSequenceFile);
    }

    public void run() throws Exception {
        String url = "http://seq.yeastgenome.org/cgi-bin/SGD/nph-blast2sgd?";
        String query = "program=" + this.blastVariant + "&database=YeastORF-P&filtop=default&output=gapped&matrix=" + this.matrixString + "&sthr=60&ethr=" + this.eValueThreshold + "&showal=25&sortop=pvalue&sequence=" + this.sequence;
        try {
            this.homologSet = new HomologSet(this.sequenceName, this.sourceSpecies, this.sequence, this.targetSequenceFile);
            this.xmlResult = NCBIUtils.getPage(url + query);
            this.parseXML();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void parseXML() throws Exception {
        String signature = "Sequences producing High-scoring Segment Pairs:";
        int start = this.xmlResult.indexOf(signature);
        int end = this.xmlResult.indexOf("<hr>", start += signature.length());
        String resultString = this.xmlResult.substring(start, end);
        String[] lines = resultString.split("<a name");
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            int ind1 = line.indexOf("<b>") + 3;
            int ind2 = line.indexOf("</b>", ind1);
            String name1 = line.substring(ind1, ind2);
            ind1 = ind2 + 5;
            ind2 = line.indexOf(" ", ind1);
            String name2 = line.substring(ind1, ind2);
            ind1 = line.indexOf("SGDID:") + 6;
            ind2 = line.indexOf(", ", ind1);
            String sgdid = line.substring(ind1 + 1, ind2);
            ind1 = line.indexOf("<a href") - 6;
            String score = line.substring(ind1, ind1 + 6).trim();
            ind1 = line.indexOf("\">", ind2 + 1) + 2;
            ind2 = line.indexOf("</a>", ind1);
            String evalue = line.substring(ind1, ind2);
            String hits = line.substring(ind2 + 5).trim();
            Homolog homolog = new Homolog(this.sequenceName, this.sourceSpecies, this.sequence, this.targetSequenceFile);
            homolog.setTargetSpecies("Saccharomyces cerevisiae");
            homolog.setRefSeqID(name1);
            int ginumber = Integer.parseInt(this.getGINumber(name1));
            homolog.setGiNumber(ginumber);
            homolog.setScore(Integer.parseInt(score));
            homolog.setEValue(Double.parseDouble(evalue));
            homolog.setHitLength(1);
            homolog.setRawDefLine(line.trim());
            this.homologSet.addHit(homolog);
        }
    }

    protected String getGINumber(String orfName) throws Exception {
        String url = "http://db.yeastgenome.org/cgi-bin/SGD/locus.pl?locus=";
        String rawPage = NCBIUtils.getPage(url + orfName);
        int ind1 = rawPage.indexOf("list_uids=");
        int ind2 = rawPage.indexOf("&", ind1 += "list_uids=".length());
        return rawPage.substring(ind1, ind2);
    }
}

