/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata;

import csplugins.isb.dreiss.httpdata.Homolog;
import csplugins.isb.dreiss.httpdata.HomologSet;
import csplugins.isb.dreiss.util.Exec;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class LocalBlast
implements Serializable {
    static double defaultEValueThreshold = 1.0E-4;
    String sequenceFileDirectory = "/data/seqdb/blastformat/";
    String blastCommand = "/package/genome/bin/blastall";
    String temporarySequenceFilename;
    String tmpXmlFileName;
    String blastVariant;
    String sequence;
    String sequenceName;
    String sourceSpecies;
    String targetSequenceFile;
    double eValueThreshold = defaultEValueThreshold;
    String xmlResult = "";
    String errorMessage = "";
    String actualBlastCommand = "";
    HomologSet homologSet;
    String matrixString = "BLOSUM62";
    int costToOpenGap = 11;
    int costToExtendGap = 1;

    public LocalBlast(String blastVariant, String sequence, String sequenceName, String sourceSpecies, String targetSequenceFile) throws Exception {
        this.blastVariant = blastVariant;
        this.sequence = sequence;
        this.eValueThreshold = this.eValueThreshold;
        this.targetSequenceFile = targetSequenceFile;
        this.sequenceName = sequenceName;
        this.sourceSpecies = sourceSpecies;
        this.temporarySequenceFilename = this.createTemporarySequenceFile(sequence);
    }

    public void setBlastCommand(String newValue) {
        this.blastCommand = newValue;
    }

    public void setSequenceFileDirectory(String newValue) {
        this.sequenceFileDirectory = newValue;
    }

    public void setEValueThreshold(double newValue) {
        this.eValueThreshold = newValue;
    }

    public void setMatrix(String newValue) {
        this.matrixString = newValue;
    }

    public void setCostToOpenGap(int newValue) {
        this.costToOpenGap = newValue;
    }

    public void setCostToExtendGap(int newValue) {
        this.costToExtendGap = newValue;
    }

    public void run() throws Exception {
        this.homologSet = new HomologSet(this.sequenceName, this.sourceSpecies, this.sequence, this.targetSequenceFile);
        this.execute();
        this.parseXml();
        this.deleteTemporaryFiles();
    }

    protected void deleteTemporaryFiles() throws Exception {
        new File(this.temporarySequenceFilename).delete();
        new File(this.tmpXmlFileName).delete();
    }

    protected void execute() throws Exception {
        String[] cmd = new String[]{this.blastCommand, "-p", this.blastVariant, "-d", this.sequenceFileDirectory + this.targetSequenceFile, "-e", new Double(this.eValueThreshold).toString(), "-m", "7", "-M", this.matrixString, "-i", this.temporarySequenceFilename, "-G", new Integer(this.costToOpenGap).toString(), "-E", new Integer(this.costToExtendGap).toString()};
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cmd.length; ++i) {
            sb.append(cmd[i] + " ");
        }
        this.actualBlastCommand = sb.toString();
        Exec child = new Exec(cmd);
        int result = child.runThreaded();
        this.xmlResult = child.getStdoutAsString();
        this.errorMessage = child.getStderrAsString();
        if (this.errorMessage.length() > 0) {
            throw new IllegalArgumentException(this.errorMessage + "\ncommand: " + sb.toString());
        }
    }

    private String createTemporarySequenceFile(String sequence) throws IOException {
        File tmpSequenceFile = File.createTempFile("blast.", ".seq");
        tmpSequenceFile.deleteOnExit();
        String filename = tmpSequenceFile.getPath();
        FileWriter fileWriter = new FileWriter(tmpSequenceFile);
        fileWriter.write(sequence);
        fileWriter.close();
        return filename;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getActualBlastCommand() {
        return this.actualBlastCommand;
    }

    public String getResultsInXml() {
        return this.xmlResult;
    }

    private void parseIteration(Element root) {
        Element iterationHits = root.getChild("Iteration_hits");
        if (iterationHits == null) {
            return;
        }
        List hits = iterationHits.getChildren("Hit");
        ListIterator iterator = hits.listIterator();
        int count = 0;
        while (iterator.hasNext()) {
            ++count;
            Element iteration = (Element)iterator.next();
            Homolog homolog = new Homolog(this.sequenceName, this.sourceSpecies, this.sequence, this.targetSequenceFile);
            homolog = this.parseHit(iteration, homolog);
            this.deduceTargetSpecies(homolog);
            this.homologSet.addHit(homolog);
        }
    }

    private void deduceTargetSpecies(Homolog homolog) {
        if (this.targetSequenceFile.equalsIgnoreCase("yeast.aa")) {
            homolog.setTargetSpecies("Saccharomyces cerevisiae");
        }
    }

    private Homolog parseHit(Element root, Homolog homolog) {
        String defLine = root.getChild("Hit_def").getText().trim();
        int hitLength = -1;
        try {
            hitLength = Integer.parseInt(root.getChild("Hit_len").getText().trim());
        }
        catch (NumberFormatException ignore) {
            // empty catch block
        }
        homolog.setHitLength(hitLength);
        homolog.setRawDefLine(root.getChild("Hit_def").getText().trim());
        this.parseRawDefLine(homolog);
        List hsps = root.getChild("Hit_hsps").getChildren("Hsp");
        ListIterator iterator = hsps.listIterator();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            homolog = this.parseHsp(e, homolog);
        }
        return homolog;
    }

    private void parseRawDefLine(Homolog homolog) {
        int end;
        String s = homolog.getRawDefLine();
        int start = s.indexOf("gi|");
        if (start >= 0) {
            end = s.indexOf("|", start += 3);
            int giNumber = -1;
            try {
                homolog.setGiNumber(Integer.parseInt(s.substring(start, end)));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((start = s.indexOf("|ref|")) > 0) {
            String refSeqID;
            int period;
            if ((period = (refSeqID = s.substring(start += 5, end = s.indexOf("|", start))).indexOf(".")) >= 0) {
                refSeqID = refSeqID.substring(0, period);
            }
            homolog.setRefSeqID(refSeqID);
        }
    }

    private Homolog parseHsp(Element root, Homolog homolog) {
        String bitScoreString = root.getChild("Hsp_bit-score").getText().trim();
        String scoreString = root.getChild("Hsp_score").getText().trim();
        String eValueString = root.getChild("Hsp_evalue").getText().trim();
        double bitScore = -1.0;
        int score = -1;
        double eValue = -1.0;
        try {
            bitScore = Double.parseDouble(bitScoreString);
            score = Integer.parseInt(scoreString);
            eValue = Double.parseDouble(eValueString);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        homolog.setScore(score);
        homolog.setEValue(eValue);
        return homolog;
    }

    protected void parseXml() throws Exception {
        if ("".equals(this.xmlResult)) {
            return;
        }
        File tmpXmlFile = File.createTempFile("blast.", ".xml");
        tmpXmlFile.deleteOnExit();
        this.tmpXmlFileName = tmpXmlFile.getPath();
        FileWriter fileWriter = new FileWriter(tmpXmlFile);
        int newHeadOfDocument = this.xmlResult.indexOf("<BlastOutput>");
        fileWriter.write(this.xmlResult.substring(newHeadOfDocument));
        fileWriter.flush();
        fileWriter.close();
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(this.tmpXmlFileName);
        Element root = doc.getRootElement();
        Element e0 = root.getChild("BlastOutput_iterations");
        List iterations = e0.getChildren("Iteration");
        ListIterator iterator = iterations.listIterator();
        while (iterator.hasNext()) {
            Element iteration = (Element)iterator.next();
            this.parseIteration(iteration);
        }
    }

    public HomologSet getResults() {
        return this.homologSet;
    }
}

