/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.dreiss.httpdata;

import csplugins.isb.dreiss.httpdata.Homolog;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

public class HomologSet
implements Serializable {
    String sourceSequenceName;
    String sourceSequenceCommonName;
    String sourceSpecies;
    String targetSequenceFileName;
    String sourceSequence;
    public static final int DEFAULT_MAX_HITS = 100;
    int maxHits = 100;
    Vector hits = new Vector();
    String status = "unassigned";
    Date submissionTime;
    Date startExecutionTime;
    Date completionTime;

    public HomologSet(String sourceSequenceName, String sourceSpecies, String sourceSequence, String targetSequenceFileName, int maxHits) {
        this.sourceSequenceName = sourceSequenceName;
        this.sourceSpecies = sourceSpecies;
        this.targetSequenceFileName = targetSequenceFileName;
        this.sourceSequence = sourceSequence;
        this.maxHits = maxHits;
        this.setStartExecutionTime();
    }

    public HomologSet(String sourceSequenceName, String sourceSpecies, String sourceSequence, String targetSequenceFileName) {
        this(sourceSequenceName, sourceSpecies, sourceSequence, targetSequenceFileName, 100);
    }

    public String getSourceSequenceName() {
        return this.sourceSequenceName;
    }

    public void setSourceSequenceCommonName(String newValue) {
        this.sourceSequenceCommonName = newValue;
    }

    public String getSourceSequenceCommonName() {
        return this.sourceSequenceCommonName;
    }

    public String getSourceSpecies() {
        return this.sourceSpecies;
    }

    public String getTargetSequenceFileName() {
        return this.targetSequenceFileName;
    }

    public String getTargetSpecies() {
        if (this.size() == 0) {
            return "unknown species";
        }
        return this.get(0).getTargetSpecies();
    }

    public String getSourceSequence() {
        return this.sourceSequence;
    }

    public int getMaxHits() {
        return this.maxHits;
    }

    public int size() {
        return this.hits.size();
    }

    public void addHit(Homolog sequence) {
        this.hits.add(sequence);
    }

    public Homolog[] getAll() {
        return this.hits.toArray(new Homolog[0]);
    }

    public Homolog get(int index) {
        if (this.hits.size() >= index) {
            return (Homolog)this.hits.get(index);
        }
        throw new IllegalArgumentException("no Homolog #" + index + " in HomologSet " + " length = " + this.size());
    }

    public void setStatus(String newValue) {
        this.status = newValue;
    }

    public String getStatus() {
        return this.status;
    }

    public void setSubmissionTime() {
        this.submissionTime = new Date();
    }

    public void setStartExecutionTime() {
        this.startExecutionTime = new Date();
    }

    public void setCompletionTime() {
        this.completionTime = new Date();
    }

    public Date getSubmissionTime() {
        return this.submissionTime;
    }

    public Date getStartExecutionTime() {
        return this.startExecutionTime;
    }

    public Date getCompletionTime() {
        return this.completionTime;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("             sourceSequenceName: " + this.sourceSequenceName);
        sb.append("   (" + this.sourceSpecies + ")");
        sb.append("\n");
        sb.append("        source sequence: " + this.sourceSequence.substring(0, 12) + "...");
        sb.append("\n");
        sb.append("         target species: " + this.targetSequenceFileName);
        sb.append("\n");
        sb.append("               max hits: " + this.maxHits);
        sb.append("\n");
        sb.append("              hit count: " + this.hits.size());
        sb.append("\n");
        sb.append("                 status: " + this.status);
        sb.append("\n");
        sb.append("                  times: " + this.submissionTime + ", " + this.startExecutionTime + ", " + this.completionTime);
        sb.append("\n");
        return sb.toString();
    }
}

