/*
 * Decompiled with CFR 0.152.
 */
package SBEAMS;

import SBEAMS.PasswordDialog;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SBEAMSClient {
    private String cookie = null;
    private static String userName;
    private static String password;
    private boolean useGui = false;
    private int passwordAttempts = 3;
    private static boolean DEBUG;
    private static String COOKIE_URL;
    private static String DEFAULT_COOKIE_FILE;
    private static String COOKIE_ERROR;

    public SBEAMSClient() throws Exception {
    }

    public SBEAMSClient(boolean bl) throws Exception {
        this.useGui = bl;
    }

    public SBEAMSClient(String string, String string2) throws Exception {
        userName = string;
        password = string2;
    }

    protected void destroyCookie() {
        this.cookie = null;
    }

    protected boolean findCookie(String string) {
        boolean bl = false;
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                Pattern pattern = Pattern.compile("(SBEAMSName\\=(.+)\\;)");
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.matches()) continue;
                this.cookie = matcher.group(1);
                bl = true;
            }
        }
        catch (IOException iOException) {
            System.err.println("Cookie File Error or Not Found");
            bl = false;
        }
        return bl;
    }

    protected boolean findCookie() {
        return this.findCookie(DEFAULT_COOKIE_FILE);
    }

    protected void saveCookie(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write(this.cookie);
            bufferedWriter.newLine();
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            System.err.println("Can't write to cookie file");
            iOException.printStackTrace();
        }
    }

    protected void saveCookie() {
        this.saveCookie(DEFAULT_COOKIE_FILE);
    }

    public String getCookie() {
        return this.cookie;
    }

    public void setCookie(String string) {
        this.cookie = string;
    }

    public boolean goodCookie() {
        if (this.cookie == null) {
            return false;
        }
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("Jan", new Integer(1));
        hashtable.put("Feb", new Integer(2));
        hashtable.put("Mar", new Integer(3));
        hashtable.put("Apr", new Integer(4));
        hashtable.put("May", new Integer(5));
        hashtable.put("Jun", new Integer(6));
        hashtable.put("Jly", new Integer(7));
        hashtable.put("Aug", new Integer(8));
        hashtable.put("Sep", new Integer(9));
        hashtable.put("Oct", new Integer(10));
        hashtable.put("Nov", new Integer(11));
        hashtable.put("Dec", new Integer(12));
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Pattern pattern = Pattern.compile("expires\\=(\\w+)\\,\\s?(\\d+)\\-(\\w+)\\-(\\d+)\\s+(\\d+)\\:(\\d+)\\:(\\d+)\\;?");
        Matcher matcher = pattern.matcher(this.cookie);
        if (!matcher.matches()) {
            return false;
        }
        n3 = new Integer(matcher.group(2));
        n2 = (Integer)hashtable.get(matcher.group(3));
        n = new Integer(matcher.group(4));
        n4 = new Integer(matcher.group(5));
        n5 = new Integer(matcher.group(6));
        n6 = new Integer(matcher.group(7));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = new Date();
        gregorianCalendar.setTime(date);
        if (gregorianCalendar.get(1) < n) {
            return true;
        }
        if (gregorianCalendar.get(1) > n) {
            return false;
        }
        if (gregorianCalendar.get(2) + 1 < n2) {
            return true;
        }
        if (gregorianCalendar.get(2) + 1 > n2) {
            return false;
        }
        if (gregorianCalendar.get(5) < n3) {
            return true;
        }
        if (gregorianCalendar.get(5) > n3) {
            return false;
        }
        if (gregorianCalendar.get(11) < n4) {
            return true;
        }
        if (gregorianCalendar.get(11) > n4) {
            return false;
        }
        if (gregorianCalendar.get(12) < n5) {
            return true;
        }
        if (gregorianCalendar.get(12) > n5) {
            return false;
        }
        if (gregorianCalendar.get(13) < n6) {
            return true;
        }
        if (gregorianCalendar.get(13) > n6) {
            return false;
        }
        return false;
    }

    private Response postRequest(String string, String string2) throws Exception {
        String string3;
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setAllowUserInteraction(false);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("ContentType", "application/x-www-form-urlencoded");
        httpURLConnection.setRequestProperty("User-Agent", "CytoLinkFromMJ");
        if (this.cookie != null) {
            httpURLConnection.setRequestProperty("Cookie", this.cookie);
        }
        PrintStream printStream = new PrintStream(httpURLConnection.getOutputStream());
        printStream.print(string2);
        printStream.flush();
        printStream.close();
        httpURLConnection.connect();
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        while ((string3 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string3 + "\n");
        }
        bufferedReader.close();
        Response response = new Response();
        response.content = stringBuffer.toString();
        response.contentType = httpURLConnection.getHeaderField("Content-Type");
        response.cookie = httpURLConnection.getHeaderField("Set-Cookie");
        return response;
    }

    public String fetchSbeamsPage(String string, String string2) throws Exception {
        if (this.cookie == null) {
            this.fetchCookie();
        }
        String string3 = new String();
        String string4 = string;
        Pattern pattern = Pattern.compile("(.*)\\?(.*)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            string4 = matcher.group(1);
            string3 = matcher.group(2);
            string2 = string2 == null ? string3 : string2 + string3;
        }
        Response response = new Response();
        response = this.postRequest(string4, string2);
        return response.content;
    }

    public String fetchSbeamsPage(String string) throws Exception {
        if (this.cookie == null) {
            this.fetchCookie();
        }
        return this.fetchSbeamsPage(string, "");
    }

    public String[] fetchSbeamsResultSetColumn(String string, String string2) throws Exception {
        int n;
        if (this.cookie == null) {
            this.fetchCookie();
        }
        String string3 = this.fetchSbeamsPage(string, "");
        String[] stringArray = string3.split("\\n");
        String[] stringArray2 = stringArray[0].split("\\t");
        String[] stringArray3 = new String[stringArray.length - 1];
        int n2 = -1;
        for (n = 0; n < stringArray2.length; ++n) {
            if (!string2.equals(stringArray2[n])) continue;
            n2 = n;
        }
        if (n2 == -1) {
            return null;
        }
        for (n = 0; n < stringArray3.length; ++n) {
            String[] stringArray4 = stringArray[n + 1].split("\\t");
            stringArray3[n] = stringArray4[n2];
        }
        return stringArray3;
    }

    public String[][] fetchSbeamsResultSetColumns(String string, String[] stringArray) throws Exception {
        int n;
        if (this.cookie == null) {
            this.fetchCookie();
        }
        String string2 = this.fetchSbeamsPage(string, "");
        String[] stringArray2 = string2.split("\\n");
        String[] stringArray3 = stringArray2[0].split("\\t");
        String[][] stringArray4 = new String[stringArray2.length - 1][stringArray.length];
        int[] nArray = new int[stringArray.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -1;
        }
        for (n = 0; n < stringArray.length; ++n) {
            for (int i = 0; i < stringArray3.length; ++i) {
                if (!stringArray[n].equals(stringArray3[i])) continue;
                nArray[n] = i;
            }
        }
        for (n = 0; n < stringArray4.length; ++n) {
            String[] stringArray5 = stringArray2[n + 1].split("\\t");
            System.out.println(stringArray2[n + 1]);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < 0) continue;
                stringArray4[n][i] = stringArray5[nArray[i]];
            }
        }
        return stringArray4;
    }

    public Hashtable fetchSbeamsResultSetHash(String string, String string2, String string3) throws Exception {
        int n;
        if (this.cookie == null) {
            this.fetchCookie();
        }
        String string4 = this.fetchSbeamsPage(string, "");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray = string4.split("\\n");
        String[] stringArray2 = stringArray[0].split("\\t");
        String[] stringArray3 = new String[stringArray.length - 1];
        int n2 = -1;
        int n3 = -1;
        for (n = 0; n < stringArray2.length; ++n) {
            if (string2.equals(stringArray2[n])) {
                n2 = n;
            }
            if (!string3.equals(stringArray2[n])) continue;
            n3 = n;
        }
        if (n2 == -1 || n3 == -1) {
            return null;
        }
        for (n = 0; n < stringArray3.length; ++n) {
            String[] stringArray4 = stringArray[n + 1].split("\\t");
            if (stringArray2.length != stringArray4.length) continue;
            hashtable.put(stringArray4[n2], stringArray4[n3]);
        }
        return hashtable;
    }

    protected boolean promptForUsernamePassword() {
        return this.promptForUsernamePassword(this.useGui);
    }

    protected boolean promptForUsernamePassword(boolean bl) {
        boolean bl2 = true;
        if (bl) {
            PasswordDialog passwordDialog = new PasswordDialog("Cytoscape SBEAMS Login");
            if (userName != null) {
                passwordDialog.setName(userName);
                passwordDialog.setPasswordFocus();
            }
            if (passwordDialog.showDialog()) {
                userName = passwordDialog.getName();
                password = passwordDialog.getPass();
            } else {
                System.err.println("User selected cancel");
                bl2 = false;
            }
            passwordDialog.dispose();
        } else {
            String string;
            BufferedReader bufferedReader;
            System.out.print("Enter SBEAMS Username: ");
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                while ((string = bufferedReader.readLine()) == null) {
                }
                userName = string;
            }
            catch (Exception exception) {
                bl2 = false;
            }
            System.out.print("Enter Password: ");
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                while ((string = bufferedReader.readLine()) == null) {
                }
                password = string;
            }
            catch (Exception exception) {
                bl2 = false;
            }
            System.out.println("Thanks for the Username/Password Information, " + userName + "!");
        }
        return bl2;
    }

    private void fetchCookie() throws Exception {
        while (this.passwordAttempts > 0) {
            if (userName == null || password == null) {
                this.promptForUsernamePassword();
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("username");
            stringBuffer.append("=");
            stringBuffer.append(URLEncoder.encode(userName, "UTF8"));
            stringBuffer.append("&");
            stringBuffer.append("password");
            stringBuffer.append("=");
            stringBuffer.append(URLEncoder.encode(password, "UTF8"));
            stringBuffer.append("&");
            stringBuffer.append("login");
            stringBuffer.append("=");
            stringBuffer.append(URLEncoder.encode(" Login ", "UTF8"));
            Response response = this.postRequest(COOKIE_URL, stringBuffer.toString());
            this.cookie = response.cookie;
            if (response.cookie != null) break;
            password = null;
            --this.passwordAttempts;
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("test SBEAMS Table Retrieval");
        try {
            SBEAMSClient sBEAMSClient = new SBEAMSClient(true);
            System.out.println(sBEAMSClient.fetchSbeamsPage("https://db.systemsbiology.net/sbeams/cgi/ProteinStructure/GetAnnotations?search_scope=All&search_key=iron&action=GO&biosequence_set_id=3&action=QUERY&output_mode=tsv"));
        }
        catch (IOException iOException) {
            System.err.println("Page Not Found");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    static {
        DEBUG = false;
        COOKIE_URL = "https://db.systemsbiology.net/sbeams/cgi/main.cgi";
        DEFAULT_COOKIE_FILE = "./.sbeamsCookie";
        COOKIE_ERROR = "badCookie";
    }

    protected static class Response {
        String contentType = null;
        String cookie = null;
        String content = null;

        protected Response() {
        }
    }
}

