/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.gaggle.lister;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Lister
extends JFrame {
    String[] listData = new String[]{"VNG0040C", "VNG0044H", "VNG0050C", "VNG0156C", "VNG0194H", "VNG0247C", "VNG0254G", "VNG0258H", "VNG0293H", "VNG0296H", "VNG0320H"};
    JList listbox;
    ListSelectionModel lsm;
    JToolBar toolbar;
    ArrayList currentSelection;

    public Lister() {
        super("Lister");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.getContentPane().add(this.createGui());
        this.setSize(300, 300);
        this.show();
    }

    JPanel createGui() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BorderLayout());
        this.toolbar = this.createToolBar();
        jPanel.add((Component)this.toolbar, "North");
        Arrays.sort(this.listData, String.CASE_INSENSITIVE_ORDER);
        this.listbox = new JList<String>(this.listData);
        this.listbox.setSelectionMode(2);
        JScrollPane jScrollPane = new JScrollPane(this.listbox);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("Clear");
        JButton jButton2 = new JButton("Select All");
        JButton jButton3 = new JButton("Describe");
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        jButton.addActionListener(new ClearSelectionAction());
        jButton2.addActionListener(new SelectAllAction());
        jButton3.addActionListener(new DescribeAction());
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    protected JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(new ExitAction());
        return jToolBar;
    }

    public JToolBar getToolBar() {
        return this.toolbar;
    }

    private void placeInCenter() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n = (int)graphicsConfiguration.getBounds().getHeight();
        int n2 = (int)graphicsConfiguration.getBounds().getWidth();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        this.setLocation((n2 - n3) / 2, (n - n4) / 2);
    }

    public void select(String[] stringArray) {
        int n;
        Object object;
        int n2;
        ListModel listModel = this.listbox.getModel();
        int[] nArray = this.listbox.getSelectedIndices();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            arrayList.add(new Integer(nArray[n2]));
        }
        for (n2 = 0; n2 < listModel.getSize(); ++n2) {
            Integer n3;
            object = (String)listModel.getElementAt(n2);
            if (Arrays.binarySearch(stringArray, object) < 0 || arrayList.contains(n3 = new Integer(n2))) continue;
            arrayList.add(n3);
        }
        n2 = arrayList.size();
        object = new int[n2];
        for (n = 0; n < n2; ++n) {
            int n4 = (Integer)arrayList.get(n);
            object[n] = n4;
        }
        for (n = 0; n < n2; ++n) {
            this.listbox.setSelectedIndices((int[])object);
        }
    }

    public void clearSelection() {
        this.listbox.clearSelection();
    }

    public String[] getCurrentSelection() {
        Object[] objectArray = this.listbox.getSelectedValues();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    public static void main(String[] stringArray) throws Exception {
        new Lister();
    }

    class ListboxSelectionListener
    implements ListSelectionListener {
        ListboxSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            Lister.this.currentSelection = new ArrayList();
            if (!listSelectionModel.isSelectionEmpty()) {
                int n = listSelectionModel.getMinSelectionIndex();
                int n2 = listSelectionModel.getMaxSelectionIndex();
                for (int i = n; i <= n2; ++i) {
                    if (!listSelectionModel.isSelectedIndex(i)) continue;
                    Lister.this.currentSelection.add(Lister.this.listData[i]);
                }
            }
        }
    }

    class DescribeAction
    extends AbstractAction {
        DescribeAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = Lister.this.listbox.getSelectedIndices();
            System.out.print("selection count: " + nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                System.out.print("  " + nArray[i]);
            }
            System.out.println();
        }
    }

    class SelectAllAction
    extends AbstractAction {
        SelectAllAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = Lister.this.listbox.getModel().getSize();
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
            Lister.this.listbox.setSelectedIndices(nArray);
        }
    }

    class ClearSelectionAction
    extends AbstractAction {
        ClearSelectionAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Lister.this.clearSelection();
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
            super("Exit");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    }
}

