/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.gaggle.sbeams;

import csplugins.isb.pshannon.gaggle.Boss;
import csplugins.isb.pshannon.gaggle.GuiBoss;
import csplugins.isb.pshannon.gaggle.sbeams.SBEAMSClient;
import csplugins.isb.pshannon.gaggle.sbeams.SbeamsResultSetTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class SBeamsSearchPanel
extends JPanel {
    String name = "SBEAMS Search Panel";
    private JScrollPane scrollPane;
    private JTextField searchBox;
    SbeamsResultSetTableModel sbeamsResultSetTableModel;
    JTable sbeamsResultSetTable;
    private JButton broadcastSbeamsSelectionsButton;
    private JButton selectAllSbeamsRowsButton;
    private JButton clearAllSbeamsSelectionsButton;
    private Boss gaggleBoss;
    private String species = "Halobacterium sp.";

    public SBeamsSearchPanel(GuiBoss guiBoss) {
        this.gaggleBoss = guiBoss;
        this.createGui();
    }

    protected void createGui() {
        this.add(new JButton("Leo"));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("Search");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SBeamsSearchPanel.this.performSearch();
            }
        });
        this.searchBox = new JTextField(20);
        this.searchBox.addActionListener(new DoSearchAction());
        JButton jButton2 = new JButton("Clear");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SBeamsSearchPanel.this.searchBox.setText("");
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(this.searchBox);
        jPanel2.add(jButton2);
        this.selectAllSbeamsRowsButton = new JButton("Select All");
        this.clearAllSbeamsSelectionsButton = new JButton("Clear All");
        this.broadcastSbeamsSelectionsButton = new JButton("Broadcast");
        this.selectAllSbeamsRowsButton.setEnabled(false);
        this.clearAllSbeamsSelectionsButton.setEnabled(false);
        this.broadcastSbeamsSelectionsButton.setEnabled(false);
        this.selectAllSbeamsRowsButton.addActionListener(new SelectAllSbeamsRowsAction());
        this.clearAllSbeamsSelectionsButton.addActionListener(new ClearAllSbeamsSelectionsAction());
        this.broadcastSbeamsSelectionsButton.addActionListener(new BroadcastSbeamsSelectionAction());
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this.createSbeamsResultSetTable(), "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.selectAllSbeamsRowsButton);
        jPanel3.add(this.clearAllSbeamsSelectionsButton);
        jPanel3.add(this.broadcastSbeamsSelectionsButton);
        jPanel.add((Component)jPanel3, "South");
        this.add(jPanel);
    }

    protected JPanel createSbeamsResultSetTable() {
        this.sbeamsResultSetTableModel = new SbeamsResultSetTableModel();
        this.sbeamsResultSetTable = new JTable(this.sbeamsResultSetTableModel);
        this.sbeamsResultSetTable.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.sbeamsResultSetTable.getColumnModel().getColumn(0).setMaxWidth(40);
        this.sbeamsResultSetTable.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.sbeamsResultSetTable.getColumnModel().getColumn(1).setMaxWidth(70);
        this.sbeamsResultSetTable.getColumnModel().getColumn(2).setPreferredWidth(70);
        this.sbeamsResultSetTable.getColumnModel().getColumn(2).setMaxWidth(70);
        this.sbeamsResultSetTable.setShowHorizontalLines(true);
        this.sbeamsResultSetTable.setShowVerticalLines(true);
        this.sbeamsResultSetTable.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.scrollPane = new JScrollPane(this.sbeamsResultSetTable);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add((Component)this.scrollPane, "Center");
        return jPanel2;
    }

    protected void performSearch() {
        String string = this.searchBox.getText().trim();
        this.sbeamsResultSetTableModel.clearData();
        this.broadcastSbeamsSelectionsButton.setEnabled(false);
        this.selectAllSbeamsRowsButton.setEnabled(false);
        this.clearAllSbeamsSelectionsButton.setEnabled(false);
        if (string.length() > 0) {
            String[] stringArray = this.doSbeamsSearch(string);
            if (stringArray.length > 0) {
                this.broadcastSbeamsSelectionsButton.setEnabled(true);
                this.selectAllSbeamsRowsButton.setEnabled(true);
                this.clearAllSbeamsSelectionsButton.setEnabled(true);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("\t");
                if (stringArray2.length < 4) continue;
                String string2 = stringArray2[0];
                String string3 = stringArray2[1];
                String string4 = stringArray2[2];
                String string5 = stringArray2[3];
                this.sbeamsResultSetTableModel.addSearchResult(string2, string3, string4, string5);
            }
            this.sbeamsResultSetTableModel.fireTableStructureChanged();
        }
    }

    protected String[] doSbeamsSearch(String string) {
        String[] stringArray;
        string = string.replaceAll(";", "%3B");
        String string2 = "https://db.systemsbiology.net/sbeams/cgi/ProteinStructure/GetAnnotations?";
        String string3 = "search_scope=All&search_key=";
        String string4 = "&action=GO&biosequence_set_id=2&action=QUERY&output_mode=tsv";
        String string5 = string2 + string3 + string + string4;
        String string6 = "";
        try {
            stringArray = new SBEAMSClient(true);
            string6 = stringArray.fetchSbeamsPage(string5);
        }
        catch (IOException iOException) {
            System.err.println("Page Not Found");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        stringArray = string6.split("\n");
        if (stringArray.length <= 1) {
            return new String[]{"no match\t\t\t"};
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        for (int i = 1; i < stringArray.length; ++i) {
            stringArray2[i - 1] = stringArray[i];
        }
        return stringArray2;
    }

    public void select(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.searchBox.getText());
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(";");
            }
            stringBuffer.append(stringArray[i]);
        }
        this.searchBox.setText(stringBuffer.toString());
    }

    class DoSearchAction
    extends AbstractAction {
        DoSearchAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SBeamsSearchPanel.this.performSearch();
        }
    }

    class ClearAllSbeamsSelectionsAction
    extends AbstractAction {
        ClearAllSbeamsSelectionsAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SBeamsSearchPanel.this.sbeamsResultSetTable.clearSelection();
        }
    }

    class SelectAllSbeamsRowsAction
    extends AbstractAction {
        SelectAllSbeamsRowsAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SBeamsSearchPanel.this.sbeamsResultSetTable.selectAll();
        }
    }

    class BroadcastSbeamsSelectionAction
    extends AbstractAction {
        BroadcastSbeamsSelectionAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = SBeamsSearchPanel.this.sbeamsResultSetTable.getSelectedRows();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < nArray.length; ++i) {
                String string = (String)SBeamsSearchPanel.this.sbeamsResultSetTableModel.getValueAt(nArray[i], 0);
                string = string.toUpperCase();
                arrayList.add(string);
            }
            try {
                SBeamsSearchPanel.this.gaggleBoss.select(SBeamsSearchPanel.this.species, arrayList.toArray(new String[0]));
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
    }
}

