/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.gaggle.lister;

import csplugins.isb.pshannon.experiment.datamatrix.LensedDataMatrix;
import csplugins.isb.pshannon.gaggle.Boss;
import csplugins.isb.pshannon.gaggle.Goose;
import csplugins.isb.pshannon.gaggle.lister.Lister;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JFrame;

public class GaggledLister
implements Goose,
Serializable {
    String name = "lister";
    Lister lister;
    Boss gaggleBoss;
    String species = "Halobacterium sp.";

    public GaggledLister() {
        this.lister = new Lister();
        WindowListener[] windowListenerArray = this.lister.getWindowListeners();
        for (int i = 0; i < windowListenerArray.length; ++i) {
            this.lister.removeWindowListener(windowListenerArray[i]);
        }
        this.lister.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                System.out.println("GW detects Lister windowClosed");
            }

            public void windowStateChanged(WindowEvent windowEvent) {
                System.out.println("GW detects Lister windowStateChange");
            }

            public void windowClosing(WindowEvent windowEvent) {
                System.out.println("GW detects Lister windowClosing");
                try {
                    GaggledLister.this.gaggleBoss.cleanUpOnExit(GaggledLister.this.name);
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
        });
        this.lister.getToolBar().add(new BroadcastSelectionAction());
        this.lister.pack();
    }

    private Lister getLister() {
        return this.lister;
    }

    public GaggledLister(JFrame jFrame, String string) {
    }

    public synchronized void select(String string, String[] stringArray) throws RemoteException {
        this.lister.select(stringArray);
    }

    public void handleLens(LensedDataMatrix lensedDataMatrix) {
    }

    public void handleBroadcastAttributes(HashMap hashMap) {
    }

    public void handleCluster(String[] stringArray, String[] stringArray2) {
    }

    public String getName() {
        return this.name;
    }

    public int getSelectionCount() {
        return this.lister.getCurrentSelection().length;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void hide() {
        this.lister.hide();
    }

    public void show() {
        this.lister.show();
        this.lister.toFront();
    }

    public void setGeometry(int n, int n2, int n3, int n4) {
        this.lister.setSize(n3, n4);
        this.lister.setLocation(n, n2);
    }

    public void exit() {
        System.exit(0);
    }

    public void connectToGaggle() throws Exception {
        String string = "gaggle";
        String string2 = "localhost";
        String string3 = "rmi://" + string2 + "/" + string;
        try {
            this.gaggleBoss = (Boss)Naming.lookup(string3);
            String string4 = this.gaggleBoss.register(this);
            this.lister.setTitle(string4);
        }
        catch (Exception exception) {
            System.err.println("GaggledLister failed to connect to gaggle at " + string3);
        }
    }

    public void clearSelections() {
        this.lister.clearSelection();
    }

    public void doBroadcast() {
        String[] stringArray = this.lister.getCurrentSelection();
        try {
            this.gaggleBoss.select(this.species, stringArray);
        }
        catch (RemoteException remoteException) {
            System.err.println("error rmi selecting at boss, from GaggleLister " + this.name);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        GaggledLister gaggledLister = new GaggledLister();
        UnicastRemoteObject.exportObject(gaggledLister);
        gaggledLister.connectToGaggle();
    }

    protected class BroadcastSelectionAction
    extends AbstractAction {
        BroadcastSelectionAction() {
            super("Broadcast");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GaggledLister.this.doBroadcast();
        }
    }
}

