/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.gaggle.cy;

import csplugins.isb.pshannon.experiment.datamatrix.LensedDataMatrix;
import csplugins.isb.pshannon.gaggle.Boss;
import csplugins.isb.pshannon.gaggle.Goose;
import cytoscape.AbstractPlugin;
import cytoscape.CytoscapeWindow;
import cytoscape.GraphObjAttributes;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import y.base.Node;
import y.view.Graph2D;

public class CyGagglePlugin
extends AbstractPlugin
implements Goose,
Serializable {
    CytoscapeWindow cw;
    String name = "cytoscape";
    Boss gaggleBoss;
    String species;

    public CyGagglePlugin(CytoscapeWindow cytoscapeWindow) {
        this.cw = cytoscapeWindow;
        this.species = this.cw.getDefaultSpecies();
        try {
            UnicastRemoteObject.exportObject(this);
            this.connectToGaggle();
            this.cw.getToolBar().add(new BroadcastSelectionAction());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doBroadcast() {
        Graph2D graph2D = this.cw.getGraph();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String[] stringArray = graph2D.selectedNodes();
            while (stringArray.ok()) {
                Node node = stringArray.node();
                String string = this.cw.getCanonicalNodeName(node);
                String string2 = this.cw.getNodeAttributes().getStringValue("species", string);
                arrayList.add(string);
                stringArray.next();
            }
            if (arrayList.size() > 0) {
                stringArray = arrayList.toArray(new String[0]);
                this.gaggleBoss.select(this.species, stringArray);
            }
        }
        catch (RemoteException remoteException) {
            System.err.println("error rmi selecting at boss, from GaggleLister " + this.name);
        }
    }

    public synchronized void select(String string, String[] stringArray) throws RemoteException {
        boolean bl = false;
        this.cw.selectNodesByName(stringArray, bl);
    }

    public void handleLens(LensedDataMatrix lensedDataMatrix) throws RemoteException {
        String[] stringArray = lensedDataMatrix.getRowTitles();
        this.select(this.species, stringArray);
    }

    public void handleBroadcastAttributes(HashMap hashMap) {
        String[] stringArray = hashMap.keySet().toArray(new String[0]);
        GraphObjAttributes graphObjAttributes = this.cw.getNodeAttributes();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            ArrayList arrayList = (ArrayList)hashMap.get(string);
            String[] stringArray2 = (String[])arrayList.get(0);
            double[] dArray = (double[])arrayList.get(1);
            for (int j = 0; j < stringArray2.length; ++j) {
                graphObjAttributes.set(string, stringArray2[j], dArray[j]);
            }
        }
        this.cw.redrawGraph();
    }

    public void handleCluster(String[] stringArray, String[] stringArray2) throws RemoteException {
        this.select(this.species, stringArray);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        this.cw.getMainFrame().setTitle(this.name);
    }

    public int getSelectionCount() {
        return this.cw.getGraph().selectedNodes().size();
    }

    public void hide() {
        this.cw.getMainFrame().hide();
    }

    public void show() {
        this.cw.getMainFrame().show();
        this.cw.getMainFrame().toFront();
    }

    public void clearSelections() {
        this.cw.selectNodes(new Node[0], true);
    }

    public void setGeometry(int n, int n2, int n3, int n4) {
        this.cw.getMainFrame().setSize(n3, n4);
        this.cw.getMainFrame().setLocation(n, n2);
    }

    public void exit() {
        try {
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (Exception exception) {
            System.err.println("exception while unexporting CyGagglePlugin " + this.getName());
        }
        this.cw.getMainFrame().dispose();
    }

    public void connectToGaggle() {
        String string = "gaggle";
        String string2 = "localhost";
        String string3 = "rmi://" + string2 + "/" + string;
        try {
            this.gaggleBoss = (Boss)Naming.lookup(string3);
            String string4 = this.gaggleBoss.register(this);
            this.cw.getMainFrame().setTitle(string4);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.cw.getMainFrame(), "Could not connect to gaggle");
        }
    }

    protected class BroadcastSelectionAction
    extends AbstractAction {
        BroadcastSelectionAction() {
            super("Broadcast");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CyGagglePlugin.this.doBroadcast();
        }
    }
}

