/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.gaggle;

import csplugins.isb.pshannon.experiment.datamatrix.LensedDataMatrix;
import csplugins.isb.pshannon.gaggle.Boss;
import csplugins.isb.pshannon.gaggle.DeafGoose;
import csplugins.isb.pshannon.gaggle.GaggleBossTableModel;
import csplugins.isb.pshannon.gaggle.Goose;
import csplugins.isb.pshannon.gaggle.NameUniquifier;
import csplugins.isb.pshannon.gaggle.TileCalculator;
import csplugins.isb.pshannon.gaggle.sbeams.SBeamsSearchPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public final class GuiBoss
extends UnicastRemoteObject
implements Boss,
WindowListener,
Serializable {
    private JFrame frame;
    private JTable gooseTable;
    private JScrollPane scrollPane;
    private JTextField searchBox;
    private GaggleBossTableModel gooseTableModel;
    String serviceName = "gaggle";
    protected HashMap gooseMap;
    protected HashMap gooseListeningMap;
    transient NameUniquifier nameUniquifier;
    ArrayList deafGeese = new ArrayList();
    SBeamsSearchPanel sbeamsSearchTab;

    public GuiBoss() throws RemoteException {
        this.gooseMap = new HashMap();
        this.gooseListeningMap = new HashMap();
        this.nameUniquifier = new NameUniquifier();
        this.frame = new JFrame(this.createFrameTitle());
        try {
            LocateRegistry.createRegistry(1099);
            Naming.rebind(this.serviceName, this);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.frame, "Gaggle Port already in use.  Exiting....");
            System.exit(0);
        }
        this.frame.setDefaultCloseOperation(3);
        this.frame.addWindowListener(this);
        this.frame.getContentPane().add(this.createGui());
        this.placeInCenter();
        this.frame.pack();
        this.frame.setVisible(true);
        this.frame.toFront();
    }

    public String renameGoose(String string, String string2) {
        String string3 = this.nameUniquifier.makeUnique(string2);
        if (this.gooseMap.containsKey(string)) {
            Goose goose = (Goose)this.gooseMap.get(string);
            this.gooseMap.remove(string);
            this.gooseMap.put(string3, goose);
            try {
                goose.setName(string3);
                return string3;
            }
            catch (RemoteException remoteException) {
                String string4 = "Failed to contact goose to rename: " + string + " -> " + string3;
                JOptionPane.showMessageDialog(this.frame, string4);
            }
        }
        return null;
    }

    protected String createFrameTitle() {
        String string = "$Revision: 1.10 $";
        String string2 = "Revision: ";
        int n = string.indexOf(string2);
        int n2 = string.indexOf(" $", n += string2.length());
        String string3 = string.substring(n, n2);
        return "Gaggle Boss " + string3;
    }

    public String register(Goose goose) throws RemoteException {
        String string = this.nameUniquifier.makeUnique(goose.getName());
        goose.setName(string);
        this.addNewGoose(string, goose);
        return string;
    }

    public String register(DeafGoose deafGoose) throws RemoteException {
        this.deafGeese.add(deafGoose);
        return "";
    }

    public void remove(String string) {
        if (this.gooseMap.containsKey(string)) {
            this.gooseMap.remove(string);
        }
        if (this.gooseListeningMap.containsKey(string)) {
            this.gooseListeningMap.remove(string);
        }
    }

    public Goose[] getGeese() {
        return this.gooseMap.values().toArray(new Goose[0]);
    }

    public String[] getSelectedGooseNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] nArray = this.gooseTable.getSelectedRows();
        String[] stringArray = this.gooseTableModel.getAppNames();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(stringArray[nArray[i]]);
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getUnselectedGooseNames() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int[] nArray = this.gooseTable.getSelectedRows();
        Object[] objectArray = this.getSelectedGooseNames();
        Object[] objectArray2 = this.getGooseNames();
        Arrays.sort(objectArray);
        Arrays.sort(objectArray2);
        for (int i = 0; i < objectArray2.length; ++i) {
            if (Arrays.binarySearch(objectArray, objectArray2[i]) >= 0) continue;
            arrayList.add(objectArray2[i]);
        }
        return arrayList.toArray(new String[0]);
    }

    public Goose getGoose(String string) {
        return (Goose)this.gooseMap.get(string);
    }

    public String[] getGooseNames() {
        return this.gooseMap.keySet().toArray(new String[0]);
    }

    public HashMap getGooseMap() {
        return this.gooseMap;
    }

    protected void broadcastToInternalTabs(String[] stringArray) {
        this.sbeamsSearchTab.select(stringArray);
    }

    public void select(String string, String[] stringArray) throws RemoteException {
        String[] stringArray2 = this.getGooseNames();
        this.broadcastToInternalTabs(stringArray);
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!this.isListening(stringArray2[i])) continue;
            Goose goose = this.getGoose(stringArray2[i]);
            try {
                goose.select(string, stringArray);
                continue;
            }
            catch (Exception exception) {
                System.err.println("error in select request to " + goose.getName());
            }
        }
        this.refresh(true);
    }

    public void broadcast(LensedDataMatrix[] lensedDataMatrixArray) throws RemoteException {
        this.broadcast(lensedDataMatrixArray[0]);
    }

    public void broadcast(LensedDataMatrix lensedDataMatrix) throws RemoteException {
        this.broadcastToInternalTabs(lensedDataMatrix.getRowTitles());
        String[] stringArray = this.getGooseNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!this.isListening(string)) continue;
            Goose goose = this.getGoose(string);
            try {
                goose.handleLens(lensedDataMatrix);
                continue;
            }
            catch (Exception exception) {
                System.err.println("error in handleLens request to " + string);
            }
        }
        this.refresh(true);
    }

    public void broadcastAttributes(HashMap hashMap) {
        String[] stringArray = this.getGooseNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!this.isListening(string)) continue;
            Goose goose = this.getGoose(string);
            try {
                goose.handleBroadcastAttributes(hashMap);
                continue;
            }
            catch (Exception exception) {
                System.err.println("error in broadcast (attributeMap) to " + string);
            }
        }
    }

    public void broadcastCluster(String[] stringArray, String[] stringArray2) {
        this.broadcastToInternalTabs(stringArray);
        String[] stringArray3 = this.getGooseNames();
        for (int i = 0; i < stringArray3.length; ++i) {
            String string = stringArray3[i];
            if (!this.isListening(string)) continue;
            Goose goose = this.getGoose(string);
            try {
                goose.handleCluster(stringArray, stringArray2);
                continue;
            }
            catch (Exception exception) {
                System.err.println("error in broadcastCluster () to " + string);
            }
        }
    }

    public void cleanUpOnExit(String string) throws RemoteException {
    }

    public void hide(String string) throws RemoteException {
        String[] stringArray = this.getGooseNames();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                if (!string.equals(stringArray[i])) continue;
                Goose goose = this.getGoose(stringArray[i]);
                goose.hide();
                continue;
            }
            catch (Exception exception) {
                System.err.println("error in hide request to " + stringArray[i]);
            }
        }
    }

    public void show(String string) throws RemoteException {
        String[] stringArray = this.getGooseNames();
        Goose goose = this.getGoose(string);
        try {
            goose.show();
        }
        catch (Exception exception) {
            System.err.println("error in show request to " + string);
        }
    }

    public void clearSelections(String string) throws RemoteException {
        Goose goose = this.getGoose(string);
        try {
            goose.clearSelections();
        }
        catch (Exception exception) {
            System.err.println("error in clearSelections request to " + string);
        }
    }

    public void setGeometry(String string, int n, int n2, int n3, int n4) throws RemoteException {
        Goose goose = this.getGoose(string);
        try {
            goose.setGeometry(n, n2, n3, n4);
        }
        catch (Exception exception) {
            System.err.println("error in setGeometry request to " + string);
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void terminate(String string) throws RemoteException {
        Goose goose = this.getGoose(string);
        try {
            goose.exit();
        }
        catch (UnmarshalException unmarshalException) {
        }
        catch (Exception exception) {
            System.err.println("error in terminate request to " + string + ": " + exception.getMessage());
        }
    }

    protected JPanel createGui() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, "Center");
        jTabbedPane.add((Component)this.createGaggleControlPanel(), "Gaggle");
        this.sbeamsSearchTab = new SBeamsSearchPanel(this);
        jTabbedPane.add((Component)this.sbeamsSearchTab, "SBEAMS");
        return jPanel;
    }

    protected JPanel createGaggleControlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        int n = 20;
        int n2 = 10;
        int n3 = 20;
        jPanel.setBorder(BorderFactory.createEmptyBorder(n, n3, n2, n3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)this.createButtonsInPanel(), "Center");
        jPanel2.add((Component)jPanel3, "South");
        this.gooseTableModel = new GaggleBossTableModel(this);
        this.gooseTable = new JTable(this.gooseTableModel);
        this.gooseTable.setSelectionMode(2);
        this.gooseTable.setShowGrid(true);
        this.gooseTable.setGridColor(Color.gray);
        this.gooseTable.setDefaultRenderer(JButton.class, new ButtonCellRenderer(this.gooseTable.getDefaultRenderer(JButton.class)));
        this.setTableColumnWidths();
        this.gooseTable.setPreferredScrollableViewportSize(new Dimension(400, 200));
        this.gooseTable.addMouseListener(new GaggleMouseListener(this.gooseTable));
        this.scrollPane = new JScrollPane(this.gooseTable);
        jPanel.add((Component)this.scrollPane, "Center");
        return jPanel2;
    }

    protected JPanel createButtonsInPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        JButton jButton = new JButton("Show");
        JButton jButton2 = new JButton("Show Others");
        JButton jButton3 = new JButton("Hide");
        JButton jButton4 = new JButton("Hide Others");
        JButton jButton5 = new JButton("Select All");
        JButton jButton6 = new JButton("Refresh");
        JButton jButton7 = new JButton("Clear Selections");
        JButton jButton8 = new JButton("Tile");
        JButton jButton9 = new JButton("Stagger");
        JButton jButton10 = new JButton("Terminate");
        JButton jButton11 = new JButton("Quit");
        jButton9.setEnabled(false);
        jButton.addActionListener(new ShowAction());
        jButton2.addActionListener(new ShowOthersAction());
        jButton3.addActionListener(new HideAction());
        jButton4.addActionListener(new HideOthersAction());
        jButton5.addActionListener(new SelectAllAction());
        jButton7.addActionListener(new ClearSelectionsAction());
        jButton6.addActionListener(new RefreshAction());
        jButton8.addActionListener(new TileAction());
        jButton9.addActionListener(new StaggerAction());
        jButton10.addActionListener(new TerminateAction());
        jButton11.addActionListener(new QuitAction());
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel3.add(jButton3);
        jPanel3.add(jButton4);
        jPanel3.add(jButton7);
        jPanel4.add(jButton5);
        jPanel4.add(jButton6);
        jPanel4.add(jButton8);
        jPanel4.add(jButton9);
        jPanel4.add(jButton10);
        jPanel5.add(jButton11);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel5, "South");
        return jPanel;
    }

    protected void setTableColumnWidths() {
        this.gooseTable.getColumnModel().getColumn(1).setPreferredWidth(60);
        this.gooseTable.getColumnModel().getColumn(1).setMaxWidth(60);
        this.gooseTable.getColumnModel().getColumn(2).setPreferredWidth(60);
        this.gooseTable.getColumnModel().getColumn(2).setMaxWidth(60);
        this.gooseTable.getColumnModel().getColumn(3).setPreferredWidth(70);
        this.gooseTable.getColumnModel().getColumn(3).setMaxWidth(70);
    }

    protected boolean listening(String string) {
        return this.gooseTableModel.isListening(string);
    }

    protected void setSelectionCount(String string, int n) {
        this.gooseTableModel.setSelectionCount(string, n);
    }

    protected void removeGooseFromGaggle(String string) {
        this.gooseTableModel.removeGoose(string);
        this.remove(string);
        this.setTableColumnWidths();
    }

    protected void refresh() {
        this.refresh(false);
    }

    protected void refresh(boolean bl) {
        HashMap hashMap = this.getGooseMap();
        String[] stringArray = this.getGooseNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Goose goose = (Goose)hashMap.get(string);
            try {
                int n = goose.getSelectionCount();
                this.setSelectionCount(string, n);
                continue;
            }
            catch (RemoteException remoteException) {
                this.removeGooseFromGaggle(string);
            }
        }
        if (bl) {
            this.setTableColumnWidths();
        }
    }

    public void askGooseToBroadcast(String string) {
        Goose goose = this.getGoose(string);
        try {
            goose.doBroadcast();
        }
        catch (RemoteException remoteException) {
            System.err.println("---- GuiBoss.askGooseToBroadcast exception");
            System.err.println("error when asking goose (" + string + ") to broadcast");
            System.err.println(remoteException.getMessage());
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
    }

    public void windowLostFocus(WindowEvent windowEvent) {
    }

    private void placeInCenter() {
        GraphicsConfiguration graphicsConfiguration = this.frame.getGraphicsConfiguration();
        int n = (int)graphicsConfiguration.getBounds().getHeight();
        int n2 = (int)graphicsConfiguration.getBounds().getWidth();
        int n3 = this.frame.getWidth();
        int n4 = this.frame.getHeight();
        this.frame.setLocation((n2 - n3) / 2, (n - n4) / 2);
    }

    public void addNewGoose(String string, Goose goose) {
        this.gooseMap.put(string, goose);
        this.gooseTableModel.addClient(string);
        this.setTableColumnWidths();
    }

    public boolean isListening(String string) {
        return this.gooseTableModel.isListening(string);
    }

    public static void main(String[] stringArray) throws Exception {
        GuiBoss guiBoss = new GuiBoss();
    }

    class ButtonCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer defaultRenderer;

        public ButtonCellRenderer(TableCellRenderer tableCellRenderer) {
            this.defaultRenderer = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Component) {
                return (Component)object;
            }
            return this.defaultRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    class GaggleMouseListener
    implements MouseListener {
        private JTable table;

        public GaggleMouseListener(JTable jTable) {
            this.table = jTable;
        }

        private void forwardEventToButton(MouseEvent mouseEvent) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = mouseEvent.getY() / this.table.getRowHeight();
            if (n2 >= this.table.getRowCount() || n2 < 0 || n >= this.table.getColumnCount() || n < 0) {
                return;
            }
            Object object = this.table.getValueAt(n2, n);
            if (!(object instanceof JButton)) {
                return;
            }
            JButton jButton = (JButton)object;
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(this.table, mouseEvent, jButton);
            jButton.doClick();
            this.table.repaint();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.forwardEventToButton(mouseEvent);
        }
    }

    class QuitAction
    extends AbstractAction {
        QuitAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Naming.unbind(GuiBoss.this.serviceName);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.exit(0);
        }
    }

    class TerminateAction
    extends AbstractAction {
        TerminateAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = GuiBoss.this.getSelectedGooseNames();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    GuiBoss.this.terminate(stringArray[i]);
                    continue;
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
            GuiBoss.this.refresh(true);
        }
    }

    class StaggerAction
    extends AbstractAction {
        StaggerAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("StaggerAction");
        }
    }

    class TileAction
    extends AbstractAction {
        TileAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = GuiBoss.this.gooseTable.getSelectedRows();
            String[] stringArray = GuiBoss.this.gooseTableModel.getAppNames();
            int n = nArray.length;
            GraphicsConfiguration graphicsConfiguration = GuiBoss.this.frame.getGraphicsConfiguration();
            int n2 = (int)graphicsConfiguration.getBounds().getHeight();
            int n3 = (int)graphicsConfiguration.getBounds().getWidth();
            int n4 = n + 1;
            TileCalculator tileCalculator = new TileCalculator(n3, n2, n4);
            int[] nArray2 = tileCalculator.getGeometry(0);
            int n5 = nArray2[0];
            int n6 = nArray2[1];
            int n7 = (int)GuiBoss.this.frame.getPreferredSize().getWidth();
            int n8 = (int)GuiBoss.this.frame.getPreferredSize().getHeight();
            int n9 = nArray2[2];
            int n10 = nArray2[3];
            if (n9 > n7) {
                n9 = n7;
            }
            if (n10 > n8) {
                n10 = n8;
            }
            GuiBoss.this.frame.setSize(n9, n10 - tileCalculator.getTitleBarHeight());
            GuiBoss.this.frame.setLocation(n5, n6);
            for (int i = 0; i < n; ++i) {
                String string = stringArray[nArray[i]];
                nArray2 = tileCalculator.getGeometry(i + 1);
                n5 = nArray2[0];
                n6 = nArray2[1];
                n9 = nArray2[2];
                n10 = nArray2[3] - tileCalculator.getTitleBarHeight();
                try {
                    GuiBoss.this.setGeometry(string, n5, n6, n9, n10);
                    GuiBoss.this.show(string);
                    continue;
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
        }
    }

    class RefreshAction
    extends AbstractAction {
        RefreshAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GuiBoss.this.refresh(true);
        }
    }

    class ClearSelectionsAction
    extends AbstractAction {
        ClearSelectionsAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = GuiBoss.this.getSelectedGooseNames();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    GuiBoss.this.clearSelections(stringArray[i]);
                    continue;
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
            GuiBoss.this.refresh(true);
        }
    }

    class HideOthersAction
    extends AbstractAction {
        HideOthersAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = GuiBoss.this.getUnselectedGooseNames();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    GuiBoss.this.hide(stringArray[i]);
                    continue;
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
        }
    }

    class HideAction
    extends AbstractAction {
        HideAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = GuiBoss.this.getSelectedGooseNames();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    GuiBoss.this.hide(stringArray[i]);
                    continue;
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
        }
    }

    class ShowOthersAction
    extends AbstractAction {
        ShowOthersAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = GuiBoss.this.getUnselectedGooseNames();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    GuiBoss.this.show(stringArray[i]);
                    continue;
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
        }
    }

    class ShowAction
    extends AbstractAction {
        ShowAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = GuiBoss.this.getSelectedGooseNames();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    GuiBoss.this.show(stringArray[i]);
                    continue;
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            }
        }
    }

    class SelectAllAction
    extends AbstractAction {
        SelectAllAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GuiBoss.this.gooseTable.selectAll();
        }
    }
}

