/*
 * Decompiled with CFR 0.152.
 */
package csplugins.isb.pshannon.experiment.readers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;

public class TextHttpIndirectFileReader {
    InputStreamReader reader;
    String rawText;
    String originalUri;
    String adjustedUri;
    String user;
    String password;
    boolean debug = false;

    public TextHttpIndirectFileReader(String string, String string2, String string3) throws Exception {
        this(string, string2, string3, false);
    }

    public TextHttpIndirectFileReader(String string, String string2, String string3, boolean bl) throws Exception {
        this.debug = bl;
        if (string2 == null) {
            if (bl) {
                System.err.println("\n-------- TextHttpIndirectFileReader, reading user & password\n");
            }
            this.readUserAndPassword();
        } else {
            if (bl) {
                System.err.println("\n-------- TextHttpIndirectFileReader, user & password supplied: " + string2 + ", " + string3);
            }
            this.user = string2;
            this.password = string3;
        }
        this.init(string, this.user, this.password);
    }

    public TextHttpIndirectFileReader(String string) throws Exception {
        this(string, null, null);
    }

    public TextHttpIndirectFileReader(String string, boolean bl) throws Exception {
        this(string, null, null, bl);
    }

    protected void init(String string, String string2, String string3) {
        this.originalUri = string;
        this.user = string2;
        this.password = string3;
        this.adjustedUri = this.adjustURI(this.originalUri);
        if (this.debug) {
            System.err.println("\n--------------- TextHttpIndirectFileReader.init");
            System.err.println("           adjustedUri: " + this.adjustedUri);
            System.err.println("                  user: " + string2);
            System.err.println("                    pw: " + string3);
            System.err.println("          original uri: " + this.originalUri);
            System.err.println();
        }
    }

    private String adjustURI(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.endsWith(".py")) {
            String string2 = string.substring(string.indexOf("://"));
            stringBuffer.append("http");
            stringBuffer.append(string2);
            stringBuffer.append("?mode=dir");
            stringBuffer.append("&name=xml");
            stringBuffer.append("&user=");
            stringBuffer.append(this.user);
            stringBuffer.append("&pw=");
            stringBuffer.append(this.password);
        } else {
            int n = string.lastIndexOf("/");
            String string3 = string.substring(n + 1);
            String string4 = string.substring(string.indexOf("://"), n);
            stringBuffer.append("http");
            stringBuffer.append(string4);
            stringBuffer.append("?mode=getFile&name=");
            stringBuffer.append(string3);
            stringBuffer.append("&user=");
            stringBuffer.append(this.user);
            stringBuffer.append("&pw=");
            stringBuffer.append(this.password);
        }
        return stringBuffer.toString();
    }

    private File findFile(String string, String string2) {
        File file;
        if (string != null && (file = new File(string, string2)).canRead()) {
            return file;
        }
        return null;
    }

    private void readUserAndPassword() {
        Properties properties = new Properties();
        String string = "gaggle.props";
        File file = this.findFile(System.getProperty("user.home"), string);
        File file2 = this.findFile(System.getProperty("user.dir"), string);
        FileInputStream fileInputStream = null;
        try {
            if (file2 != null) {
                fileInputStream = new FileInputStream(file2);
                properties.load(fileInputStream);
                if (this.debug) {
                    System.err.println("TextHttpIndirectFileReader reading props from " + file2.getPath());
                }
            } else if (file != null) {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                if (this.debug) {
                    System.err.println("TextHttpIndirectFileReader reading props from " + file.getPath());
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.user = "";
        this.password = "";
        if (properties.containsKey("user")) {
            this.user = (String)properties.get("user");
        }
        if (properties.containsKey("password")) {
            this.password = (String)properties.get("password");
        }
        if (this.debug) {
            System.err.println("TextHttpIndirectFileReader, user=" + this.user + "  pw: " + this.password);
        }
    }

    public String getAdjustedUri() {
        return this.adjustedUri;
    }

    public int read() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TextHttpIndirectFileReader.getPage(this.adjustedUri));
        this.rawText = stringBuffer.toString();
        return stringBuffer.length();
    }

    public int read(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        this.adjustedUri = this.adjustURI(string);
        stringBuffer.append(TextHttpIndirectFileReader.getPage(this.adjustedUri));
        this.rawText = stringBuffer.toString();
        return stringBuffer.length();
    }

    public String getText() {
        return this.rawText.trim();
    }

    public static String getPage(String string) throws Exception {
        String string2;
        try {
            string2 = TextHttpIndirectFileReader.getPage(new URL(string));
        }
        catch (Exception exception) {
            string2 = "";
        }
        return string2;
    }

    public static String getPage(URL uRL) throws Exception {
        String string;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        int n = httpURLConnection.getResponseCode();
        String string2 = httpURLConnection.getContentType();
        int n2 = httpURLConnection.getContentLength();
        String string3 = httpURLConnection.getContentEncoding();
        if (n != 200) {
            throw new IOException("\nHTTP response code: " + n);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public File writeToTemporaryFile() throws IOException {
        File file = File.createTempFile("httpIndirect", ".txt");
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(this.rawText, 0, this.rawText.length());
        fileWriter.close();
        return file;
    }
}

